/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.analysis;

import com.google.common.base.Preconditions;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.VisitorState;
import com.google.errorprone.analysis.AnalysesConfig;
import com.google.errorprone.analysis.LocalAnalysis;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Context;
import java.lang.annotation.Annotation;
import java.util.Set;

public final class BugCheckerLocalAnalysis
extends SimpleTreeVisitor<Void, VisitorState>
implements LocalAnalysis {
    private final BugChecker checker;

    BugCheckerLocalAnalysis(BugChecker checker) {
        this.checker = (BugChecker)Preconditions.checkNotNull((Object)checker);
    }

    @Override
    public Set<String> allNames() {
        return this.checker.allNames();
    }

    @Override
    public String canonicalName() {
        return this.checker.canonicalName();
    }

    @Override
    public Set<Class<? extends Annotation>> customSuppressionAnnotations() {
        return this.checker.customSuppressionAnnotations();
    }

    @Override
    public BugPattern.Suppressibility suppressibility() {
        return this.checker.suppressibility();
    }

    @Override
    public void analyze(TreePath tree, Context context, AnalysesConfig config, DescriptionListener listener) {
        tree.getLeaf().accept(this, new VisitorState(context, listener).withPath(tree));
    }

    @Override
    protected Void defaultAction(Tree node, VisitorState state) {
        return null;
    }

    private void report(Description description, VisitorState state) {
        if (description != Description.NO_MATCH) {
            state.reportMatch(description);
        }
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ArrayAccessTreeMatcher) {
            BugChecker.ArrayAccessTreeMatcher matcher = (BugChecker.ArrayAccessTreeMatcher)((Object)this.checker);
            this.report(matcher.matchArrayAccess(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.AnnotationTreeMatcher) {
            BugChecker.AnnotationTreeMatcher matcher = (BugChecker.AnnotationTreeMatcher)((Object)this.checker);
            this.report(matcher.matchAnnotation(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.CompilationUnitTreeMatcher) {
            BugChecker.CompilationUnitTreeMatcher matcher = (BugChecker.CompilationUnitTreeMatcher)((Object)this.checker);
            this.report(matcher.matchCompilationUnit(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitImport(ImportTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ImportTreeMatcher) {
            BugChecker.ImportTreeMatcher matcher = (BugChecker.ImportTreeMatcher)((Object)this.checker);
            this.report(matcher.matchImport(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitClass(ClassTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ClassTreeMatcher) {
            BugChecker.ClassTreeMatcher matcher = (BugChecker.ClassTreeMatcher)((Object)this.checker);
            this.report(matcher.matchClass(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitMethod(MethodTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.MethodTreeMatcher) {
            BugChecker.MethodTreeMatcher matcher = (BugChecker.MethodTreeMatcher)((Object)this.checker);
            this.report(matcher.matchMethod(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitVariable(VariableTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.VariableTreeMatcher) {
            BugChecker.VariableTreeMatcher matcher = (BugChecker.VariableTreeMatcher)((Object)this.checker);
            this.report(matcher.matchVariable(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitEmptyStatement(EmptyStatementTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.EmptyStatementTreeMatcher) {
            BugChecker.EmptyStatementTreeMatcher matcher = (BugChecker.EmptyStatementTreeMatcher)((Object)this.checker);
            this.report(matcher.matchEmptyStatement(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitBlock(BlockTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.BlockTreeMatcher) {
            BugChecker.BlockTreeMatcher matcher = (BugChecker.BlockTreeMatcher)((Object)this.checker);
            this.report(matcher.matchBlock(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.DoWhileLoopTreeMatcher) {
            BugChecker.DoWhileLoopTreeMatcher matcher = (BugChecker.DoWhileLoopTreeMatcher)((Object)this.checker);
            this.report(matcher.matchDoWhileLoop(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.WhileLoopTreeMatcher) {
            BugChecker.WhileLoopTreeMatcher matcher = (BugChecker.WhileLoopTreeMatcher)((Object)this.checker);
            this.report(matcher.matchWhileLoop(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitForLoop(ForLoopTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ForLoopTreeMatcher) {
            BugChecker.ForLoopTreeMatcher matcher = (BugChecker.ForLoopTreeMatcher)((Object)this.checker);
            this.report(matcher.matchForLoop(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.EnhancedForLoopTreeMatcher) {
            BugChecker.EnhancedForLoopTreeMatcher matcher = (BugChecker.EnhancedForLoopTreeMatcher)((Object)this.checker);
            this.report(matcher.matchEnhancedForLoop(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitLabeledStatement(LabeledStatementTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.LabeledStatementTreeMatcher) {
            BugChecker.LabeledStatementTreeMatcher matcher = (BugChecker.LabeledStatementTreeMatcher)((Object)this.checker);
            this.report(matcher.matchLabeledStatement(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitSwitch(SwitchTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.SwitchTreeMatcher) {
            BugChecker.SwitchTreeMatcher matcher = (BugChecker.SwitchTreeMatcher)((Object)this.checker);
            this.report(matcher.matchSwitch(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitCase(CaseTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.CaseTreeMatcher) {
            BugChecker.CaseTreeMatcher matcher = (BugChecker.CaseTreeMatcher)((Object)this.checker);
            this.report(matcher.matchCase(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.SynchronizedTreeMatcher) {
            BugChecker.SynchronizedTreeMatcher matcher = (BugChecker.SynchronizedTreeMatcher)((Object)this.checker);
            this.report(matcher.matchSynchronized(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitTry(TryTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.TryTreeMatcher) {
            BugChecker.TryTreeMatcher matcher = (BugChecker.TryTreeMatcher)((Object)this.checker);
            this.report(matcher.matchTry(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitCatch(CatchTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.CatchTreeMatcher) {
            BugChecker.CatchTreeMatcher matcher = (BugChecker.CatchTreeMatcher)((Object)this.checker);
            this.report(matcher.matchCatch(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ConditionalExpressionTreeMatcher) {
            BugChecker.ConditionalExpressionTreeMatcher matcher = (BugChecker.ConditionalExpressionTreeMatcher)((Object)this.checker);
            this.report(matcher.matchConditionalExpression(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitIf(IfTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.IfTreeMatcher) {
            BugChecker.IfTreeMatcher matcher = (BugChecker.IfTreeMatcher)((Object)this.checker);
            this.report(matcher.matchIf(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ExpressionStatementTreeMatcher) {
            BugChecker.ExpressionStatementTreeMatcher matcher = (BugChecker.ExpressionStatementTreeMatcher)((Object)this.checker);
            this.report(matcher.matchExpressionStatement(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitBreak(BreakTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.BreakTreeMatcher) {
            BugChecker.BreakTreeMatcher matcher = (BugChecker.BreakTreeMatcher)((Object)this.checker);
            this.report(matcher.matchBreak(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitContinue(ContinueTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ContinueTreeMatcher) {
            BugChecker.ContinueTreeMatcher matcher = (BugChecker.ContinueTreeMatcher)((Object)this.checker);
            this.report(matcher.matchContinue(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ReturnTreeMatcher) {
            BugChecker.ReturnTreeMatcher matcher = (BugChecker.ReturnTreeMatcher)((Object)this.checker);
            this.report(matcher.matchReturn(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitThrow(ThrowTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ThrowTreeMatcher) {
            BugChecker.ThrowTreeMatcher matcher = (BugChecker.ThrowTreeMatcher)((Object)this.checker);
            this.report(matcher.matchThrow(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitAssert(AssertTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.AssertTreeMatcher) {
            BugChecker.AssertTreeMatcher matcher = (BugChecker.AssertTreeMatcher)((Object)this.checker);
            this.report(matcher.matchAssert(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.MethodInvocationTreeMatcher) {
            BugChecker.MethodInvocationTreeMatcher matcher = (BugChecker.MethodInvocationTreeMatcher)((Object)this.checker);
            this.report(matcher.matchMethodInvocation(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.NewClassTreeMatcher) {
            BugChecker.NewClassTreeMatcher matcher = (BugChecker.NewClassTreeMatcher)((Object)this.checker);
            this.report(matcher.matchNewClass(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitNewArray(NewArrayTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.NewArrayTreeMatcher) {
            BugChecker.NewArrayTreeMatcher matcher = (BugChecker.NewArrayTreeMatcher)((Object)this.checker);
            this.report(matcher.matchNewArray(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.LambdaExpressionTreeMatcher) {
            BugChecker.LambdaExpressionTreeMatcher matcher = (BugChecker.LambdaExpressionTreeMatcher)((Object)this.checker);
            this.report(matcher.matchLambdaExpression(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitParenthesized(ParenthesizedTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ParenthesizedTreeMatcher) {
            BugChecker.ParenthesizedTreeMatcher matcher = (BugChecker.ParenthesizedTreeMatcher)((Object)this.checker);
            this.report(matcher.matchParenthesized(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitAssignment(AssignmentTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.AssignmentTreeMatcher) {
            BugChecker.AssignmentTreeMatcher matcher = (BugChecker.AssignmentTreeMatcher)((Object)this.checker);
            this.report(matcher.matchAssignment(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.CompoundAssignmentTreeMatcher) {
            BugChecker.CompoundAssignmentTreeMatcher matcher = (BugChecker.CompoundAssignmentTreeMatcher)((Object)this.checker);
            this.report(matcher.matchCompoundAssignment(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.UnaryTreeMatcher) {
            BugChecker.UnaryTreeMatcher matcher = (BugChecker.UnaryTreeMatcher)((Object)this.checker);
            this.report(matcher.matchUnary(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitBinary(BinaryTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.BinaryTreeMatcher) {
            BugChecker.BinaryTreeMatcher matcher = (BugChecker.BinaryTreeMatcher)((Object)this.checker);
            this.report(matcher.matchBinary(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.TypeCastTreeMatcher) {
            BugChecker.TypeCastTreeMatcher matcher = (BugChecker.TypeCastTreeMatcher)((Object)this.checker);
            this.report(matcher.matchTypeCast(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.InstanceOfTreeMatcher) {
            BugChecker.InstanceOfTreeMatcher matcher = (BugChecker.InstanceOfTreeMatcher)((Object)this.checker);
            this.report(matcher.matchInstanceOf(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.MemberSelectTreeMatcher) {
            BugChecker.MemberSelectTreeMatcher matcher = (BugChecker.MemberSelectTreeMatcher)((Object)this.checker);
            this.report(matcher.matchMemberSelect(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.MemberReferenceTreeMatcher) {
            BugChecker.MemberReferenceTreeMatcher matcher = (BugChecker.MemberReferenceTreeMatcher)((Object)this.checker);
            this.report(matcher.matchMemberReference(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.IdentifierTreeMatcher) {
            BugChecker.IdentifierTreeMatcher matcher = (BugChecker.IdentifierTreeMatcher)((Object)this.checker);
            this.report(matcher.matchIdentifier(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.LiteralTreeMatcher) {
            BugChecker.LiteralTreeMatcher matcher = (BugChecker.LiteralTreeMatcher)((Object)this.checker);
            this.report(matcher.matchLiteral(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitPrimitiveType(PrimitiveTypeTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.PrimitiveTypeTreeMatcher) {
            BugChecker.PrimitiveTypeTreeMatcher matcher = (BugChecker.PrimitiveTypeTreeMatcher)((Object)this.checker);
            this.report(matcher.matchPrimitiveType(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitArrayType(ArrayTypeTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ArrayTypeTreeMatcher) {
            BugChecker.ArrayTypeTreeMatcher matcher = (BugChecker.ArrayTypeTreeMatcher)((Object)this.checker);
            this.report(matcher.matchArrayType(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitParameterizedType(ParameterizedTypeTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ParameterizedTypeTreeMatcher) {
            BugChecker.ParameterizedTypeTreeMatcher matcher = (BugChecker.ParameterizedTypeTreeMatcher)((Object)this.checker);
            this.report(matcher.matchParameterizedType(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitUnionType(UnionTypeTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.UnionTypeTreeMatcher) {
            BugChecker.UnionTypeTreeMatcher matcher = (BugChecker.UnionTypeTreeMatcher)((Object)this.checker);
            this.report(matcher.matchUnionType(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitIntersectionType(IntersectionTypeTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.IntersectionTypeTreeMatcher) {
            BugChecker.IntersectionTypeTreeMatcher matcher = (BugChecker.IntersectionTypeTreeMatcher)((Object)this.checker);
            this.report(matcher.matchIntersectionType(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.TypeParameterTreeMatcher) {
            BugChecker.TypeParameterTreeMatcher matcher = (BugChecker.TypeParameterTreeMatcher)((Object)this.checker);
            this.report(matcher.matchTypeParameter(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitWildcard(WildcardTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.WildcardTreeMatcher) {
            BugChecker.WildcardTreeMatcher matcher = (BugChecker.WildcardTreeMatcher)((Object)this.checker);
            this.report(matcher.matchWildcard(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitModifiers(ModifiersTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.ModifiersTreeMatcher) {
            BugChecker.ModifiersTreeMatcher matcher = (BugChecker.ModifiersTreeMatcher)((Object)this.checker);
            this.report(matcher.matchModifiers(node, state), state);
        }
        return null;
    }

    @Override
    public Void visitAnnotatedType(AnnotatedTypeTree node, VisitorState state) {
        if (this.checker instanceof BugChecker.AnnotatedTypeTreeMatcher) {
            BugChecker.AnnotatedTypeTreeMatcher matcher = (BugChecker.AnnotatedTypeTreeMatcher)((Object)this.checker);
            this.report(matcher.matchAnnotatedType(node, state), state);
        }
        return null;
    }
}

