/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.analysis;

import com.google.errorprone.BugPattern;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.analysis.AnalysesConfig;
import com.google.errorprone.analysis.AutoValue_TopLevelAnalysisWithSeverity;
import com.google.errorprone.analysis.TopLevelAnalysis;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.util.Context;
import java.util.Set;

public abstract class TopLevelAnalysisWithSeverity
implements TopLevelAnalysis {
    static TopLevelAnalysisWithSeverity wrap(String canonicalName, boolean onByDefault, BugPattern.SeverityLevel defaultSeverity, boolean disableable, TopLevelAnalysis analysis) {
        return new AutoValue_TopLevelAnalysisWithSeverity(canonicalName, onByDefault, defaultSeverity, disableable, analysis);
    }

    abstract String canonicalName();

    abstract boolean onByDefault();

    abstract BugPattern.SeverityLevel defaultSeverity();

    abstract boolean disableable();

    abstract TopLevelAnalysis analysis();

    @Override
    public Set<String> knownAnalysisNames() {
        return this.analysis().knownAnalysisNames();
    }

    @Override
    public void analyze(CompilationUnitTree compilationUnit, Context context, AnalysesConfig config, final DescriptionListener listener) {
        BugPattern.SeverityLevel severity;
        boolean on;
        block10: {
            block9: {
                on = this.onByDefault();
                ErrorProneOptions.Severity optionsSeverity = (ErrorProneOptions.Severity)((Object)config.errorProneOptions().getSeverityMap().get((Object)this.canonicalName()));
                if (optionsSeverity == null) break block9;
                switch (optionsSeverity) {
                    case OFF: {
                        if (!this.disableable()) {
                            throw new IllegalArgumentException(this.canonicalName() + " may not be disabled");
                        }
                        on = false;
                        severity = BugPattern.SeverityLevel.NOT_A_PROBLEM;
                        break block10;
                    }
                    case DEFAULT: {
                        on = true;
                        severity = this.defaultSeverity();
                        break block10;
                    }
                    case WARN: {
                        if (!this.disableable() && this.defaultSeverity() == BugPattern.SeverityLevel.ERROR) {
                            throw new IllegalArgumentException(this.canonicalName() + " is not disableable and may not be demoted to a warning");
                        }
                        on = true;
                        severity = BugPattern.SeverityLevel.WARNING;
                        break block10;
                    }
                    case ERROR: {
                        on = true;
                        severity = BugPattern.SeverityLevel.ERROR;
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected severity level: " + (Object)((Object)optionsSeverity));
                    }
                }
            }
            severity = this.defaultSeverity();
        }
        if (on && severity.enabled()) {
            this.analysis().analyze(compilationUnit, context, config, new DescriptionListener(){

                @Override
                public void onDescribed(Description description) {
                    listener.onDescribed(description.applySeverityOverride(severity));
                }
            });
        }
    }
}

