/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportStatements {
    private int startPos = Integer.MAX_VALUE;
    private int endPos = -1;
    private final Set<String> importStrings;
    private boolean hasExistingImports;
    private static final Ordering<String> IMPORT_ORDERING = new Ordering<String>(){

        public int compare(String s1, String s2) {
            return ComparisonChain.start().compare((Comparable)((Object)Kind.getKind(s1)), (Comparable)((Object)Kind.getKind(s2))).compare((Comparable)((Object)s1), (Comparable)((Object)s2)).result();
        }
    };
    private static final Pattern TOPLEVEL_PATTERN = Pattern.compile("import\\s+(static\\s+|)([^.]+).");

    public static ImportStatements create(JCTree.JCCompilationUnit compilationUnit) {
        return new ImportStatements((JCTree.JCExpression)compilationUnit.getPackageName(), compilationUnit.getImports(), compilationUnit.endPositions);
    }

    public ImportStatements(JCTree.JCExpression packageTree, List<JCTree.JCImport> importTrees, EndPosTable endPositions) {
        if (importTrees.isEmpty()) {
            this.hasExistingImports = false;
            this.endPos = this.startPos = packageTree.getEndPosition(endPositions) + 2;
        } else {
            this.hasExistingImports = true;
            for (JCTree.JCImport importTree : importTrees) {
                int currStartPos = importTree.getStartPosition();
                int currEndPos = importTree.getEndPosition(endPositions);
                this.startPos = Math.min(this.startPos, currStartPos);
                this.endPos = Math.max(this.endPos, currEndPos);
            }
        }
        Preconditions.checkState((this.startPos <= this.endPos ? 1 : 0) != 0);
        this.importStrings = new TreeSet<String>((Comparator<String>)IMPORT_ORDERING);
        this.importStrings.addAll(Lists.transform(importTrees, (Function)new Function<JCTree.JCImport, String>(){

            public String apply(JCTree.JCImport input) {
                String importExpr = input.toString();
                return importExpr.substring(0, importExpr.length() - 2);
            }
        }));
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public boolean add(String importToAdd) {
        return this.importStrings.add(importToAdd);
    }

    public boolean addAll(Collection<String> importsToAdd) {
        return this.importStrings.addAll(importsToAdd);
    }

    public boolean remove(String importToRemove) {
        return this.importStrings.remove(importToRemove);
    }

    public boolean removeAll(Collection<String> importsToRemove) {
        return this.importStrings.removeAll(importsToRemove);
    }

    public String toString() {
        if (this.importStrings.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (!this.hasExistingImports) {
            result.append('\n');
        }
        Kind prevKind = null;
        String prevTopLevel = null;
        for (String importString : this.importStrings) {
            Kind currKind = Kind.getKind(importString);
            String currTopLevel = ImportStatements.getTopLevel(importString);
            if (prevKind != null && prevKind != currKind) {
                result.append('\n');
            } else if (currKind == Kind.THIRD_PARTY && prevTopLevel != null && !prevTopLevel.equals(currTopLevel)) {
                result.append('\n');
            }
            result.append(importString).append(";\n");
            prevKind = currKind;
            prevTopLevel = currTopLevel;
        }
        String replacementString = result.toString();
        if (!this.hasExistingImports) {
            return replacementString;
        }
        return replacementString.substring(0, replacementString.length() - 1);
    }

    @VisibleForTesting
    static String getTopLevel(String importString) {
        Matcher m = TOPLEVEL_PATTERN.matcher(importString);
        if (m.find()) {
            return m.group(2);
        }
        throw new IllegalArgumentException(importString + " is not a valid import statement");
    }

    private static enum Kind {
        STATIC,
        GOOGLE,
        THIRD_PARTY,
        JAVA,
        JAVAX;


        public static Kind getKind(String importString) {
            if (importString.startsWith("import static")) {
                return STATIC;
            }
            if (importString.startsWith("import com.google.")) {
                return GOOGLE;
            }
            if (importString.startsWith("import java.")) {
                return JAVA;
            }
            if (importString.startsWith("import javax.")) {
                return JAVAX;
            }
            return THIRD_PARTY;
        }
    }
}

