/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="CannotMockFinalClass", summary="Mockito cannot mock final classes", explanation="Mockito cannot mock final classes. See https://github.com/mockito/mockito/wiki/FAQ for details.", category=BugPattern.Category.MOCKITO, maturity=BugPattern.MaturityLevel.MATURE, severity=BugPattern.SeverityLevel.WARNING)
public class CannotMockFinalClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<AnnotationTree> runWithJunit4 = Matchers.allOf(Matchers.isType("org.junit.runner.RunWith"), Matchers.hasArgumentWithValue("value", Matchers.classLiteral(Matchers.isSameType("org.junit.runners.JUnit4"))));
    private static final Matcher<Tree> enclosingClassIsJunit4Test = Matchers.enclosingClass(Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, runWithJunit4));
    private static final Matcher<VariableTree> variableOfFinalClassAnnotatedMock = Matchers.allOf(Matchers.variableType(Matchers.hasModifier(Modifier.FINAL)), Matchers.hasAnnotation("org.mockito.Mock"), enclosingClassIsJunit4Test);
    private static final Matcher<MethodInvocationTree> creationOfMockForFinalClass = Matchers.allOf(Matchers.staticMethod().onClass("org.mockito.Mockito").named("mock"), Matchers.argument(0, Matchers.classLiteral(Matchers.hasModifier(Modifier.FINAL))), enclosingClassIsJunit4Test);

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        return variableOfFinalClassAnnotatedMock.matches(tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return creationOfMockForFinalClass.matches(tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

