/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.TypeElement;

@BugPattern(name="GuiceAssistedParameters", summary="A constructor cannot have two @Assisted parameters of the same type unless they are disambiguated with named @Assisted annotations. ", explanation="See http://google-guice.googlecode.com/git/javadoc/com/google/inject/assistedinject/FactoryModuleBuilder.html", category=BugPattern.Category.GUICE, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class GuiceAssistedParameters
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String ASSISTED_ANNOTATION = "com.google.inject.assistedinject.Assisted";
    private Matcher<VariableTree> constructorAssistedParameterMatcher = new Matcher<VariableTree>(){

        @Override
        public boolean matches(VariableTree t, VisitorState state) {
            Symbol modified = ASTHelpers.getSymbol(state.getPath().getParentPath().getLeaf());
            return modified != null && modified.isConstructor() && Matchers.hasAnnotation(GuiceAssistedParameters.ASSISTED_ANNOTATION).matches(t, state);
        }
    };

    @Override
    public final Description matchVariable(VariableTree variableTree, VisitorState state) {
        if (this.constructorAssistedParameterMatcher.matches(variableTree, state)) {
            Attribute.Compound thisParamsAssisted = null;
            for (Attribute.Compound c : ASTHelpers.getSymbol(variableTree).getAnnotationMirrors()) {
                if (!((TypeElement)c.getAnnotationType().asElement()).getQualifiedName().contentEquals(ASSISTED_ANNOTATION)) continue;
                thisParamsAssisted = c;
            }
            MethodTree enclosingMethod = (MethodTree)state.getPath().getParentPath().getLeaf();
            int numIdentical = 0;
            for (VariableTree variableTree2 : enclosingMethod.getParameters()) {
                if (!Matchers.isSameType(variableTree).matches(variableTree2, state)) continue;
                Attribute.Compound otherParamsAssisted = null;
                for (Attribute.Compound c : ASTHelpers.getSymbol(variableTree2).getAnnotationMirrors()) {
                    if (!((TypeElement)c.getAnnotationType().asElement()).getQualifiedName().contentEquals(ASSISTED_ANNOTATION)) continue;
                    otherParamsAssisted = c;
                }
                if (otherParamsAssisted != null) {
                    if (thisParamsAssisted.getElementValues().isEmpty() && otherParamsAssisted.getElementValues().isEmpty()) {
                        ++numIdentical;
                    }
                    for (Symbol.MethodSymbol m : thisParamsAssisted.getElementValues().keySet()) {
                        if (!otherParamsAssisted.getElementValues().get(m).getValue().equals(thisParamsAssisted.getElementValues().get(m).getValue())) continue;
                        ++numIdentical;
                    }
                }
                if (numIdentical <= true) continue;
                return this.describe(variableTree, state);
            }
        }
        return Description.NO_MATCH;
    }

    public Description describe(VariableTree variableTree, VisitorState state) {
        for (AnnotationTree annotationTree : variableTree.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol(annotationTree).equals(state.getSymbolFromString(ASSISTED_ANNOTATION))) continue;
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        throw new IllegalStateException("Expected to find @Assisted on this parameter");
    }
}

