/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(name="JavaxInjectOnAbstractMethod", summary="Abstract methods are not injectable with javax.inject.Inject.", explanation="The javax.inject.Inject annotation cannot go on an abstract method as per the JSR-330 spec. This is in line with the fact that if a class overrides a method that was annotated with javax.inject.Inject, and the subclass methodis not annotated, the subclass method will not be injected.\n\nSee http://docs.oracle.com/javaee/6/api/javax/inject/Inject.html\nand https://code.google.com/p/google-guice/wiki/JSR330 ", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectJavaxInjectOnAbstractMethod
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    Matcher<AnnotationTree> javaxInjectAnnotationMatcher = new Matcher<AnnotationTree>(){

        @Override
        public boolean matches(AnnotationTree annotationTree, VisitorState state) {
            return ASTHelpers.getSymbol(annotationTree).equals(state.getSymbolFromString(InjectJavaxInjectOnAbstractMethod.JAVAX_INJECT_ANNOTATION));
        }
    };

    @Override
    public Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (!this.javaxInjectAnnotationMatcher.matches(annotationTree, state)) {
            return Description.NO_MATCH;
        }
        Tree annotatedNode = state.getPath().getParentPath().getParentPath().getLeaf();
        if (InjectJavaxInjectOnAbstractMethod.isMethod(annotatedNode) && InjectJavaxInjectOnAbstractMethod.isAbstract(annotatedNode)) {
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }

    private static boolean isMethod(Tree tree) {
        return tree.getKind().equals((Object)Tree.Kind.METHOD);
    }

    private static boolean isAbstract(Tree tree) {
        return ((MethodTree)tree).getModifiers().getFlags().contains((Object)Modifier.ABSTRACT);
    }
}

