/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;

@BugPattern(name="InjectMoreThanOneScopeAnnotationOnClass", summary="A class can be annotated with at most one scope annotation", explanation="Annotating a class with more than one scope annotation is invalid according to the JSR-330 specification. ", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectMoreThanOneScopeAnnotationOnClass
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String GUICE_SCOPE_ANNOTATION = "com.google.inject.ScopeAnnotation";
    private static final String JAVAX_SCOPE_ANNOTATION = "javax.inject.Scope";
    private Matcher<AnnotationTree> scopeAnnotationMatcher = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope"));

    @Override
    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        int numberOfScopeAnnotations = 0;
        if (this.scopeAnnotationMatcher.matches(annotationTree, state) && state.getPath().getParentPath().getParentPath().getLeaf() instanceof ClassTree) {
            for (AnnotationTree annotationTree2 : ((ModifiersTree)state.getPath().getParentPath().getLeaf()).getAnnotations()) {
                if (!this.scopeAnnotationMatcher.matches(annotationTree2, state)) continue;
                ++numberOfScopeAnnotations;
            }
        }
        if (numberOfScopeAnnotations > 1) {
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }
}

