/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;

@BugPattern(name="JMockTestWithoutRunWithOrRuleAnnotation", summary="jMock tests must have a @RunWith(JMock.class) annotation, or the Mockery field must have a @Rule JUnit annotation", explanation="jMock tests must have a @RunWith(JMock.class) annotation, or the Mockery field must have a @Rule JUnit annotation. If this is not done, then all of your jMock tests will run and pass, but none of your assertions will actually be evaluated. Your tests will pass even if they shouldn't.", category=BugPattern.Category.JMOCK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class JMockTestWithoutRunWithOrRuleAnnotation
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String JMOCK_TEST_RUNNER_CLASS = "org.jmock.integration.junit4.JMock";
    private static final Matcher<VariableTree> fieldIsMockery = Matchers.allOf(Matchers.isSubtypeOf("org.jmock.Mockery"), Matchers.isField());
    private static final Matcher<VariableTree> fieldHasRuleAnnotation = Matchers.hasAnnotation("org.junit.Rule");
    private static final Matcher<Tree> enclosingClassRunsWithJMockTestRunner = Matchers.enclosingClass(Matchers.allOf(Matchers.hasAnnotation("org.junit.runner.RunWith"), Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.hasArgumentWithValue("value", Matchers.classLiteral(Matchers.isSameType("org.jmock.integration.junit4.JMock"))))));
    private static final Matcher<VariableTree> BUG_PATTERN_MATCHER = Matchers.allOf(fieldIsMockery, Matchers.not(Matchers.anyOf(fieldHasRuleAnnotation, enclosingClassRunsWithJMockTestRunner)));

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (BUG_PATTERN_MATCHER.matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

