/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.AbstractJUnit4InitMethodNotRun;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import java.util.Arrays;
import java.util.List;

@BugPattern(name="JUnit4TearDownNotRun", summary="tearDown() method will not be run; Please add an @After annotation", explanation="JUnit 3 provides the overridable method tearDown(), to be overridden by  subclasses when the test needs to perform some post-test de-initialization.  In JUnit 4, this is accomplished by annotating such a method with @After. The method that triggered this error matches the definition of tearDown() from JUnit3, but was not annotated with @After and thus won't be run by the JUnit4 runner.\n\n If you intend for this tearDown() method not to be run by the JUnit4 runner, but perhaps be manually invoked after certain test methods, please rename the method  or mark it private.\n\n If the method is part of an abstract test class hierarchy where this class's tearDown() is invoked by a superclass method that is annotated with @After, then please rename the abstract method or add @After to the superclass's definition of tearDown()", category=BugPattern.Category.JUNIT, maturity=BugPattern.MaturityLevel.MATURE, severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4TearDownNotRun
extends AbstractJUnit4InitMethodNotRun {
    @Override
    protected Matcher<MethodTree> methodMatcher() {
        return Matchers.allOf(JUnitMatchers.looksLikeJUnit3TearDown, Matchers.not(JUnitMatchers.hasJUnit4AfterAnnotations));
    }

    @Override
    protected String correctAnnotation() {
        return "org.junit.After";
    }

    @Override
    protected List<AbstractJUnit4InitMethodNotRun.AnnotationReplacements> annotationReplacements() {
        return Arrays.asList(new AbstractJUnit4InitMethodNotRun.AnnotationReplacements("org.junit.Before", "org.junit.After"), new AbstractJUnit4InitMethodNotRun.AnnotationReplacements("org.junit.BeforeClass", "org.junit.AfterClass"));
    }
}

