/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.tree.JCTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="JUnit4TestNotRun", summary="Test method will not be run; please add @Test annotation", explanation="JUnit 3 required that test methods be named in a special way to be run as part of a test case. JUnit 4 requires that test methods be annotated with @Test. The test method that triggered this error is named like a JUnit 3 test, but is in a JUnit 4 test class.  Thus, it will not be run unless you annotate it with @Test.\n\nIf you intend for this test method not to run, please add both an @Test and an @Ignore annotation to make it clear that you are purposely disabling it.", category=BugPattern.Category.JUNIT, maturity=BugPattern.MaturityLevel.MATURE, severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4TestNotRun
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String JUNIT4_TEST_ANNOTATION = "org.junit.Test";
    private static final JUnitMatchers.JUnit4TestClassMatcher isJUnit4TestClass = new JUnitMatchers.JUnit4TestClassMatcher();

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        String methodSource;
        boolean matches = Matchers.allOf(JUnitMatchers.isJunit3TestCase, Matchers.not(JUnitMatchers.hasJUnitAnnotation), Matchers.enclosingClass(isJUnit4TestClass)).matches(methodTree, state);
        if (!matches) {
            return Description.NO_MATCH;
        }
        if (Matchers.hasModifier(Modifier.STATIC).matches(methodTree, state) && (methodSource = state.getSourceForNode((JCTree.JCMethodDecl)methodTree)) != null) {
            String methodString = "@Test\n" + methodSource.toString().replaceFirst(" static ", " ");
            Fix fix = SuggestedFix.builder().addImport(JUNIT4_TEST_ANNOTATION).replace(methodTree, methodString).build();
            return this.describeMatch(methodTree, fix);
        }
        Fix fix = SuggestedFix.builder().addImport(JUNIT4_TEST_ANNOTATION).prefixWith(methodTree, "@Test\n").build();
        return this.describeMatch(methodTree, fix);
    }
}

