/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;

@BugPattern(name="NonOverridingEquals", summary="equals method doesn't override Object.equals", category=BugPattern.Category.JDK, maturity=BugPattern.MaturityLevel.MATURE, severity=BugPattern.SeverityLevel.WARNING)
public class NonOverridingEquals
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String MESSAGE_BASE = "equals method doesn't override Object.equals";
    private static final Matcher<MethodTree> MATCHER = Matchers.allOf(Matchers.methodIsNamed("equals"), Matchers.methodHasParameters(Matchers.variableType(Matchers.not(Matchers.isSameType("java.lang.Object")))), Matchers.anyOf(Matchers.methodReturns(Suppliers.BOOLEAN_TYPE), Matchers.methodReturns(Suppliers.JAVA_LANG_BOOLEAN_TYPE)));
    private static final Matcher<MethodTree> enclosingClassOverridesEquals = Matchers.enclosingClass(Matchers.hasMethod(Matchers.allOf(Matchers.methodIsNamed("equals"), Matchers.methodReturns(Suppliers.BOOLEAN_TYPE), Matchers.methodHasParameters(Matchers.variableType(Matchers.isSameType(Suppliers.OBJECT_TYPE))), Matchers.not(Matchers.isStatic()))));
    private static final Matcher<MethodTree> noFixMatcher = Matchers.anyOf(Matchers.isStatic(), Matchers.not(Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC)), Matchers.methodReturns(Suppliers.JAVA_LANG_BOOLEAN_TYPE));

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!MATCHER.matches(methodTree, state)) {
            return Description.NO_MATCH;
        }
        if (enclosingClassOverridesEquals.matches(methodTree, state)) {
            return this.buildDescription(methodTree).setMessage("equals method doesn't override Object.equals; if this is a type-specific helper for a method that does override Object.equals, either inline it into the callers or rename it to avoid ambiguity in overload resolution").build();
        }
        if (noFixMatcher.matches(methodTree, state)) {
            return this.describeMatch(methodTree);
        }
        JCTree.JCClassDecl cls = (JCTree.JCClassDecl)state.findEnclosing(ClassTree.class);
        if ((cls.getModifiers().flags & 0x4000L) != 0L) {
            return this.buildDescription(methodTree).setMessage("equals method doesn't override Object.equals; enum instances can safely be compared by reference equality, so please delete this").addFix(SuggestedFix.delete(methodTree)).build();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (ASTHelpers.getAnnotation(methodTree, Override.class) == null) {
            fix.prefixWith(methodTree, "@Override\n");
        }
        JCTree parameterType = (JCTree)methodTree.getParameters().get(0).getType();
        Name parameterName = ((JCTree.JCVariableDecl)methodTree.getParameters().get(0)).getName();
        fix.replace(parameterType, "Object");
        if (methodTree.getBody() != null) {
            String typeCheckStmt = "if (!(" + parameterName + " instanceof " + parameterType + ")) {\n" + "  return false;\n" + "}\n";
            fix.prefixWith(methodTree.getBody().getStatements().get(0), typeCheckStmt);
            new CastScanner().scan(methodTree.getBody(), new CastState(parameterName, parameterType.toString(), fix));
        }
        return this.describeMatch(methodTree, fix.build());
    }

    private static class CastScanner
    extends TreeScanner<Void, CastState> {
        private CastScanner() {
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, CastState state) {
            if (state.name.equals(node.getName())) {
                state.fix.replace(node, "((" + state.castToType + ") " + state.name + ")");
            }
            return (Void)super.visitIdentifier(node, state);
        }
    }

    private static class CastState {
        Name name;
        String castToType;
        SuggestedFix.Builder fix;

        public CastState(Name name, String castToType, SuggestedFix.Builder fix) {
            this.name = name;
            this.castToType = castToType;
            this.fix = fix;
        }
    }
}

