/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(category=BugPattern.Category.ONE_OFF, maturity=BugPattern.MaturityLevel.EXPERIMENTAL, name="ProtoStringFieldReferenceEquality", severity=BugPattern.SeverityLevel.ERROR, summary="Comparing protobuf fields of type String using reference equality", explanation="Comparing strings with == is almost always an error, but it is an error 100% of the time when one of the strings is a protobuf field.  Additionally, protobuf fields cannot be null, so Object.equals(Object) is always more correct.")
public class ProtoStringFieldReferenceEquality
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final String PROTO_SUPER_CLASS = "com.google.protobuf.GeneratedMessage";
    private static final Matcher<ExpressionTree> PROTO_STRING_METHOD = Matchers.allOf(Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage"), Matchers.isSameType("java.lang.String"));

    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.EQUAL_TO && tree.getKind() != Tree.Kind.NOT_EQUAL_TO) {
            return Description.NO_MATCH;
        }
        String leftOperand = state.getSourceForNode((JCTree)((Object)tree.getLeftOperand())).toString();
        String rightOperand = state.getSourceForNode((JCTree)((Object)tree.getRightOperand())).toString();
        if (PROTO_STRING_METHOD.matches(tree.getLeftOperand(), state) && tree.getRightOperand().getKind() != Tree.Kind.NULL_LITERAL || PROTO_STRING_METHOD.matches(tree.getRightOperand(), state) && tree.getLeftOperand().getKind() != Tree.Kind.NULL_LITERAL) {
            String result = leftOperand + ".equals(" + rightOperand + ")";
            if (tree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                result = "!" + result;
            }
            return this.describeMatch(tree, SuggestedFix.replace(tree, result));
        }
        return Description.NO_MATCH;
    }
}

