/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(name="SelfEquality", summary="Variable compared to itself", explanation="There is no good reason to test a primitive value or reference for equality with itself.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class SelfEquality
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!Matchers.anyOf(Matchers.kindIs(Tree.Kind.EQUAL_TO), Matchers.kindIs(Tree.Kind.NOT_EQUAL_TO)).matches(tree, state) || !ASTHelpers.sameVariable(tree.getLeftOperand(), tree.getRightOperand())) {
            return Description.NO_MATCH;
        }
        StringBuilder fixedExpression = new StringBuilder();
        Fix fix = null;
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        Type leftType = ((JCTree)((Object)leftOperand)).type;
        Types types = state.getTypes();
        Symtab symtab = state.getSymtab();
        ExpressionTree toReplace = rightOperand.getKind() == Tree.Kind.IDENTIFIER ? rightOperand : (leftOperand.getKind() == Tree.Kind.IDENTIFIER ? leftOperand : rightOperand);
        TreePath path = state.getPath();
        while (path.getLeaf() != null && path.getLeaf().getKind() != Tree.Kind.CLASS && path.getLeaf().getKind() != Tree.Kind.BLOCK) {
            path = path.getParentPath();
        }
        if (path.getLeaf() != null) {
            List members = path.getLeaf().getKind() == Tree.Kind.CLASS ? ((JCTree.JCClassDecl)path.getLeaf()).getMembers() : ((JCTree.JCBlock)path.getLeaf()).getStatements();
            for (JCTree jcTree : members) {
                if (jcTree.getKind() != Tree.Kind.VARIABLE) continue;
                JCTree.JCVariableDecl declaration = (JCTree.JCVariableDecl)jcTree;
                Symbol.TypeSymbol variableTypeSymbol = declaration.getType().type.tsym;
                if (!ASTHelpers.getSymbol(toReplace).isMemberOf(variableTypeSymbol, state.getTypes())) continue;
                if (toReplace.getKind() == Tree.Kind.IDENTIFIER) {
                    fix = SuggestedFix.prefixWith(toReplace, declaration.getName() + ".");
                    continue;
                }
                fix = SuggestedFix.replace(((JCTree.JCFieldAccess)toReplace).getExpression(), declaration.getName().toString());
            }
        }
        if (fix == null) {
            if (tree.getKind() == Tree.Kind.EQUAL_TO) {
                fixedExpression.append("!");
            }
            if (types.isSameType(leftType, symtab.floatType)) {
                fixedExpression.append("Float.isNaN(" + leftOperand + ")");
                fix = SuggestedFix.replace(tree, fixedExpression.toString());
            } else if (types.isSameType(leftType, symtab.doubleType)) {
                fixedExpression.append("Double.isNaN(" + leftOperand + ")");
                fix = SuggestedFix.replace(tree, fixedExpression.toString());
            } else {
                fix = tree.getKind() == Tree.Kind.EQUAL_TO ? SuggestedFix.replace(tree, "true") : SuggestedFix.replace(tree, "false");
            }
        }
        return fix == null ? this.describeMatch(tree) : this.describeMatch(tree, fix);
    }
}

