/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ImportTree;

@BugPattern(name="UnnecessaryStaticImport", summary="Using static imports for types is unnecessary", explanation="Using static imports for types is unnecessary, since they can always be replaced by equivalent non-static imports.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class UnnecessaryStaticImport
extends BugChecker
implements BugChecker.ImportTreeMatcher {
    @Override
    public Description matchImport(ImportTree tree, VisitorState state) {
        StaticImports.StaticImportInfo importInfo = StaticImports.tryCreate(tree, state);
        if (importInfo == null || importInfo.member().isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, SuggestedFix.replace(tree, importInfo.importStatement()));
    }
}

