/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.Node;

public final class LocalStore<V extends AbstractValue<V>>
implements Store<LocalStore<V>> {
    private static final LocalStore<?> EMPTY = new LocalStore(ImmutableMap.of());
    private final ImmutableMap<Equivalence.Wrapper<Node>, V> contents;

    public static <V extends AbstractValue<V>> LocalStore<V> empty() {
        return EMPTY;
    }

    private LocalStore(Map<Equivalence.Wrapper<Node>, V> contents) {
        this.contents = ImmutableMap.copyOf(contents);
    }

    public V getInformation(Node node) {
        return (V)((AbstractValue)this.contents.get((Object)NodeEquivalance.INSTANCE.wrap(node)));
    }

    public Builder<V> toBuilder() {
        return new Builder(this);
    }

    public LocalStore<V> copy() {
        return this;
    }

    public LocalStore<V> leastUpperBound(LocalStore<V> other) {
        Builder<V> result = LocalStore.empty().toBuilder();
        for (Equivalence.Wrapper var : Sets.intersection((Set)this.contents.keySet(), (Set)other.contents.keySet())) {
            ((Builder)result).contents.put(var, ((AbstractValue)this.contents.get((Object)var)).leastUpperBound((AbstractValue)other.contents.get((Object)var)));
        }
        return result.build();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalStore)) {
            return false;
        }
        LocalStore other = (LocalStore)o;
        return this.contents.equals(other.contents);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public String toString() {
        return this.contents.toString();
    }

    public boolean canAlias(FlowExpressions.Receiver a, FlowExpressions.Receiver b) {
        return true;
    }

    public boolean hasDOToutput() {
        return false;
    }

    public String toDOToutput() {
        throw new UnsupportedOperationException("DOT output not supported");
    }

    private static class NodeEquivalance
    extends Equivalence<Node> {
        static final NodeEquivalance INSTANCE = new NodeEquivalance();

        private NodeEquivalance() {
        }

        protected boolean doEquivalent(Node a, Node b) {
            if (a instanceof LocalVariableNode && b instanceof LocalVariableNode) {
                Element aEl = ((LocalVariableNode)a).getElement();
                Element bEl = ((LocalVariableNode)b).getElement();
                return aEl.equals(bEl);
            }
            return a.equals(b);
        }

        protected int doHash(Node n) {
            if (n instanceof LocalVariableNode) {
                return ((LocalVariableNode)n).getElement().hashCode();
            }
            return n.hashCode();
        }
    }

    public static final class Builder<V extends AbstractValue<V>> {
        private final Map<Equivalence.Wrapper<Node>, V> contents;

        Builder(LocalStore<V> prototype) {
            this.contents = new HashMap<Equivalence.Wrapper<Node>, V>(((LocalStore)prototype).contents);
        }

        public Builder<V> setInformation(Node node, V value) {
            this.contents.put((Equivalence.Wrapper<Node>)NodeEquivalance.INSTANCE.wrap(node), Preconditions.checkNotNull(value));
            return this;
        }

        public V getInformation(Node node) {
            return (V)((AbstractValue)this.contents.get(NodeEquivalance.INSTANCE.wrap(node)));
        }

        public LocalStore<V> build() {
            return new LocalStore(this.contents);
        }
    }
}

