/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;

public class StaticMethod
implements Matcher<ExpressionTree> {
    private final String fullClass;
    private final String methodName;

    public StaticMethod(String fullClass, String methodName) {
        this.fullClass = fullClass;
        this.methodName = methodName;
    }

    @Override
    public boolean matches(ExpressionTree item, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(item);
        if (!(sym instanceof Symbol.MethodSymbol) || !sym.isStatic()) {
            return false;
        }
        boolean methodSame = this.methodName.equals("*") || sym.getSimpleName().contentEquals(this.methodName) || sym.toString().equals(this.methodName);
        boolean classSame = this.fullClass.equals("*") || sym.owner.getQualifiedName().contentEquals(this.fullClass);
        return methodSame && classSame;
    }
}

