/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.SubContext;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.refaster.BlockTemplate;
import com.google.errorprone.refaster.ControlFlowVisitor;
import com.google.errorprone.refaster.ExpressionTemplate;
import com.google.errorprone.refaster.PlaceholderMethod;
import com.google.errorprone.refaster.Refaster;
import com.google.errorprone.refaster.RefasterRuleBuilderScanner;
import com.google.errorprone.refaster.Template;
import com.google.errorprone.refaster.UAnnotatedType;
import com.google.errorprone.refaster.UAnnotation;
import com.google.errorprone.refaster.UAnyOf;
import com.google.errorprone.refaster.UArrayAccess;
import com.google.errorprone.refaster.UArrayType;
import com.google.errorprone.refaster.UArrayTypeTree;
import com.google.errorprone.refaster.UAssert;
import com.google.errorprone.refaster.UAssign;
import com.google.errorprone.refaster.UAssignOp;
import com.google.errorprone.refaster.UBinary;
import com.google.errorprone.refaster.UBlock;
import com.google.errorprone.refaster.UBreak;
import com.google.errorprone.refaster.UCatch;
import com.google.errorprone.refaster.UClassDecl;
import com.google.errorprone.refaster.UClassIdent;
import com.google.errorprone.refaster.UClassType;
import com.google.errorprone.refaster.UConditional;
import com.google.errorprone.refaster.UContinue;
import com.google.errorprone.refaster.UDoWhileLoop;
import com.google.errorprone.refaster.UEnhancedForLoop;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UExpressionStatement;
import com.google.errorprone.refaster.UForAll;
import com.google.errorprone.refaster.UForLoop;
import com.google.errorprone.refaster.UFreeIdent;
import com.google.errorprone.refaster.UIf;
import com.google.errorprone.refaster.UInstanceOf;
import com.google.errorprone.refaster.UIntersectionClassType;
import com.google.errorprone.refaster.UIntersectionType;
import com.google.errorprone.refaster.ULabeledStatement;
import com.google.errorprone.refaster.ULambda;
import com.google.errorprone.refaster.ULiteral;
import com.google.errorprone.refaster.ULocalVarIdent;
import com.google.errorprone.refaster.UMatches;
import com.google.errorprone.refaster.UMemberReference;
import com.google.errorprone.refaster.UMemberSelect;
import com.google.errorprone.refaster.UMethodDecl;
import com.google.errorprone.refaster.UMethodInvocation;
import com.google.errorprone.refaster.UMethodType;
import com.google.errorprone.refaster.UModifiers;
import com.google.errorprone.refaster.UNewArray;
import com.google.errorprone.refaster.UNewClass;
import com.google.errorprone.refaster.UOfKind;
import com.google.errorprone.refaster.UParens;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UPlaceholderStatement;
import com.google.errorprone.refaster.UPrimitiveType;
import com.google.errorprone.refaster.UPrimitiveTypeTree;
import com.google.errorprone.refaster.URepeated;
import com.google.errorprone.refaster.UReturn;
import com.google.errorprone.refaster.USkip;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.UStaticIdent;
import com.google.errorprone.refaster.USynchronized;
import com.google.errorprone.refaster.UThrow;
import com.google.errorprone.refaster.UTree;
import com.google.errorprone.refaster.UTry;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.UTypeApply;
import com.google.errorprone.refaster.UTypeCast;
import com.google.errorprone.refaster.UTypeParameter;
import com.google.errorprone.refaster.UTypeVar;
import com.google.errorprone.refaster.UTypeVarIdent;
import com.google.errorprone.refaster.UUnary;
import com.google.errorprone.refaster.UUnionType;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.UWhileLoop;
import com.google.errorprone.refaster.UWildcard;
import com.google.errorprone.refaster.UWildcardType;
import com.google.errorprone.refaster.Unifiable;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.refaster.annotation.Matches;
import com.google.errorprone.refaster.annotation.NotMatches;
import com.google.errorprone.refaster.annotation.OfKind;
import com.google.errorprone.refaster.annotation.Repeated;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.AnnotationProxyMaker;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;

public class UTemplater
extends SimpleTreeVisitor<Tree, Void> {
    public static final Context.Key<Boolean> REQUIRE_BLOCK_KEY = new Context.Key();
    private final ImmutableMap<String, Symbol.VarSymbol> freeVariables;
    private final Context context;
    private static final UStaticIdent ANY_OF;
    private static final UStaticIdent IS_INSTANCE;
    private static final UStaticIdent CLAZZ;
    private static final UStaticIdent NEW_ARRAY;
    private static final UStaticIdent ENUM_VALUE_OF;
    private final Type.Visitor<UType, Void> typeTemplater = new Types.SimpleVisitor<UType, Void>(){
        private final Map<Symbol.TypeSymbol, UTypeVar> typeVariables = new HashMap<Symbol.TypeSymbol, UTypeVar>();

        @Override
        public UType visitType(Type type, Void v) {
            if (UPrimitiveType.isDeFactoPrimitive(type.getKind())) {
                return UPrimitiveType.create(type.getKind());
            }
            throw new IllegalArgumentException("Refaster does not currently support syntax " + (Object)((Object)type.getKind()));
        }

        @Override
        public UArrayType visitArrayType(Type.ArrayType type, Void v) {
            return UArrayType.create(type.getComponentType().accept(this, null));
        }

        @Override
        public UMethodType visitMethodType(Type.MethodType type, Void v) {
            return UMethodType.create(type.getReturnType().accept(this, null), UTemplater.this.templateTypes(type.getParameterTypes()));
        }

        @Override
        public UType visitClassType(Type.ClassType type, Void v) {
            if (type instanceof Type.IntersectionClassType) {
                return UIntersectionClassType.create(UTemplater.this.templateTypes(((Type.IntersectionClassType)type).getComponents()));
            }
            return UClassType.create((CharSequence)type.tsym.getQualifiedName().toString(), UTemplater.this.templateTypes(type.getTypeArguments()));
        }

        @Override
        public UWildcardType visitWildcardType(Type.WildcardType type, Void v) {
            return UWildcardType.create(type.kind, type.type.accept(this, null));
        }

        @Override
        public UTypeVar visitTypeVar(Type.TypeVar type, Void v) {
            Element tsym = type.asElement();
            if (this.typeVariables.containsKey(tsym)) {
                return this.typeVariables.get(tsym);
            }
            UTypeVar var = UTypeVar.create(((Name)((Symbol.TypeSymbol)tsym).getSimpleName()).toString());
            this.typeVariables.put((Symbol.TypeSymbol)tsym, var);
            var.setLowerBound(type.getLowerBound().accept(this, null));
            var.setUpperBound(type.getUpperBound().accept(this, null));
            return var;
        }

        @Override
        public UForAll visitForAll(Type.ForAll type, Void v) {
            ImmutableList vars = UTemplater.cast(UTemplater.this.templateTypes(type.getTypeVariables()), UTypeVar.class);
            return UForAll.create((List<UTypeVar>)vars, type.qtype.accept(this, null));
        }
    };

    public static Template<?> createTemplate(Context context, MethodTree decl) {
        UMethodType methodType;
        Object typeParameters;
        Symbol.MethodSymbol declSym = ASTHelpers.getSymbol(decl);
        ImmutableClassToInstanceMap<Annotation> annotations = UTemplater.annotationMap(declSym);
        ImmutableMap<String, Symbol.VarSymbol> freeExpressionVars = UTemplater.freeExpressionVariables(decl);
        SubContext subContext = new SubContext(context);
        final UTemplater templater = new UTemplater((Map<String, Symbol.VarSymbol>)freeExpressionVars, subContext);
        ImmutableMap expressionVarTypes = ImmutableMap.copyOf((Map)Maps.transformValues(freeExpressionVars, (Function)new Function<Symbol.VarSymbol, UType>(){

            public UType apply(Symbol.VarSymbol sym) {
                return templater.template(sym.type);
            }
        }));
        UType genericType = templater.template(declSym.type);
        if (genericType instanceof UForAll) {
            UForAll forAllType = (UForAll)genericType;
            typeParameters = forAllType.getTypeVars();
            methodType = (UMethodType)forAllType.getQuantifiedType();
        } else if (genericType instanceof UMethodType) {
            typeParameters = ImmutableList.of();
            methodType = (UMethodType)genericType;
        } else {
            throw new IllegalArgumentException("Expected genericType to be either a ForAll or a UMethodType, but was " + genericType);
        }
        List<? extends StatementTree> bodyStatements = decl.getBody().getStatements();
        if (bodyStatements.size() == 1 && ((StatementTree)Iterables.getOnlyElement(bodyStatements)).getKind() == Tree.Kind.RETURN && context.get(REQUIRE_BLOCK_KEY) == null) {
            ExpressionTree expression = ((ReturnTree)Iterables.getOnlyElement(bodyStatements)).getExpression();
            return ExpressionTemplate.create(annotations, (Iterable<UTypeVar>)typeParameters, (Map<String, ? extends UType>)expressionVarTypes, templater.template(expression), methodType.getReturnType());
        }
        ArrayList<UStatement> templateStatements = new ArrayList<UStatement>();
        for (StatementTree statementTree : bodyStatements) {
            templateStatements.add(templater.template(statementTree));
        }
        return BlockTemplate.create(annotations, (Iterable<UTypeVar>)typeParameters, (Map<String, ? extends UType>)expressionVarTypes, templateStatements);
    }

    public static ImmutableMap<String, Symbol.VarSymbol> freeExpressionVariables(MethodTree templateMethodDecl) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (VariableTree variableTree : templateMethodDecl.getParameters()) {
            builder.put((Object)variableTree.getName().toString(), (Object)ASTHelpers.getSymbol(variableTree));
        }
        return builder.build();
    }

    public UTemplater(Map<String, Symbol.VarSymbol> freeVariables, Context context) {
        this.freeVariables = ImmutableMap.copyOf(freeVariables);
        this.context = context;
    }

    UTemplater(Context context) {
        this((Map<String, Symbol.VarSymbol>)ImmutableMap.of(), context);
    }

    public Tree template(Tree tree) {
        return tree.accept(this, null);
    }

    @Nullable
    private List<Tree> templateTrees(@Nullable Iterable<? extends Tree> trees) {
        if (trees == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tree tree : trees) {
            builder.add((Object)this.template(tree));
        }
        return builder.build();
    }

    private static <T> ImmutableList<T> cast(Iterable<?> elements, Class<T> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object element : elements) {
            builder.add(clazz.cast(element));
        }
        return builder.build();
    }

    @Override
    public UMethodDecl visitMethod(MethodTree decl, Void v) {
        return UMethodDecl.create(this.visitModifiers(decl.getModifiers(), null), decl.getName(), this.templateType(decl.getReturnType()), UTemplater.cast(this.templateStatements(decl.getParameters()), UVariableDecl.class), this.templateExpressions(decl.getThrows()), (UBlock)this.template(decl.getBody()));
    }

    @Override
    public UModifiers visitModifiers(ModifiersTree modifiers, Void v) {
        return UModifiers.create(((JCTree.JCModifiers)modifiers).flags, UTemplater.cast(this.templateExpressions(modifiers.getAnnotations()), UAnnotation.class));
    }

    public UExpression template(ExpressionTree tree) {
        return (UExpression)tree.accept(this, null);
    }

    @Nullable
    private List<UExpression> templateExpressions(@Nullable Iterable<? extends ExpressionTree> expressions) {
        if (expressions == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ExpressionTree expressionTree : expressions) {
            builder.add((Object)this.template(expressionTree));
        }
        return builder.build();
    }

    public UExpression templateType(Tree tree) {
        Preconditions.checkArgument((boolean)(tree instanceof ExpressionTree), (String)"Trees representing types are expected to implement ExpressionTree, but %s does not", (Object[])new Object[]{tree});
        return this.template((ExpressionTree)tree);
    }

    @Nullable
    private List<UExpression> templateTypeExpressions(@Nullable Iterable<? extends Tree> types) {
        if (types == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tree tree : types) {
            builder.add((Object)this.templateType(tree));
        }
        return builder.build();
    }

    @Override
    public UInstanceOf visitInstanceOf(InstanceOfTree tree, Void v) {
        return UInstanceOf.create(this.template(tree.getExpression()), this.templateType(tree.getType()));
    }

    @Override
    public UPrimitiveTypeTree visitPrimitiveType(PrimitiveTypeTree tree, Void v) {
        return UPrimitiveTypeTree.create(((JCTree.JCPrimitiveTypeTree)tree).typetag);
    }

    @Override
    public ULiteral visitLiteral(LiteralTree tree, Void v) {
        return ULiteral.create(tree.getKind(), tree.getValue());
    }

    @Override
    public UParens visitParenthesized(ParenthesizedTree tree, Void v) {
        return UParens.create(this.template(tree.getExpression()));
    }

    @Override
    public UAssign visitAssignment(AssignmentTree tree, Void v) {
        return UAssign.create(this.template(tree.getVariable()), this.template(tree.getExpression()));
    }

    @Override
    public UArrayAccess visitArrayAccess(ArrayAccessTree tree, Void v) {
        return UArrayAccess.create(this.template(tree.getExpression()), this.template(tree.getIndex()));
    }

    @Override
    public UAnnotation visitAnnotation(AnnotationTree tree, Void v) {
        return UAnnotation.create(this.templateType(tree.getAnnotationType()), this.templateExpressions(tree.getArguments()));
    }

    @Override
    public UAnnotatedType visitAnnotatedType(AnnotatedTypeTree tree, Void v) {
        return UAnnotatedType.create(UTemplater.cast(this.templateExpressions(tree.getAnnotations()), UAnnotation.class), this.template(tree.getUnderlyingType()));
    }

    @Override
    public UExpression visitMemberSelect(MemberSelectTree tree, Void v) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (sym instanceof Symbol.ClassSymbol) {
            return UClassIdent.create((Symbol.ClassSymbol)sym);
        }
        if (sym.isStatic()) {
            ExpressionTree selected = tree.getExpression();
            Preconditions.checkState((boolean)(ASTHelpers.getSymbol(selected) instanceof Symbol.ClassSymbol), (Object)"Refaster cannot match static methods used on instances");
            return this.staticMember(sym);
        }
        return UMemberSelect.create(this.template(tree.getExpression()), tree.getIdentifier(), this.template(sym.type));
    }

    private UStaticIdent staticMember(Symbol symbol) {
        return UStaticIdent.create((Symbol.ClassSymbol)symbol.getEnclosingElement(), (CharSequence)symbol.getSimpleName(), this.template(symbol.asType()));
    }

    private static Tree getSingleExplicitTypeArgument(MethodInvocationTree tree) {
        if (tree.getTypeArguments().isEmpty()) {
            throw new IllegalArgumentException("Methods in the Refaster class must be invoked with an explicit type parameter; for example, 'Refaster.<T>isInstance(o)'.");
        }
        return (Tree)Iterables.getOnlyElement(tree.getTypeArguments());
    }

    static <T, U extends Unifiable<? super T>> boolean anyMatch(U toUnify, T target, Unifier unifier) {
        return toUnify.unify(target, unifier).first().isPresent();
    }

    @Override
    public UExpression visitMethodInvocation(MethodInvocationTree tree, Void v) {
        if (UTemplater.anyMatch(ANY_OF, tree.getMethodSelect(), new Unifier(this.context))) {
            return UAnyOf.create(this.templateExpressions(tree.getArguments()));
        }
        if (UTemplater.anyMatch(IS_INSTANCE, tree.getMethodSelect(), new Unifier(this.context))) {
            return UInstanceOf.create(this.template((ExpressionTree)Iterables.getOnlyElement(tree.getArguments())), this.templateType(UTemplater.getSingleExplicitTypeArgument(tree)));
        }
        if (UTemplater.anyMatch(CLAZZ, tree.getMethodSelect(), new Unifier(this.context))) {
            Tree typeArg = UTemplater.getSingleExplicitTypeArgument(tree);
            return UMemberSelect.create(this.templateType(typeArg), "class", UClassType.create("java.lang.Class", this.template(((JCTree)typeArg).type)));
        }
        if (UTemplater.anyMatch(NEW_ARRAY, tree.getMethodSelect(), new Unifier(this.context))) {
            Tree typeArg = UTemplater.getSingleExplicitTypeArgument(tree);
            ExpressionTree lengthArg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
            return UNewArray.create(this.templateType(typeArg), (List<? extends UExpression>)ImmutableList.of((Object)this.template(lengthArg)), null);
        }
        if (UTemplater.anyMatch(ENUM_VALUE_OF, tree.getMethodSelect(), new Unifier(this.context))) {
            Tree typeArg = UTemplater.getSingleExplicitTypeArgument(tree);
            ExpressionTree strArg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
            return UMethodInvocation.create((UExpression)UMemberSelect.create(this.templateType(typeArg), "valueOf", UMethodType.create(this.template(((JCTree)typeArg).type), UClassType.create("java.lang.String", new UType[0]))), this.template(strArg));
        }
        Map<Symbol.MethodSymbol, PlaceholderMethod> placeholderMethods = this.context.get(RefasterRuleBuilderScanner.PLACEHOLDER_METHODS_KEY);
        if (placeholderMethods != null && placeholderMethods.containsKey(ASTHelpers.getSymbol(tree))) {
            return UPlaceholderExpression.create(placeholderMethods.get(ASTHelpers.getSymbol(tree)), this.templateExpressions(tree.getArguments()));
        }
        return UMethodInvocation.create(this.template(tree.getMethodSelect()), this.templateExpressions(tree.getArguments()));
    }

    @Override
    public UBinary visitBinary(BinaryTree tree, Void v) {
        return UBinary.create(tree.getKind(), this.template(tree.getLeftOperand()), this.template(tree.getRightOperand()));
    }

    @Override
    public UAssignOp visitCompoundAssignment(CompoundAssignmentTree tree, Void v) {
        return UAssignOp.create(this.template(tree.getVariable()), tree.getKind(), this.template(tree.getExpression()));
    }

    @Override
    public UUnary visitUnary(UnaryTree tree, Void v) {
        return UUnary.create(tree.getKind(), this.template(tree.getExpression()));
    }

    @Override
    public UExpression visitConditionalExpression(ConditionalExpressionTree tree, Void v) {
        return UConditional.create(this.template(tree.getCondition()), this.template(tree.getTrueExpression()), this.template(tree.getFalseExpression()));
    }

    @Override
    public UNewArray visitNewArray(NewArrayTree tree, Void v) {
        return UNewArray.create((UExpression)this.template(tree.getType()), this.templateExpressions(tree.getDimensions()), this.templateExpressions(tree.getInitializers()));
    }

    @Override
    public UNewClass visitNewClass(NewClassTree tree, Void v) {
        return UNewClass.create(tree.getEnclosingExpression() == null ? null : this.template(tree.getEnclosingExpression()), this.templateTypeExpressions(tree.getTypeArguments()), this.template(tree.getIdentifier()), this.templateExpressions(tree.getArguments()), tree.getClassBody() == null ? null : this.visitClass(tree.getClassBody(), null));
    }

    @Override
    public UClassDecl visitClass(ClassTree tree, Void v) {
        ImmutableList.Builder decls = ImmutableList.builder();
        for (MethodTree decl : Iterables.filter(tree.getMembers(), MethodTree.class)) {
            if (decl.getReturnType() == null) continue;
            decls.add((Object)this.visitMethod(decl, null));
        }
        return UClassDecl.create((Iterable<UMethodDecl>)decls.build());
    }

    @Override
    public UArrayTypeTree visitArrayType(ArrayTypeTree tree, Void v) {
        return UArrayTypeTree.create(this.templateType(tree.getType()));
    }

    @Override
    public UTypeApply visitParameterizedType(ParameterizedTypeTree tree, Void v) {
        return UTypeApply.create(this.templateType(tree.getType()), this.templateTypeExpressions(tree.getTypeArguments()));
    }

    @Override
    public UUnionType visitUnionType(UnionTypeTree tree, Void v) {
        return UUnionType.create(this.templateTypeExpressions(tree.getTypeAlternatives()));
    }

    @Override
    public UWildcard visitWildcard(WildcardTree tree, Void v) {
        return UWildcard.create(tree.getKind(), tree.getBound() == null ? null : this.templateType(tree.getBound()));
    }

    @Override
    public UIntersectionType visitIntersectionType(IntersectionTypeTree tree, Void v) {
        return UIntersectionType.create(this.templateTypeExpressions(tree.getBounds()));
    }

    @Override
    public UTypeParameter visitTypeParameter(TypeParameterTree tree, Void v) {
        return UTypeParameter.create((CharSequence)tree.getName(), this.templateTypeExpressions(tree.getBounds()), UTemplater.cast(this.templateExpressions(tree.getAnnotations()), UAnnotation.class));
    }

    @Override
    public UTypeCast visitTypeCast(TypeCastTree tree, Void v) {
        return UTypeCast.create(this.templateType(tree.getType()), this.template(tree.getExpression()));
    }

    @Override
    public ULambda visitLambdaExpression(LambdaExpressionTree tree, Void v) {
        return ULambda.create(UTemplater.cast(this.templateStatements(tree.getParameters()), UVariableDecl.class), (UTree)this.template(tree.getBody()));
    }

    @Override
    public UMemberReference visitMemberReference(MemberReferenceTree tree, Void v) {
        return UMemberReference.create(tree.getMode(), this.template(tree.getQualifierExpression()), tree.getName(), tree.getTypeArguments() == null ? null : this.templateExpressions(tree.getTypeArguments()));
    }

    @Override
    public UExpression visitIdentifier(IdentifierTree tree, Void v) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (sym instanceof Symbol.ClassSymbol) {
            return UClassIdent.create((Symbol.ClassSymbol)sym);
        }
        if (sym != null && sym.isStatic()) {
            return this.staticMember(sym);
        }
        if (this.freeVariables.containsKey((Object)tree.getName().toString())) {
            Repeated repeated;
            OfKind hasKind;
            NotMatches notMatches;
            Symbol.VarSymbol symbol = (Symbol.VarSymbol)this.freeVariables.get((Object)tree.getName().toString());
            Preconditions.checkState((symbol == sym ? 1 : 0) != 0);
            UExpression ident = UFreeIdent.create(tree.getName());
            Matches matches = ASTHelpers.getAnnotation(symbol, Matches.class);
            if (matches != null) {
                ident = UMatches.create(UTemplater.getValue(matches), true, ident);
            }
            if ((notMatches = ASTHelpers.getAnnotation(symbol, NotMatches.class)) != null) {
                ident = UMatches.create(UTemplater.getValue(notMatches), false, ident);
            }
            if ((hasKind = ASTHelpers.getAnnotation(symbol, OfKind.class)) != null) {
                EnumSet<Tree.Kind> allowed = EnumSet.copyOf(Arrays.asList(hasKind.value()));
                ident = UOfKind.create(ident, (Set<Tree.Kind>)ImmutableSet.copyOf(allowed));
            }
            if ((repeated = ASTHelpers.getAnnotation(symbol, Repeated.class)) != null) {
                ident = URepeated.create(tree.getName(), ident);
            }
            return ident;
        }
        if (sym == null) {
            return UTypeVarIdent.create(tree.getName());
        }
        switch (sym.getKind()) {
            case TYPE_PARAMETER: {
                return UTypeVarIdent.create(tree.getName());
            }
        }
        return ULocalVarIdent.create(tree.getName());
    }

    static Class<? extends Matcher<? super ExpressionTree>> getValue(Matches matches) {
        try {
            matches.value();
            throw new RuntimeException("unreachable");
        }
        catch (MirroredTypeException e) {
            DeclaredType type = (DeclaredType)e.getTypeMirror();
            String name = ((TypeElement)type.asElement()).getQualifiedName().toString();
            try {
                return UTemplater.asSubclass(Class.forName(name), new TypeToken<Matcher<? super ExpressionTree>>(){});
            }
            catch (ClassCastException | ClassNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    static Class<? extends Matcher<? super ExpressionTree>> getValue(NotMatches matches) {
        try {
            matches.value();
            throw new RuntimeException("unreachable");
        }
        catch (MirroredTypeException e) {
            DeclaredType type = (DeclaredType)e.getTypeMirror();
            String name = ((TypeElement)type.asElement()).getQualifiedName().toString();
            try {
                return UTemplater.asSubclass(Class.forName(name), new TypeToken<Matcher<? super ExpressionTree>>(){});
            }
            catch (ClassCastException | ClassNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static <T> Class<? extends T> asSubclass(Class<?> klass, TypeToken<T> token) throws ClassCastException {
        if (!token.isSupertypeOf(klass)) {
            throw new ClassCastException(klass + " is not assignable to " + token);
        }
        return klass;
    }

    public UStatement template(StatementTree tree) {
        return (UStatement)tree.accept(this, null);
    }

    @Nullable
    private List<UStatement> templateStatements(@Nullable List<? extends StatementTree> statements) {
        if (statements == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StatementTree statementTree : statements) {
            builder.add((Object)this.template(statementTree));
        }
        return builder.build();
    }

    @Override
    public UTry visitTry(TryTree tree, Void v) {
        ImmutableList<UTree> resources = UTemplater.cast(this.templateTrees(tree.getResources()), UTree.class);
        UBlock block = this.visitBlock(tree.getBlock(), null);
        ImmutableList.Builder catchesBuilder = ImmutableList.builder();
        for (CatchTree catchTree : tree.getCatches()) {
            catchesBuilder.add((Object)this.visitCatch(catchTree, null));
        }
        UBlock finallyBlock = tree.getFinallyBlock() == null ? null : this.visitBlock(tree.getFinallyBlock(), null);
        return UTry.create(resources, block, (Iterable<UCatch>)catchesBuilder.build(), finallyBlock);
    }

    @Override
    public UCatch visitCatch(CatchTree tree, Void v) {
        return UCatch.create(this.visitVariable(tree.getParameter(), null), this.visitBlock(tree.getBlock(), null));
    }

    @Nullable
    private PlaceholderMethod placeholder(@Nullable ExpressionTree expr) {
        Map<Symbol.MethodSymbol, PlaceholderMethod> placeholderMethods = this.context.get(RefasterRuleBuilderScanner.PLACEHOLDER_METHODS_KEY);
        return placeholderMethods != null && expr != null ? placeholderMethods.get(ASTHelpers.getSymbol(expr)) : null;
    }

    @Override
    public UStatement visitExpressionStatement(ExpressionStatementTree tree, Void v) {
        PlaceholderMethod placeholderMethod = this.placeholder(tree.getExpression());
        if (placeholderMethod != null && placeholderMethod.returnType().equals(UPrimitiveType.VOID)) {
            MethodInvocationTree invocation = (MethodInvocationTree)tree.getExpression();
            return UPlaceholderStatement.create(placeholderMethod, this.templateExpressions(invocation.getArguments()), ControlFlowVisitor.Result.NEVER_EXITS);
        }
        return UExpressionStatement.create(this.template(tree.getExpression()));
    }

    @Override
    public UStatement visitReturn(ReturnTree tree, Void v) {
        PlaceholderMethod placeholderMethod = this.placeholder(tree.getExpression());
        if (placeholderMethod != null) {
            MethodInvocationTree invocation = (MethodInvocationTree)tree.getExpression();
            return UPlaceholderStatement.create(placeholderMethod, this.templateExpressions(invocation.getArguments()), ControlFlowVisitor.Result.ALWAYS_RETURNS);
        }
        return UReturn.create(tree.getExpression() == null ? null : this.template(tree.getExpression()));
    }

    @Override
    public UWhileLoop visitWhileLoop(WhileLoopTree tree, Void v) {
        return UWhileLoop.create(this.template(tree.getCondition()), this.template(tree.getStatement()));
    }

    @Override
    public UVariableDecl visitVariable(VariableTree tree, Void v) {
        return UVariableDecl.create(tree.getName(), this.templateType(tree.getType()), tree.getInitializer() == null ? null : this.template(tree.getInitializer()));
    }

    @Override
    public USkip visitEmptyStatement(EmptyStatementTree tree, Void v) {
        return USkip.INSTANCE;
    }

    @Override
    public UForLoop visitForLoop(ForLoopTree tree, Void v) {
        return UForLoop.create(this.templateStatements(tree.getInitializer()), tree.getCondition() == null ? null : this.template(tree.getCondition()), UTemplater.cast(this.templateStatements(tree.getUpdate()), UExpressionStatement.class), this.template(tree.getStatement()));
    }

    @Override
    public ULabeledStatement visitLabeledStatement(LabeledStatementTree tree, Void v) {
        return ULabeledStatement.create(tree.getLabel(), this.template(tree.getStatement()));
    }

    @Override
    public UBreak visitBreak(BreakTree tree, Void v) {
        return UBreak.create(tree.getLabel());
    }

    @Override
    public UContinue visitContinue(ContinueTree tree, Void v) {
        return UContinue.create(tree.getLabel());
    }

    @Override
    public UBlock visitBlock(BlockTree tree, Void v) {
        return UBlock.create(this.templateStatements(tree.getStatements()));
    }

    @Override
    public UThrow visitThrow(ThrowTree tree, Void v) {
        return UThrow.create(this.template(tree.getExpression()));
    }

    @Override
    public UDoWhileLoop visitDoWhileLoop(DoWhileLoopTree tree, Void v) {
        return UDoWhileLoop.create(this.template(tree.getStatement()), this.template(tree.getCondition()));
    }

    @Override
    public UEnhancedForLoop visitEnhancedForLoop(EnhancedForLoopTree tree, Void v) {
        return UEnhancedForLoop.create(this.visitVariable(tree.getVariable(), null), this.template(tree.getExpression()), this.template(tree.getStatement()));
    }

    @Override
    public USynchronized visitSynchronized(SynchronizedTree tree, Void v) {
        return USynchronized.create(this.template(tree.getExpression()), this.visitBlock(tree.getBlock(), null));
    }

    @Override
    public UIf visitIf(IfTree tree, Void v) {
        return UIf.create(this.template(tree.getCondition()), this.template(tree.getThenStatement()), tree.getElseStatement() == null ? null : this.template(tree.getElseStatement()));
    }

    @Override
    public UAssert visitAssert(AssertTree tree, Void v) {
        return UAssert.create(this.template(tree.getCondition()), tree.getDetail() == null ? null : this.template(tree.getDetail()));
    }

    @Override
    protected UTree<?> defaultAction(Tree tree, Void v) {
        throw new IllegalArgumentException("Refaster does not currently support syntax " + tree.getClass());
    }

    public UType template(Type type) {
        return type.accept(this.typeTemplater, null);
    }

    List<UType> templateTypes(Iterable<? extends Type> types) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : types) {
            builder.add((Object)this.template(type));
        }
        return builder.build();
    }

    public static ImmutableClassToInstanceMap<Annotation> annotationMap(Symbol symbol) {
        ImmutableClassToInstanceMap.Builder builder = ImmutableClassToInstanceMap.builder();
        for (Attribute.Compound compound : symbol.getAnnotationMirrors()) {
            javax.lang.model.element.Name qualifiedAnnotationType = ((TypeElement)compound.getAnnotationType().asElement()).getQualifiedName();
            try {
                Class<Annotation> annotationClazz = Class.forName(qualifiedAnnotationType.toString()).asSubclass(Annotation.class);
                builder.put(annotationClazz, (Object)AnnotationProxyMaker.generateAnnotation(compound, annotationClazz));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unrecognized annotation type", e);
            }
        }
        return builder.build();
    }

    static {
        UTypeVar tVar = UTypeVar.create("T");
        ANY_OF = UStaticIdent.create(Refaster.class.getCanonicalName(), (CharSequence)"anyOf", (UType)UForAll.create((List<UTypeVar>)ImmutableList.of((Object)tVar), UMethodType.create((UType)tVar, UArrayType.create(tVar))));
        IS_INSTANCE = UStaticIdent.create(Refaster.class.getCanonicalName(), (CharSequence)"isInstance", (UType)UForAll.create((List<UTypeVar>)ImmutableList.of((Object)tVar), UMethodType.create((UType)UPrimitiveType.BOOLEAN, UClassType.create(Object.class.getCanonicalName(), new UType[0]))));
        CLAZZ = UStaticIdent.create(Refaster.class.getCanonicalName(), (CharSequence)"clazz", (UType)UForAll.create((List<UTypeVar>)ImmutableList.of((Object)tVar), UMethodType.create((UType)UClassType.create(Class.class.getCanonicalName(), tVar), new UType[0])));
        NEW_ARRAY = UStaticIdent.create(Refaster.class.getCanonicalName(), (CharSequence)"newArray", (UType)UForAll.create((List<UTypeVar>)ImmutableList.of((Object)tVar), UMethodType.create((UType)UArrayType.create(tVar), UPrimitiveType.INT)));
        UTypeVar eVar = UTypeVar.create("E", UClassType.create(Enum.class.getCanonicalName(), UTypeVar.create("E")));
        ENUM_VALUE_OF = UStaticIdent.create(Refaster.class.getCanonicalName(), (CharSequence)"enumValueOf", (UType)UForAll.create((List<UTypeVar>)ImmutableList.of((Object)eVar), UMethodType.create((UType)eVar, UClassType.create(String.class.getCanonicalName(), new UType[0]))));
    }
}

