/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.suppliers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;

public class Suppliers {
    public static final Supplier<Type> JAVA_LANG_VOID_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getTypeFromString("java.lang.Void");
        }
    };
    public static final Supplier<Type> VOID_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().voidType;
        }
    };
    public static final Supplier<Type> JAVA_LANG_BOOLEAN_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getTypeFromString("java.lang.Boolean");
        }
    };
    public static final Supplier<Type> BOOLEAN_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().booleanType;
        }
    };
    public static final Supplier<Type> INT_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().intType;
        }
    };
    public static final Supplier<Type> OBJECT_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().objectType;
        }
    };
    public static final Supplier<Type> EXCEPTION_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().exceptionType;
        }
    };
    public static final Supplier<Type> ANNOTATION_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().annotationType;
        }
    };
    public static Supplier<Type> ENCLOSING_CLASS = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return ((JCTree)state.findEnclosing(new Class[]{ClassTree.class})).type;
        }
    };

    public static Supplier<Type> genericTypeOf(final Supplier<ExpressionTree> expressionSupplier, final int n) {
        return new Supplier<Type>(){

            @Override
            public Type get(VisitorState state) {
                JCTree.JCExpression jcExpression = (JCTree.JCExpression)expressionSupplier.get(state);
                if (jcExpression.type.getTypeArguments().size() <= n) {
                    return state.getSymtab().objectType;
                }
                return jcExpression.type.getTypeArguments().get(n);
            }
        };
    }

    public static Supplier<Type> genericTypeOfType(final Supplier<Type> typeSupplier, final int n) {
        return new Supplier<Type>(){

            @Override
            public Type get(VisitorState state) {
                Type type = (Type)typeSupplier.get(state);
                if (type.getTypeArguments().size() <= n) {
                    return state.getSymtab().objectType;
                }
                return type.getTypeArguments().get(n);
            }
        };
    }

    public static Supplier<Type> receiverType() {
        return new Supplier<Type>(){

            @Override
            public Type get(VisitorState state) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)state.getPath().getLeaf();
                return ASTHelpers.getReceiverType(methodInvocation.getMethodSelect());
            }
        };
    }

    public static Supplier<ExpressionTree> receiverInstance() {
        return new Supplier<ExpressionTree>(){

            @Override
            public ExpressionTree get(VisitorState state) {
                MethodInvocationTree method = (MethodInvocationTree)state.getPath().getLeaf();
                return ((JCTree.JCFieldAccess)method.getMethodSelect()).getExpression();
            }
        };
    }

    public static Supplier<Type> typeFromString(final String typeString) {
        return new Supplier<Type>(){

            @Override
            public Type get(VisitorState state) {
                return state.getTypeFromString(typeString);
            }
        };
    }

    public static <T> Supplier<T> identitySupplier(final T toSupply) {
        return new Supplier<T>(){

            @Override
            public T get(VisitorState state) {
                return toSupply;
            }
        };
    }
}

