/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

class ByteUtils {
    @NonNull
    private final ByteBuffer mIntBuffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
    @NonNull
    private final ByteBuffer mLongBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);

    ByteUtils() {
    }

    @NonNull
    byte[] getLongAsIntArray(long value) {
        return ((ByteBuffer)this.mLongBuffer.rewind()).putLong(value).array();
    }

    @NonNull
    byte[] getIntAsArray(int value) {
        return ((ByteBuffer)this.mIntBuffer.rewind()).putInt(value).array();
    }

    static class Cache {
        private static final Cache sPngCache = new Cache();
        private final Map<Long, ByteUtils> map = Maps.newHashMap();

        Cache() {
        }

        @NonNull
        static Cache getCache() {
            return sPngCache;
        }

        synchronized ByteUtils getUtils(long key) {
            ByteUtils utils = this.map.get(key);
            if (utils == null) {
                utils = new ByteUtils();
                this.map.put(key, utils);
            }
            return utils;
        }

        static ByteUtils get() {
            return Cache.getCache().getUtils(Thread.currentThread().getId());
        }

        synchronized void clear() {
            this.map.clear();
        }
    }
}

