/* Copyright (c) 2015, Google Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

 /* This file was generated by err_data_generate.go. */

#include <openssl/base.h>
#include <openssl/err.h>
#include <openssl/type_check.h>


OPENSSL_COMPILE_ASSERT(ERR_LIB_NONE == 1, library_values_changed_1);
OPENSSL_COMPILE_ASSERT(ERR_LIB_SYS == 2, library_values_changed_2);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BN == 3, library_values_changed_3);
OPENSSL_COMPILE_ASSERT(ERR_LIB_RSA == 4, library_values_changed_4);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DH == 5, library_values_changed_5);
OPENSSL_COMPILE_ASSERT(ERR_LIB_EVP == 6, library_values_changed_6);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BUF == 7, library_values_changed_7);
OPENSSL_COMPILE_ASSERT(ERR_LIB_OBJ == 8, library_values_changed_8);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PEM == 9, library_values_changed_9);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DSA == 10, library_values_changed_10);
OPENSSL_COMPILE_ASSERT(ERR_LIB_X509 == 11, library_values_changed_11);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ASN1 == 12, library_values_changed_12);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CONF == 13, library_values_changed_13);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CRYPTO == 14, library_values_changed_14);
OPENSSL_COMPILE_ASSERT(ERR_LIB_EC == 15, library_values_changed_15);
OPENSSL_COMPILE_ASSERT(ERR_LIB_SSL == 16, library_values_changed_16);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BIO == 17, library_values_changed_17);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PKCS7 == 18, library_values_changed_18);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PKCS8 == 19, library_values_changed_19);
OPENSSL_COMPILE_ASSERT(ERR_LIB_X509V3 == 20, library_values_changed_20);
OPENSSL_COMPILE_ASSERT(ERR_LIB_RAND == 21, library_values_changed_21);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ENGINE == 22, library_values_changed_22);
OPENSSL_COMPILE_ASSERT(ERR_LIB_OCSP == 23, library_values_changed_23);
OPENSSL_COMPILE_ASSERT(ERR_LIB_UI == 24, library_values_changed_24);
OPENSSL_COMPILE_ASSERT(ERR_LIB_COMP == 25, library_values_changed_25);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ECDSA == 26, library_values_changed_26);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ECDH == 27, library_values_changed_27);
OPENSSL_COMPILE_ASSERT(ERR_LIB_HMAC == 28, library_values_changed_28);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DIGEST == 29, library_values_changed_29);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CIPHER == 30, library_values_changed_30);
OPENSSL_COMPILE_ASSERT(ERR_LIB_HKDF == 31, library_values_changed_31);
OPENSSL_COMPILE_ASSERT(ERR_LIB_USER == 32, library_values_changed_32);
OPENSSL_COMPILE_ASSERT(ERR_NUM_LIBS == 33, library_values_changed_num);

const uint32_t kOpenSSLReasonValues[] = {
    0xc3207ba,
    0xc3287d4,
    0xc3307e3,
    0xc3387f3,
    0xc340802,
    0xc34881b,
    0xc350827,
    0xc358844,
    0xc360856,
    0xc368864,
    0xc370874,
    0xc378881,
    0xc380891,
    0xc38889c,
    0xc3908b2,
    0xc3988c1,
    0xc3a08d5,
    0xc3a87c7,
    0xc3b00b0,
    0x10321478,
    0x10329484,
    0x1033149d,
    0x103394b0,
    0x10340de1,
    0x103494cf,
    0x103514e4,
    0x10359516,
    0x1036152f,
    0x10369544,
    0x10371562,
    0x10379571,
    0x1038158d,
    0x103895a8,
    0x103915b7,
    0x103995d3,
    0x103a15ee,
    0x103a9605,
    0x103b1616,
    0x103b962a,
    0x103c1649,
    0x103c9658,
    0x103d166f,
    0x103d9682,
    0x103e0b6c,
    0x103e96b3,
    0x103f16c6,
    0x103f96e0,
    0x104016f0,
    0x10409704,
    0x1041171a,
    0x10419732,
    0x10421747,
    0x1042975b,
    0x1043176d,
    0x104385d0,
    0x104408c1,
    0x10449782,
    0x10451799,
    0x104597ae,
    0x104617bc,
    0x10469695,
    0x104714f7,
    0x104787c7,
    0x104800b0,
    0x104894c3,
    0x14320b4f,
    0x14328b5d,
    0x14330b6c,
    0x14338b7e,
    0x18320083,
    0x18328e47,
    0x18340e75,
    0x18348e89,
    0x18358ec0,
    0x18368eed,
    0x18370f00,
    0x18378f14,
    0x18380f38,
    0x18388f46,
    0x18390f5c,
    0x18398f70,
    0x183a0f80,
    0x183b0f90,
    0x183b8fa5,
    0x183c8fd0,
    0x183d0fe4,
    0x183d8ff4,
    0x183e0b9b,
    0x183e9001,
    0x183f1013,
    0x183f901e,
    0x1840102e,
    0x1840903f,
    0x18411050,
    0x18419062,
    0x1842108b,
    0x184290bd,
    0x184310cc,
    0x18451135,
    0x1845914b,
    0x18461166,
    0x18468ed8,
    0x184709d9,
    0x18478094,
    0x18480fbc,
    0x18489101,
    0x18490e5d,
    0x18498e9e,
    0x184a119c,
    0x184a9119,
    0x184b10e0,
    0x184b8e37,
    0x184c10a4,
    0x184c866b,
    0x184d1181,
    0x203211c3,
    0x243211cf,
    0x24328907,
    0x243311e1,
    0x243391ee,
    0x243411fb,
    0x2434920d,
    0x2435121c,
    0x24359239,
    0x24361246,
    0x24369254,
    0x24371262,
    0x24379270,
    0x24381279,
    0x24389286,
    0x24391299,
    0x28320b8f,
    0x28328b9b,
    0x28330b6c,
    0x28338bae,
    0x2c322bfd,
    0x2c32ac0b,
    0x2c332c1d,
    0x2c33ac2f,
    0x2c342c43,
    0x2c34ac55,
    0x2c352c70,
    0x2c35ac82,
    0x2c362c95,
    0x2c3682f3,
    0x2c372ca2,
    0x2c37acb4,
    0x2c382cc7,
    0x2c38acd5,
    0x2c392ce5,
    0x2c39acf7,
    0x2c3a2d0b,
    0x2c3aad1c,
    0x2c3b1359,
    0x2c3bad2d,
    0x2c3c2d41,
    0x2c3cad57,
    0x2c3d2d70,
    0x2c3dad9e,
    0x2c3e2dac,
    0x2c3eadc4,
    0x2c3f2ddc,
    0x2c3fade9,
    0x2c402e0c,
    0x2c40ae2b,
    0x2c4111c3,
    0x2c41ae3c,
    0x2c422e4f,
    0x2c429135,
    0x2c432e60,
    0x2c4386a2,
    0x2c442d8d,
    0x30320000,
    0x30328015,
    0x3033001f,
    0x30338038,
    0x3034004a,
    0x30348064,
    0x3035006b,
    0x30358083,
    0x30360094,
    0x303680a1,
    0x303700b0,
    0x303780bd,
    0x303800d0,
    0x303880eb,
    0x30390100,
    0x30398114,
    0x303a0128,
    0x303a8139,
    0x303b0152,
    0x303b816f,
    0x303c017d,
    0x303c8191,
    0x303d01a1,
    0x303d81ba,
    0x303e01ca,
    0x303e81dd,
    0x303f01ec,
    0x303f81f8,
    0x3040020d,
    0x3040821d,
    0x30410234,
    0x30418241,
    0x30420254,
    0x30428263,
    0x30430278,
    0x30438299,
    0x304402ac,
    0x304482bf,
    0x304502d8,
    0x304582f3,
    0x30460310,
    0x30468329,
    0x30470337,
    0x30478348,
    0x30480357,
    0x3048836f,
    0x30490381,
    0x30498395,
    0x304a03b4,
    0x304a83c7,
    0x304b03d2,
    0x304b83e1,
    0x304c03f2,
    0x304c83fe,
    0x304d0414,
    0x304d8422,
    0x304e0438,
    0x304e844a,
    0x304f045c,
    0x304f846f,
    0x30500482,
    0x30508493,
    0x305104a3,
    0x305184bb,
    0x305204d0,
    0x305284e8,
    0x305304fc,
    0x30538514,
    0x3054052d,
    0x30548546,
    0x30550563,
    0x3055856e,
    0x30560586,
    0x30568596,
    0x305705a7,
    0x305785ba,
    0x305805d0,
    0x305885d9,
    0x305905ee,
    0x30598601,
    0x305a0610,
    0x305a8630,
    0x305b063f,
    0x305b864b,
    0x305c066b,
    0x305c8687,
    0x305d0698,
    0x305d86a2,
    0x34320ac9,
    0x34328add,
    0x34330afa,
    0x34338b0d,
    0x34340b1c,
    0x34348b39,
    0x3c320083,
    0x3c328bd8,
    0x3c330bf1,
    0x3c338c0c,
    0x3c340c29,
    0x3c348c44,
    0x3c350c5f,
    0x3c358c74,
    0x3c360c8d,
    0x3c368ca5,
    0x3c370cb6,
    0x3c378cc4,
    0x3c380cd1,
    0x3c388ce5,
    0x3c390b9b,
    0x3c398cf9,
    0x3c3a0d0d,
    0x3c3a8881,
    0x3c3b0d1d,
    0x3c3b8d38,
    0x3c3c0d4a,
    0x3c3c8d60,
    0x3c3d0d6a,
    0x3c3d8d7e,
    0x3c3e0d8c,
    0x3c3e8db1,
    0x3c3f0bc4,
    0x3c3f8d9a,
    0x403217d3,
    0x403297e9,
    0x40331817,
    0x40339821,
    0x40341838,
    0x40349856,
    0x40351866,
    0x40359878,
    0x40361885,
    0x40369891,
    0x403718a6,
    0x403798bb,
    0x403818cd,
    0x403898d8,
    0x403918ea,
    0x40398de1,
    0x403a18fa,
    0x403a990d,
    0x403b192e,
    0x403b993f,
    0x403c194f,
    0x403c8064,
    0x403d195b,
    0x403d9977,
    0x403e198d,
    0x403e999c,
    0x403f19af,
    0x403f99c9,
    0x404019d7,
    0x404099ec,
    0x40411a00,
    0x40419a1d,
    0x40421a36,
    0x40429a51,
    0x40431a6a,
    0x40439a7d,
    0x40441a91,
    0x40449aa9,
    0x40451af4,
    0x40459b02,
    0x40461b20,
    0x40468094,
    0x40471b35,
    0x40479b47,
    0x40481b6b,
    0x40489b8b,
    0x40491b9f,
    0x40499bb4,
    0x404a1bcd,
    0x404a9c07,
    0x404b1c38,
    0x404b9c6e,
    0x404c1c89,
    0x404c9ca3,
    0x404d1cba,
    0x404d9ce2,
    0x404e1cf9,
    0x404e9d15,
    0x404f1d31,
    0x404f9d52,
    0x40501d74,
    0x40509d90,
    0x40511da4,
    0x40519db1,
    0x40521dc8,
    0x40529dd8,
    0x40531de8,
    0x40539dfc,
    0x40541e17,
    0x40549e27,
    0x40551e3e,
    0x40559e4d,
    0x40561e7a,
    0x40569e92,
    0x40571eae,
    0x40579ec7,
    0x40581eda,
    0x40589eef,
    0x40591f12,
    0x40599f3d,
    0x405a1f4a,
    0x405a9f63,
    0x405b1f7b,
    0x405b9f8e,
    0x405c1fa3,
    0x405c9fb5,
    0x405d1fca,
    0x405d9fda,
    0x405e1ff3,
    0x405ea007,
    0x405f2017,
    0x405fa02f,
    0x40602040,
    0x4060a053,
    0x40612064,
    0x4061a082,
    0x40622093,
    0x4062a0a0,
    0x406320b7,
    0x4063a0f8,
    0x4064210f,
    0x4064a11c,
    0x4065212a,
    0x4065a14c,
    0x40662174,
    0x4066a189,
    0x406721a0,
    0x4067a1b1,
    0x406821c2,
    0x4068a1d3,
    0x406921e8,
    0x4069a1ff,
    0x406a2210,
    0x406aa229,
    0x406b2244,
    0x406ba25b,
    0x406c22c8,
    0x406ca2e9,
    0x406d22fc,
    0x406da31d,
    0x406e2338,
    0x406ea381,
    0x406f23a2,
    0x406fa3c8,
    0x407023e8,
    0x4070a404,
    0x40712591,
    0x4071a5b4,
    0x407225ca,
    0x4072a5e9,
    0x40732601,
    0x4073a621,
    0x4074284b,
    0x4074a870,
    0x4075288b,
    0x4075a8aa,
    0x407628d9,
    0x4076a901,
    0x40772932,
    0x4077a951,
    0x4078298b,
    0x4078a9a2,
    0x407929b5,
    0x4079a9d2,
    0x407a0782,
    0x407aa9e4,
    0x407b29f7,
    0x407baa10,
    0x407c2a28,
    0x407c90bd,
    0x407d2a3c,
    0x407daa56,
    0x407e2a67,
    0x407eaa7b,
    0x407f2a89,
    0x407faaa4,
    0x40801286,
    0x4080aac9,
    0x40812aeb,
    0x4081ab06,
    0x40822b1b,
    0x4082ab33,
    0x40832b4b,
    0x4083ab62,
    0x40842b78,
    0x4084ab84,
    0x40852b97,
    0x4085abac,
    0x40862bbe,
    0x4086abd3,
    0x40872bdc,
    0x40879cd0,
    0x40880083,
    0x4088a0d7,
    0x40890a17,
    0x4089a273,
    0x408a1bf0,
    0x408aa29d,
    0x408b291a,
    0x408ba976,
    0x408c2353,
    0x408c9c21,
    0x408d1c56,
    0x408d9e68,
    0x408e1ab9,
    0x408e9add,
    0x408f1f20,
    0x41f424bc,
    0x41f9254e,
    0x41fe2441,
    0x41fea672,
    0x41ff2763,
    0x420324d5,
    0x420824f7,
    0x4208a533,
    0x42092425,
    0x4209a56d,
    0x420a247c,
    0x420aa45c,
    0x420b249c,
    0x420ba515,
    0x420c277f,
    0x420ca63f,
    0x420d2659,
    0x420da690,
    0x421226aa,
    0x42172746,
    0x4217a6ec,
    0x421c270e,
    0x421f26c9,
    0x42212796,
    0x42262729,
    0x422b282f,
    0x422ba7f8,
    0x422c2817,
    0x422ca7d2,
    0x422d27b1,
    0x443206ad,
    0x443286bc,
    0x443306c8,
    0x443386d6,
    0x443406e9,
    0x443486fa,
    0x44350701,
    0x4435870b,
    0x4436071e,
    0x44368734,
    0x44370746,
    0x44378753,
    0x44380762,
    0x4438876a,
    0x44390782,
    0x44398790,
    0x443a07a3,
    0x4c3212b0,
    0x4c3292c0,
    0x4c3312d3,
    0x4c3392f3,
    0x4c340094,
    0x4c3480b0,
    0x4c3512ff,
    0x4c35930d,
    0x4c361329,
    0x4c36933c,
    0x4c37134b,
    0x4c379359,
    0x4c38136e,
    0x4c38937a,
    0x4c39139a,
    0x4c3993c4,
    0x4c3a13dd,
    0x4c3a93f6,
    0x4c3b05d0,
    0x4c3b940f,
    0x4c3c1421,
    0x4c3c9430,
    0x4c3d10bd,
    0x4c3d9449,
    0x4c3e1456,
    0x50322e72,
    0x5032ae81,
    0x50332e8c,
    0x5033ae9c,
    0x50342eb5,
    0x5034aecf,
    0x50352edd,
    0x5035aef3,
    0x50362f05,
    0x5036af1b,
    0x50372f34,
    0x5037af47,
    0x50382f5f,
    0x5038af70,
    0x50392f85,
    0x5039af99,
    0x503a2fb9,
    0x503aafcf,
    0x503b2fe7,
    0x503baff9,
    0x503c3015,
    0x503cb02c,
    0x503d3045,
    0x503db05b,
    0x503e3068,
    0x503eb07e,
    0x503f3090,
    0x503f8348,
    0x504030a3,
    0x5040b0b3,
    0x504130cd,
    0x5041b0dc,
    0x504230f6,
    0x5042b113,
    0x50433123,
    0x5043b133,
    0x50443142,
    0x50448414,
    0x50453156,
    0x5045b174,
    0x50463187,
    0x5046b19d,
    0x504731af,
    0x5047b1c4,
    0x504831ea,
    0x5048b1f8,
    0x5049320b,
    0x5049b220,
    0x504a3236,
    0x504ab246,
    0x504b3266,
    0x504bb279,
    0x504c329c,
    0x504cb2ca,
    0x504d32dc,
    0x504db2f9,
    0x504e3314,
    0x504eb330,
    0x504f3342,
    0x504fb359,
    0x50503368,
    0x50508687,
    0x5051337b,
    0x58320e1f,
    0x68320de1,
    0x68328b9b,
    0x68330bae,
    0x68338def,
    0x68340dff,
    0x683480b0,
    0x6c320dbd,
    0x6c328b7e,
    0x6c330dc8,
    0x7432098d,
    0x783208f2,
    0x78328907,
    0x78330913,
    0x78338083,
    0x78340922,
    0x78348937,
    0x78350956,
    0x78358978,
    0x7836098d,
    0x783689a3,
    0x783709b3,
    0x783789c6,
    0x783809d9,
    0x783889eb,
    0x783909f8,
    0x78398a17,
    0x783a0a2c,
    0x783a8a3a,
    0x783b0a44,
    0x783b8a58,
    0x783c0a6f,
    0x783c8a84,
    0x783d0a9b,
    0x783d8ab0,
    0x783e0a06,
    0x7c3211b2,
};

const size_t kOpenSSLReasonValuesLen = sizeof(kOpenSSLReasonValues) / sizeof(kOpenSSLReasonValues[0]);

const char kOpenSSLReasonStringData[] =
    "ASN1_LENGTH_MISMATCH\0"
    "AUX_ERROR\0"
    "BAD_GET_ASN1_OBJECT_CALL\0"
    "BAD_OBJECT_HEADER\0"
    "BMPSTRING_IS_WRONG_LENGTH\0"
    "BN_LIB\0"
    "BOOLEAN_IS_WRONG_LENGTH\0"
    "BUFFER_TOO_SMALL\0"
    "DECODE_ERROR\0"
    "DEPTH_EXCEEDED\0"
    "ENCODE_ERROR\0"
    "ERROR_GETTING_TIME\0"
    "EXPECTING_AN_ASN1_SEQUENCE\0"
    "EXPECTING_AN_INTEGER\0"
    "EXPECTING_AN_OBJECT\0"
    "EXPECTING_A_BOOLEAN\0"
    "EXPECTING_A_TIME\0"
    "EXPLICIT_LENGTH_MISMATCH\0"
    "EXPLICIT_TAG_NOT_CONSTRUCTED\0"
    "FIELD_MISSING\0"
    "FIRST_NUM_TOO_LARGE\0"
    "HEADER_TOO_LONG\0"
    "ILLEGAL_BITSTRING_FORMAT\0"
    "ILLEGAL_BOOLEAN\0"
    "ILLEGAL_CHARACTERS\0"
    "ILLEGAL_FORMAT\0"
    "ILLEGAL_HEX\0"
    "ILLEGAL_IMPLICIT_TAG\0"
    "ILLEGAL_INTEGER\0"
    "ILLEGAL_NESTED_TAGGING\0"
    "ILLEGAL_NULL\0"
    "ILLEGAL_NULL_VALUE\0"
    "ILLEGAL_OBJECT\0"
    "ILLEGAL_OPTIONAL_ANY\0"
    "ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE\0"
    "ILLEGAL_TAGGED_ANY\0"
    "ILLEGAL_TIME_VALUE\0"
    "INTEGER_NOT_ASCII_FORMAT\0"
    "INTEGER_TOO_LARGE_FOR_LONG\0"
    "INVALID_BIT_STRING_BITS_LEFT\0"
    "INVALID_BMPSTRING_LENGTH\0"
    "INVALID_DIGIT\0"
    "INVALID_MODIFIER\0"
    "INVALID_NUMBER\0"
    "INVALID_OBJECT_ENCODING\0"
    "INVALID_SEPARATOR\0"
    "INVALID_TIME_FORMAT\0"
    "INVALID_UNIVERSALSTRING_LENGTH\0"
    "INVALID_UTF8STRING\0"
    "LIST_ERROR\0"
    "MALLOC_FAILURE\0"
    "MISSING_ASN1_EOS\0"
    "MISSING_EOC\0"
    "MISSING_SECOND_NUMBER\0"
    "MISSING_VALUE\0"
    "MSTRING_NOT_UNIVERSAL\0"
    "MSTRING_WRONG_TAG\0"
    "NESTED_ASN1_ERROR\0"
    "NESTED_ASN1_STRING\0"
    "NON_HEX_CHARACTERS\0"
    "NOT_ASCII_FORMAT\0"
    "NOT_ENOUGH_DATA\0"
    "NO_MATCHING_CHOICE_TYPE\0"
    "NULL_IS_WRONG_LENGTH\0"
    "OBJECT_NOT_ASCII_FORMAT\0"
    "ODD_NUMBER_OF_CHARS\0"
    "SECOND_NUMBER_TOO_LARGE\0"
    "SEQUENCE_LENGTH_MISMATCH\0"
    "SEQUENCE_NOT_CONSTRUCTED\0"
    "SEQUENCE_OR_SET_NEEDS_CONFIG\0"
    "SHORT_LINE\0"
    "STREAMING_NOT_SUPPORTED\0"
    "STRING_TOO_LONG\0"
    "STRING_TOO_SHORT\0"
    "TAG_VALUE_TOO_HIGH\0"
    "TIME_NOT_ASCII_FORMAT\0"
    "TOO_LONG\0"
    "TYPE_NOT_CONSTRUCTED\0"
    "TYPE_NOT_PRIMITIVE\0"
    "UNEXPECTED_EOC\0"
    "UNIVERSALSTRING_IS_WRONG_LENGTH\0"
    "UNKNOWN_FORMAT\0"
    "UNKNOWN_TAG\0"
    "UNSUPPORTED_ANY_DEFINED_BY_TYPE\0"
    "UNSUPPORTED_PUBLIC_KEY_TYPE\0"
    "UNSUPPORTED_TYPE\0"
    "WRONG_TAG\0"
    "WRONG_TYPE\0"
    "BAD_FOPEN_MODE\0"
    "BROKEN_PIPE\0"
    "CONNECT_ERROR\0"
    "ERROR_SETTING_NBIO\0"
    "INVALID_ARGUMENT\0"
    "IN_USE\0"
    "KEEPALIVE\0"
    "NBIO_CONNECT_ERROR\0"
    "NO_HOSTNAME_SPECIFIED\0"
    "NO_PORT_SPECIFIED\0"
    "NO_SUCH_FILE\0"
    "NULL_PARAMETER\0"
    "SYS_LIB\0"
    "UNABLE_TO_CREATE_SOCKET\0"
    "UNINITIALIZED\0"
    "UNSUPPORTED_METHOD\0"
    "WRITE_TO_READ_ONLY_BIO\0"
    "ARG2_LT_ARG3\0"
    "BAD_ENCODING\0"
    "BAD_RECIPROCAL\0"
    "BIGNUM_TOO_LONG\0"
    "BITS_TOO_SMALL\0"
    "CALLED_WITH_EVEN_MODULUS\0"
    "DIV_BY_ZERO\0"
    "EXPAND_ON_STATIC_BIGNUM_DATA\0"
    "INPUT_NOT_REDUCED\0"
    "INVALID_RANGE\0"
    "NEGATIVE_NUMBER\0"
    "NOT_A_SQUARE\0"
    "NOT_INITIALIZED\0"
    "NO_INVERSE\0"
    "PRIVATE_KEY_TOO_LARGE\0"
    "P_IS_NOT_PRIME\0"
    "TOO_MANY_ITERATIONS\0"
    "TOO_MANY_TEMPORARY_VARIABLES\0"
    "AES_KEY_SETUP_FAILED\0"
    "BAD_DECRYPT\0"
    "BAD_KEY_LENGTH\0"
    "CTRL_NOT_IMPLEMENTED\0"
    "CTRL_OPERATION_NOT_IMPLEMENTED\0"
    "DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH\0"
    "INITIALIZATION_ERROR\0"
    "INPUT_NOT_INITIALIZED\0"
    "INVALID_AD_SIZE\0"
    "INVALID_KEY_LENGTH\0"
    "INVALID_NONCE_SIZE\0"
    "INVALID_OPERATION\0"
    "IV_TOO_LARGE\0"
    "NO_CIPHER_SET\0"
    "NO_DIRECTION_SET\0"
    "OUTPUT_ALIASES_INPUT\0"
    "TAG_TOO_LARGE\0"
    "TOO_LARGE\0"
    "UNSUPPORTED_AD_SIZE\0"
    "UNSUPPORTED_INPUT_SIZE\0"
    "UNSUPPORTED_KEY_SIZE\0"
    "UNSUPPORTED_NONCE_SIZE\0"
    "UNSUPPORTED_TAG_SIZE\0"
    "WRONG_FINAL_BLOCK_LENGTH\0"
    "LIST_CANNOT_BE_NULL\0"
    "MISSING_CLOSE_SQUARE_BRACKET\0"
    "MISSING_EQUAL_SIGN\0"
    "NO_CLOSE_BRACE\0"
    "UNABLE_TO_CREATE_NEW_SECTION\0"
    "VARIABLE_HAS_NO_VALUE\0"
    "BAD_GENERATOR\0"
    "INVALID_PUBKEY\0"
    "MODULUS_TOO_LARGE\0"
    "NO_PRIVATE_VALUE\0"
    "BAD_Q_VALUE\0"
    "MISSING_PARAMETERS\0"
    "NEED_NEW_SETUP_VALUES\0"
    "BIGNUM_OUT_OF_RANGE\0"
    "COORDINATES_OUT_OF_RANGE\0"
    "D2I_ECPKPARAMETERS_FAILURE\0"
    "EC_GROUP_NEW_BY_NAME_FAILURE\0"
    "GROUP2PKPARAMETERS_FAILURE\0"
    "I2D_ECPKPARAMETERS_FAILURE\0"
    "INCOMPATIBLE_OBJECTS\0"
    "INVALID_COMPRESSED_POINT\0"
    "INVALID_COMPRESSION_BIT\0"
    "INVALID_ENCODING\0"
    "INVALID_FIELD\0"
    "INVALID_FORM\0"
    "INVALID_GROUP_ORDER\0"
    "INVALID_PRIVATE_KEY\0"
    "MISSING_PRIVATE_KEY\0"
    "NON_NAMED_CURVE\0"
    "PKPARAMETERS2GROUP_FAILURE\0"
    "POINT_AT_INFINITY\0"
    "POINT_IS_NOT_ON_CURVE\0"
    "SLOT_FULL\0"
    "UNDEFINED_GENERATOR\0"
    "UNKNOWN_GROUP\0"
    "UNKNOWN_ORDER\0"
    "WRONG_CURVE_PARAMETERS\0"
    "WRONG_ORDER\0"
    "KDF_FAILED\0"
    "POINT_ARITHMETIC_FAILURE\0"
    "BAD_SIGNATURE\0"
    "NOT_IMPLEMENTED\0"
    "RANDOM_NUMBER_GENERATION_FAILED\0"
    "OPERATION_NOT_SUPPORTED\0"
    "BN_DECODE_ERROR\0"
    "COMMAND_NOT_SUPPORTED\0"
    "CONTEXT_NOT_INITIALISED\0"
    "DIFFERENT_KEY_TYPES\0"
    "DIFFERENT_PARAMETERS\0"
    "DIGEST_AND_KEY_TYPE_NOT_SUPPORTED\0"
    "EXPECTING_AN_EC_KEY_KEY\0"
    "EXPECTING_AN_RSA_KEY\0"
    "EXPECTING_A_DH_KEY\0"
    "EXPECTING_A_DSA_KEY\0"
    "ILLEGAL_OR_UNSUPPORTED_PADDING_MODE\0"
    "INVALID_CURVE\0"
    "INVALID_DIGEST_LENGTH\0"
    "INVALID_DIGEST_TYPE\0"
    "INVALID_KEYBITS\0"
    "INVALID_MGF1_MD\0"
    "INVALID_PADDING_MODE\0"
    "INVALID_PSS_PARAMETERS\0"
    "INVALID_PSS_SALTLEN\0"
    "INVALID_SALT_LENGTH\0"
    "INVALID_TRAILER\0"
    "KEYS_NOT_SET\0"
    "NO_DEFAULT_DIGEST\0"
    "NO_KEY_SET\0"
    "NO_MDC2_SUPPORT\0"
    "NO_NID_FOR_CURVE\0"
    "NO_OPERATION_SET\0"
    "NO_PARAMETERS_SET\0"
    "OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE\0"
    "OPERATON_NOT_INITIALIZED\0"
    "PARAMETER_ENCODING_ERROR\0"
    "UNKNOWN_DIGEST\0"
    "UNKNOWN_MASK_DIGEST\0"
    "UNKNOWN_MESSAGE_DIGEST_ALGORITHM\0"
    "UNKNOWN_PUBLIC_KEY_TYPE\0"
    "UNKNOWN_SIGNATURE_ALGORITHM\0"
    "UNSUPPORTED_ALGORITHM\0"
    "UNSUPPORTED_MASK_ALGORITHM\0"
    "UNSUPPORTED_MASK_PARAMETER\0"
    "UNSUPPORTED_SIGNATURE_TYPE\0"
    "WRONG_PUBLIC_KEY_TYPE\0"
    "OUTPUT_TOO_LARGE\0"
    "UNKNOWN_NID\0"
    "BAD_BASE64_DECODE\0"
    "BAD_END_LINE\0"
    "BAD_IV_CHARS\0"
    "BAD_PASSWORD_READ\0"
    "CIPHER_IS_NULL\0"
    "ERROR_CONVERTING_PRIVATE_KEY\0"
    "NOT_DEK_INFO\0"
    "NOT_ENCRYPTED\0"
    "NOT_PROC_TYPE\0"
    "NO_START_LINE\0"
    "READ_KEY\0"
    "SHORT_HEADER\0"
    "UNSUPPORTED_CIPHER\0"
    "UNSUPPORTED_ENCRYPTION\0"
    "BAD_PKCS12_DATA\0"
    "BAD_PKCS12_VERSION\0"
    "CIPHER_HAS_NO_OBJECT_IDENTIFIER\0"
    "CRYPT_ERROR\0"
    "ENCRYPT_ERROR\0"
    "ERROR_SETTING_CIPHER_PARAMS\0"
    "INCORRECT_PASSWORD\0"
    "KEYGEN_FAILURE\0"
    "KEY_GEN_ERROR\0"
    "METHOD_NOT_SUPPORTED\0"
    "MISSING_MAC\0"
    "MULTIPLE_PRIVATE_KEYS_IN_PKCS12\0"
    "PKCS12_PUBLIC_KEY_INTEGRITY_NOT_SUPPORTED\0"
    "PKCS12_TOO_DEEPLY_NESTED\0"
    "PRIVATE_KEY_DECODE_ERROR\0"
    "PRIVATE_KEY_ENCODE_ERROR\0"
    "UNKNOWN_ALGORITHM\0"
    "UNKNOWN_CIPHER\0"
    "UNKNOWN_CIPHER_ALGORITHM\0"
    "UNKNOWN_HASH\0"
    "UNSUPPORTED_PRIVATE_KEY_ALGORITHM\0"
    "BAD_E_VALUE\0"
    "BAD_FIXED_HEADER_DECRYPT\0"
    "BAD_PAD_BYTE_COUNT\0"
    "BAD_RSA_PARAMETERS\0"
    "BAD_VERSION\0"
    "BLOCK_TYPE_IS_NOT_01\0"
    "BN_NOT_INITIALIZED\0"
    "CANNOT_RECOVER_MULTI_PRIME_KEY\0"
    "CRT_PARAMS_ALREADY_GIVEN\0"
    "CRT_VALUES_INCORRECT\0"
    "DATA_LEN_NOT_EQUAL_TO_MOD_LEN\0"
    "DATA_TOO_LARGE\0"
    "DATA_TOO_LARGE_FOR_KEY_SIZE\0"
    "DATA_TOO_LARGE_FOR_MODULUS\0"
    "DATA_TOO_SMALL\0"
    "DATA_TOO_SMALL_FOR_KEY_SIZE\0"
    "DIGEST_TOO_BIG_FOR_RSA_KEY\0"
    "D_E_NOT_CONGRUENT_TO_1\0"
    "EMPTY_PUBLIC_KEY\0"
    "FIRST_OCTET_INVALID\0"
    "INCONSISTENT_SET_OF_CRT_VALUES\0"
    "INTERNAL_ERROR\0"
    "INVALID_MESSAGE_LENGTH\0"
    "KEY_SIZE_TOO_SMALL\0"
    "LAST_OCTET_INVALID\0"
    "MUST_HAVE_AT_LEAST_TWO_PRIMES\0"
    "NO_PUBLIC_EXPONENT\0"
    "NULL_BEFORE_BLOCK_MISSING\0"
    "N_NOT_EQUAL_P_Q\0"
    "OAEP_DECODING_ERROR\0"
    "ONLY_ONE_OF_P_Q_GIVEN\0"
    "OUTPUT_BUFFER_TOO_SMALL\0"
    "PADDING_CHECK_FAILED\0"
    "PKCS_DECODING_ERROR\0"
    "SLEN_CHECK_FAILED\0"
    "SLEN_RECOVERY_FAILED\0"
    "UNKNOWN_ALGORITHM_TYPE\0"
    "UNKNOWN_PADDING_TYPE\0"
    "VALUE_MISSING\0"
    "WRONG_SIGNATURE_LENGTH\0"
    "APP_DATA_IN_HANDSHAKE\0"
    "ATTEMPT_TO_REUSE_SESSION_IN_DIFFERENT_CONTEXT\0"
    "BAD_ALERT\0"
    "BAD_CHANGE_CIPHER_SPEC\0"
    "BAD_DATA_RETURNED_BY_CALLBACK\0"
    "BAD_DH_P_LENGTH\0"
    "BAD_DIGEST_LENGTH\0"
    "BAD_ECC_CERT\0"
    "BAD_ECPOINT\0"
    "BAD_HANDSHAKE_LENGTH\0"
    "BAD_HANDSHAKE_RECORD\0"
    "BAD_HELLO_REQUEST\0"
    "BAD_LENGTH\0"
    "BAD_PACKET_LENGTH\0"
    "BAD_RSA_ENCRYPT\0"
    "BAD_SRTP_MKI_VALUE\0"
    "BAD_SRTP_PROTECTION_PROFILE_LIST\0"
    "BAD_SSL_FILETYPE\0"
    "BAD_WRITE_RETRY\0"
    "BIO_NOT_SET\0"
    "CANNOT_SERIALIZE_PUBLIC_KEY\0"
    "CA_DN_LENGTH_MISMATCH\0"
    "CA_DN_TOO_LONG\0"
    "CCS_RECEIVED_EARLY\0"
    "CERTIFICATE_VERIFY_FAILED\0"
    "CERT_CB_ERROR\0"
    "CERT_LENGTH_MISMATCH\0"
    "CHANNEL_ID_NOT_P256\0"
    "CHANNEL_ID_SIGNATURE_INVALID\0"
    "CIPHER_CODE_WRONG_LENGTH\0"
    "CIPHER_OR_HASH_UNAVAILABLE\0"
    "CLIENTHELLO_PARSE_FAILED\0"
    "CLIENTHELLO_TLSEXT\0"
    "CONNECTION_REJECTED\0"
    "CONNECTION_TYPE_NOT_SET\0"
    "COOKIE_MISMATCH\0"
    "CUSTOM_EXTENSION_CONTENTS_TOO_LARGE\0"
    "CUSTOM_EXTENSION_ERROR\0"
    "D2I_ECDSA_SIG\0"
    "DATA_BETWEEN_CCS_AND_FINISHED\0"
    "DATA_LENGTH_TOO_LONG\0"
    "DECRYPTION_FAILED\0"
    "DECRYPTION_FAILED_OR_BAD_RECORD_MAC\0"
    "DH_PUBLIC_VALUE_LENGTH_IS_WRONG\0"
    "DIGEST_CHECK_FAILED\0"
    "DTLS_MESSAGE_TOO_BIG\0"
    "ECC_CERT_NOT_FOR_SIGNING\0"
    "EMPTY_SRTP_PROTECTION_PROFILE_LIST\0"
    "EMS_STATE_INCONSISTENT\0"
    "ENCRYPTED_LENGTH_TOO_LONG\0"
    "ERROR_ADDING_EXTENSION\0"
    "ERROR_IN_RECEIVED_CIPHER_LIST\0"
    "ERROR_PARSING_EXTENSION\0"
    "EVP_DIGESTSIGNFINAL_FAILED\0"
    "EVP_DIGESTSIGNINIT_FAILED\0"
    "EXCESSIVE_MESSAGE_SIZE\0"
    "EXTRA_DATA_IN_MESSAGE\0"
    "FRAGMENT_MISMATCH\0"
    "GOT_A_FIN_BEFORE_A_CCS\0"
    "GOT_CHANNEL_ID_BEFORE_A_CCS\0"
    "GOT_NEXT_PROTO_BEFORE_A_CCS\0"
    "GOT_NEXT_PROTO_WITHOUT_EXTENSION\0"
    "HANDSHAKE_FAILURE_ON_CLIENT_HELLO\0"
    "HANDSHAKE_RECORD_BEFORE_CCS\0"
    "HTTPS_PROXY_REQUEST\0"
    "HTTP_REQUEST\0"
    "INAPPROPRIATE_FALLBACK\0"
    "INVALID_COMMAND\0"
    "INVALID_MESSAGE\0"
    "INVALID_SSL_SESSION\0"
    "INVALID_TICKET_KEYS_LENGTH\0"
    "LENGTH_MISMATCH\0"
    "LIBRARY_HAS_NO_CIPHERS\0"
    "MISSING_DH_KEY\0"
    "MISSING_ECDSA_SIGNING_CERT\0"
    "MISSING_EXTENSION\0"
    "MISSING_RSA_CERTIFICATE\0"
    "MISSING_RSA_ENCRYPTING_CERT\0"
    "MISSING_RSA_SIGNING_CERT\0"
    "MISSING_TMP_DH_KEY\0"
    "MISSING_TMP_ECDH_KEY\0"
    "MIXED_SPECIAL_OPERATOR_WITH_GROUPS\0"
    "MTU_TOO_SMALL\0"
    "NEGOTIATED_BOTH_NPN_AND_ALPN\0"
    "NESTED_GROUP\0"
    "NO_CERTIFICATES_RETURNED\0"
    "NO_CERTIFICATE_ASSIGNED\0"
    "NO_CERTIFICATE_SET\0"
    "NO_CIPHERS_AVAILABLE\0"
    "NO_CIPHERS_PASSED\0"
    "NO_CIPHERS_SPECIFIED\0"
    "NO_CIPHER_MATCH\0"
    "NO_COMPRESSION_SPECIFIED\0"
    "NO_METHOD_SPECIFIED\0"
    "NO_P256_SUPPORT\0"
    "NO_PRIVATE_KEY_ASSIGNED\0"
    "NO_RENEGOTIATION\0"
    "NO_REQUIRED_DIGEST\0"
    "NO_SHARED_CIPHER\0"
    "NO_SHARED_SIGATURE_ALGORITHMS\0"
    "NO_SRTP_PROFILES\0"
    "NULL_SSL_CTX\0"
    "NULL_SSL_METHOD_PASSED\0"
    "OLD_SESSION_CIPHER_NOT_RETURNED\0"
    "OLD_SESSION_VERSION_NOT_RETURNED\0"
    "PACKET_LENGTH_TOO_LONG\0"
    "PARSE_TLSEXT\0"
    "PATH_TOO_LONG\0"
    "PEER_DID_NOT_RETURN_A_CERTIFICATE\0"
    "PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE\0"
    "PROTOCOL_IS_SHUTDOWN\0"
    "PSK_IDENTITY_NOT_FOUND\0"
    "PSK_NO_CLIENT_CB\0"
    "PSK_NO_SERVER_CB\0"
    "READ_BIO_NOT_SET\0"
    "READ_TIMEOUT_EXPIRED\0"
    "RECORD_LENGTH_MISMATCH\0"
    "RECORD_TOO_LARGE\0"
    "RENEGOTIATE_EXT_TOO_LONG\0"
    "RENEGOTIATION_ENCODING_ERR\0"
    "RENEGOTIATION_MISMATCH\0"
    "REQUIRED_CIPHER_MISSING\0"
    "RESUMED_EMS_SESSION_WITHOUT_EMS_EXTENSION\0"
    "RESUMED_NON_EMS_SESSION_WITH_EMS_EXTENSION\0"
    "SCSV_RECEIVED_WHEN_RENEGOTIATING\0"
    "SERVERHELLO_TLSEXT\0"
    "SESSION_ID_CONTEXT_UNINITIALIZED\0"
    "SESSION_MAY_NOT_BE_CREATED\0"
    "SIGNATURE_ALGORITHMS_ERROR\0"
    "SIGNATURE_ALGORITHMS_EXTENSION_SENT_BY_SERVER\0"
    "SRTP_COULD_NOT_ALLOCATE_PROFILES\0"
    "SRTP_PROTECTION_PROFILE_LIST_TOO_LONG\0"
    "SRTP_UNKNOWN_PROTECTION_PROFILE\0"
    "SSL3_EXT_INVALID_SERVERNAME\0"
    "SSL3_EXT_INVALID_SERVERNAME_TYPE\0"
    "SSLV3_ALERT_BAD_CERTIFICATE\0"
    "SSLV3_ALERT_BAD_RECORD_MAC\0"
    "SSLV3_ALERT_CERTIFICATE_EXPIRED\0"
    "SSLV3_ALERT_CERTIFICATE_REVOKED\0"
    "SSLV3_ALERT_CERTIFICATE_UNKNOWN\0"
    "SSLV3_ALERT_CLOSE_NOTIFY\0"
    "SSLV3_ALERT_DECOMPRESSION_FAILURE\0"
    "SSLV3_ALERT_HANDSHAKE_FAILURE\0"
    "SSLV3_ALERT_ILLEGAL_PARAMETER\0"
    "SSLV3_ALERT_NO_CERTIFICATE\0"
    "SSLV3_ALERT_UNEXPECTED_MESSAGE\0"
    "SSLV3_ALERT_UNSUPPORTED_CERTIFICATE\0"
    "SSL_CTX_HAS_NO_DEFAULT_SSL_VERSION\0"
    "SSL_HANDSHAKE_FAILURE\0"
    "SSL_SESSION_ID_CALLBACK_FAILED\0"
    "SSL_SESSION_ID_CONFLICT\0"
    "SSL_SESSION_ID_CONTEXT_TOO_LONG\0"
    "SSL_SESSION_ID_HAS_BAD_LENGTH\0"
    "TLSV1_ALERT_ACCESS_DENIED\0"
    "TLSV1_ALERT_DECODE_ERROR\0"
    "TLSV1_ALERT_DECRYPTION_FAILED\0"
    "TLSV1_ALERT_DECRYPT_ERROR\0"
    "TLSV1_ALERT_EXPORT_RESTRICTION\0"
    "TLSV1_ALERT_INAPPROPRIATE_FALLBACK\0"
    "TLSV1_ALERT_INSUFFICIENT_SECURITY\0"
    "TLSV1_ALERT_INTERNAL_ERROR\0"
    "TLSV1_ALERT_NO_RENEGOTIATION\0"
    "TLSV1_ALERT_PROTOCOL_VERSION\0"
    "TLSV1_ALERT_RECORD_OVERFLOW\0"
    "TLSV1_ALERT_UNKNOWN_CA\0"
    "TLSV1_ALERT_USER_CANCELLED\0"
    "TLSV1_BAD_CERTIFICATE_HASH_VALUE\0"
    "TLSV1_BAD_CERTIFICATE_STATUS_RESPONSE\0"
    "TLSV1_CERTIFICATE_UNOBTAINABLE\0"
    "TLSV1_UNRECOGNIZED_NAME\0"
    "TLSV1_UNSUPPORTED_EXTENSION\0"
    "TLS_CLIENT_CERT_REQ_WITH_ANON_CIPHER\0"
    "TLS_ILLEGAL_EXPORTER_LABEL\0"
    "TLS_INVALID_ECPOINTFORMAT_LIST\0"
    "TLS_PEER_DID_NOT_RESPOND_WITH_CERTIFICATE_LIST\0"
    "TLS_RSA_ENCRYPTED_VALUE_LENGTH_IS_WRONG\0"
    "TOO_MANY_EMPTY_FRAGMENTS\0"
    "TOO_MANY_WARNING_ALERTS\0"
    "UNABLE_TO_FIND_ECDH_PARAMETERS\0"
    "UNABLE_TO_FIND_PUBLIC_KEY_PARAMETERS\0"
    "UNEXPECTED_EXTENSION\0"
    "UNEXPECTED_GROUP_CLOSE\0"
    "UNEXPECTED_MESSAGE\0"
    "UNEXPECTED_OPERATOR_IN_GROUP\0"
    "UNEXPECTED_RECORD\0"
    "UNKNOWN_ALERT_TYPE\0"
    "UNKNOWN_CERTIFICATE_TYPE\0"
    "UNKNOWN_CIPHER_RETURNED\0"
    "UNKNOWN_CIPHER_TYPE\0"
    "UNKNOWN_KEY_EXCHANGE_TYPE\0"
    "UNKNOWN_PROTOCOL\0"
    "UNKNOWN_SSL_VERSION\0"
    "UNKNOWN_STATE\0"
    "UNPROCESSED_HANDSHAKE_DATA\0"
    "UNSAFE_LEGACY_RENEGOTIATION_DISABLED\0"
    "UNSUPPORTED_COMPRESSION_ALGORITHM\0"
    "UNSUPPORTED_ELLIPTIC_CURVE\0"
    "UNSUPPORTED_PROTOCOL\0"
    "UNSUPPORTED_SSL_VERSION\0"
    "USE_SRTP_NOT_NEGOTIATED\0"
    "WRONG_CERTIFICATE_TYPE\0"
    "WRONG_CIPHER_RETURNED\0"
    "WRONG_CURVE\0"
    "WRONG_MESSAGE_TYPE\0"
    "WRONG_SIGNATURE_TYPE\0"
    "WRONG_SSL_VERSION\0"
    "WRONG_VERSION_NUMBER\0"
    "X509_LIB\0"
    "X509_VERIFICATION_SETUP_PROBLEMS\0"
    "AKID_MISMATCH\0"
    "BAD_PKCS7_VERSION\0"
    "BAD_X509_FILETYPE\0"
    "BASE64_DECODE_ERROR\0"
    "CANT_CHECK_DH_KEY\0"
    "CERT_ALREADY_IN_HASH_TABLE\0"
    "CRL_ALREADY_DELTA\0"
    "CRL_VERIFY_FAILURE\0"
    "IDP_MISMATCH\0"
    "INVALID_DIRECTORY\0"
    "INVALID_FIELD_NAME\0"
    "INVALID_TRUST\0"
    "ISSUER_MISMATCH\0"
    "KEY_TYPE_MISMATCH\0"
    "KEY_VALUES_MISMATCH\0"
    "LOADING_CERT_DIR\0"
    "LOADING_DEFAULTS\0"
    "NEWER_CRL_NOT_NEWER\0"
    "NOT_PKCS7_SIGNED_DATA\0"
    "NO_CERTIFICATES_INCLUDED\0"
    "NO_CERT_SET_FOR_US_TO_VERIFY\0"
    "NO_CRLS_INCLUDED\0"
    "NO_CRL_NUMBER\0"
    "PUBLIC_KEY_DECODE_ERROR\0"
    "PUBLIC_KEY_ENCODE_ERROR\0"
    "SHOULD_RETRY\0"
    "UNABLE_TO_FIND_PARAMETERS_IN_CHAIN\0"
    "UNABLE_TO_GET_CERTS_PUBLIC_KEY\0"
    "UNKNOWN_KEY_TYPE\0"
    "UNKNOWN_PURPOSE_ID\0"
    "UNKNOWN_TRUST_ID\0"
    "WRONG_LOOKUP_TYPE\0"
    "BAD_IP_ADDRESS\0"
    "BAD_OBJECT\0"
    "BN_DEC2BN_ERROR\0"
    "BN_TO_ASN1_INTEGER_ERROR\0"
    "CANNOT_FIND_FREE_FUNCTION\0"
    "DIRNAME_ERROR\0"
    "DISTPOINT_ALREADY_SET\0"
    "DUPLICATE_ZONE_ID\0"
    "ERROR_CONVERTING_ZONE\0"
    "ERROR_CREATING_EXTENSION\0"
    "ERROR_IN_EXTENSION\0"
    "EXPECTED_A_SECTION_NAME\0"
    "EXTENSION_EXISTS\0"
    "EXTENSION_NAME_ERROR\0"
    "EXTENSION_NOT_FOUND\0"
    "EXTENSION_SETTING_NOT_SUPPORTED\0"
    "EXTENSION_VALUE_ERROR\0"
    "ILLEGAL_EMPTY_EXTENSION\0"
    "ILLEGAL_HEX_DIGIT\0"
    "INCORRECT_POLICY_SYNTAX_TAG\0"
    "INVALID_BOOLEAN_STRING\0"
    "INVALID_EXTENSION_STRING\0"
    "INVALID_MULTIPLE_RDNS\0"
    "INVALID_NAME\0"
    "INVALID_NULL_ARGUMENT\0"
    "INVALID_NULL_NAME\0"
    "INVALID_NULL_VALUE\0"
    "INVALID_NUMBERS\0"
    "INVALID_OBJECT_IDENTIFIER\0"
    "INVALID_OPTION\0"
    "INVALID_POLICY_IDENTIFIER\0"
    "INVALID_PROXY_POLICY_SETTING\0"
    "INVALID_PURPOSE\0"
    "INVALID_SECTION\0"
    "INVALID_SYNTAX\0"
    "ISSUER_DECODE_ERROR\0"
    "NEED_ORGANIZATION_AND_NUMBERS\0"
    "NO_CONFIG_DATABASE\0"
    "NO_ISSUER_CERTIFICATE\0"
    "NO_ISSUER_DETAILS\0"
    "NO_POLICY_IDENTIFIER\0"
    "NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED\0"
    "NO_PUBLIC_KEY\0"
    "NO_SUBJECT_DETAILS\0"
    "ODD_NUMBER_OF_DIGITS\0"
    "OPERATION_NOT_DEFINED\0"
    "OTHERNAME_ERROR\0"
    "POLICY_LANGUAGE_ALREADY_DEFINED\0"
    "POLICY_PATH_LENGTH\0"
    "POLICY_PATH_LENGTH_ALREADY_DEFINED\0"
    "POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY\0"
    "SECTION_NOT_FOUND\0"
    "UNABLE_TO_GET_ISSUER_DETAILS\0"
    "UNABLE_TO_GET_ISSUER_KEYID\0"
    "UNKNOWN_BIT_STRING_ARGUMENT\0"
    "UNKNOWN_EXTENSION\0"
    "UNKNOWN_EXTENSION_NAME\0"
    "UNKNOWN_OPTION\0"
    "UNSUPPORTED_OPTION\0"
    "USER_TOO_LONG\0"
    "";

