/*
 *
 * Copyright 2015, Google Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: reflection.proto

#define INTERNAL_SUPPRESS_PROTOBUF_FIELD_DEPRECATION
#include <grpc++/ext/reflection.pb.h>

#include <algorithm>

#include <google/protobuf/stubs/common.h>
#include <google/protobuf/stubs/port.h>
#include <google/protobuf/stubs/once.h>
#include <google/protobuf/io/coded_stream.h>
#include <google/protobuf/wire_format_lite_inl.h>
#include <google/protobuf/descriptor.h>
#include <google/protobuf/generated_message_reflection.h>
#include <google/protobuf/reflection_ops.h>
#include <google/protobuf/wire_format.h>
// @@protoc_insertion_point(includes)

namespace grpc {
namespace reflection {
namespace v1alpha {

namespace {

const ::google::protobuf::Descriptor* ServerReflectionRequest_descriptor_ = NULL;
const ::google::protobuf::internal::GeneratedMessageReflection*
  ServerReflectionRequest_reflection_ = NULL;
struct ServerReflectionRequestOneofInstance {
  ::google::protobuf::internal::ArenaStringPtr file_by_filename_;
  ::google::protobuf::internal::ArenaStringPtr file_containing_symbol_;
  const ::grpc::reflection::v1alpha::ExtensionRequest* file_containing_extension_;
  ::google::protobuf::internal::ArenaStringPtr all_extension_numbers_of_type_;
  ::google::protobuf::internal::ArenaStringPtr list_services_;
}* ServerReflectionRequest_default_oneof_instance_ = NULL;
const ::google::protobuf::Descriptor* ExtensionRequest_descriptor_ = NULL;
const ::google::protobuf::internal::GeneratedMessageReflection*
  ExtensionRequest_reflection_ = NULL;
const ::google::protobuf::Descriptor* ServerReflectionResponse_descriptor_ = NULL;
const ::google::protobuf::internal::GeneratedMessageReflection*
  ServerReflectionResponse_reflection_ = NULL;
struct ServerReflectionResponseOneofInstance {
  const ::grpc::reflection::v1alpha::FileDescriptorResponse* file_descriptor_response_;
  const ::grpc::reflection::v1alpha::ExtensionNumberResponse* all_extension_numbers_response_;
  const ::grpc::reflection::v1alpha::ListServiceResponse* list_services_response_;
  const ::grpc::reflection::v1alpha::ErrorResponse* error_response_;
}* ServerReflectionResponse_default_oneof_instance_ = NULL;
const ::google::protobuf::Descriptor* FileDescriptorResponse_descriptor_ = NULL;
const ::google::protobuf::internal::GeneratedMessageReflection*
  FileDescriptorResponse_reflection_ = NULL;
const ::google::protobuf::Descriptor* ExtensionNumberResponse_descriptor_ = NULL;
const ::google::protobuf::internal::GeneratedMessageReflection*
  ExtensionNumberResponse_reflection_ = NULL;
const ::google::protobuf::Descriptor* ListServiceResponse_descriptor_ = NULL;
const ::google::protobuf::internal::GeneratedMessageReflection*
  ListServiceResponse_reflection_ = NULL;
const ::google::protobuf::Descriptor* ServiceResponse_descriptor_ = NULL;
const ::google::protobuf::internal::GeneratedMessageReflection*
  ServiceResponse_reflection_ = NULL;
const ::google::protobuf::Descriptor* ErrorResponse_descriptor_ = NULL;
const ::google::protobuf::internal::GeneratedMessageReflection*
  ErrorResponse_reflection_ = NULL;

}  // namespace


void protobuf_AssignDesc_reflection_2eproto() {
  protobuf_AddDesc_reflection_2eproto();
  const ::google::protobuf::FileDescriptor* file =
    ::google::protobuf::DescriptorPool::generated_pool()->FindFileByName(
      "reflection.proto");
  GOOGLE_CHECK(file != NULL);
  ServerReflectionRequest_descriptor_ = file->message_type(0);
  static const int ServerReflectionRequest_offsets_[7] = {
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionRequest, host_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionRequest_default_oneof_instance_, file_by_filename_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionRequest_default_oneof_instance_, file_containing_symbol_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionRequest_default_oneof_instance_, file_containing_extension_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionRequest_default_oneof_instance_, all_extension_numbers_of_type_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionRequest_default_oneof_instance_, list_services_),
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionRequest, message_request_),
  };
  ServerReflectionRequest_reflection_ =
    ::google::protobuf::internal::GeneratedMessageReflection::NewGeneratedMessageReflection(
      ServerReflectionRequest_descriptor_,
      ServerReflectionRequest::default_instance_,
      ServerReflectionRequest_offsets_,
      -1,
      -1,
      -1,
      ServerReflectionRequest_default_oneof_instance_,
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionRequest, _oneof_case_[0]),
      sizeof(ServerReflectionRequest),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionRequest, _internal_metadata_),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionRequest, _is_default_instance_));
  ExtensionRequest_descriptor_ = file->message_type(1);
  static const int ExtensionRequest_offsets_[2] = {
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ExtensionRequest, containing_type_),
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ExtensionRequest, extension_number_),
  };
  ExtensionRequest_reflection_ =
    ::google::protobuf::internal::GeneratedMessageReflection::NewGeneratedMessageReflection(
      ExtensionRequest_descriptor_,
      ExtensionRequest::default_instance_,
      ExtensionRequest_offsets_,
      -1,
      -1,
      -1,
      sizeof(ExtensionRequest),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ExtensionRequest, _internal_metadata_),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ExtensionRequest, _is_default_instance_));
  ServerReflectionResponse_descriptor_ = file->message_type(2);
  static const int ServerReflectionResponse_offsets_[7] = {
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionResponse, valid_host_),
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionResponse, original_request_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionResponse_default_oneof_instance_, file_descriptor_response_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionResponse_default_oneof_instance_, all_extension_numbers_response_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionResponse_default_oneof_instance_, list_services_response_),
    PROTO2_GENERATED_DEFAULT_ONEOF_FIELD_OFFSET(ServerReflectionResponse_default_oneof_instance_, error_response_),
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionResponse, message_response_),
  };
  ServerReflectionResponse_reflection_ =
    ::google::protobuf::internal::GeneratedMessageReflection::NewGeneratedMessageReflection(
      ServerReflectionResponse_descriptor_,
      ServerReflectionResponse::default_instance_,
      ServerReflectionResponse_offsets_,
      -1,
      -1,
      -1,
      ServerReflectionResponse_default_oneof_instance_,
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionResponse, _oneof_case_[0]),
      sizeof(ServerReflectionResponse),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionResponse, _internal_metadata_),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServerReflectionResponse, _is_default_instance_));
  FileDescriptorResponse_descriptor_ = file->message_type(3);
  static const int FileDescriptorResponse_offsets_[1] = {
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(FileDescriptorResponse, file_descriptor_proto_),
  };
  FileDescriptorResponse_reflection_ =
    ::google::protobuf::internal::GeneratedMessageReflection::NewGeneratedMessageReflection(
      FileDescriptorResponse_descriptor_,
      FileDescriptorResponse::default_instance_,
      FileDescriptorResponse_offsets_,
      -1,
      -1,
      -1,
      sizeof(FileDescriptorResponse),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(FileDescriptorResponse, _internal_metadata_),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(FileDescriptorResponse, _is_default_instance_));
  ExtensionNumberResponse_descriptor_ = file->message_type(4);
  static const int ExtensionNumberResponse_offsets_[2] = {
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ExtensionNumberResponse, base_type_name_),
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ExtensionNumberResponse, extension_number_),
  };
  ExtensionNumberResponse_reflection_ =
    ::google::protobuf::internal::GeneratedMessageReflection::NewGeneratedMessageReflection(
      ExtensionNumberResponse_descriptor_,
      ExtensionNumberResponse::default_instance_,
      ExtensionNumberResponse_offsets_,
      -1,
      -1,
      -1,
      sizeof(ExtensionNumberResponse),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ExtensionNumberResponse, _internal_metadata_),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ExtensionNumberResponse, _is_default_instance_));
  ListServiceResponse_descriptor_ = file->message_type(5);
  static const int ListServiceResponse_offsets_[1] = {
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ListServiceResponse, service_),
  };
  ListServiceResponse_reflection_ =
    ::google::protobuf::internal::GeneratedMessageReflection::NewGeneratedMessageReflection(
      ListServiceResponse_descriptor_,
      ListServiceResponse::default_instance_,
      ListServiceResponse_offsets_,
      -1,
      -1,
      -1,
      sizeof(ListServiceResponse),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ListServiceResponse, _internal_metadata_),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ListServiceResponse, _is_default_instance_));
  ServiceResponse_descriptor_ = file->message_type(6);
  static const int ServiceResponse_offsets_[1] = {
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServiceResponse, name_),
  };
  ServiceResponse_reflection_ =
    ::google::protobuf::internal::GeneratedMessageReflection::NewGeneratedMessageReflection(
      ServiceResponse_descriptor_,
      ServiceResponse::default_instance_,
      ServiceResponse_offsets_,
      -1,
      -1,
      -1,
      sizeof(ServiceResponse),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServiceResponse, _internal_metadata_),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ServiceResponse, _is_default_instance_));
  ErrorResponse_descriptor_ = file->message_type(7);
  static const int ErrorResponse_offsets_[2] = {
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ErrorResponse, error_code_),
    GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ErrorResponse, error_message_),
  };
  ErrorResponse_reflection_ =
    ::google::protobuf::internal::GeneratedMessageReflection::NewGeneratedMessageReflection(
      ErrorResponse_descriptor_,
      ErrorResponse::default_instance_,
      ErrorResponse_offsets_,
      -1,
      -1,
      -1,
      sizeof(ErrorResponse),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ErrorResponse, _internal_metadata_),
      GOOGLE_PROTOBUF_GENERATED_MESSAGE_FIELD_OFFSET(ErrorResponse, _is_default_instance_));
}

namespace {

GOOGLE_PROTOBUF_DECLARE_ONCE(protobuf_AssignDescriptors_once_);
inline void protobuf_AssignDescriptorsOnce() {
  ::google::protobuf::GoogleOnceInit(&protobuf_AssignDescriptors_once_,
                 &protobuf_AssignDesc_reflection_2eproto);
}

void protobuf_RegisterTypes(const ::std::string&) {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedMessage(
      ServerReflectionRequest_descriptor_, &ServerReflectionRequest::default_instance());
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedMessage(
      ExtensionRequest_descriptor_, &ExtensionRequest::default_instance());
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedMessage(
      ServerReflectionResponse_descriptor_, &ServerReflectionResponse::default_instance());
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedMessage(
      FileDescriptorResponse_descriptor_, &FileDescriptorResponse::default_instance());
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedMessage(
      ExtensionNumberResponse_descriptor_, &ExtensionNumberResponse::default_instance());
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedMessage(
      ListServiceResponse_descriptor_, &ListServiceResponse::default_instance());
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedMessage(
      ServiceResponse_descriptor_, &ServiceResponse::default_instance());
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedMessage(
      ErrorResponse_descriptor_, &ErrorResponse::default_instance());
}

}  // namespace

void protobuf_ShutdownFile_reflection_2eproto() {
  delete ServerReflectionRequest::default_instance_;
  delete ServerReflectionRequest_default_oneof_instance_;
  delete ServerReflectionRequest_reflection_;
  delete ExtensionRequest::default_instance_;
  delete ExtensionRequest_reflection_;
  delete ServerReflectionResponse::default_instance_;
  delete ServerReflectionResponse_default_oneof_instance_;
  delete ServerReflectionResponse_reflection_;
  delete FileDescriptorResponse::default_instance_;
  delete FileDescriptorResponse_reflection_;
  delete ExtensionNumberResponse::default_instance_;
  delete ExtensionNumberResponse_reflection_;
  delete ListServiceResponse::default_instance_;
  delete ListServiceResponse_reflection_;
  delete ServiceResponse::default_instance_;
  delete ServiceResponse_reflection_;
  delete ErrorResponse::default_instance_;
  delete ErrorResponse_reflection_;
}

void protobuf_AddDesc_reflection_2eproto() {
  static bool already_here = false;
  if (already_here) return;
  already_here = true;
  GOOGLE_PROTOBUF_VERIFY_VERSION;

  ::google::protobuf::DescriptorPool::InternalAddGeneratedFile(
    "\n\020reflection.proto\022\027grpc.reflection.v1al"
    "pha\"\212\002\n\027ServerReflectionRequest\022\014\n\004host\030"
    "\001 \001(\t\022\032\n\020file_by_filename\030\003 \001(\tH\000\022 \n\026fil"
    "e_containing_symbol\030\004 \001(\tH\000\022N\n\031file_cont"
    "aining_extension\030\005 \001(\0132).grpc.reflection"
    ".v1alpha.ExtensionRequestH\000\022\'\n\035all_exten"
    "sion_numbers_of_type\030\006 \001(\tH\000\022\027\n\rlist_ser"
    "vices\030\007 \001(\tH\000B\021\n\017message_request\"E\n\020Exte"
    "nsionRequest\022\027\n\017containing_type\030\001 \001(\t\022\030\n"
    "\020extension_number\030\002 \001(\005\"\321\003\n\030ServerReflec"
    "tionResponse\022\022\n\nvalid_host\030\001 \001(\t\022J\n\020orig"
    "inal_request\030\002 \001(\01320.grpc.reflection.v1a"
    "lpha.ServerReflectionRequest\022S\n\030file_des"
    "criptor_response\030\004 \001(\0132/.grpc.reflection"
    ".v1alpha.FileDescriptorResponseH\000\022Z\n\036all"
    "_extension_numbers_response\030\005 \001(\01320.grpc"
    ".reflection.v1alpha.ExtensionNumberRespo"
    "nseH\000\022N\n\026list_services_response\030\006 \001(\0132,."
    "grpc.reflection.v1alpha.ListServiceRespo"
    "nseH\000\022@\n\016error_response\030\007 \001(\0132&.grpc.ref"
    "lection.v1alpha.ErrorResponseH\000B\022\n\020messa"
    "ge_response\"7\n\026FileDescriptorResponse\022\035\n"
    "\025file_descriptor_proto\030\001 \003(\014\"K\n\027Extensio"
    "nNumberResponse\022\026\n\016base_type_name\030\001 \001(\t\022"
    "\030\n\020extension_number\030\002 \003(\005\"P\n\023ListService"
    "Response\0229\n\007service\030\001 \003(\0132(.grpc.reflect"
    "ion.v1alpha.ServiceResponse\"\037\n\017ServiceRe"
    "sponse\022\014\n\004name\030\001 \001(\t\":\n\rErrorResponse\022\022\n"
    "\nerror_code\030\001 \001(\005\022\025\n\rerror_message\030\002 \001(\t"
    "2\223\001\n\020ServerReflection\022\177\n\024ServerReflectio"
    "nInfo\0220.grpc.reflection.v1alpha.ServerRe"
    "flectionRequest\0321.grpc.reflection.v1alph"
    "a.ServerReflectionResponse(\0010\001b\006proto3", 1318);
  ::google::protobuf::MessageFactory::InternalRegisterGeneratedFile(
    "reflection.proto", &protobuf_RegisterTypes);
  ServerReflectionRequest::default_instance_ = new ServerReflectionRequest();
  ServerReflectionRequest_default_oneof_instance_ = new ServerReflectionRequestOneofInstance();
  ExtensionRequest::default_instance_ = new ExtensionRequest();
  ServerReflectionResponse::default_instance_ = new ServerReflectionResponse();
  ServerReflectionResponse_default_oneof_instance_ = new ServerReflectionResponseOneofInstance();
  FileDescriptorResponse::default_instance_ = new FileDescriptorResponse();
  ExtensionNumberResponse::default_instance_ = new ExtensionNumberResponse();
  ListServiceResponse::default_instance_ = new ListServiceResponse();
  ServiceResponse::default_instance_ = new ServiceResponse();
  ErrorResponse::default_instance_ = new ErrorResponse();
  ServerReflectionRequest::default_instance_->InitAsDefaultInstance();
  ExtensionRequest::default_instance_->InitAsDefaultInstance();
  ServerReflectionResponse::default_instance_->InitAsDefaultInstance();
  FileDescriptorResponse::default_instance_->InitAsDefaultInstance();
  ExtensionNumberResponse::default_instance_->InitAsDefaultInstance();
  ListServiceResponse::default_instance_->InitAsDefaultInstance();
  ServiceResponse::default_instance_->InitAsDefaultInstance();
  ErrorResponse::default_instance_->InitAsDefaultInstance();
  ::google::protobuf::internal::OnShutdown(&protobuf_ShutdownFile_reflection_2eproto);
}

// Force AddDescriptors() to be called at static initialization time.
struct StaticDescriptorInitializer_reflection_2eproto {
  StaticDescriptorInitializer_reflection_2eproto() {
    protobuf_AddDesc_reflection_2eproto();
  }
} static_descriptor_initializer_reflection_2eproto_;

namespace {

static void MergeFromFail(int line) GOOGLE_ATTRIBUTE_COLD;
static void MergeFromFail(int line) {
  GOOGLE_CHECK(false) << __FILE__ << ":" << line;
}

}  // namespace


// ===================================================================

#if !defined(_MSC_VER) || _MSC_VER >= 1900
const int ServerReflectionRequest::kHostFieldNumber;
const int ServerReflectionRequest::kFileByFilenameFieldNumber;
const int ServerReflectionRequest::kFileContainingSymbolFieldNumber;
const int ServerReflectionRequest::kFileContainingExtensionFieldNumber;
const int ServerReflectionRequest::kAllExtensionNumbersOfTypeFieldNumber;
const int ServerReflectionRequest::kListServicesFieldNumber;
#endif  // !defined(_MSC_VER) || _MSC_VER >= 1900

ServerReflectionRequest::ServerReflectionRequest()
  : ::google::protobuf::Message(), _internal_metadata_(NULL) {
  SharedCtor();
  // @@protoc_insertion_point(constructor:grpc.reflection.v1alpha.ServerReflectionRequest)
}

void ServerReflectionRequest::InitAsDefaultInstance() {
  _is_default_instance_ = true;
  ServerReflectionRequest_default_oneof_instance_->file_by_filename_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  ServerReflectionRequest_default_oneof_instance_->file_containing_symbol_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  ServerReflectionRequest_default_oneof_instance_->file_containing_extension_ = const_cast< ::grpc::reflection::v1alpha::ExtensionRequest*>(&::grpc::reflection::v1alpha::ExtensionRequest::default_instance());
  ServerReflectionRequest_default_oneof_instance_->all_extension_numbers_of_type_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  ServerReflectionRequest_default_oneof_instance_->list_services_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}

ServerReflectionRequest::ServerReflectionRequest(const ServerReflectionRequest& from)
  : ::google::protobuf::Message(),
    _internal_metadata_(NULL) {
  SharedCtor();
  MergeFrom(from);
  // @@protoc_insertion_point(copy_constructor:grpc.reflection.v1alpha.ServerReflectionRequest)
}

void ServerReflectionRequest::SharedCtor() {
    _is_default_instance_ = false;
  ::google::protobuf::internal::GetEmptyString();
  _cached_size_ = 0;
  host_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  clear_has_message_request();
}

ServerReflectionRequest::~ServerReflectionRequest() {
  // @@protoc_insertion_point(destructor:grpc.reflection.v1alpha.ServerReflectionRequest)
  SharedDtor();
}

void ServerReflectionRequest::SharedDtor() {
  host_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  if (has_message_request()) {
    clear_message_request();
  }
  if (this != default_instance_) {
  }
}

void ServerReflectionRequest::SetCachedSize(int size) const {
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
}
const ::google::protobuf::Descriptor* ServerReflectionRequest::descriptor() {
  protobuf_AssignDescriptorsOnce();
  return ServerReflectionRequest_descriptor_;
}

const ServerReflectionRequest& ServerReflectionRequest::default_instance() {
  if (default_instance_ == NULL) protobuf_AddDesc_reflection_2eproto();
  return *default_instance_;
}

ServerReflectionRequest* ServerReflectionRequest::default_instance_ = NULL;

ServerReflectionRequest* ServerReflectionRequest::New(::google::protobuf::Arena* arena) const {
  ServerReflectionRequest* n = new ServerReflectionRequest;
  if (arena != NULL) {
    arena->Own(n);
  }
  return n;
}

void ServerReflectionRequest::clear_message_request() {
// @@protoc_insertion_point(one_of_clear_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  switch(message_request_case()) {
    case kFileByFilename: {
      message_request_.file_by_filename_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
      break;
    }
    case kFileContainingSymbol: {
      message_request_.file_containing_symbol_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
      break;
    }
    case kFileContainingExtension: {
      delete message_request_.file_containing_extension_;
      break;
    }
    case kAllExtensionNumbersOfType: {
      message_request_.all_extension_numbers_of_type_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
      break;
    }
    case kListServices: {
      message_request_.list_services_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
      break;
    }
    case MESSAGE_REQUEST_NOT_SET: {
      break;
    }
  }
  _oneof_case_[0] = MESSAGE_REQUEST_NOT_SET;
}


void ServerReflectionRequest::Clear() {
// @@protoc_insertion_point(message_clear_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  host_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  clear_message_request();
}

bool ServerReflectionRequest::MergePartialFromCodedStream(
    ::google::protobuf::io::CodedInputStream* input) {
#define DO_(EXPRESSION) if (!GOOGLE_PREDICT_TRUE(EXPRESSION)) goto failure
  ::google::protobuf::uint32 tag;
  // @@protoc_insertion_point(parse_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  for (;;) {
    ::std::pair< ::google::protobuf::uint32, bool> p = input->ReadTagWithCutoff(127);
    tag = p.first;
    if (!p.second) goto handle_unusual;
    switch (::google::protobuf::internal::WireFormatLite::GetTagFieldNumber(tag)) {
      // optional string host = 1;
      case 1: {
        if (tag == 10) {
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_host()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->host().data(), this->host().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ServerReflectionRequest.host"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(26)) goto parse_file_by_filename;
        break;
      }

      // optional string file_by_filename = 3;
      case 3: {
        if (tag == 26) {
         parse_file_by_filename:
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_file_by_filename()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->file_by_filename().data(), this->file_by_filename().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(34)) goto parse_file_containing_symbol;
        break;
      }

      // optional string file_containing_symbol = 4;
      case 4: {
        if (tag == 34) {
         parse_file_containing_symbol:
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_file_containing_symbol()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->file_containing_symbol().data(), this->file_containing_symbol().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(42)) goto parse_file_containing_extension;
        break;
      }

      // optional .grpc.reflection.v1alpha.ExtensionRequest file_containing_extension = 5;
      case 5: {
        if (tag == 42) {
         parse_file_containing_extension:
          DO_(::google::protobuf::internal::WireFormatLite::ReadMessageNoVirtual(
               input, mutable_file_containing_extension()));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(50)) goto parse_all_extension_numbers_of_type;
        break;
      }

      // optional string all_extension_numbers_of_type = 6;
      case 6: {
        if (tag == 50) {
         parse_all_extension_numbers_of_type:
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_all_extension_numbers_of_type()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->all_extension_numbers_of_type().data(), this->all_extension_numbers_of_type().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(58)) goto parse_list_services;
        break;
      }

      // optional string list_services = 7;
      case 7: {
        if (tag == 58) {
         parse_list_services:
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_list_services()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->list_services().data(), this->list_services().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ServerReflectionRequest.list_services"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectAtEnd()) goto success;
        break;
      }

      default: {
      handle_unusual:
        if (tag == 0 ||
            ::google::protobuf::internal::WireFormatLite::GetTagWireType(tag) ==
            ::google::protobuf::internal::WireFormatLite::WIRETYPE_END_GROUP) {
          goto success;
        }
        DO_(::google::protobuf::internal::WireFormatLite::SkipField(input, tag));
        break;
      }
    }
  }
success:
  // @@protoc_insertion_point(parse_success:grpc.reflection.v1alpha.ServerReflectionRequest)
  return true;
failure:
  // @@protoc_insertion_point(parse_failure:grpc.reflection.v1alpha.ServerReflectionRequest)
  return false;
#undef DO_
}

void ServerReflectionRequest::SerializeWithCachedSizes(
    ::google::protobuf::io::CodedOutputStream* output) const {
  // @@protoc_insertion_point(serialize_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  // optional string host = 1;
  if (this->host().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->host().data(), this->host().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.host");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      1, this->host(), output);
  }

  // optional string file_by_filename = 3;
  if (has_file_by_filename()) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->file_by_filename().data(), this->file_by_filename().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      3, this->file_by_filename(), output);
  }

  // optional string file_containing_symbol = 4;
  if (has_file_containing_symbol()) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->file_containing_symbol().data(), this->file_containing_symbol().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      4, this->file_containing_symbol(), output);
  }

  // optional .grpc.reflection.v1alpha.ExtensionRequest file_containing_extension = 5;
  if (has_file_containing_extension()) {
    ::google::protobuf::internal::WireFormatLite::WriteMessageMaybeToArray(
      5, *message_request_.file_containing_extension_, output);
  }

  // optional string all_extension_numbers_of_type = 6;
  if (has_all_extension_numbers_of_type()) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->all_extension_numbers_of_type().data(), this->all_extension_numbers_of_type().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      6, this->all_extension_numbers_of_type(), output);
  }

  // optional string list_services = 7;
  if (has_list_services()) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->list_services().data(), this->list_services().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.list_services");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      7, this->list_services(), output);
  }

  // @@protoc_insertion_point(serialize_end:grpc.reflection.v1alpha.ServerReflectionRequest)
}

::google::protobuf::uint8* ServerReflectionRequest::SerializeWithCachedSizesToArray(
    ::google::protobuf::uint8* target) const {
  // @@protoc_insertion_point(serialize_to_array_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  // optional string host = 1;
  if (this->host().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->host().data(), this->host().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.host");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        1, this->host(), target);
  }

  // optional string file_by_filename = 3;
  if (has_file_by_filename()) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->file_by_filename().data(), this->file_by_filename().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        3, this->file_by_filename(), target);
  }

  // optional string file_containing_symbol = 4;
  if (has_file_containing_symbol()) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->file_containing_symbol().data(), this->file_containing_symbol().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        4, this->file_containing_symbol(), target);
  }

  // optional .grpc.reflection.v1alpha.ExtensionRequest file_containing_extension = 5;
  if (has_file_containing_extension()) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteMessageNoVirtualToArray(
        5, *message_request_.file_containing_extension_, target);
  }

  // optional string all_extension_numbers_of_type = 6;
  if (has_all_extension_numbers_of_type()) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->all_extension_numbers_of_type().data(), this->all_extension_numbers_of_type().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        6, this->all_extension_numbers_of_type(), target);
  }

  // optional string list_services = 7;
  if (has_list_services()) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->list_services().data(), this->list_services().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionRequest.list_services");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        7, this->list_services(), target);
  }

  // @@protoc_insertion_point(serialize_to_array_end:grpc.reflection.v1alpha.ServerReflectionRequest)
  return target;
}

int ServerReflectionRequest::ByteSize() const {
// @@protoc_insertion_point(message_byte_size_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  int total_size = 0;

  // optional string host = 1;
  if (this->host().size() > 0) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::StringSize(
        this->host());
  }

  switch (message_request_case()) {
    // optional string file_by_filename = 3;
    case kFileByFilename: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::StringSize(
          this->file_by_filename());
      break;
    }
    // optional string file_containing_symbol = 4;
    case kFileContainingSymbol: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::StringSize(
          this->file_containing_symbol());
      break;
    }
    // optional .grpc.reflection.v1alpha.ExtensionRequest file_containing_extension = 5;
    case kFileContainingExtension: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::MessageSizeNoVirtual(
          *message_request_.file_containing_extension_);
      break;
    }
    // optional string all_extension_numbers_of_type = 6;
    case kAllExtensionNumbersOfType: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::StringSize(
          this->all_extension_numbers_of_type());
      break;
    }
    // optional string list_services = 7;
    case kListServices: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::StringSize(
          this->list_services());
      break;
    }
    case MESSAGE_REQUEST_NOT_SET: {
      break;
    }
  }
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = total_size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
  return total_size;
}

void ServerReflectionRequest::MergeFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_merge_from_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  const ServerReflectionRequest* source = 
      ::google::protobuf::internal::DynamicCastToGenerated<const ServerReflectionRequest>(
          &from);
  if (source == NULL) {
  // @@protoc_insertion_point(generalized_merge_from_cast_fail:grpc.reflection.v1alpha.ServerReflectionRequest)
    ::google::protobuf::internal::ReflectionOps::Merge(from, this);
  } else {
  // @@protoc_insertion_point(generalized_merge_from_cast_success:grpc.reflection.v1alpha.ServerReflectionRequest)
    MergeFrom(*source);
  }
}

void ServerReflectionRequest::MergeFrom(const ServerReflectionRequest& from) {
// @@protoc_insertion_point(class_specific_merge_from_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  switch (from.message_request_case()) {
    case kFileByFilename: {
      set_file_by_filename(from.file_by_filename());
      break;
    }
    case kFileContainingSymbol: {
      set_file_containing_symbol(from.file_containing_symbol());
      break;
    }
    case kFileContainingExtension: {
      mutable_file_containing_extension()->::grpc::reflection::v1alpha::ExtensionRequest::MergeFrom(from.file_containing_extension());
      break;
    }
    case kAllExtensionNumbersOfType: {
      set_all_extension_numbers_of_type(from.all_extension_numbers_of_type());
      break;
    }
    case kListServices: {
      set_list_services(from.list_services());
      break;
    }
    case MESSAGE_REQUEST_NOT_SET: {
      break;
    }
  }
  if (from.host().size() > 0) {

    host_.AssignWithDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), from.host_);
  }
}

void ServerReflectionRequest::CopyFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_copy_from_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

void ServerReflectionRequest::CopyFrom(const ServerReflectionRequest& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:grpc.reflection.v1alpha.ServerReflectionRequest)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

bool ServerReflectionRequest::IsInitialized() const {

  return true;
}

void ServerReflectionRequest::Swap(ServerReflectionRequest* other) {
  if (other == this) return;
  InternalSwap(other);
}
void ServerReflectionRequest::InternalSwap(ServerReflectionRequest* other) {
  host_.Swap(&other->host_);
  std::swap(message_request_, other->message_request_);
  std::swap(_oneof_case_[0], other->_oneof_case_[0]);
  _internal_metadata_.Swap(&other->_internal_metadata_);
  std::swap(_cached_size_, other->_cached_size_);
}

::google::protobuf::Metadata ServerReflectionRequest::GetMetadata() const {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::Metadata metadata;
  metadata.descriptor = ServerReflectionRequest_descriptor_;
  metadata.reflection = ServerReflectionRequest_reflection_;
  return metadata;
}

#if PROTOBUF_INLINE_NOT_IN_HEADERS
// ServerReflectionRequest

// optional string host = 1;
void ServerReflectionRequest::clear_host() {
  host_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 const ::std::string& ServerReflectionRequest::host() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionRequest.host)
  return host_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ServerReflectionRequest::set_host(const ::std::string& value) {
  
  host_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.host)
}
 void ServerReflectionRequest::set_host(const char* value) {
  
  host_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ServerReflectionRequest.host)
}
 void ServerReflectionRequest::set_host(const char* value, size_t size) {
  
  host_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ServerReflectionRequest.host)
}
 ::std::string* ServerReflectionRequest::mutable_host() {
  
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionRequest.host)
  return host_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ServerReflectionRequest::release_host() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionRequest.host)
  
  return host_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ServerReflectionRequest::set_allocated_host(::std::string* host) {
  if (host != NULL) {
    
  } else {
    
  }
  host_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), host);
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionRequest.host)
}

// optional string file_by_filename = 3;
bool ServerReflectionRequest::has_file_by_filename() const {
  return message_request_case() == kFileByFilename;
}
void ServerReflectionRequest::set_has_file_by_filename() {
  _oneof_case_[0] = kFileByFilename;
}
void ServerReflectionRequest::clear_file_by_filename() {
  if (has_file_by_filename()) {
    message_request_.file_by_filename_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
    clear_has_message_request();
  }
}
 const ::std::string& ServerReflectionRequest::file_by_filename() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename)
  if (has_file_by_filename()) {
    return message_request_.file_by_filename_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  return *&::google::protobuf::internal::GetEmptyStringAlreadyInited();
}
 void ServerReflectionRequest::set_file_by_filename(const ::std::string& value) {
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename)
  if (!has_file_by_filename()) {
    clear_message_request();
    set_has_file_by_filename();
    message_request_.file_by_filename_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.file_by_filename_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename)
}
 void ServerReflectionRequest::set_file_by_filename(const char* value) {
  if (!has_file_by_filename()) {
    clear_message_request();
    set_has_file_by_filename();
    message_request_.file_by_filename_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.file_by_filename_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename)
}
 void ServerReflectionRequest::set_file_by_filename(const char* value, size_t size) {
  if (!has_file_by_filename()) {
    clear_message_request();
    set_has_file_by_filename();
    message_request_.file_by_filename_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.file_by_filename_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(
      reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename)
}
 ::std::string* ServerReflectionRequest::mutable_file_by_filename() {
  if (!has_file_by_filename()) {
    clear_message_request();
    set_has_file_by_filename();
    message_request_.file_by_filename_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename)
  return message_request_.file_by_filename_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ServerReflectionRequest::release_file_by_filename() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename)
  if (has_file_by_filename()) {
    clear_has_message_request();
    return message_request_.file_by_filename_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  } else {
    return NULL;
  }
}
 void ServerReflectionRequest::set_allocated_file_by_filename(::std::string* file_by_filename) {
  if (!has_file_by_filename()) {
    message_request_.file_by_filename_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  clear_message_request();
  if (file_by_filename != NULL) {
    set_has_file_by_filename();
    message_request_.file_by_filename_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
        file_by_filename);
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionRequest.file_by_filename)
}

// optional string file_containing_symbol = 4;
bool ServerReflectionRequest::has_file_containing_symbol() const {
  return message_request_case() == kFileContainingSymbol;
}
void ServerReflectionRequest::set_has_file_containing_symbol() {
  _oneof_case_[0] = kFileContainingSymbol;
}
void ServerReflectionRequest::clear_file_containing_symbol() {
  if (has_file_containing_symbol()) {
    message_request_.file_containing_symbol_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
    clear_has_message_request();
  }
}
 const ::std::string& ServerReflectionRequest::file_containing_symbol() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol)
  if (has_file_containing_symbol()) {
    return message_request_.file_containing_symbol_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  return *&::google::protobuf::internal::GetEmptyStringAlreadyInited();
}
 void ServerReflectionRequest::set_file_containing_symbol(const ::std::string& value) {
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol)
  if (!has_file_containing_symbol()) {
    clear_message_request();
    set_has_file_containing_symbol();
    message_request_.file_containing_symbol_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.file_containing_symbol_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol)
}
 void ServerReflectionRequest::set_file_containing_symbol(const char* value) {
  if (!has_file_containing_symbol()) {
    clear_message_request();
    set_has_file_containing_symbol();
    message_request_.file_containing_symbol_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.file_containing_symbol_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol)
}
 void ServerReflectionRequest::set_file_containing_symbol(const char* value, size_t size) {
  if (!has_file_containing_symbol()) {
    clear_message_request();
    set_has_file_containing_symbol();
    message_request_.file_containing_symbol_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.file_containing_symbol_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(
      reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol)
}
 ::std::string* ServerReflectionRequest::mutable_file_containing_symbol() {
  if (!has_file_containing_symbol()) {
    clear_message_request();
    set_has_file_containing_symbol();
    message_request_.file_containing_symbol_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol)
  return message_request_.file_containing_symbol_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ServerReflectionRequest::release_file_containing_symbol() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol)
  if (has_file_containing_symbol()) {
    clear_has_message_request();
    return message_request_.file_containing_symbol_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  } else {
    return NULL;
  }
}
 void ServerReflectionRequest::set_allocated_file_containing_symbol(::std::string* file_containing_symbol) {
  if (!has_file_containing_symbol()) {
    message_request_.file_containing_symbol_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  clear_message_request();
  if (file_containing_symbol != NULL) {
    set_has_file_containing_symbol();
    message_request_.file_containing_symbol_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
        file_containing_symbol);
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_symbol)
}

// optional .grpc.reflection.v1alpha.ExtensionRequest file_containing_extension = 5;
bool ServerReflectionRequest::has_file_containing_extension() const {
  return message_request_case() == kFileContainingExtension;
}
void ServerReflectionRequest::set_has_file_containing_extension() {
  _oneof_case_[0] = kFileContainingExtension;
}
void ServerReflectionRequest::clear_file_containing_extension() {
  if (has_file_containing_extension()) {
    delete message_request_.file_containing_extension_;
    clear_has_message_request();
  }
}
 const ::grpc::reflection::v1alpha::ExtensionRequest& ServerReflectionRequest::file_containing_extension() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_extension)
  return has_file_containing_extension()
      ? *message_request_.file_containing_extension_
      : ::grpc::reflection::v1alpha::ExtensionRequest::default_instance();
}
::grpc::reflection::v1alpha::ExtensionRequest* ServerReflectionRequest::mutable_file_containing_extension() {
  if (!has_file_containing_extension()) {
    clear_message_request();
    set_has_file_containing_extension();
    message_request_.file_containing_extension_ = new ::grpc::reflection::v1alpha::ExtensionRequest;
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_extension)
  return message_request_.file_containing_extension_;
}
::grpc::reflection::v1alpha::ExtensionRequest* ServerReflectionRequest::release_file_containing_extension() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_extension)
  if (has_file_containing_extension()) {
    clear_has_message_request();
    ::grpc::reflection::v1alpha::ExtensionRequest* temp = message_request_.file_containing_extension_;
    message_request_.file_containing_extension_ = NULL;
    return temp;
  } else {
    return NULL;
  }
}
void ServerReflectionRequest::set_allocated_file_containing_extension(::grpc::reflection::v1alpha::ExtensionRequest* file_containing_extension) {
  clear_message_request();
  if (file_containing_extension) {
    set_has_file_containing_extension();
    message_request_.file_containing_extension_ = file_containing_extension;
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionRequest.file_containing_extension)
}

// optional string all_extension_numbers_of_type = 6;
bool ServerReflectionRequest::has_all_extension_numbers_of_type() const {
  return message_request_case() == kAllExtensionNumbersOfType;
}
void ServerReflectionRequest::set_has_all_extension_numbers_of_type() {
  _oneof_case_[0] = kAllExtensionNumbersOfType;
}
void ServerReflectionRequest::clear_all_extension_numbers_of_type() {
  if (has_all_extension_numbers_of_type()) {
    message_request_.all_extension_numbers_of_type_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
    clear_has_message_request();
  }
}
 const ::std::string& ServerReflectionRequest::all_extension_numbers_of_type() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type)
  if (has_all_extension_numbers_of_type()) {
    return message_request_.all_extension_numbers_of_type_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  return *&::google::protobuf::internal::GetEmptyStringAlreadyInited();
}
 void ServerReflectionRequest::set_all_extension_numbers_of_type(const ::std::string& value) {
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type)
  if (!has_all_extension_numbers_of_type()) {
    clear_message_request();
    set_has_all_extension_numbers_of_type();
    message_request_.all_extension_numbers_of_type_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.all_extension_numbers_of_type_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type)
}
 void ServerReflectionRequest::set_all_extension_numbers_of_type(const char* value) {
  if (!has_all_extension_numbers_of_type()) {
    clear_message_request();
    set_has_all_extension_numbers_of_type();
    message_request_.all_extension_numbers_of_type_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.all_extension_numbers_of_type_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type)
}
 void ServerReflectionRequest::set_all_extension_numbers_of_type(const char* value, size_t size) {
  if (!has_all_extension_numbers_of_type()) {
    clear_message_request();
    set_has_all_extension_numbers_of_type();
    message_request_.all_extension_numbers_of_type_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.all_extension_numbers_of_type_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(
      reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type)
}
 ::std::string* ServerReflectionRequest::mutable_all_extension_numbers_of_type() {
  if (!has_all_extension_numbers_of_type()) {
    clear_message_request();
    set_has_all_extension_numbers_of_type();
    message_request_.all_extension_numbers_of_type_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type)
  return message_request_.all_extension_numbers_of_type_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ServerReflectionRequest::release_all_extension_numbers_of_type() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type)
  if (has_all_extension_numbers_of_type()) {
    clear_has_message_request();
    return message_request_.all_extension_numbers_of_type_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  } else {
    return NULL;
  }
}
 void ServerReflectionRequest::set_allocated_all_extension_numbers_of_type(::std::string* all_extension_numbers_of_type) {
  if (!has_all_extension_numbers_of_type()) {
    message_request_.all_extension_numbers_of_type_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  clear_message_request();
  if (all_extension_numbers_of_type != NULL) {
    set_has_all_extension_numbers_of_type();
    message_request_.all_extension_numbers_of_type_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
        all_extension_numbers_of_type);
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionRequest.all_extension_numbers_of_type)
}

// optional string list_services = 7;
bool ServerReflectionRequest::has_list_services() const {
  return message_request_case() == kListServices;
}
void ServerReflectionRequest::set_has_list_services() {
  _oneof_case_[0] = kListServices;
}
void ServerReflectionRequest::clear_list_services() {
  if (has_list_services()) {
    message_request_.list_services_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
    clear_has_message_request();
  }
}
 const ::std::string& ServerReflectionRequest::list_services() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionRequest.list_services)
  if (has_list_services()) {
    return message_request_.list_services_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  return *&::google::protobuf::internal::GetEmptyStringAlreadyInited();
}
 void ServerReflectionRequest::set_list_services(const ::std::string& value) {
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.list_services)
  if (!has_list_services()) {
    clear_message_request();
    set_has_list_services();
    message_request_.list_services_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.list_services_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionRequest.list_services)
}
 void ServerReflectionRequest::set_list_services(const char* value) {
  if (!has_list_services()) {
    clear_message_request();
    set_has_list_services();
    message_request_.list_services_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.list_services_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ServerReflectionRequest.list_services)
}
 void ServerReflectionRequest::set_list_services(const char* value, size_t size) {
  if (!has_list_services()) {
    clear_message_request();
    set_has_list_services();
    message_request_.list_services_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  message_request_.list_services_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(
      reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ServerReflectionRequest.list_services)
}
 ::std::string* ServerReflectionRequest::mutable_list_services() {
  if (!has_list_services()) {
    clear_message_request();
    set_has_list_services();
    message_request_.list_services_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionRequest.list_services)
  return message_request_.list_services_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ServerReflectionRequest::release_list_services() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionRequest.list_services)
  if (has_list_services()) {
    clear_has_message_request();
    return message_request_.list_services_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  } else {
    return NULL;
  }
}
 void ServerReflectionRequest::set_allocated_list_services(::std::string* list_services) {
  if (!has_list_services()) {
    message_request_.list_services_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  }
  clear_message_request();
  if (list_services != NULL) {
    set_has_list_services();
    message_request_.list_services_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
        list_services);
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionRequest.list_services)
}

bool ServerReflectionRequest::has_message_request() const {
  return message_request_case() != MESSAGE_REQUEST_NOT_SET;
}
void ServerReflectionRequest::clear_has_message_request() {
  _oneof_case_[0] = MESSAGE_REQUEST_NOT_SET;
}
ServerReflectionRequest::MessageRequestCase ServerReflectionRequest::message_request_case() const {
  return ServerReflectionRequest::MessageRequestCase(_oneof_case_[0]);
}
#endif  // PROTOBUF_INLINE_NOT_IN_HEADERS

// ===================================================================

#if !defined(_MSC_VER) || _MSC_VER >= 1900
const int ExtensionRequest::kContainingTypeFieldNumber;
const int ExtensionRequest::kExtensionNumberFieldNumber;
#endif  // !defined(_MSC_VER) || _MSC_VER >= 1900

ExtensionRequest::ExtensionRequest()
  : ::google::protobuf::Message(), _internal_metadata_(NULL) {
  SharedCtor();
  // @@protoc_insertion_point(constructor:grpc.reflection.v1alpha.ExtensionRequest)
}

void ExtensionRequest::InitAsDefaultInstance() {
  _is_default_instance_ = true;
}

ExtensionRequest::ExtensionRequest(const ExtensionRequest& from)
  : ::google::protobuf::Message(),
    _internal_metadata_(NULL) {
  SharedCtor();
  MergeFrom(from);
  // @@protoc_insertion_point(copy_constructor:grpc.reflection.v1alpha.ExtensionRequest)
}

void ExtensionRequest::SharedCtor() {
    _is_default_instance_ = false;
  ::google::protobuf::internal::GetEmptyString();
  _cached_size_ = 0;
  containing_type_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  extension_number_ = 0;
}

ExtensionRequest::~ExtensionRequest() {
  // @@protoc_insertion_point(destructor:grpc.reflection.v1alpha.ExtensionRequest)
  SharedDtor();
}

void ExtensionRequest::SharedDtor() {
  containing_type_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  if (this != default_instance_) {
  }
}

void ExtensionRequest::SetCachedSize(int size) const {
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
}
const ::google::protobuf::Descriptor* ExtensionRequest::descriptor() {
  protobuf_AssignDescriptorsOnce();
  return ExtensionRequest_descriptor_;
}

const ExtensionRequest& ExtensionRequest::default_instance() {
  if (default_instance_ == NULL) protobuf_AddDesc_reflection_2eproto();
  return *default_instance_;
}

ExtensionRequest* ExtensionRequest::default_instance_ = NULL;

ExtensionRequest* ExtensionRequest::New(::google::protobuf::Arena* arena) const {
  ExtensionRequest* n = new ExtensionRequest;
  if (arena != NULL) {
    arena->Own(n);
  }
  return n;
}

void ExtensionRequest::Clear() {
// @@protoc_insertion_point(message_clear_start:grpc.reflection.v1alpha.ExtensionRequest)
  containing_type_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  extension_number_ = 0;
}

bool ExtensionRequest::MergePartialFromCodedStream(
    ::google::protobuf::io::CodedInputStream* input) {
#define DO_(EXPRESSION) if (!GOOGLE_PREDICT_TRUE(EXPRESSION)) goto failure
  ::google::protobuf::uint32 tag;
  // @@protoc_insertion_point(parse_start:grpc.reflection.v1alpha.ExtensionRequest)
  for (;;) {
    ::std::pair< ::google::protobuf::uint32, bool> p = input->ReadTagWithCutoff(127);
    tag = p.first;
    if (!p.second) goto handle_unusual;
    switch (::google::protobuf::internal::WireFormatLite::GetTagFieldNumber(tag)) {
      // optional string containing_type = 1;
      case 1: {
        if (tag == 10) {
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_containing_type()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->containing_type().data(), this->containing_type().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ExtensionRequest.containing_type"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(16)) goto parse_extension_number;
        break;
      }

      // optional int32 extension_number = 2;
      case 2: {
        if (tag == 16) {
         parse_extension_number:
          DO_((::google::protobuf::internal::WireFormatLite::ReadPrimitive<
                   ::google::protobuf::int32, ::google::protobuf::internal::WireFormatLite::TYPE_INT32>(
                 input, &extension_number_)));

        } else {
          goto handle_unusual;
        }
        if (input->ExpectAtEnd()) goto success;
        break;
      }

      default: {
      handle_unusual:
        if (tag == 0 ||
            ::google::protobuf::internal::WireFormatLite::GetTagWireType(tag) ==
            ::google::protobuf::internal::WireFormatLite::WIRETYPE_END_GROUP) {
          goto success;
        }
        DO_(::google::protobuf::internal::WireFormatLite::SkipField(input, tag));
        break;
      }
    }
  }
success:
  // @@protoc_insertion_point(parse_success:grpc.reflection.v1alpha.ExtensionRequest)
  return true;
failure:
  // @@protoc_insertion_point(parse_failure:grpc.reflection.v1alpha.ExtensionRequest)
  return false;
#undef DO_
}

void ExtensionRequest::SerializeWithCachedSizes(
    ::google::protobuf::io::CodedOutputStream* output) const {
  // @@protoc_insertion_point(serialize_start:grpc.reflection.v1alpha.ExtensionRequest)
  // optional string containing_type = 1;
  if (this->containing_type().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->containing_type().data(), this->containing_type().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ExtensionRequest.containing_type");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      1, this->containing_type(), output);
  }

  // optional int32 extension_number = 2;
  if (this->extension_number() != 0) {
    ::google::protobuf::internal::WireFormatLite::WriteInt32(2, this->extension_number(), output);
  }

  // @@protoc_insertion_point(serialize_end:grpc.reflection.v1alpha.ExtensionRequest)
}

::google::protobuf::uint8* ExtensionRequest::SerializeWithCachedSizesToArray(
    ::google::protobuf::uint8* target) const {
  // @@protoc_insertion_point(serialize_to_array_start:grpc.reflection.v1alpha.ExtensionRequest)
  // optional string containing_type = 1;
  if (this->containing_type().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->containing_type().data(), this->containing_type().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ExtensionRequest.containing_type");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        1, this->containing_type(), target);
  }

  // optional int32 extension_number = 2;
  if (this->extension_number() != 0) {
    target = ::google::protobuf::internal::WireFormatLite::WriteInt32ToArray(2, this->extension_number(), target);
  }

  // @@protoc_insertion_point(serialize_to_array_end:grpc.reflection.v1alpha.ExtensionRequest)
  return target;
}

int ExtensionRequest::ByteSize() const {
// @@protoc_insertion_point(message_byte_size_start:grpc.reflection.v1alpha.ExtensionRequest)
  int total_size = 0;

  // optional string containing_type = 1;
  if (this->containing_type().size() > 0) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::StringSize(
        this->containing_type());
  }

  // optional int32 extension_number = 2;
  if (this->extension_number() != 0) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::Int32Size(
        this->extension_number());
  }

  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = total_size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
  return total_size;
}

void ExtensionRequest::MergeFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_merge_from_start:grpc.reflection.v1alpha.ExtensionRequest)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  const ExtensionRequest* source = 
      ::google::protobuf::internal::DynamicCastToGenerated<const ExtensionRequest>(
          &from);
  if (source == NULL) {
  // @@protoc_insertion_point(generalized_merge_from_cast_fail:grpc.reflection.v1alpha.ExtensionRequest)
    ::google::protobuf::internal::ReflectionOps::Merge(from, this);
  } else {
  // @@protoc_insertion_point(generalized_merge_from_cast_success:grpc.reflection.v1alpha.ExtensionRequest)
    MergeFrom(*source);
  }
}

void ExtensionRequest::MergeFrom(const ExtensionRequest& from) {
// @@protoc_insertion_point(class_specific_merge_from_start:grpc.reflection.v1alpha.ExtensionRequest)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  if (from.containing_type().size() > 0) {

    containing_type_.AssignWithDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), from.containing_type_);
  }
  if (from.extension_number() != 0) {
    set_extension_number(from.extension_number());
  }
}

void ExtensionRequest::CopyFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_copy_from_start:grpc.reflection.v1alpha.ExtensionRequest)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

void ExtensionRequest::CopyFrom(const ExtensionRequest& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:grpc.reflection.v1alpha.ExtensionRequest)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

bool ExtensionRequest::IsInitialized() const {

  return true;
}

void ExtensionRequest::Swap(ExtensionRequest* other) {
  if (other == this) return;
  InternalSwap(other);
}
void ExtensionRequest::InternalSwap(ExtensionRequest* other) {
  containing_type_.Swap(&other->containing_type_);
  std::swap(extension_number_, other->extension_number_);
  _internal_metadata_.Swap(&other->_internal_metadata_);
  std::swap(_cached_size_, other->_cached_size_);
}

::google::protobuf::Metadata ExtensionRequest::GetMetadata() const {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::Metadata metadata;
  metadata.descriptor = ExtensionRequest_descriptor_;
  metadata.reflection = ExtensionRequest_reflection_;
  return metadata;
}

#if PROTOBUF_INLINE_NOT_IN_HEADERS
// ExtensionRequest

// optional string containing_type = 1;
void ExtensionRequest::clear_containing_type() {
  containing_type_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 const ::std::string& ExtensionRequest::containing_type() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ExtensionRequest.containing_type)
  return containing_type_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ExtensionRequest::set_containing_type(const ::std::string& value) {
  
  containing_type_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ExtensionRequest.containing_type)
}
 void ExtensionRequest::set_containing_type(const char* value) {
  
  containing_type_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ExtensionRequest.containing_type)
}
 void ExtensionRequest::set_containing_type(const char* value, size_t size) {
  
  containing_type_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ExtensionRequest.containing_type)
}
 ::std::string* ExtensionRequest::mutable_containing_type() {
  
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ExtensionRequest.containing_type)
  return containing_type_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ExtensionRequest::release_containing_type() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ExtensionRequest.containing_type)
  
  return containing_type_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ExtensionRequest::set_allocated_containing_type(::std::string* containing_type) {
  if (containing_type != NULL) {
    
  } else {
    
  }
  containing_type_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), containing_type);
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ExtensionRequest.containing_type)
}

// optional int32 extension_number = 2;
void ExtensionRequest::clear_extension_number() {
  extension_number_ = 0;
}
 ::google::protobuf::int32 ExtensionRequest::extension_number() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ExtensionRequest.extension_number)
  return extension_number_;
}
 void ExtensionRequest::set_extension_number(::google::protobuf::int32 value) {
  
  extension_number_ = value;
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ExtensionRequest.extension_number)
}

#endif  // PROTOBUF_INLINE_NOT_IN_HEADERS

// ===================================================================

#if !defined(_MSC_VER) || _MSC_VER >= 1900
const int ServerReflectionResponse::kValidHostFieldNumber;
const int ServerReflectionResponse::kOriginalRequestFieldNumber;
const int ServerReflectionResponse::kFileDescriptorResponseFieldNumber;
const int ServerReflectionResponse::kAllExtensionNumbersResponseFieldNumber;
const int ServerReflectionResponse::kListServicesResponseFieldNumber;
const int ServerReflectionResponse::kErrorResponseFieldNumber;
#endif  // !defined(_MSC_VER) || _MSC_VER >= 1900

ServerReflectionResponse::ServerReflectionResponse()
  : ::google::protobuf::Message(), _internal_metadata_(NULL) {
  SharedCtor();
  // @@protoc_insertion_point(constructor:grpc.reflection.v1alpha.ServerReflectionResponse)
}

void ServerReflectionResponse::InitAsDefaultInstance() {
  _is_default_instance_ = true;
  original_request_ = const_cast< ::grpc::reflection::v1alpha::ServerReflectionRequest*>(&::grpc::reflection::v1alpha::ServerReflectionRequest::default_instance());
  ServerReflectionResponse_default_oneof_instance_->file_descriptor_response_ = const_cast< ::grpc::reflection::v1alpha::FileDescriptorResponse*>(&::grpc::reflection::v1alpha::FileDescriptorResponse::default_instance());
  ServerReflectionResponse_default_oneof_instance_->all_extension_numbers_response_ = const_cast< ::grpc::reflection::v1alpha::ExtensionNumberResponse*>(&::grpc::reflection::v1alpha::ExtensionNumberResponse::default_instance());
  ServerReflectionResponse_default_oneof_instance_->list_services_response_ = const_cast< ::grpc::reflection::v1alpha::ListServiceResponse*>(&::grpc::reflection::v1alpha::ListServiceResponse::default_instance());
  ServerReflectionResponse_default_oneof_instance_->error_response_ = const_cast< ::grpc::reflection::v1alpha::ErrorResponse*>(&::grpc::reflection::v1alpha::ErrorResponse::default_instance());
}

ServerReflectionResponse::ServerReflectionResponse(const ServerReflectionResponse& from)
  : ::google::protobuf::Message(),
    _internal_metadata_(NULL) {
  SharedCtor();
  MergeFrom(from);
  // @@protoc_insertion_point(copy_constructor:grpc.reflection.v1alpha.ServerReflectionResponse)
}

void ServerReflectionResponse::SharedCtor() {
    _is_default_instance_ = false;
  ::google::protobuf::internal::GetEmptyString();
  _cached_size_ = 0;
  valid_host_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  original_request_ = NULL;
  clear_has_message_response();
}

ServerReflectionResponse::~ServerReflectionResponse() {
  // @@protoc_insertion_point(destructor:grpc.reflection.v1alpha.ServerReflectionResponse)
  SharedDtor();
}

void ServerReflectionResponse::SharedDtor() {
  valid_host_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  if (has_message_response()) {
    clear_message_response();
  }
  if (this != default_instance_) {
    delete original_request_;
  }
}

void ServerReflectionResponse::SetCachedSize(int size) const {
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
}
const ::google::protobuf::Descriptor* ServerReflectionResponse::descriptor() {
  protobuf_AssignDescriptorsOnce();
  return ServerReflectionResponse_descriptor_;
}

const ServerReflectionResponse& ServerReflectionResponse::default_instance() {
  if (default_instance_ == NULL) protobuf_AddDesc_reflection_2eproto();
  return *default_instance_;
}

ServerReflectionResponse* ServerReflectionResponse::default_instance_ = NULL;

ServerReflectionResponse* ServerReflectionResponse::New(::google::protobuf::Arena* arena) const {
  ServerReflectionResponse* n = new ServerReflectionResponse;
  if (arena != NULL) {
    arena->Own(n);
  }
  return n;
}

void ServerReflectionResponse::clear_message_response() {
// @@protoc_insertion_point(one_of_clear_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  switch(message_response_case()) {
    case kFileDescriptorResponse: {
      delete message_response_.file_descriptor_response_;
      break;
    }
    case kAllExtensionNumbersResponse: {
      delete message_response_.all_extension_numbers_response_;
      break;
    }
    case kListServicesResponse: {
      delete message_response_.list_services_response_;
      break;
    }
    case kErrorResponse: {
      delete message_response_.error_response_;
      break;
    }
    case MESSAGE_RESPONSE_NOT_SET: {
      break;
    }
  }
  _oneof_case_[0] = MESSAGE_RESPONSE_NOT_SET;
}


void ServerReflectionResponse::Clear() {
// @@protoc_insertion_point(message_clear_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  valid_host_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  if (GetArenaNoVirtual() == NULL && original_request_ != NULL) delete original_request_;
  original_request_ = NULL;
  clear_message_response();
}

bool ServerReflectionResponse::MergePartialFromCodedStream(
    ::google::protobuf::io::CodedInputStream* input) {
#define DO_(EXPRESSION) if (!GOOGLE_PREDICT_TRUE(EXPRESSION)) goto failure
  ::google::protobuf::uint32 tag;
  // @@protoc_insertion_point(parse_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  for (;;) {
    ::std::pair< ::google::protobuf::uint32, bool> p = input->ReadTagWithCutoff(127);
    tag = p.first;
    if (!p.second) goto handle_unusual;
    switch (::google::protobuf::internal::WireFormatLite::GetTagFieldNumber(tag)) {
      // optional string valid_host = 1;
      case 1: {
        if (tag == 10) {
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_valid_host()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->valid_host().data(), this->valid_host().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ServerReflectionResponse.valid_host"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(18)) goto parse_original_request;
        break;
      }

      // optional .grpc.reflection.v1alpha.ServerReflectionRequest original_request = 2;
      case 2: {
        if (tag == 18) {
         parse_original_request:
          DO_(::google::protobuf::internal::WireFormatLite::ReadMessageNoVirtual(
               input, mutable_original_request()));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(34)) goto parse_file_descriptor_response;
        break;
      }

      // optional .grpc.reflection.v1alpha.FileDescriptorResponse file_descriptor_response = 4;
      case 4: {
        if (tag == 34) {
         parse_file_descriptor_response:
          DO_(::google::protobuf::internal::WireFormatLite::ReadMessageNoVirtual(
               input, mutable_file_descriptor_response()));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(42)) goto parse_all_extension_numbers_response;
        break;
      }

      // optional .grpc.reflection.v1alpha.ExtensionNumberResponse all_extension_numbers_response = 5;
      case 5: {
        if (tag == 42) {
         parse_all_extension_numbers_response:
          DO_(::google::protobuf::internal::WireFormatLite::ReadMessageNoVirtual(
               input, mutable_all_extension_numbers_response()));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(50)) goto parse_list_services_response;
        break;
      }

      // optional .grpc.reflection.v1alpha.ListServiceResponse list_services_response = 6;
      case 6: {
        if (tag == 50) {
         parse_list_services_response:
          DO_(::google::protobuf::internal::WireFormatLite::ReadMessageNoVirtual(
               input, mutable_list_services_response()));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(58)) goto parse_error_response;
        break;
      }

      // optional .grpc.reflection.v1alpha.ErrorResponse error_response = 7;
      case 7: {
        if (tag == 58) {
         parse_error_response:
          DO_(::google::protobuf::internal::WireFormatLite::ReadMessageNoVirtual(
               input, mutable_error_response()));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectAtEnd()) goto success;
        break;
      }

      default: {
      handle_unusual:
        if (tag == 0 ||
            ::google::protobuf::internal::WireFormatLite::GetTagWireType(tag) ==
            ::google::protobuf::internal::WireFormatLite::WIRETYPE_END_GROUP) {
          goto success;
        }
        DO_(::google::protobuf::internal::WireFormatLite::SkipField(input, tag));
        break;
      }
    }
  }
success:
  // @@protoc_insertion_point(parse_success:grpc.reflection.v1alpha.ServerReflectionResponse)
  return true;
failure:
  // @@protoc_insertion_point(parse_failure:grpc.reflection.v1alpha.ServerReflectionResponse)
  return false;
#undef DO_
}

void ServerReflectionResponse::SerializeWithCachedSizes(
    ::google::protobuf::io::CodedOutputStream* output) const {
  // @@protoc_insertion_point(serialize_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  // optional string valid_host = 1;
  if (this->valid_host().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->valid_host().data(), this->valid_host().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionResponse.valid_host");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      1, this->valid_host(), output);
  }

  // optional .grpc.reflection.v1alpha.ServerReflectionRequest original_request = 2;
  if (this->has_original_request()) {
    ::google::protobuf::internal::WireFormatLite::WriteMessageMaybeToArray(
      2, *this->original_request_, output);
  }

  // optional .grpc.reflection.v1alpha.FileDescriptorResponse file_descriptor_response = 4;
  if (has_file_descriptor_response()) {
    ::google::protobuf::internal::WireFormatLite::WriteMessageMaybeToArray(
      4, *message_response_.file_descriptor_response_, output);
  }

  // optional .grpc.reflection.v1alpha.ExtensionNumberResponse all_extension_numbers_response = 5;
  if (has_all_extension_numbers_response()) {
    ::google::protobuf::internal::WireFormatLite::WriteMessageMaybeToArray(
      5, *message_response_.all_extension_numbers_response_, output);
  }

  // optional .grpc.reflection.v1alpha.ListServiceResponse list_services_response = 6;
  if (has_list_services_response()) {
    ::google::protobuf::internal::WireFormatLite::WriteMessageMaybeToArray(
      6, *message_response_.list_services_response_, output);
  }

  // optional .grpc.reflection.v1alpha.ErrorResponse error_response = 7;
  if (has_error_response()) {
    ::google::protobuf::internal::WireFormatLite::WriteMessageMaybeToArray(
      7, *message_response_.error_response_, output);
  }

  // @@protoc_insertion_point(serialize_end:grpc.reflection.v1alpha.ServerReflectionResponse)
}

::google::protobuf::uint8* ServerReflectionResponse::SerializeWithCachedSizesToArray(
    ::google::protobuf::uint8* target) const {
  // @@protoc_insertion_point(serialize_to_array_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  // optional string valid_host = 1;
  if (this->valid_host().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->valid_host().data(), this->valid_host().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServerReflectionResponse.valid_host");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        1, this->valid_host(), target);
  }

  // optional .grpc.reflection.v1alpha.ServerReflectionRequest original_request = 2;
  if (this->has_original_request()) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteMessageNoVirtualToArray(
        2, *this->original_request_, target);
  }

  // optional .grpc.reflection.v1alpha.FileDescriptorResponse file_descriptor_response = 4;
  if (has_file_descriptor_response()) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteMessageNoVirtualToArray(
        4, *message_response_.file_descriptor_response_, target);
  }

  // optional .grpc.reflection.v1alpha.ExtensionNumberResponse all_extension_numbers_response = 5;
  if (has_all_extension_numbers_response()) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteMessageNoVirtualToArray(
        5, *message_response_.all_extension_numbers_response_, target);
  }

  // optional .grpc.reflection.v1alpha.ListServiceResponse list_services_response = 6;
  if (has_list_services_response()) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteMessageNoVirtualToArray(
        6, *message_response_.list_services_response_, target);
  }

  // optional .grpc.reflection.v1alpha.ErrorResponse error_response = 7;
  if (has_error_response()) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteMessageNoVirtualToArray(
        7, *message_response_.error_response_, target);
  }

  // @@protoc_insertion_point(serialize_to_array_end:grpc.reflection.v1alpha.ServerReflectionResponse)
  return target;
}

int ServerReflectionResponse::ByteSize() const {
// @@protoc_insertion_point(message_byte_size_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  int total_size = 0;

  // optional string valid_host = 1;
  if (this->valid_host().size() > 0) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::StringSize(
        this->valid_host());
  }

  // optional .grpc.reflection.v1alpha.ServerReflectionRequest original_request = 2;
  if (this->has_original_request()) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::MessageSizeNoVirtual(
        *this->original_request_);
  }

  switch (message_response_case()) {
    // optional .grpc.reflection.v1alpha.FileDescriptorResponse file_descriptor_response = 4;
    case kFileDescriptorResponse: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::MessageSizeNoVirtual(
          *message_response_.file_descriptor_response_);
      break;
    }
    // optional .grpc.reflection.v1alpha.ExtensionNumberResponse all_extension_numbers_response = 5;
    case kAllExtensionNumbersResponse: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::MessageSizeNoVirtual(
          *message_response_.all_extension_numbers_response_);
      break;
    }
    // optional .grpc.reflection.v1alpha.ListServiceResponse list_services_response = 6;
    case kListServicesResponse: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::MessageSizeNoVirtual(
          *message_response_.list_services_response_);
      break;
    }
    // optional .grpc.reflection.v1alpha.ErrorResponse error_response = 7;
    case kErrorResponse: {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::MessageSizeNoVirtual(
          *message_response_.error_response_);
      break;
    }
    case MESSAGE_RESPONSE_NOT_SET: {
      break;
    }
  }
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = total_size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
  return total_size;
}

void ServerReflectionResponse::MergeFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_merge_from_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  const ServerReflectionResponse* source = 
      ::google::protobuf::internal::DynamicCastToGenerated<const ServerReflectionResponse>(
          &from);
  if (source == NULL) {
  // @@protoc_insertion_point(generalized_merge_from_cast_fail:grpc.reflection.v1alpha.ServerReflectionResponse)
    ::google::protobuf::internal::ReflectionOps::Merge(from, this);
  } else {
  // @@protoc_insertion_point(generalized_merge_from_cast_success:grpc.reflection.v1alpha.ServerReflectionResponse)
    MergeFrom(*source);
  }
}

void ServerReflectionResponse::MergeFrom(const ServerReflectionResponse& from) {
// @@protoc_insertion_point(class_specific_merge_from_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  switch (from.message_response_case()) {
    case kFileDescriptorResponse: {
      mutable_file_descriptor_response()->::grpc::reflection::v1alpha::FileDescriptorResponse::MergeFrom(from.file_descriptor_response());
      break;
    }
    case kAllExtensionNumbersResponse: {
      mutable_all_extension_numbers_response()->::grpc::reflection::v1alpha::ExtensionNumberResponse::MergeFrom(from.all_extension_numbers_response());
      break;
    }
    case kListServicesResponse: {
      mutable_list_services_response()->::grpc::reflection::v1alpha::ListServiceResponse::MergeFrom(from.list_services_response());
      break;
    }
    case kErrorResponse: {
      mutable_error_response()->::grpc::reflection::v1alpha::ErrorResponse::MergeFrom(from.error_response());
      break;
    }
    case MESSAGE_RESPONSE_NOT_SET: {
      break;
    }
  }
  if (from.valid_host().size() > 0) {

    valid_host_.AssignWithDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), from.valid_host_);
  }
  if (from.has_original_request()) {
    mutable_original_request()->::grpc::reflection::v1alpha::ServerReflectionRequest::MergeFrom(from.original_request());
  }
}

void ServerReflectionResponse::CopyFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_copy_from_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

void ServerReflectionResponse::CopyFrom(const ServerReflectionResponse& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:grpc.reflection.v1alpha.ServerReflectionResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

bool ServerReflectionResponse::IsInitialized() const {

  return true;
}

void ServerReflectionResponse::Swap(ServerReflectionResponse* other) {
  if (other == this) return;
  InternalSwap(other);
}
void ServerReflectionResponse::InternalSwap(ServerReflectionResponse* other) {
  valid_host_.Swap(&other->valid_host_);
  std::swap(original_request_, other->original_request_);
  std::swap(message_response_, other->message_response_);
  std::swap(_oneof_case_[0], other->_oneof_case_[0]);
  _internal_metadata_.Swap(&other->_internal_metadata_);
  std::swap(_cached_size_, other->_cached_size_);
}

::google::protobuf::Metadata ServerReflectionResponse::GetMetadata() const {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::Metadata metadata;
  metadata.descriptor = ServerReflectionResponse_descriptor_;
  metadata.reflection = ServerReflectionResponse_reflection_;
  return metadata;
}

#if PROTOBUF_INLINE_NOT_IN_HEADERS
// ServerReflectionResponse

// optional string valid_host = 1;
void ServerReflectionResponse::clear_valid_host() {
  valid_host_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 const ::std::string& ServerReflectionResponse::valid_host() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionResponse.valid_host)
  return valid_host_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ServerReflectionResponse::set_valid_host(const ::std::string& value) {
  
  valid_host_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServerReflectionResponse.valid_host)
}
 void ServerReflectionResponse::set_valid_host(const char* value) {
  
  valid_host_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ServerReflectionResponse.valid_host)
}
 void ServerReflectionResponse::set_valid_host(const char* value, size_t size) {
  
  valid_host_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ServerReflectionResponse.valid_host)
}
 ::std::string* ServerReflectionResponse::mutable_valid_host() {
  
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionResponse.valid_host)
  return valid_host_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ServerReflectionResponse::release_valid_host() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionResponse.valid_host)
  
  return valid_host_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ServerReflectionResponse::set_allocated_valid_host(::std::string* valid_host) {
  if (valid_host != NULL) {
    
  } else {
    
  }
  valid_host_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), valid_host);
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionResponse.valid_host)
}

// optional .grpc.reflection.v1alpha.ServerReflectionRequest original_request = 2;
bool ServerReflectionResponse::has_original_request() const {
  return !_is_default_instance_ && original_request_ != NULL;
}
void ServerReflectionResponse::clear_original_request() {
  if (GetArenaNoVirtual() == NULL && original_request_ != NULL) delete original_request_;
  original_request_ = NULL;
}
const ::grpc::reflection::v1alpha::ServerReflectionRequest& ServerReflectionResponse::original_request() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionResponse.original_request)
  return original_request_ != NULL ? *original_request_ : *default_instance_->original_request_;
}
::grpc::reflection::v1alpha::ServerReflectionRequest* ServerReflectionResponse::mutable_original_request() {
  
  if (original_request_ == NULL) {
    original_request_ = new ::grpc::reflection::v1alpha::ServerReflectionRequest;
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionResponse.original_request)
  return original_request_;
}
::grpc::reflection::v1alpha::ServerReflectionRequest* ServerReflectionResponse::release_original_request() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionResponse.original_request)
  
  ::grpc::reflection::v1alpha::ServerReflectionRequest* temp = original_request_;
  original_request_ = NULL;
  return temp;
}
void ServerReflectionResponse::set_allocated_original_request(::grpc::reflection::v1alpha::ServerReflectionRequest* original_request) {
  delete original_request_;
  original_request_ = original_request;
  if (original_request) {
    
  } else {
    
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionResponse.original_request)
}

// optional .grpc.reflection.v1alpha.FileDescriptorResponse file_descriptor_response = 4;
bool ServerReflectionResponse::has_file_descriptor_response() const {
  return message_response_case() == kFileDescriptorResponse;
}
void ServerReflectionResponse::set_has_file_descriptor_response() {
  _oneof_case_[0] = kFileDescriptorResponse;
}
void ServerReflectionResponse::clear_file_descriptor_response() {
  if (has_file_descriptor_response()) {
    delete message_response_.file_descriptor_response_;
    clear_has_message_response();
  }
}
 const ::grpc::reflection::v1alpha::FileDescriptorResponse& ServerReflectionResponse::file_descriptor_response() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionResponse.file_descriptor_response)
  return has_file_descriptor_response()
      ? *message_response_.file_descriptor_response_
      : ::grpc::reflection::v1alpha::FileDescriptorResponse::default_instance();
}
::grpc::reflection::v1alpha::FileDescriptorResponse* ServerReflectionResponse::mutable_file_descriptor_response() {
  if (!has_file_descriptor_response()) {
    clear_message_response();
    set_has_file_descriptor_response();
    message_response_.file_descriptor_response_ = new ::grpc::reflection::v1alpha::FileDescriptorResponse;
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionResponse.file_descriptor_response)
  return message_response_.file_descriptor_response_;
}
::grpc::reflection::v1alpha::FileDescriptorResponse* ServerReflectionResponse::release_file_descriptor_response() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionResponse.file_descriptor_response)
  if (has_file_descriptor_response()) {
    clear_has_message_response();
    ::grpc::reflection::v1alpha::FileDescriptorResponse* temp = message_response_.file_descriptor_response_;
    message_response_.file_descriptor_response_ = NULL;
    return temp;
  } else {
    return NULL;
  }
}
void ServerReflectionResponse::set_allocated_file_descriptor_response(::grpc::reflection::v1alpha::FileDescriptorResponse* file_descriptor_response) {
  clear_message_response();
  if (file_descriptor_response) {
    set_has_file_descriptor_response();
    message_response_.file_descriptor_response_ = file_descriptor_response;
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionResponse.file_descriptor_response)
}

// optional .grpc.reflection.v1alpha.ExtensionNumberResponse all_extension_numbers_response = 5;
bool ServerReflectionResponse::has_all_extension_numbers_response() const {
  return message_response_case() == kAllExtensionNumbersResponse;
}
void ServerReflectionResponse::set_has_all_extension_numbers_response() {
  _oneof_case_[0] = kAllExtensionNumbersResponse;
}
void ServerReflectionResponse::clear_all_extension_numbers_response() {
  if (has_all_extension_numbers_response()) {
    delete message_response_.all_extension_numbers_response_;
    clear_has_message_response();
  }
}
 const ::grpc::reflection::v1alpha::ExtensionNumberResponse& ServerReflectionResponse::all_extension_numbers_response() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionResponse.all_extension_numbers_response)
  return has_all_extension_numbers_response()
      ? *message_response_.all_extension_numbers_response_
      : ::grpc::reflection::v1alpha::ExtensionNumberResponse::default_instance();
}
::grpc::reflection::v1alpha::ExtensionNumberResponse* ServerReflectionResponse::mutable_all_extension_numbers_response() {
  if (!has_all_extension_numbers_response()) {
    clear_message_response();
    set_has_all_extension_numbers_response();
    message_response_.all_extension_numbers_response_ = new ::grpc::reflection::v1alpha::ExtensionNumberResponse;
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionResponse.all_extension_numbers_response)
  return message_response_.all_extension_numbers_response_;
}
::grpc::reflection::v1alpha::ExtensionNumberResponse* ServerReflectionResponse::release_all_extension_numbers_response() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionResponse.all_extension_numbers_response)
  if (has_all_extension_numbers_response()) {
    clear_has_message_response();
    ::grpc::reflection::v1alpha::ExtensionNumberResponse* temp = message_response_.all_extension_numbers_response_;
    message_response_.all_extension_numbers_response_ = NULL;
    return temp;
  } else {
    return NULL;
  }
}
void ServerReflectionResponse::set_allocated_all_extension_numbers_response(::grpc::reflection::v1alpha::ExtensionNumberResponse* all_extension_numbers_response) {
  clear_message_response();
  if (all_extension_numbers_response) {
    set_has_all_extension_numbers_response();
    message_response_.all_extension_numbers_response_ = all_extension_numbers_response;
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionResponse.all_extension_numbers_response)
}

// optional .grpc.reflection.v1alpha.ListServiceResponse list_services_response = 6;
bool ServerReflectionResponse::has_list_services_response() const {
  return message_response_case() == kListServicesResponse;
}
void ServerReflectionResponse::set_has_list_services_response() {
  _oneof_case_[0] = kListServicesResponse;
}
void ServerReflectionResponse::clear_list_services_response() {
  if (has_list_services_response()) {
    delete message_response_.list_services_response_;
    clear_has_message_response();
  }
}
 const ::grpc::reflection::v1alpha::ListServiceResponse& ServerReflectionResponse::list_services_response() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionResponse.list_services_response)
  return has_list_services_response()
      ? *message_response_.list_services_response_
      : ::grpc::reflection::v1alpha::ListServiceResponse::default_instance();
}
::grpc::reflection::v1alpha::ListServiceResponse* ServerReflectionResponse::mutable_list_services_response() {
  if (!has_list_services_response()) {
    clear_message_response();
    set_has_list_services_response();
    message_response_.list_services_response_ = new ::grpc::reflection::v1alpha::ListServiceResponse;
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionResponse.list_services_response)
  return message_response_.list_services_response_;
}
::grpc::reflection::v1alpha::ListServiceResponse* ServerReflectionResponse::release_list_services_response() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionResponse.list_services_response)
  if (has_list_services_response()) {
    clear_has_message_response();
    ::grpc::reflection::v1alpha::ListServiceResponse* temp = message_response_.list_services_response_;
    message_response_.list_services_response_ = NULL;
    return temp;
  } else {
    return NULL;
  }
}
void ServerReflectionResponse::set_allocated_list_services_response(::grpc::reflection::v1alpha::ListServiceResponse* list_services_response) {
  clear_message_response();
  if (list_services_response) {
    set_has_list_services_response();
    message_response_.list_services_response_ = list_services_response;
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionResponse.list_services_response)
}

// optional .grpc.reflection.v1alpha.ErrorResponse error_response = 7;
bool ServerReflectionResponse::has_error_response() const {
  return message_response_case() == kErrorResponse;
}
void ServerReflectionResponse::set_has_error_response() {
  _oneof_case_[0] = kErrorResponse;
}
void ServerReflectionResponse::clear_error_response() {
  if (has_error_response()) {
    delete message_response_.error_response_;
    clear_has_message_response();
  }
}
 const ::grpc::reflection::v1alpha::ErrorResponse& ServerReflectionResponse::error_response() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServerReflectionResponse.error_response)
  return has_error_response()
      ? *message_response_.error_response_
      : ::grpc::reflection::v1alpha::ErrorResponse::default_instance();
}
::grpc::reflection::v1alpha::ErrorResponse* ServerReflectionResponse::mutable_error_response() {
  if (!has_error_response()) {
    clear_message_response();
    set_has_error_response();
    message_response_.error_response_ = new ::grpc::reflection::v1alpha::ErrorResponse;
  }
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServerReflectionResponse.error_response)
  return message_response_.error_response_;
}
::grpc::reflection::v1alpha::ErrorResponse* ServerReflectionResponse::release_error_response() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServerReflectionResponse.error_response)
  if (has_error_response()) {
    clear_has_message_response();
    ::grpc::reflection::v1alpha::ErrorResponse* temp = message_response_.error_response_;
    message_response_.error_response_ = NULL;
    return temp;
  } else {
    return NULL;
  }
}
void ServerReflectionResponse::set_allocated_error_response(::grpc::reflection::v1alpha::ErrorResponse* error_response) {
  clear_message_response();
  if (error_response) {
    set_has_error_response();
    message_response_.error_response_ = error_response;
  }
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServerReflectionResponse.error_response)
}

bool ServerReflectionResponse::has_message_response() const {
  return message_response_case() != MESSAGE_RESPONSE_NOT_SET;
}
void ServerReflectionResponse::clear_has_message_response() {
  _oneof_case_[0] = MESSAGE_RESPONSE_NOT_SET;
}
ServerReflectionResponse::MessageResponseCase ServerReflectionResponse::message_response_case() const {
  return ServerReflectionResponse::MessageResponseCase(_oneof_case_[0]);
}
#endif  // PROTOBUF_INLINE_NOT_IN_HEADERS

// ===================================================================

#if !defined(_MSC_VER) || _MSC_VER >= 1900
const int FileDescriptorResponse::kFileDescriptorProtoFieldNumber;
#endif  // !defined(_MSC_VER) || _MSC_VER >= 1900

FileDescriptorResponse::FileDescriptorResponse()
  : ::google::protobuf::Message(), _internal_metadata_(NULL) {
  SharedCtor();
  // @@protoc_insertion_point(constructor:grpc.reflection.v1alpha.FileDescriptorResponse)
}

void FileDescriptorResponse::InitAsDefaultInstance() {
  _is_default_instance_ = true;
}

FileDescriptorResponse::FileDescriptorResponse(const FileDescriptorResponse& from)
  : ::google::protobuf::Message(),
    _internal_metadata_(NULL) {
  SharedCtor();
  MergeFrom(from);
  // @@protoc_insertion_point(copy_constructor:grpc.reflection.v1alpha.FileDescriptorResponse)
}

void FileDescriptorResponse::SharedCtor() {
    _is_default_instance_ = false;
  ::google::protobuf::internal::GetEmptyString();
  _cached_size_ = 0;
}

FileDescriptorResponse::~FileDescriptorResponse() {
  // @@protoc_insertion_point(destructor:grpc.reflection.v1alpha.FileDescriptorResponse)
  SharedDtor();
}

void FileDescriptorResponse::SharedDtor() {
  if (this != default_instance_) {
  }
}

void FileDescriptorResponse::SetCachedSize(int size) const {
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
}
const ::google::protobuf::Descriptor* FileDescriptorResponse::descriptor() {
  protobuf_AssignDescriptorsOnce();
  return FileDescriptorResponse_descriptor_;
}

const FileDescriptorResponse& FileDescriptorResponse::default_instance() {
  if (default_instance_ == NULL) protobuf_AddDesc_reflection_2eproto();
  return *default_instance_;
}

FileDescriptorResponse* FileDescriptorResponse::default_instance_ = NULL;

FileDescriptorResponse* FileDescriptorResponse::New(::google::protobuf::Arena* arena) const {
  FileDescriptorResponse* n = new FileDescriptorResponse;
  if (arena != NULL) {
    arena->Own(n);
  }
  return n;
}

void FileDescriptorResponse::Clear() {
// @@protoc_insertion_point(message_clear_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  file_descriptor_proto_.Clear();
}

bool FileDescriptorResponse::MergePartialFromCodedStream(
    ::google::protobuf::io::CodedInputStream* input) {
#define DO_(EXPRESSION) if (!GOOGLE_PREDICT_TRUE(EXPRESSION)) goto failure
  ::google::protobuf::uint32 tag;
  // @@protoc_insertion_point(parse_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  for (;;) {
    ::std::pair< ::google::protobuf::uint32, bool> p = input->ReadTagWithCutoff(127);
    tag = p.first;
    if (!p.second) goto handle_unusual;
    switch (::google::protobuf::internal::WireFormatLite::GetTagFieldNumber(tag)) {
      // repeated bytes file_descriptor_proto = 1;
      case 1: {
        if (tag == 10) {
         parse_file_descriptor_proto:
          DO_(::google::protobuf::internal::WireFormatLite::ReadBytes(
                input, this->add_file_descriptor_proto()));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(10)) goto parse_file_descriptor_proto;
        if (input->ExpectAtEnd()) goto success;
        break;
      }

      default: {
      handle_unusual:
        if (tag == 0 ||
            ::google::protobuf::internal::WireFormatLite::GetTagWireType(tag) ==
            ::google::protobuf::internal::WireFormatLite::WIRETYPE_END_GROUP) {
          goto success;
        }
        DO_(::google::protobuf::internal::WireFormatLite::SkipField(input, tag));
        break;
      }
    }
  }
success:
  // @@protoc_insertion_point(parse_success:grpc.reflection.v1alpha.FileDescriptorResponse)
  return true;
failure:
  // @@protoc_insertion_point(parse_failure:grpc.reflection.v1alpha.FileDescriptorResponse)
  return false;
#undef DO_
}

void FileDescriptorResponse::SerializeWithCachedSizes(
    ::google::protobuf::io::CodedOutputStream* output) const {
  // @@protoc_insertion_point(serialize_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  // repeated bytes file_descriptor_proto = 1;
  for (int i = 0; i < this->file_descriptor_proto_size(); i++) {
    ::google::protobuf::internal::WireFormatLite::WriteBytes(
      1, this->file_descriptor_proto(i), output);
  }

  // @@protoc_insertion_point(serialize_end:grpc.reflection.v1alpha.FileDescriptorResponse)
}

::google::protobuf::uint8* FileDescriptorResponse::SerializeWithCachedSizesToArray(
    ::google::protobuf::uint8* target) const {
  // @@protoc_insertion_point(serialize_to_array_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  // repeated bytes file_descriptor_proto = 1;
  for (int i = 0; i < this->file_descriptor_proto_size(); i++) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteBytesToArray(1, this->file_descriptor_proto(i), target);
  }

  // @@protoc_insertion_point(serialize_to_array_end:grpc.reflection.v1alpha.FileDescriptorResponse)
  return target;
}

int FileDescriptorResponse::ByteSize() const {
// @@protoc_insertion_point(message_byte_size_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  int total_size = 0;

  // repeated bytes file_descriptor_proto = 1;
  total_size += 1 * this->file_descriptor_proto_size();
  for (int i = 0; i < this->file_descriptor_proto_size(); i++) {
    total_size += ::google::protobuf::internal::WireFormatLite::BytesSize(
      this->file_descriptor_proto(i));
  }

  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = total_size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
  return total_size;
}

void FileDescriptorResponse::MergeFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_merge_from_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  const FileDescriptorResponse* source = 
      ::google::protobuf::internal::DynamicCastToGenerated<const FileDescriptorResponse>(
          &from);
  if (source == NULL) {
  // @@protoc_insertion_point(generalized_merge_from_cast_fail:grpc.reflection.v1alpha.FileDescriptorResponse)
    ::google::protobuf::internal::ReflectionOps::Merge(from, this);
  } else {
  // @@protoc_insertion_point(generalized_merge_from_cast_success:grpc.reflection.v1alpha.FileDescriptorResponse)
    MergeFrom(*source);
  }
}

void FileDescriptorResponse::MergeFrom(const FileDescriptorResponse& from) {
// @@protoc_insertion_point(class_specific_merge_from_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  file_descriptor_proto_.MergeFrom(from.file_descriptor_proto_);
}

void FileDescriptorResponse::CopyFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_copy_from_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

void FileDescriptorResponse::CopyFrom(const FileDescriptorResponse& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:grpc.reflection.v1alpha.FileDescriptorResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

bool FileDescriptorResponse::IsInitialized() const {

  return true;
}

void FileDescriptorResponse::Swap(FileDescriptorResponse* other) {
  if (other == this) return;
  InternalSwap(other);
}
void FileDescriptorResponse::InternalSwap(FileDescriptorResponse* other) {
  file_descriptor_proto_.UnsafeArenaSwap(&other->file_descriptor_proto_);
  _internal_metadata_.Swap(&other->_internal_metadata_);
  std::swap(_cached_size_, other->_cached_size_);
}

::google::protobuf::Metadata FileDescriptorResponse::GetMetadata() const {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::Metadata metadata;
  metadata.descriptor = FileDescriptorResponse_descriptor_;
  metadata.reflection = FileDescriptorResponse_reflection_;
  return metadata;
}

#if PROTOBUF_INLINE_NOT_IN_HEADERS
// FileDescriptorResponse

// repeated bytes file_descriptor_proto = 1;
int FileDescriptorResponse::file_descriptor_proto_size() const {
  return file_descriptor_proto_.size();
}
void FileDescriptorResponse::clear_file_descriptor_proto() {
  file_descriptor_proto_.Clear();
}
 const ::std::string& FileDescriptorResponse::file_descriptor_proto(int index) const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
  return file_descriptor_proto_.Get(index);
}
 ::std::string* FileDescriptorResponse::mutable_file_descriptor_proto(int index) {
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
  return file_descriptor_proto_.Mutable(index);
}
 void FileDescriptorResponse::set_file_descriptor_proto(int index, const ::std::string& value) {
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
  file_descriptor_proto_.Mutable(index)->assign(value);
}
 void FileDescriptorResponse::set_file_descriptor_proto(int index, const char* value) {
  file_descriptor_proto_.Mutable(index)->assign(value);
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
}
 void FileDescriptorResponse::set_file_descriptor_proto(int index, const void* value, size_t size) {
  file_descriptor_proto_.Mutable(index)->assign(
    reinterpret_cast<const char*>(value), size);
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
}
 ::std::string* FileDescriptorResponse::add_file_descriptor_proto() {
  // @@protoc_insertion_point(field_add_mutable:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
  return file_descriptor_proto_.Add();
}
 void FileDescriptorResponse::add_file_descriptor_proto(const ::std::string& value) {
  file_descriptor_proto_.Add()->assign(value);
  // @@protoc_insertion_point(field_add:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
}
 void FileDescriptorResponse::add_file_descriptor_proto(const char* value) {
  file_descriptor_proto_.Add()->assign(value);
  // @@protoc_insertion_point(field_add_char:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
}
 void FileDescriptorResponse::add_file_descriptor_proto(const void* value, size_t size) {
  file_descriptor_proto_.Add()->assign(reinterpret_cast<const char*>(value), size);
  // @@protoc_insertion_point(field_add_pointer:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
}
 const ::google::protobuf::RepeatedPtrField< ::std::string>&
FileDescriptorResponse::file_descriptor_proto() const {
  // @@protoc_insertion_point(field_list:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
  return file_descriptor_proto_;
}
 ::google::protobuf::RepeatedPtrField< ::std::string>*
FileDescriptorResponse::mutable_file_descriptor_proto() {
  // @@protoc_insertion_point(field_mutable_list:grpc.reflection.v1alpha.FileDescriptorResponse.file_descriptor_proto)
  return &file_descriptor_proto_;
}

#endif  // PROTOBUF_INLINE_NOT_IN_HEADERS

// ===================================================================

#if !defined(_MSC_VER) || _MSC_VER >= 1900
const int ExtensionNumberResponse::kBaseTypeNameFieldNumber;
const int ExtensionNumberResponse::kExtensionNumberFieldNumber;
#endif  // !defined(_MSC_VER) || _MSC_VER >= 1900

ExtensionNumberResponse::ExtensionNumberResponse()
  : ::google::protobuf::Message(), _internal_metadata_(NULL) {
  SharedCtor();
  // @@protoc_insertion_point(constructor:grpc.reflection.v1alpha.ExtensionNumberResponse)
}

void ExtensionNumberResponse::InitAsDefaultInstance() {
  _is_default_instance_ = true;
}

ExtensionNumberResponse::ExtensionNumberResponse(const ExtensionNumberResponse& from)
  : ::google::protobuf::Message(),
    _internal_metadata_(NULL) {
  SharedCtor();
  MergeFrom(from);
  // @@protoc_insertion_point(copy_constructor:grpc.reflection.v1alpha.ExtensionNumberResponse)
}

void ExtensionNumberResponse::SharedCtor() {
    _is_default_instance_ = false;
  ::google::protobuf::internal::GetEmptyString();
  _cached_size_ = 0;
  base_type_name_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}

ExtensionNumberResponse::~ExtensionNumberResponse() {
  // @@protoc_insertion_point(destructor:grpc.reflection.v1alpha.ExtensionNumberResponse)
  SharedDtor();
}

void ExtensionNumberResponse::SharedDtor() {
  base_type_name_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  if (this != default_instance_) {
  }
}

void ExtensionNumberResponse::SetCachedSize(int size) const {
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
}
const ::google::protobuf::Descriptor* ExtensionNumberResponse::descriptor() {
  protobuf_AssignDescriptorsOnce();
  return ExtensionNumberResponse_descriptor_;
}

const ExtensionNumberResponse& ExtensionNumberResponse::default_instance() {
  if (default_instance_ == NULL) protobuf_AddDesc_reflection_2eproto();
  return *default_instance_;
}

ExtensionNumberResponse* ExtensionNumberResponse::default_instance_ = NULL;

ExtensionNumberResponse* ExtensionNumberResponse::New(::google::protobuf::Arena* arena) const {
  ExtensionNumberResponse* n = new ExtensionNumberResponse;
  if (arena != NULL) {
    arena->Own(n);
  }
  return n;
}

void ExtensionNumberResponse::Clear() {
// @@protoc_insertion_point(message_clear_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  base_type_name_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  extension_number_.Clear();
}

bool ExtensionNumberResponse::MergePartialFromCodedStream(
    ::google::protobuf::io::CodedInputStream* input) {
#define DO_(EXPRESSION) if (!GOOGLE_PREDICT_TRUE(EXPRESSION)) goto failure
  ::google::protobuf::uint32 tag;
  // @@protoc_insertion_point(parse_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  for (;;) {
    ::std::pair< ::google::protobuf::uint32, bool> p = input->ReadTagWithCutoff(127);
    tag = p.first;
    if (!p.second) goto handle_unusual;
    switch (::google::protobuf::internal::WireFormatLite::GetTagFieldNumber(tag)) {
      // optional string base_type_name = 1;
      case 1: {
        if (tag == 10) {
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_base_type_name()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->base_type_name().data(), this->base_type_name().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(18)) goto parse_extension_number;
        break;
      }

      // repeated int32 extension_number = 2;
      case 2: {
        if (tag == 18) {
         parse_extension_number:
          DO_((::google::protobuf::internal::WireFormatLite::ReadPackedPrimitive<
                   ::google::protobuf::int32, ::google::protobuf::internal::WireFormatLite::TYPE_INT32>(
                 input, this->mutable_extension_number())));
        } else if (tag == 16) {
          DO_((::google::protobuf::internal::WireFormatLite::ReadRepeatedPrimitiveNoInline<
                   ::google::protobuf::int32, ::google::protobuf::internal::WireFormatLite::TYPE_INT32>(
                 1, 18, input, this->mutable_extension_number())));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectAtEnd()) goto success;
        break;
      }

      default: {
      handle_unusual:
        if (tag == 0 ||
            ::google::protobuf::internal::WireFormatLite::GetTagWireType(tag) ==
            ::google::protobuf::internal::WireFormatLite::WIRETYPE_END_GROUP) {
          goto success;
        }
        DO_(::google::protobuf::internal::WireFormatLite::SkipField(input, tag));
        break;
      }
    }
  }
success:
  // @@protoc_insertion_point(parse_success:grpc.reflection.v1alpha.ExtensionNumberResponse)
  return true;
failure:
  // @@protoc_insertion_point(parse_failure:grpc.reflection.v1alpha.ExtensionNumberResponse)
  return false;
#undef DO_
}

void ExtensionNumberResponse::SerializeWithCachedSizes(
    ::google::protobuf::io::CodedOutputStream* output) const {
  // @@protoc_insertion_point(serialize_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  // optional string base_type_name = 1;
  if (this->base_type_name().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->base_type_name().data(), this->base_type_name().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      1, this->base_type_name(), output);
  }

  // repeated int32 extension_number = 2;
  if (this->extension_number_size() > 0) {
    ::google::protobuf::internal::WireFormatLite::WriteTag(2, ::google::protobuf::internal::WireFormatLite::WIRETYPE_LENGTH_DELIMITED, output);
    output->WriteVarint32(_extension_number_cached_byte_size_);
  }
  for (int i = 0; i < this->extension_number_size(); i++) {
    ::google::protobuf::internal::WireFormatLite::WriteInt32NoTag(
      this->extension_number(i), output);
  }

  // @@protoc_insertion_point(serialize_end:grpc.reflection.v1alpha.ExtensionNumberResponse)
}

::google::protobuf::uint8* ExtensionNumberResponse::SerializeWithCachedSizesToArray(
    ::google::protobuf::uint8* target) const {
  // @@protoc_insertion_point(serialize_to_array_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  // optional string base_type_name = 1;
  if (this->base_type_name().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->base_type_name().data(), this->base_type_name().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        1, this->base_type_name(), target);
  }

  // repeated int32 extension_number = 2;
  if (this->extension_number_size() > 0) {
    target = ::google::protobuf::internal::WireFormatLite::WriteTagToArray(
      2,
      ::google::protobuf::internal::WireFormatLite::WIRETYPE_LENGTH_DELIMITED,
      target);
    target = ::google::protobuf::io::CodedOutputStream::WriteVarint32ToArray(
      _extension_number_cached_byte_size_, target);
  }
  for (int i = 0; i < this->extension_number_size(); i++) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteInt32NoTagToArray(this->extension_number(i), target);
  }

  // @@protoc_insertion_point(serialize_to_array_end:grpc.reflection.v1alpha.ExtensionNumberResponse)
  return target;
}

int ExtensionNumberResponse::ByteSize() const {
// @@protoc_insertion_point(message_byte_size_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  int total_size = 0;

  // optional string base_type_name = 1;
  if (this->base_type_name().size() > 0) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::StringSize(
        this->base_type_name());
  }

  // repeated int32 extension_number = 2;
  {
    int data_size = 0;
    for (int i = 0; i < this->extension_number_size(); i++) {
      data_size += ::google::protobuf::internal::WireFormatLite::
        Int32Size(this->extension_number(i));
    }
    if (data_size > 0) {
      total_size += 1 +
        ::google::protobuf::internal::WireFormatLite::Int32Size(data_size);
    }
    GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
    _extension_number_cached_byte_size_ = data_size;
    GOOGLE_SAFE_CONCURRENT_WRITES_END();
    total_size += data_size;
  }

  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = total_size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
  return total_size;
}

void ExtensionNumberResponse::MergeFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_merge_from_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  const ExtensionNumberResponse* source = 
      ::google::protobuf::internal::DynamicCastToGenerated<const ExtensionNumberResponse>(
          &from);
  if (source == NULL) {
  // @@protoc_insertion_point(generalized_merge_from_cast_fail:grpc.reflection.v1alpha.ExtensionNumberResponse)
    ::google::protobuf::internal::ReflectionOps::Merge(from, this);
  } else {
  // @@protoc_insertion_point(generalized_merge_from_cast_success:grpc.reflection.v1alpha.ExtensionNumberResponse)
    MergeFrom(*source);
  }
}

void ExtensionNumberResponse::MergeFrom(const ExtensionNumberResponse& from) {
// @@protoc_insertion_point(class_specific_merge_from_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  extension_number_.MergeFrom(from.extension_number_);
  if (from.base_type_name().size() > 0) {

    base_type_name_.AssignWithDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), from.base_type_name_);
  }
}

void ExtensionNumberResponse::CopyFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_copy_from_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

void ExtensionNumberResponse::CopyFrom(const ExtensionNumberResponse& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:grpc.reflection.v1alpha.ExtensionNumberResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

bool ExtensionNumberResponse::IsInitialized() const {

  return true;
}

void ExtensionNumberResponse::Swap(ExtensionNumberResponse* other) {
  if (other == this) return;
  InternalSwap(other);
}
void ExtensionNumberResponse::InternalSwap(ExtensionNumberResponse* other) {
  base_type_name_.Swap(&other->base_type_name_);
  extension_number_.UnsafeArenaSwap(&other->extension_number_);
  _internal_metadata_.Swap(&other->_internal_metadata_);
  std::swap(_cached_size_, other->_cached_size_);
}

::google::protobuf::Metadata ExtensionNumberResponse::GetMetadata() const {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::Metadata metadata;
  metadata.descriptor = ExtensionNumberResponse_descriptor_;
  metadata.reflection = ExtensionNumberResponse_reflection_;
  return metadata;
}

#if PROTOBUF_INLINE_NOT_IN_HEADERS
// ExtensionNumberResponse

// optional string base_type_name = 1;
void ExtensionNumberResponse::clear_base_type_name() {
  base_type_name_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 const ::std::string& ExtensionNumberResponse::base_type_name() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name)
  return base_type_name_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ExtensionNumberResponse::set_base_type_name(const ::std::string& value) {
  
  base_type_name_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name)
}
 void ExtensionNumberResponse::set_base_type_name(const char* value) {
  
  base_type_name_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name)
}
 void ExtensionNumberResponse::set_base_type_name(const char* value, size_t size) {
  
  base_type_name_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name)
}
 ::std::string* ExtensionNumberResponse::mutable_base_type_name() {
  
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name)
  return base_type_name_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ExtensionNumberResponse::release_base_type_name() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name)
  
  return base_type_name_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ExtensionNumberResponse::set_allocated_base_type_name(::std::string* base_type_name) {
  if (base_type_name != NULL) {
    
  } else {
    
  }
  base_type_name_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), base_type_name);
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ExtensionNumberResponse.base_type_name)
}

// repeated int32 extension_number = 2;
int ExtensionNumberResponse::extension_number_size() const {
  return extension_number_.size();
}
void ExtensionNumberResponse::clear_extension_number() {
  extension_number_.Clear();
}
 ::google::protobuf::int32 ExtensionNumberResponse::extension_number(int index) const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ExtensionNumberResponse.extension_number)
  return extension_number_.Get(index);
}
 void ExtensionNumberResponse::set_extension_number(int index, ::google::protobuf::int32 value) {
  extension_number_.Set(index, value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ExtensionNumberResponse.extension_number)
}
 void ExtensionNumberResponse::add_extension_number(::google::protobuf::int32 value) {
  extension_number_.Add(value);
  // @@protoc_insertion_point(field_add:grpc.reflection.v1alpha.ExtensionNumberResponse.extension_number)
}
 const ::google::protobuf::RepeatedField< ::google::protobuf::int32 >&
ExtensionNumberResponse::extension_number() const {
  // @@protoc_insertion_point(field_list:grpc.reflection.v1alpha.ExtensionNumberResponse.extension_number)
  return extension_number_;
}
 ::google::protobuf::RepeatedField< ::google::protobuf::int32 >*
ExtensionNumberResponse::mutable_extension_number() {
  // @@protoc_insertion_point(field_mutable_list:grpc.reflection.v1alpha.ExtensionNumberResponse.extension_number)
  return &extension_number_;
}

#endif  // PROTOBUF_INLINE_NOT_IN_HEADERS

// ===================================================================

#if !defined(_MSC_VER) || _MSC_VER >= 1900
const int ListServiceResponse::kServiceFieldNumber;
#endif  // !defined(_MSC_VER) || _MSC_VER >= 1900

ListServiceResponse::ListServiceResponse()
  : ::google::protobuf::Message(), _internal_metadata_(NULL) {
  SharedCtor();
  // @@protoc_insertion_point(constructor:grpc.reflection.v1alpha.ListServiceResponse)
}

void ListServiceResponse::InitAsDefaultInstance() {
  _is_default_instance_ = true;
}

ListServiceResponse::ListServiceResponse(const ListServiceResponse& from)
  : ::google::protobuf::Message(),
    _internal_metadata_(NULL) {
  SharedCtor();
  MergeFrom(from);
  // @@protoc_insertion_point(copy_constructor:grpc.reflection.v1alpha.ListServiceResponse)
}

void ListServiceResponse::SharedCtor() {
    _is_default_instance_ = false;
  _cached_size_ = 0;
}

ListServiceResponse::~ListServiceResponse() {
  // @@protoc_insertion_point(destructor:grpc.reflection.v1alpha.ListServiceResponse)
  SharedDtor();
}

void ListServiceResponse::SharedDtor() {
  if (this != default_instance_) {
  }
}

void ListServiceResponse::SetCachedSize(int size) const {
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
}
const ::google::protobuf::Descriptor* ListServiceResponse::descriptor() {
  protobuf_AssignDescriptorsOnce();
  return ListServiceResponse_descriptor_;
}

const ListServiceResponse& ListServiceResponse::default_instance() {
  if (default_instance_ == NULL) protobuf_AddDesc_reflection_2eproto();
  return *default_instance_;
}

ListServiceResponse* ListServiceResponse::default_instance_ = NULL;

ListServiceResponse* ListServiceResponse::New(::google::protobuf::Arena* arena) const {
  ListServiceResponse* n = new ListServiceResponse;
  if (arena != NULL) {
    arena->Own(n);
  }
  return n;
}

void ListServiceResponse::Clear() {
// @@protoc_insertion_point(message_clear_start:grpc.reflection.v1alpha.ListServiceResponse)
  service_.Clear();
}

bool ListServiceResponse::MergePartialFromCodedStream(
    ::google::protobuf::io::CodedInputStream* input) {
#define DO_(EXPRESSION) if (!GOOGLE_PREDICT_TRUE(EXPRESSION)) goto failure
  ::google::protobuf::uint32 tag;
  // @@protoc_insertion_point(parse_start:grpc.reflection.v1alpha.ListServiceResponse)
  for (;;) {
    ::std::pair< ::google::protobuf::uint32, bool> p = input->ReadTagWithCutoff(127);
    tag = p.first;
    if (!p.second) goto handle_unusual;
    switch (::google::protobuf::internal::WireFormatLite::GetTagFieldNumber(tag)) {
      // repeated .grpc.reflection.v1alpha.ServiceResponse service = 1;
      case 1: {
        if (tag == 10) {
          DO_(input->IncrementRecursionDepth());
         parse_loop_service:
          DO_(::google::protobuf::internal::WireFormatLite::ReadMessageNoVirtualNoRecursionDepth(
                input, add_service()));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(10)) goto parse_loop_service;
        input->UnsafeDecrementRecursionDepth();
        if (input->ExpectAtEnd()) goto success;
        break;
      }

      default: {
      handle_unusual:
        if (tag == 0 ||
            ::google::protobuf::internal::WireFormatLite::GetTagWireType(tag) ==
            ::google::protobuf::internal::WireFormatLite::WIRETYPE_END_GROUP) {
          goto success;
        }
        DO_(::google::protobuf::internal::WireFormatLite::SkipField(input, tag));
        break;
      }
    }
  }
success:
  // @@protoc_insertion_point(parse_success:grpc.reflection.v1alpha.ListServiceResponse)
  return true;
failure:
  // @@protoc_insertion_point(parse_failure:grpc.reflection.v1alpha.ListServiceResponse)
  return false;
#undef DO_
}

void ListServiceResponse::SerializeWithCachedSizes(
    ::google::protobuf::io::CodedOutputStream* output) const {
  // @@protoc_insertion_point(serialize_start:grpc.reflection.v1alpha.ListServiceResponse)
  // repeated .grpc.reflection.v1alpha.ServiceResponse service = 1;
  for (unsigned int i = 0, n = this->service_size(); i < n; i++) {
    ::google::protobuf::internal::WireFormatLite::WriteMessageMaybeToArray(
      1, this->service(i), output);
  }

  // @@protoc_insertion_point(serialize_end:grpc.reflection.v1alpha.ListServiceResponse)
}

::google::protobuf::uint8* ListServiceResponse::SerializeWithCachedSizesToArray(
    ::google::protobuf::uint8* target) const {
  // @@protoc_insertion_point(serialize_to_array_start:grpc.reflection.v1alpha.ListServiceResponse)
  // repeated .grpc.reflection.v1alpha.ServiceResponse service = 1;
  for (unsigned int i = 0, n = this->service_size(); i < n; i++) {
    target = ::google::protobuf::internal::WireFormatLite::
      WriteMessageNoVirtualToArray(
        1, this->service(i), target);
  }

  // @@protoc_insertion_point(serialize_to_array_end:grpc.reflection.v1alpha.ListServiceResponse)
  return target;
}

int ListServiceResponse::ByteSize() const {
// @@protoc_insertion_point(message_byte_size_start:grpc.reflection.v1alpha.ListServiceResponse)
  int total_size = 0;

  // repeated .grpc.reflection.v1alpha.ServiceResponse service = 1;
  total_size += 1 * this->service_size();
  for (int i = 0; i < this->service_size(); i++) {
    total_size +=
      ::google::protobuf::internal::WireFormatLite::MessageSizeNoVirtual(
        this->service(i));
  }

  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = total_size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
  return total_size;
}

void ListServiceResponse::MergeFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_merge_from_start:grpc.reflection.v1alpha.ListServiceResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  const ListServiceResponse* source = 
      ::google::protobuf::internal::DynamicCastToGenerated<const ListServiceResponse>(
          &from);
  if (source == NULL) {
  // @@protoc_insertion_point(generalized_merge_from_cast_fail:grpc.reflection.v1alpha.ListServiceResponse)
    ::google::protobuf::internal::ReflectionOps::Merge(from, this);
  } else {
  // @@protoc_insertion_point(generalized_merge_from_cast_success:grpc.reflection.v1alpha.ListServiceResponse)
    MergeFrom(*source);
  }
}

void ListServiceResponse::MergeFrom(const ListServiceResponse& from) {
// @@protoc_insertion_point(class_specific_merge_from_start:grpc.reflection.v1alpha.ListServiceResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  service_.MergeFrom(from.service_);
}

void ListServiceResponse::CopyFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_copy_from_start:grpc.reflection.v1alpha.ListServiceResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

void ListServiceResponse::CopyFrom(const ListServiceResponse& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:grpc.reflection.v1alpha.ListServiceResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

bool ListServiceResponse::IsInitialized() const {

  return true;
}

void ListServiceResponse::Swap(ListServiceResponse* other) {
  if (other == this) return;
  InternalSwap(other);
}
void ListServiceResponse::InternalSwap(ListServiceResponse* other) {
  service_.UnsafeArenaSwap(&other->service_);
  _internal_metadata_.Swap(&other->_internal_metadata_);
  std::swap(_cached_size_, other->_cached_size_);
}

::google::protobuf::Metadata ListServiceResponse::GetMetadata() const {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::Metadata metadata;
  metadata.descriptor = ListServiceResponse_descriptor_;
  metadata.reflection = ListServiceResponse_reflection_;
  return metadata;
}

#if PROTOBUF_INLINE_NOT_IN_HEADERS
// ListServiceResponse

// repeated .grpc.reflection.v1alpha.ServiceResponse service = 1;
int ListServiceResponse::service_size() const {
  return service_.size();
}
void ListServiceResponse::clear_service() {
  service_.Clear();
}
const ::grpc::reflection::v1alpha::ServiceResponse& ListServiceResponse::service(int index) const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ListServiceResponse.service)
  return service_.Get(index);
}
::grpc::reflection::v1alpha::ServiceResponse* ListServiceResponse::mutable_service(int index) {
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ListServiceResponse.service)
  return service_.Mutable(index);
}
::grpc::reflection::v1alpha::ServiceResponse* ListServiceResponse::add_service() {
  // @@protoc_insertion_point(field_add:grpc.reflection.v1alpha.ListServiceResponse.service)
  return service_.Add();
}
::google::protobuf::RepeatedPtrField< ::grpc::reflection::v1alpha::ServiceResponse >*
ListServiceResponse::mutable_service() {
  // @@protoc_insertion_point(field_mutable_list:grpc.reflection.v1alpha.ListServiceResponse.service)
  return &service_;
}
const ::google::protobuf::RepeatedPtrField< ::grpc::reflection::v1alpha::ServiceResponse >&
ListServiceResponse::service() const {
  // @@protoc_insertion_point(field_list:grpc.reflection.v1alpha.ListServiceResponse.service)
  return service_;
}

#endif  // PROTOBUF_INLINE_NOT_IN_HEADERS

// ===================================================================

#if !defined(_MSC_VER) || _MSC_VER >= 1900
const int ServiceResponse::kNameFieldNumber;
#endif  // !defined(_MSC_VER) || _MSC_VER >= 1900

ServiceResponse::ServiceResponse()
  : ::google::protobuf::Message(), _internal_metadata_(NULL) {
  SharedCtor();
  // @@protoc_insertion_point(constructor:grpc.reflection.v1alpha.ServiceResponse)
}

void ServiceResponse::InitAsDefaultInstance() {
  _is_default_instance_ = true;
}

ServiceResponse::ServiceResponse(const ServiceResponse& from)
  : ::google::protobuf::Message(),
    _internal_metadata_(NULL) {
  SharedCtor();
  MergeFrom(from);
  // @@protoc_insertion_point(copy_constructor:grpc.reflection.v1alpha.ServiceResponse)
}

void ServiceResponse::SharedCtor() {
    _is_default_instance_ = false;
  ::google::protobuf::internal::GetEmptyString();
  _cached_size_ = 0;
  name_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}

ServiceResponse::~ServiceResponse() {
  // @@protoc_insertion_point(destructor:grpc.reflection.v1alpha.ServiceResponse)
  SharedDtor();
}

void ServiceResponse::SharedDtor() {
  name_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  if (this != default_instance_) {
  }
}

void ServiceResponse::SetCachedSize(int size) const {
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
}
const ::google::protobuf::Descriptor* ServiceResponse::descriptor() {
  protobuf_AssignDescriptorsOnce();
  return ServiceResponse_descriptor_;
}

const ServiceResponse& ServiceResponse::default_instance() {
  if (default_instance_ == NULL) protobuf_AddDesc_reflection_2eproto();
  return *default_instance_;
}

ServiceResponse* ServiceResponse::default_instance_ = NULL;

ServiceResponse* ServiceResponse::New(::google::protobuf::Arena* arena) const {
  ServiceResponse* n = new ServiceResponse;
  if (arena != NULL) {
    arena->Own(n);
  }
  return n;
}

void ServiceResponse::Clear() {
// @@protoc_insertion_point(message_clear_start:grpc.reflection.v1alpha.ServiceResponse)
  name_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}

bool ServiceResponse::MergePartialFromCodedStream(
    ::google::protobuf::io::CodedInputStream* input) {
#define DO_(EXPRESSION) if (!GOOGLE_PREDICT_TRUE(EXPRESSION)) goto failure
  ::google::protobuf::uint32 tag;
  // @@protoc_insertion_point(parse_start:grpc.reflection.v1alpha.ServiceResponse)
  for (;;) {
    ::std::pair< ::google::protobuf::uint32, bool> p = input->ReadTagWithCutoff(127);
    tag = p.first;
    if (!p.second) goto handle_unusual;
    switch (::google::protobuf::internal::WireFormatLite::GetTagFieldNumber(tag)) {
      // optional string name = 1;
      case 1: {
        if (tag == 10) {
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_name()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->name().data(), this->name().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ServiceResponse.name"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectAtEnd()) goto success;
        break;
      }

      default: {
      handle_unusual:
        if (tag == 0 ||
            ::google::protobuf::internal::WireFormatLite::GetTagWireType(tag) ==
            ::google::protobuf::internal::WireFormatLite::WIRETYPE_END_GROUP) {
          goto success;
        }
        DO_(::google::protobuf::internal::WireFormatLite::SkipField(input, tag));
        break;
      }
    }
  }
success:
  // @@protoc_insertion_point(parse_success:grpc.reflection.v1alpha.ServiceResponse)
  return true;
failure:
  // @@protoc_insertion_point(parse_failure:grpc.reflection.v1alpha.ServiceResponse)
  return false;
#undef DO_
}

void ServiceResponse::SerializeWithCachedSizes(
    ::google::protobuf::io::CodedOutputStream* output) const {
  // @@protoc_insertion_point(serialize_start:grpc.reflection.v1alpha.ServiceResponse)
  // optional string name = 1;
  if (this->name().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->name().data(), this->name().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServiceResponse.name");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      1, this->name(), output);
  }

  // @@protoc_insertion_point(serialize_end:grpc.reflection.v1alpha.ServiceResponse)
}

::google::protobuf::uint8* ServiceResponse::SerializeWithCachedSizesToArray(
    ::google::protobuf::uint8* target) const {
  // @@protoc_insertion_point(serialize_to_array_start:grpc.reflection.v1alpha.ServiceResponse)
  // optional string name = 1;
  if (this->name().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->name().data(), this->name().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ServiceResponse.name");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        1, this->name(), target);
  }

  // @@protoc_insertion_point(serialize_to_array_end:grpc.reflection.v1alpha.ServiceResponse)
  return target;
}

int ServiceResponse::ByteSize() const {
// @@protoc_insertion_point(message_byte_size_start:grpc.reflection.v1alpha.ServiceResponse)
  int total_size = 0;

  // optional string name = 1;
  if (this->name().size() > 0) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::StringSize(
        this->name());
  }

  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = total_size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
  return total_size;
}

void ServiceResponse::MergeFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_merge_from_start:grpc.reflection.v1alpha.ServiceResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  const ServiceResponse* source = 
      ::google::protobuf::internal::DynamicCastToGenerated<const ServiceResponse>(
          &from);
  if (source == NULL) {
  // @@protoc_insertion_point(generalized_merge_from_cast_fail:grpc.reflection.v1alpha.ServiceResponse)
    ::google::protobuf::internal::ReflectionOps::Merge(from, this);
  } else {
  // @@protoc_insertion_point(generalized_merge_from_cast_success:grpc.reflection.v1alpha.ServiceResponse)
    MergeFrom(*source);
  }
}

void ServiceResponse::MergeFrom(const ServiceResponse& from) {
// @@protoc_insertion_point(class_specific_merge_from_start:grpc.reflection.v1alpha.ServiceResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  if (from.name().size() > 0) {

    name_.AssignWithDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), from.name_);
  }
}

void ServiceResponse::CopyFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_copy_from_start:grpc.reflection.v1alpha.ServiceResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

void ServiceResponse::CopyFrom(const ServiceResponse& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:grpc.reflection.v1alpha.ServiceResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

bool ServiceResponse::IsInitialized() const {

  return true;
}

void ServiceResponse::Swap(ServiceResponse* other) {
  if (other == this) return;
  InternalSwap(other);
}
void ServiceResponse::InternalSwap(ServiceResponse* other) {
  name_.Swap(&other->name_);
  _internal_metadata_.Swap(&other->_internal_metadata_);
  std::swap(_cached_size_, other->_cached_size_);
}

::google::protobuf::Metadata ServiceResponse::GetMetadata() const {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::Metadata metadata;
  metadata.descriptor = ServiceResponse_descriptor_;
  metadata.reflection = ServiceResponse_reflection_;
  return metadata;
}

#if PROTOBUF_INLINE_NOT_IN_HEADERS
// ServiceResponse

// optional string name = 1;
void ServiceResponse::clear_name() {
  name_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 const ::std::string& ServiceResponse::name() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ServiceResponse.name)
  return name_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ServiceResponse::set_name(const ::std::string& value) {
  
  name_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ServiceResponse.name)
}
 void ServiceResponse::set_name(const char* value) {
  
  name_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ServiceResponse.name)
}
 void ServiceResponse::set_name(const char* value, size_t size) {
  
  name_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ServiceResponse.name)
}
 ::std::string* ServiceResponse::mutable_name() {
  
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ServiceResponse.name)
  return name_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ServiceResponse::release_name() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ServiceResponse.name)
  
  return name_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ServiceResponse::set_allocated_name(::std::string* name) {
  if (name != NULL) {
    
  } else {
    
  }
  name_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), name);
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ServiceResponse.name)
}

#endif  // PROTOBUF_INLINE_NOT_IN_HEADERS

// ===================================================================

#if !defined(_MSC_VER) || _MSC_VER >= 1900
const int ErrorResponse::kErrorCodeFieldNumber;
const int ErrorResponse::kErrorMessageFieldNumber;
#endif  // !defined(_MSC_VER) || _MSC_VER >= 1900

ErrorResponse::ErrorResponse()
  : ::google::protobuf::Message(), _internal_metadata_(NULL) {
  SharedCtor();
  // @@protoc_insertion_point(constructor:grpc.reflection.v1alpha.ErrorResponse)
}

void ErrorResponse::InitAsDefaultInstance() {
  _is_default_instance_ = true;
}

ErrorResponse::ErrorResponse(const ErrorResponse& from)
  : ::google::protobuf::Message(),
    _internal_metadata_(NULL) {
  SharedCtor();
  MergeFrom(from);
  // @@protoc_insertion_point(copy_constructor:grpc.reflection.v1alpha.ErrorResponse)
}

void ErrorResponse::SharedCtor() {
    _is_default_instance_ = false;
  ::google::protobuf::internal::GetEmptyString();
  _cached_size_ = 0;
  error_code_ = 0;
  error_message_.UnsafeSetDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}

ErrorResponse::~ErrorResponse() {
  // @@protoc_insertion_point(destructor:grpc.reflection.v1alpha.ErrorResponse)
  SharedDtor();
}

void ErrorResponse::SharedDtor() {
  error_message_.DestroyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
  if (this != default_instance_) {
  }
}

void ErrorResponse::SetCachedSize(int size) const {
  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
}
const ::google::protobuf::Descriptor* ErrorResponse::descriptor() {
  protobuf_AssignDescriptorsOnce();
  return ErrorResponse_descriptor_;
}

const ErrorResponse& ErrorResponse::default_instance() {
  if (default_instance_ == NULL) protobuf_AddDesc_reflection_2eproto();
  return *default_instance_;
}

ErrorResponse* ErrorResponse::default_instance_ = NULL;

ErrorResponse* ErrorResponse::New(::google::protobuf::Arena* arena) const {
  ErrorResponse* n = new ErrorResponse;
  if (arena != NULL) {
    arena->Own(n);
  }
  return n;
}

void ErrorResponse::Clear() {
// @@protoc_insertion_point(message_clear_start:grpc.reflection.v1alpha.ErrorResponse)
  error_code_ = 0;
  error_message_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}

bool ErrorResponse::MergePartialFromCodedStream(
    ::google::protobuf::io::CodedInputStream* input) {
#define DO_(EXPRESSION) if (!GOOGLE_PREDICT_TRUE(EXPRESSION)) goto failure
  ::google::protobuf::uint32 tag;
  // @@protoc_insertion_point(parse_start:grpc.reflection.v1alpha.ErrorResponse)
  for (;;) {
    ::std::pair< ::google::protobuf::uint32, bool> p = input->ReadTagWithCutoff(127);
    tag = p.first;
    if (!p.second) goto handle_unusual;
    switch (::google::protobuf::internal::WireFormatLite::GetTagFieldNumber(tag)) {
      // optional int32 error_code = 1;
      case 1: {
        if (tag == 8) {
          DO_((::google::protobuf::internal::WireFormatLite::ReadPrimitive<
                   ::google::protobuf::int32, ::google::protobuf::internal::WireFormatLite::TYPE_INT32>(
                 input, &error_code_)));

        } else {
          goto handle_unusual;
        }
        if (input->ExpectTag(18)) goto parse_error_message;
        break;
      }

      // optional string error_message = 2;
      case 2: {
        if (tag == 18) {
         parse_error_message:
          DO_(::google::protobuf::internal::WireFormatLite::ReadString(
                input, this->mutable_error_message()));
          DO_(::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
            this->error_message().data(), this->error_message().length(),
            ::google::protobuf::internal::WireFormatLite::PARSE,
            "grpc.reflection.v1alpha.ErrorResponse.error_message"));
        } else {
          goto handle_unusual;
        }
        if (input->ExpectAtEnd()) goto success;
        break;
      }

      default: {
      handle_unusual:
        if (tag == 0 ||
            ::google::protobuf::internal::WireFormatLite::GetTagWireType(tag) ==
            ::google::protobuf::internal::WireFormatLite::WIRETYPE_END_GROUP) {
          goto success;
        }
        DO_(::google::protobuf::internal::WireFormatLite::SkipField(input, tag));
        break;
      }
    }
  }
success:
  // @@protoc_insertion_point(parse_success:grpc.reflection.v1alpha.ErrorResponse)
  return true;
failure:
  // @@protoc_insertion_point(parse_failure:grpc.reflection.v1alpha.ErrorResponse)
  return false;
#undef DO_
}

void ErrorResponse::SerializeWithCachedSizes(
    ::google::protobuf::io::CodedOutputStream* output) const {
  // @@protoc_insertion_point(serialize_start:grpc.reflection.v1alpha.ErrorResponse)
  // optional int32 error_code = 1;
  if (this->error_code() != 0) {
    ::google::protobuf::internal::WireFormatLite::WriteInt32(1, this->error_code(), output);
  }

  // optional string error_message = 2;
  if (this->error_message().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->error_message().data(), this->error_message().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ErrorResponse.error_message");
    ::google::protobuf::internal::WireFormatLite::WriteStringMaybeAliased(
      2, this->error_message(), output);
  }

  // @@protoc_insertion_point(serialize_end:grpc.reflection.v1alpha.ErrorResponse)
}

::google::protobuf::uint8* ErrorResponse::SerializeWithCachedSizesToArray(
    ::google::protobuf::uint8* target) const {
  // @@protoc_insertion_point(serialize_to_array_start:grpc.reflection.v1alpha.ErrorResponse)
  // optional int32 error_code = 1;
  if (this->error_code() != 0) {
    target = ::google::protobuf::internal::WireFormatLite::WriteInt32ToArray(1, this->error_code(), target);
  }

  // optional string error_message = 2;
  if (this->error_message().size() > 0) {
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
      this->error_message().data(), this->error_message().length(),
      ::google::protobuf::internal::WireFormatLite::SERIALIZE,
      "grpc.reflection.v1alpha.ErrorResponse.error_message");
    target =
      ::google::protobuf::internal::WireFormatLite::WriteStringToArray(
        2, this->error_message(), target);
  }

  // @@protoc_insertion_point(serialize_to_array_end:grpc.reflection.v1alpha.ErrorResponse)
  return target;
}

int ErrorResponse::ByteSize() const {
// @@protoc_insertion_point(message_byte_size_start:grpc.reflection.v1alpha.ErrorResponse)
  int total_size = 0;

  // optional int32 error_code = 1;
  if (this->error_code() != 0) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::Int32Size(
        this->error_code());
  }

  // optional string error_message = 2;
  if (this->error_message().size() > 0) {
    total_size += 1 +
      ::google::protobuf::internal::WireFormatLite::StringSize(
        this->error_message());
  }

  GOOGLE_SAFE_CONCURRENT_WRITES_BEGIN();
  _cached_size_ = total_size;
  GOOGLE_SAFE_CONCURRENT_WRITES_END();
  return total_size;
}

void ErrorResponse::MergeFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_merge_from_start:grpc.reflection.v1alpha.ErrorResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  const ErrorResponse* source = 
      ::google::protobuf::internal::DynamicCastToGenerated<const ErrorResponse>(
          &from);
  if (source == NULL) {
  // @@protoc_insertion_point(generalized_merge_from_cast_fail:grpc.reflection.v1alpha.ErrorResponse)
    ::google::protobuf::internal::ReflectionOps::Merge(from, this);
  } else {
  // @@protoc_insertion_point(generalized_merge_from_cast_success:grpc.reflection.v1alpha.ErrorResponse)
    MergeFrom(*source);
  }
}

void ErrorResponse::MergeFrom(const ErrorResponse& from) {
// @@protoc_insertion_point(class_specific_merge_from_start:grpc.reflection.v1alpha.ErrorResponse)
  if (GOOGLE_PREDICT_FALSE(&from == this)) MergeFromFail(__LINE__);
  if (from.error_code() != 0) {
    set_error_code(from.error_code());
  }
  if (from.error_message().size() > 0) {

    error_message_.AssignWithDefault(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), from.error_message_);
  }
}

void ErrorResponse::CopyFrom(const ::google::protobuf::Message& from) {
// @@protoc_insertion_point(generalized_copy_from_start:grpc.reflection.v1alpha.ErrorResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

void ErrorResponse::CopyFrom(const ErrorResponse& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:grpc.reflection.v1alpha.ErrorResponse)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

bool ErrorResponse::IsInitialized() const {

  return true;
}

void ErrorResponse::Swap(ErrorResponse* other) {
  if (other == this) return;
  InternalSwap(other);
}
void ErrorResponse::InternalSwap(ErrorResponse* other) {
  std::swap(error_code_, other->error_code_);
  error_message_.Swap(&other->error_message_);
  _internal_metadata_.Swap(&other->_internal_metadata_);
  std::swap(_cached_size_, other->_cached_size_);
}

::google::protobuf::Metadata ErrorResponse::GetMetadata() const {
  protobuf_AssignDescriptorsOnce();
  ::google::protobuf::Metadata metadata;
  metadata.descriptor = ErrorResponse_descriptor_;
  metadata.reflection = ErrorResponse_reflection_;
  return metadata;
}

#if PROTOBUF_INLINE_NOT_IN_HEADERS
// ErrorResponse

// optional int32 error_code = 1;
void ErrorResponse::clear_error_code() {
  error_code_ = 0;
}
 ::google::protobuf::int32 ErrorResponse::error_code() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ErrorResponse.error_code)
  return error_code_;
}
 void ErrorResponse::set_error_code(::google::protobuf::int32 value) {
  
  error_code_ = value;
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ErrorResponse.error_code)
}

// optional string error_message = 2;
void ErrorResponse::clear_error_message() {
  error_message_.ClearToEmptyNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 const ::std::string& ErrorResponse::error_message() const {
  // @@protoc_insertion_point(field_get:grpc.reflection.v1alpha.ErrorResponse.error_message)
  return error_message_.GetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ErrorResponse::set_error_message(const ::std::string& value) {
  
  error_message_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), value);
  // @@protoc_insertion_point(field_set:grpc.reflection.v1alpha.ErrorResponse.error_message)
}
 void ErrorResponse::set_error_message(const char* value) {
  
  error_message_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), ::std::string(value));
  // @@protoc_insertion_point(field_set_char:grpc.reflection.v1alpha.ErrorResponse.error_message)
}
 void ErrorResponse::set_error_message(const char* value, size_t size) {
  
  error_message_.SetNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(),
      ::std::string(reinterpret_cast<const char*>(value), size));
  // @@protoc_insertion_point(field_set_pointer:grpc.reflection.v1alpha.ErrorResponse.error_message)
}
 ::std::string* ErrorResponse::mutable_error_message() {
  
  // @@protoc_insertion_point(field_mutable:grpc.reflection.v1alpha.ErrorResponse.error_message)
  return error_message_.MutableNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 ::std::string* ErrorResponse::release_error_message() {
  // @@protoc_insertion_point(field_release:grpc.reflection.v1alpha.ErrorResponse.error_message)
  
  return error_message_.ReleaseNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited());
}
 void ErrorResponse::set_allocated_error_message(::std::string* error_message) {
  if (error_message != NULL) {
    
  } else {
    
  }
  error_message_.SetAllocatedNoArena(&::google::protobuf::internal::GetEmptyStringAlreadyInited(), error_message);
  // @@protoc_insertion_point(field_set_allocated:grpc.reflection.v1alpha.ErrorResponse.error_message)
}

#endif  // PROTOBUF_INLINE_NOT_IN_HEADERS

// @@protoc_insertion_point(namespace_scope)

}  // namespace v1alpha
}  // namespace reflection
}  // namespace grpc

// @@protoc_insertion_point(global_scope)
