## Filing Bugs

If you're experiencing behavior that appears to be a bug in RStudio, you're welcome to [file an issue](https://github.com/rstudio/rstudio/issues/new). Before you do, please go through this pre-flight checklist:

1. Is the source of the error or problem the RStudio IDE itself? Many errors you see inside RStudio come from R or R packages. If you're having trouble with R, read [Getting Help with R](https://www.r-project.org/help.html) for pointers.

2. Is your issue a bug rather than a question? If you're having general trouble with RStudio or have questions for the RStudio community, the [RStudio Community Forum](https://community.rstudio.com/c/rstudio-ide) is an excellent resource.

3. Are you the first person to report this issue? [Search the issue list](https://github.com/rstudio/rstudio/issues) to find out. If you aren't, the most helpful thing you can do is vote for the existing issue (add a reaction to it), and optionally add a comment describing your own experience.

When you're ready to file an issue, please do the following:

1. If at all possible, include a [minimal working example](https://en.wikipedia.org/wiki/Minimal_Working_Example) which will reproduce the bug. If you're unable to reproduce consistently, then please do your best to provide us a set of actions, or other steps that seem to be correlated with the issue you are seeing. 

2. Indicate your operating system, exact version of RStudio (from *Help | About RStudio*) and the output of `sessionInfo()` in R.

3. If appropriate, include screenshots, any relevant log files, and a [diagnostic report](https://support.rstudio.com/hc/en-us/articles/200321257-Running-a-Diagnostics-Report).

Label your issue with **bug**. We appreciate you taking the time to file a report; detailed bug reports from the community help us tremendously!

## Enhancements

You're also welcome to submit ideas for enhancements to RStudio. When doing so, please [search the issue list](https://github.com/rstudio/rstudio/issues) to see if the enhancement has already been filed. If it has, vote for it (add a reaction to it) and optionally add a comment with your perspective on the idea. 

See our [guide to writing feature requests](https://github.com/rstudio/rstudio/wiki/Writing-Good-Feature-Requests) for more on how to write a great feature request.

## RStudio Pro

This repo contains the code for the open source version of RStudio and RStudio Server, and its issues page is for issues pertaining specifically to the open source version of the software. To report issues or request new features for the professional version of RStudio, please get in touch with the RStudio support team at <support@rstudio.com>.

## Contributing Code

We welcome contributions to RStudio. To submit a contribution:

1. [Fork](https://github.com/rstudio/rstudio/fork) the repository and make your changes.

2. Ensure that you have signed the [individual](https://rstudioblog.files.wordpress.com/2017/05/rstudio_individual_contributor_agreement.pdf) or [corporate](https://rstudioblog.files.wordpress.com/2017/05/rstudio_corporate_contributor_agreement.pdf) contributor agreement as appropriate. You can send the signed copy to jj@rstudio.com.

3. Submit a [pull request](https://help.github.com/articles/using-pull-requests).

We'll try to be as responsive as possible in reviewing and accepting pull requests. Appreciate your contributions very much!

