/*
 * JobOutputEvent.java
 *
 * Copyright (C) 2009-18 by RStudio, Inc.
 *
 * Unless you have received this program directly from RStudio pursuant
 * to the terms of a commercial license agreement with RStudio, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */
package org.rstudio.studio.client.workbench.views.jobs.events;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;

public class JobOutputEvent extends GwtEvent<JobOutputEvent.Handler>
{
   public static class Data extends JavaScriptObject
   {
      protected Data() 
      {
      }
      
      public final native String id() /*-{
         return this[0];
      }-*/;

      public final native int type() /*-{
         return this[1];
      }-*/;

      public final native String output() /*-{
         return this[2];
      }-*/;
   }

   public interface Handler extends EventHandler
   {
      void onJobOutput(JobOutputEvent event);
   }
   
   public JobOutputEvent(Data data)
   {
      data_ = data;
   }

   public Data getData()
   {
      return data_;
   }

   @Override
   public Type<Handler> getAssociatedType()
   {
      return TYPE;
   }

   @Override
   protected void dispatch(Handler handler)
   {
      handler.onJobOutput(this);
   }

   private final Data data_;

   public static final Type<Handler> TYPE = new Type<Handler>();
}