# System.Collections

``` diff
+namespace System.Collections {
+    public class ArrayList : ICollection, IEnumerable, IList {
+        public ArrayList();
+        public ArrayList(ICollection c);
+        public ArrayList(int capacity);
+        public virtual int Capacity { get; set; }
+        public virtual int Count { get; }
+        public virtual bool IsFixedSize { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual object SyncRoot { get; }
+        public virtual object this[int index] { get; set; }
+        public static ArrayList Adapter(IList list);
+        public virtual int Add(object value);
+        public virtual void AddRange(ICollection c);
+        public virtual int BinarySearch(int index, int count, object value, IComparer comparer);
+        public virtual int BinarySearch(object value);
+        public virtual int BinarySearch(object value, IComparer comparer);
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object item);
+        public virtual void CopyTo(Array array);
+        public virtual void CopyTo(Array array, int arrayIndex);
+        public virtual void CopyTo(int index, Array array, int arrayIndex, int count);
+        public static ArrayList FixedSize(ArrayList list);
+        public static IList FixedSize(IList list);
+        public virtual IEnumerator GetEnumerator();
+        public virtual IEnumerator GetEnumerator(int index, int count);
+        public virtual ArrayList GetRange(int index, int count);
+        public virtual int IndexOf(object value);
+        public virtual int IndexOf(object value, int startIndex);
+        public virtual int IndexOf(object value, int startIndex, int count);
+        public virtual void Insert(int index, object value);
+        public virtual void InsertRange(int index, ICollection c);
+        public virtual int LastIndexOf(object value);
+        public virtual int LastIndexOf(object value, int startIndex);
+        public virtual int LastIndexOf(object value, int startIndex, int count);
+        public static ArrayList ReadOnly(ArrayList list);
+        public static IList ReadOnly(IList list);
+        public virtual void Remove(object obj);
+        public virtual void RemoveAt(int index);
+        public virtual void RemoveRange(int index, int count);
+        public static ArrayList Repeat(object value, int count);
+        public virtual void Reverse();
+        public virtual void Reverse(int index, int count);
+        public virtual void SetRange(int index, ICollection c);
+        public virtual void Sort();
+        public virtual void Sort(IComparer comparer);
+        public virtual void Sort(int index, int count, IComparer comparer);
+        public static ArrayList Synchronized(ArrayList list);
+        public static IList Synchronized(IList list);
+        public virtual object[] ToArray();
+        public virtual Array ToArray(Type type);
+        public virtual void TrimToSize();
+    }
+    public sealed class BitArray : ICollection, IEnumerable {
+        public BitArray(bool[] values);
+        public BitArray(byte[] bytes);
+        public BitArray(BitArray bits);
+        public BitArray(int length);
+        public BitArray(int length, bool defaultValue);
+        public BitArray(int[] values);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public int Length { get; set; }
+        public object SyncRoot { get; }
+        int System.Collections.ICollection.Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public bool this[int index] { get; set; }
+        public BitArray And(BitArray value);
+        public object Clone();
+        public void CopyTo(Array array, int index);
+        public bool Get(int index);
+        public IEnumerator GetEnumerator();
+        public BitArray Not();
+        public BitArray Or(BitArray value);
+        public void Set(int index, bool value);
+        public void SetAll(bool value);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        public BitArray Xor(BitArray value);
+    }
+    public class CaseInsensitiveComparer : IComparer {
+        public CaseInsensitiveComparer();
+        public CaseInsensitiveComparer(CultureInfo culture);
+        public static CaseInsensitiveComparer Default { get; }
+        public static CaseInsensitiveComparer DefaultInvariant { get; }
+        public int Compare(object a, object b);
+    }
+    public abstract class CollectionBase : ICollection, IEnumerable, IList {
+        protected CollectionBase();
+        protected CollectionBase(int capacity);
+        public int Capacity { get; set; }
+        public int Count { get; }
+        protected ArrayList InnerList { get; }
+        protected IList List { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public void Clear();
+        public IEnumerator GetEnumerator();
+        protected virtual void OnClear();
+        protected virtual void OnClearComplete();
+        protected virtual void OnInsert(int index, object value);
+        protected virtual void OnInsertComplete(int index, object value);
+        protected virtual void OnRemove(int index, object value);
+        protected virtual void OnRemoveComplete(int index, object value);
+        protected virtual void OnSet(int index, object oldValue, object newValue);
+        protected virtual void OnSetComplete(int index, object oldValue, object newValue);
+        protected virtual void OnValidate(object value);
+        public void RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        int System.Collections.IList.Add(object value);
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+    }
+    public sealed class Comparer : IComparer {
+        public static readonly Comparer Default;
+        public static readonly Comparer DefaultInvariant;
+        public Comparer(CultureInfo culture);
+        public int Compare(object a, object b);
+    }
+    public abstract class DictionaryBase : ICollection, IDictionary, IEnumerable {
+        protected DictionaryBase();
+        public int Count { get; }
+        protected IDictionary Dictionary { get; }
+        protected Hashtable InnerHashtable { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IDictionary.IsFixedSize { get; }
+        bool System.Collections.IDictionary.IsReadOnly { get; }
+        object System.Collections.IDictionary.this[object key] { get; set; }
+        ICollection System.Collections.IDictionary.Keys { get; }
+        ICollection System.Collections.IDictionary.Values { get; }
+        public void Clear();
+        public void CopyTo(Array array, int index);
+        public IDictionaryEnumerator GetEnumerator();
+        protected virtual void OnClear();
+        protected virtual void OnClearComplete();
+        protected virtual object OnGet(object key, object currentValue);
+        protected virtual void OnInsert(object key, object value);
+        protected virtual void OnInsertComplete(object key, object value);
+        protected virtual void OnRemove(object key, object value);
+        protected virtual void OnRemoveComplete(object key, object value);
+        protected virtual void OnSet(object key, object oldValue, object newValue);
+        protected virtual void OnSetComplete(object key, object oldValue, object newValue);
+        protected virtual void OnValidate(object key, object value);
+        void System.Collections.IDictionary.Add(object key, object value);
+        bool System.Collections.IDictionary.Contains(object key);
+        void System.Collections.IDictionary.Remove(object key);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DictionaryEntry {
+        public DictionaryEntry(object key, object value);
+        public object Key { get; set; }
+        public object Value { get; set; }
+    }
+    public class Hashtable : ICollection, IDictionary, IEnumerable {
+        public Hashtable();
+        public Hashtable(IDictionary d);
+        public Hashtable(IDictionary d, IEqualityComparer equalityComparer);
+        public Hashtable(IDictionary d, float loadFactor);
+        public Hashtable(IDictionary d, float loadFactor, IEqualityComparer equalityComparer);
+        public Hashtable(IEqualityComparer equalityComparer);
+        public Hashtable(int capacity);
+        public Hashtable(int capacity, IEqualityComparer equalityComparer);
+        public Hashtable(int capacity, float loadFactor);
+        public Hashtable(int capacity, float loadFactor, IEqualityComparer equalityComparer);
+        public virtual int Count { get; }
+        protected IEqualityComparer EqualityComparer { get; }
+        public virtual bool IsFixedSize { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual ICollection Keys { get; }
+        public virtual object SyncRoot { get; }
+        public virtual object this[object key] { get; set; }
+        public virtual ICollection Values { get; }
+        public virtual void Add(object key, object value);
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object key);
+        public virtual bool ContainsKey(object key);
+        public virtual bool ContainsValue(object value);
+        public virtual void CopyTo(Array array, int arrayIndex);
+        public virtual IDictionaryEnumerator GetEnumerator();
+        protected virtual int GetHash(object key);
+        protected virtual bool KeyEquals(object item, object key);
+        public virtual void Remove(object key);
+        public static Hashtable Synchronized(Hashtable table);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public interface ICollection : IEnumerable {
+        int Count { get; }
+        bool IsSynchronized { get; }
+        object SyncRoot { get; }
+        void CopyTo(Array array, int index);
+    }
+    public interface IComparer {
+        int Compare(object x, object y);
+    }
+    public interface IDictionary : ICollection, IEnumerable {
+        bool IsFixedSize { get; }
+        bool IsReadOnly { get; }
+        ICollection Keys { get; }
+        object this[object key] { get; set; }
+        ICollection Values { get; }
+        void Add(object key, object value);
+        void Clear();
+        bool Contains(object key);
+        new IDictionaryEnumerator GetEnumerator();
+        void Remove(object key);
+    }
+    public interface IDictionaryEnumerator : IEnumerator {
+        DictionaryEntry Entry { get; }
+        object Key { get; }
+        object Value { get; }
+    }
+    public interface IEnumerable {
+        IEnumerator GetEnumerator();
+    }
+    public interface IEnumerator {
+        object Current { get; }
+        bool MoveNext();
+        void Reset();
+    }
+    public interface IEqualityComparer {
+        bool Equals(object x, object y);
+        int GetHashCode(object obj);
+    }
+    public interface IList : ICollection, IEnumerable {
+        bool IsFixedSize { get; }
+        bool IsReadOnly { get; }
+        object this[int index] { get; set; }
+        int Add(object value);
+        void Clear();
+        bool Contains(object value);
+        int IndexOf(object value);
+        void Insert(int index, object value);
+        void Remove(object value);
+        void RemoveAt(int index);
+    }
+    public interface IStructuralComparable {
+        int CompareTo(object other, IComparer comparer);
+    }
+    public interface IStructuralEquatable {
+        bool Equals(object other, IEqualityComparer comparer);
+        int GetHashCode(IEqualityComparer comparer);
+    }
+    public class Queue : ICollection, IEnumerable {
+        public Queue();
+        public Queue(ICollection col);
+        public Queue(int capacity);
+        public Queue(int capacity, float growFactor);
+        public virtual int Count { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual object SyncRoot { get; }
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object obj);
+        public virtual void CopyTo(Array array, int index);
+        public virtual object Dequeue();
+        public virtual void Enqueue(object obj);
+        public virtual IEnumerator GetEnumerator();
+        public virtual object Peek();
+        public static Queue Synchronized(Queue queue);
+        public virtual object[] ToArray();
+        public virtual void TrimToSize();
+    }
+    public abstract class ReadOnlyCollectionBase : ICollection, IEnumerable {
+        protected ReadOnlyCollectionBase();
+        public virtual int Count { get; }
+        protected ArrayList InnerList { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public virtual IEnumerator GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+    }
+    public class SortedList : ICollection, IDictionary, IEnumerable {
+        public SortedList();
+        public SortedList(IComparer comparer);
+        public SortedList(IComparer comparer, int capacity);
+        public SortedList(IDictionary d);
+        public SortedList(IDictionary d, IComparer comparer);
+        public SortedList(int initialCapacity);
+        public virtual int Capacity { get; set; }
+        public virtual int Count { get; }
+        public virtual bool IsFixedSize { get; }
+        public virtual bool IsReadOnly { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual ICollection Keys { get; }
+        public virtual object SyncRoot { get; }
+        public virtual object this[object key] { get; set; }
+        public virtual ICollection Values { get; }
+        public virtual void Add(object key, object value);
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object key);
+        public virtual bool ContainsKey(object key);
+        public virtual bool ContainsValue(object value);
+        public virtual void CopyTo(Array array, int arrayIndex);
+        public virtual object GetByIndex(int index);
+        public virtual IDictionaryEnumerator GetEnumerator();
+        public virtual object GetKey(int index);
+        public virtual IList GetKeyList();
+        public virtual IList GetValueList();
+        public virtual int IndexOfKey(object key);
+        public virtual int IndexOfValue(object value);
+        public virtual void Remove(object key);
+        public virtual void RemoveAt(int index);
+        public virtual void SetByIndex(int index, object value);
+        public static SortedList Synchronized(SortedList list);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public virtual void TrimToSize();
+    }
+    public class Stack : ICollection, IEnumerable {
+        public Stack();
+        public Stack(ICollection col);
+        public Stack(int initialCapacity);
+        public virtual int Count { get; }
+        public virtual bool IsSynchronized { get; }
+        public virtual object SyncRoot { get; }
+        public virtual void Clear();
+        public virtual object Clone();
+        public virtual bool Contains(object obj);
+        public virtual void CopyTo(Array array, int index);
+        public virtual IEnumerator GetEnumerator();
+        public virtual object Peek();
+        public virtual object Pop();
+        public virtual void Push(object obj);
+        public static Stack Synchronized(Stack stack);
+        public virtual object[] ToArray();
+    }
+    public static class StructuralComparisons {
+        public static IComparer StructuralComparer { get; }
+        public static IEqualityComparer StructuralEqualityComparer { get; }
+    }
+}
```

