# System.Net.Http

``` diff
+namespace System.Net.Http {
+    public class ByteArrayContent : HttpContent {
+        public ByteArrayContent(byte[] content);
+        public ByteArrayContent(byte[] content, int offset, int count);
+        protected override Task<Stream> CreateContentReadStreamAsync();
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context);
+        protected internal override bool TryComputeLength(out long length);
+    }
+    public enum ClientCertificateOption {
+        Automatic = 1,
+        Manual = 0,
+    }
+    public enum CookieUsePolicy {
+        IgnoreCookies = 0,
+        UseInternalCookieStoreOnly = 1,
+        UseSpecifiedCookieContainer = 2,
+    }
+    public abstract class DelegatingHandler : HttpMessageHandler {
+        protected DelegatingHandler();
+        protected DelegatingHandler(HttpMessageHandler innerHandler);
+        public HttpMessageHandler InnerHandler { get; set; }
+        protected override void Dispose(bool disposing);
+        protected internal override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
+    public class FormUrlEncodedContent : ByteArrayContent {
+        public FormUrlEncodedContent(IEnumerable<KeyValuePair<string, string>> nameValueCollection);
+    }
+    public class HttpClient : HttpMessageInvoker {
+        public HttpClient();
+        public HttpClient(HttpMessageHandler handler);
+        public HttpClient(HttpMessageHandler handler, bool disposeHandler);
+        public Uri BaseAddress { get; set; }
+        public HttpRequestHeaders DefaultRequestHeaders { get; }
+        public long MaxResponseContentBufferSize { get; set; }
+        public TimeSpan Timeout { get; set; }
+        public void CancelPendingRequests();
+        public Task<HttpResponseMessage> DeleteAsync(string requestUri);
+        public Task<HttpResponseMessage> DeleteAsync(string requestUri, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> DeleteAsync(Uri requestUri);
+        public Task<HttpResponseMessage> DeleteAsync(Uri requestUri, CancellationToken cancellationToken);
+        protected override void Dispose(bool disposing);
+        public Task<HttpResponseMessage> GetAsync(string requestUri);
+        public Task<HttpResponseMessage> GetAsync(string requestUri, HttpCompletionOption completionOption);
+        public Task<HttpResponseMessage> GetAsync(string requestUri, HttpCompletionOption completionOption, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> GetAsync(string requestUri, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> GetAsync(Uri requestUri);
+        public Task<HttpResponseMessage> GetAsync(Uri requestUri, HttpCompletionOption completionOption);
+        public Task<HttpResponseMessage> GetAsync(Uri requestUri, HttpCompletionOption completionOption, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> GetAsync(Uri requestUri, CancellationToken cancellationToken);
+        public Task<byte[]> GetByteArrayAsync(string requestUri);
+        public Task<byte[]> GetByteArrayAsync(Uri requestUri);
+        public Task<Stream> GetStreamAsync(string requestUri);
+        public Task<Stream> GetStreamAsync(Uri requestUri);
+        public Task<string> GetStringAsync(string requestUri);
+        public Task<string> GetStringAsync(Uri requestUri);
+        public Task<HttpResponseMessage> PostAsync(string requestUri, HttpContent content);
+        public Task<HttpResponseMessage> PostAsync(string requestUri, HttpContent content, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> PostAsync(Uri requestUri, HttpContent content);
+        public Task<HttpResponseMessage> PostAsync(Uri requestUri, HttpContent content, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> PutAsync(string requestUri, HttpContent content);
+        public Task<HttpResponseMessage> PutAsync(string requestUri, HttpContent content, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> PutAsync(Uri requestUri, HttpContent content);
+        public Task<HttpResponseMessage> PutAsync(Uri requestUri, HttpContent content, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> SendAsync(HttpRequestMessage request);
+        public Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, HttpCompletionOption completionOption);
+        public Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, HttpCompletionOption completionOption, CancellationToken cancellationToken);
+        public override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
+    public class HttpClientHandler : HttpMessageHandler {
+        public HttpClientHandler();
+        public bool AllowAutoRedirect { get; set; }
+        public DecompressionMethods AutomaticDecompression { get; set; }
+        public bool CheckCertificateRevocationList { get; set; }
+        public ClientCertificateOption ClientCertificateOptions { get; set; }
+        public X509CertificateCollection ClientCertificates { get; }
+        public CookieContainer CookieContainer { get; set; }
+        public ICredentials Credentials { get; set; }
+        public ICredentials DefaultProxyCredentials { get; set; }
+        public int MaxAutomaticRedirections { get; set; }
+        public int MaxConnectionsPerServer { get; set; }
+        public long MaxRequestContentBufferSize { get; set; }
+        public int MaxResponseHeadersLength { get; set; }
+        public bool PreAuthenticate { get; set; }
+        public IDictionary<string, object> Properties { get; }
+        public IWebProxy Proxy { get; set; }
+        public Func<HttpRequestMessage, X509Certificate2, X509Chain, SslPolicyErrors, bool> ServerCertificateCustomValidationCallback { get; set; }
+        public SslProtocols SslProtocols { get; set; }
+        public virtual bool SupportsAutomaticDecompression { get; }
+        public virtual bool SupportsProxy { get; }
+        public virtual bool SupportsRedirectConfiguration { get; }
+        public bool UseCookies { get; set; }
+        public bool UseDefaultCredentials { get; set; }
+        public bool UseProxy { get; set; }
+        protected override void Dispose(bool disposing);
+        protected internal override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
+    public enum HttpCompletionOption {
+        ResponseContentRead = 0,
+        ResponseHeadersRead = 1,
+    }
+    public abstract class HttpContent : IDisposable {
+        protected HttpContent();
+        public HttpContentHeaders Headers { get; }
+        public Task CopyToAsync(Stream stream);
+        public Task CopyToAsync(Stream stream, TransportContext context);
+        protected virtual Task<Stream> CreateContentReadStreamAsync();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public Task LoadIntoBufferAsync();
+        public Task LoadIntoBufferAsync(long maxBufferSize);
+        public Task<byte[]> ReadAsByteArrayAsync();
+        public Task<Stream> ReadAsStreamAsync();
+        public Task<string> ReadAsStringAsync();
+        protected abstract Task SerializeToStreamAsync(Stream stream, TransportContext context);
+        protected internal abstract bool TryComputeLength(out long length);
+    }
+    public abstract class HttpMessageHandler : IDisposable {
+        protected HttpMessageHandler();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected internal abstract Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
+    public class HttpMessageInvoker : IDisposable {
+        public HttpMessageInvoker(HttpMessageHandler handler);
+        public HttpMessageInvoker(HttpMessageHandler handler, bool disposeHandler);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public virtual Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
+    public class HttpMethod : IEquatable<HttpMethod> {
+        public HttpMethod(string method);
+        public static HttpMethod Delete { get; }
+        public static HttpMethod Get { get; }
+        public static HttpMethod Head { get; }
+        public string Method { get; }
+        public static HttpMethod Options { get; }
+        public static HttpMethod Post { get; }
+        public static HttpMethod Put { get; }
+        public static HttpMethod Trace { get; }
+        public bool Equals(HttpMethod other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(HttpMethod left, HttpMethod right);
+        public static bool operator !=(HttpMethod left, HttpMethod right);
+        public override string ToString();
+    }
+    public class HttpRequestException : Exception {
+        public HttpRequestException();
+        public HttpRequestException(string message);
+        public HttpRequestException(string message, Exception inner);
+    }
+    public class HttpRequestMessage : IDisposable {
+        public HttpRequestMessage();
+        public HttpRequestMessage(HttpMethod method, string requestUri);
+        public HttpRequestMessage(HttpMethod method, Uri requestUri);
+        public HttpContent Content { get; set; }
+        public HttpRequestHeaders Headers { get; }
+        public HttpMethod Method { get; set; }
+        public IDictionary<string, object> Properties { get; }
+        public Uri RequestUri { get; set; }
+        public Version Version { get; set; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public override string ToString();
+    }
+    public class HttpResponseMessage : IDisposable {
+        public HttpResponseMessage();
+        public HttpResponseMessage(HttpStatusCode statusCode);
+        public HttpContent Content { get; set; }
+        public HttpResponseHeaders Headers { get; }
+        public bool IsSuccessStatusCode { get; }
+        public string ReasonPhrase { get; set; }
+        public HttpRequestMessage RequestMessage { get; set; }
+        public HttpStatusCode StatusCode { get; set; }
+        public Version Version { get; set; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public HttpResponseMessage EnsureSuccessStatusCode();
+        public override string ToString();
+    }
+    public abstract class MessageProcessingHandler : DelegatingHandler {
+        protected MessageProcessingHandler();
+        protected MessageProcessingHandler(HttpMessageHandler innerHandler);
+        protected abstract HttpRequestMessage ProcessRequest(HttpRequestMessage request, CancellationToken cancellationToken);
+        protected abstract HttpResponseMessage ProcessResponse(HttpResponseMessage response, CancellationToken cancellationToken);
+        protected internal sealed override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
+    public class MultipartContent : HttpContent, IEnumerable, IEnumerable<HttpContent> {
+        public MultipartContent();
+        public MultipartContent(string subtype);
+        public MultipartContent(string subtype, string boundary);
+        public virtual void Add(HttpContent content);
+        protected override void Dispose(bool disposing);
+        public IEnumerator<HttpContent> GetEnumerator();
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        protected internal override bool TryComputeLength(out long length);
+    }
+    public class MultipartFormDataContent : MultipartContent {
+        public MultipartFormDataContent();
+        public MultipartFormDataContent(string boundary);
+        public override void Add(HttpContent content);
+        public void Add(HttpContent content, string name);
+        public void Add(HttpContent content, string name, string fileName);
+    }
+    public class StreamContent : HttpContent {
+        public StreamContent(Stream content);
+        public StreamContent(Stream content, int bufferSize);
+        protected override Task<Stream> CreateContentReadStreamAsync();
+        protected override void Dispose(bool disposing);
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context);
+        protected internal override bool TryComputeLength(out long length);
+    }
+    public class StringContent : ByteArrayContent {
+        public StringContent(string content);
+        public StringContent(string content, Encoding encoding);
+        public StringContent(string content, Encoding encoding, string mediaType);
+    }
+    public enum WindowsProxyUsePolicy {
+        DoNotUseProxy = 0,
+        UseCustomProxy = 3,
+        UseWinHttpProxy = 1,
+        UseWinInetProxy = 2,
+    }
+    public class WinHttpHandler : HttpMessageHandler {
+        public WinHttpHandler();
+        public DecompressionMethods AutomaticDecompression { get; set; }
+        public bool AutomaticRedirection { get; set; }
+        public bool CheckCertificateRevocationList { get; set; }
+        public ClientCertificateOption ClientCertificateOption { get; set; }
+        public X509Certificate2Collection ClientCertificates { get; }
+        public CookieContainer CookieContainer { get; set; }
+        public CookieUsePolicy CookieUsePolicy { get; set; }
+        public ICredentials DefaultProxyCredentials { get; set; }
+        public int MaxAutomaticRedirections { get; set; }
+        public int MaxConnectionsPerServer { get; set; }
+        public int MaxResponseDrainSize { get; set; }
+        public int MaxResponseHeadersLength { get; set; }
+        public bool PreAuthenticate { get; set; }
+        public IDictionary<string, object> Properties { get; }
+        public IWebProxy Proxy { get; set; }
+        public TimeSpan ReceiveDataTimeout { get; set; }
+        public TimeSpan ReceiveHeadersTimeout { get; set; }
+        public TimeSpan SendTimeout { get; set; }
+        public Func<HttpRequestMessage, X509Certificate2, X509Chain, SslPolicyErrors, bool> ServerCertificateValidationCallback { get; set; }
+        public ICredentials ServerCredentials { get; set; }
+        public SslProtocols SslProtocols { get; set; }
+        public WindowsProxyUsePolicy WindowsProxyUsePolicy { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
+}
```

