# System.Reflection.Metadata.Ecma335

``` diff
+namespace System.Reflection.Metadata.Ecma335 {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EditAndContinueLogEntry : IEquatable<EditAndContinueLogEntry> {
+        public EditAndContinueLogEntry(EntityHandle handle, EditAndContinueOperation operation);
+        public EntityHandle Handle { get; }
+        public EditAndContinueOperation Operation { get; }
+        public override bool Equals(object obj);
+        public bool Equals(EditAndContinueLogEntry other);
+        public override int GetHashCode();
+    }
+    public enum EditAndContinueOperation {
+        AddEvent = 5,
+        AddField = 2,
+        AddMethod = 1,
+        AddParameter = 3,
+        AddProperty = 4,
+        Default = 0,
+    }
+    public static class ExportedTypeExtensions {
+        public static int GetTypeDefinitionId(this ExportedType exportedType);
+    }
+    public enum HeapIndex {
+        Blob = 2,
+        Guid = 3,
+        String = 1,
+        UserString = 0,
+    }
+    public sealed class MetadataAggregator {
+        public MetadataAggregator(IReadOnlyList<int> baseTableRowCounts, IReadOnlyList<int> baseHeapSizes, IReadOnlyList<MetadataReader> deltaReaders);
+        public MetadataAggregator(MetadataReader baseReader, IReadOnlyList<MetadataReader> deltaReaders);
+        public Handle GetGenerationHandle(Handle handle, out int generation);
+    }
+    public static class MetadataReaderExtensions {
+        public static IEnumerable<EditAndContinueLogEntry> GetEditAndContinueLogEntries(this MetadataReader reader);
+        public static IEnumerable<EntityHandle> GetEditAndContinueMapEntries(this MetadataReader reader);
+        public static int GetHeapMetadataOffset(this MetadataReader reader, HeapIndex heapIndex);
+        public static int GetHeapSize(this MetadataReader reader, HeapIndex heapIndex);
+        public static BlobHandle GetNextHandle(this MetadataReader reader, BlobHandle handle);
+        public static StringHandle GetNextHandle(this MetadataReader reader, StringHandle handle);
+        public static UserStringHandle GetNextHandle(this MetadataReader reader, UserStringHandle handle);
+        public static int GetTableMetadataOffset(this MetadataReader reader, TableIndex tableIndex);
+        public static int GetTableRowCount(this MetadataReader reader, TableIndex tableIndex);
+        public static int GetTableRowSize(this MetadataReader reader, TableIndex tableIndex);
+        public static IEnumerable<TypeDefinitionHandle> GetTypesWithEvents(this MetadataReader reader);
+        public static IEnumerable<TypeDefinitionHandle> GetTypesWithProperties(this MetadataReader reader);
+    }
+    public static class MetadataTokens {
+        public static readonly int HeapCount;
+        public static readonly int TableCount;
+        public static AssemblyFileHandle AssemblyFileHandle(int rowNumber);
+        public static AssemblyReferenceHandle AssemblyReferenceHandle(int rowNumber);
+        public static BlobHandle BlobHandle(int offset);
+        public static ConstantHandle ConstantHandle(int rowNumber);
+        public static CustomAttributeHandle CustomAttributeHandle(int rowNumber);
+        public static CustomDebugInformationHandle CustomDebugInformationHandle(int rowNumber);
+        public static DeclarativeSecurityAttributeHandle DeclarativeSecurityAttributeHandle(int rowNumber);
+        public static DocumentHandle DocumentHandle(int rowNumber);
+        public static DocumentNameBlobHandle DocumentNameBlobHandle(int offset);
+        public static EntityHandle EntityHandle(int token);
+        public static EntityHandle EntityHandle(TableIndex tableIndex, int rowNumber);
+        public static EventDefinitionHandle EventDefinitionHandle(int rowNumber);
+        public static ExportedTypeHandle ExportedTypeHandle(int rowNumber);
+        public static FieldDefinitionHandle FieldDefinitionHandle(int rowNumber);
+        public static GenericParameterConstraintHandle GenericParameterConstraintHandle(int rowNumber);
+        public static GenericParameterHandle GenericParameterHandle(int rowNumber);
+        public static int GetHeapOffset(Handle handle);
+        public static int GetHeapOffset(this MetadataReader reader, Handle handle);
+        public static int GetRowNumber(EntityHandle handle);
+        public static int GetRowNumber(this MetadataReader reader, EntityHandle handle);
+        public static int GetToken(EntityHandle handle);
+        public static int GetToken(Handle handle);
+        public static int GetToken(this MetadataReader reader, EntityHandle handle);
+        public static int GetToken(this MetadataReader reader, Handle handle);
+        public static GuidHandle GuidHandle(int offset);
+        public static Handle Handle(int token);
+        public static EntityHandle Handle(TableIndex tableIndex, int rowNumber);
+        public static ImportScopeHandle ImportScopeHandle(int rowNumber);
+        public static InterfaceImplementationHandle InterfaceImplementationHandle(int rowNumber);
+        public static LocalConstantHandle LocalConstantHandle(int rowNumber);
+        public static LocalScopeHandle LocalScopeHandle(int rowNumber);
+        public static LocalVariableHandle LocalVariableHandle(int rowNumber);
+        public static ManifestResourceHandle ManifestResourceHandle(int rowNumber);
+        public static MemberReferenceHandle MemberReferenceHandle(int rowNumber);
+        public static MethodDebugInformationHandle MethodDebugInformationHandle(int rowNumber);
+        public static MethodDefinitionHandle MethodDefinitionHandle(int rowNumber);
+        public static MethodImplementationHandle MethodImplementationHandle(int rowNumber);
+        public static MethodSpecificationHandle MethodSpecificationHandle(int rowNumber);
+        public static ModuleReferenceHandle ModuleReferenceHandle(int rowNumber);
+        public static ParameterHandle ParameterHandle(int rowNumber);
+        public static PropertyDefinitionHandle PropertyDefinitionHandle(int rowNumber);
+        public static StandaloneSignatureHandle StandaloneSignatureHandle(int rowNumber);
+        public static StringHandle StringHandle(int offset);
+        public static bool TryGetHeapIndex(HandleKind type, out HeapIndex index);
+        public static bool TryGetTableIndex(HandleKind type, out TableIndex index);
+        public static TypeDefinitionHandle TypeDefinitionHandle(int rowNumber);
+        public static TypeReferenceHandle TypeReferenceHandle(int rowNumber);
+        public static TypeSpecificationHandle TypeSpecificationHandle(int rowNumber);
+        public static UserStringHandle UserStringHandle(int offset);
+    }
+    public enum TableIndex : byte {
+        Assembly = (byte)32,
+        AssemblyOS = (byte)34,
+        AssemblyProcessor = (byte)33,
+        AssemblyRef = (byte)35,
+        AssemblyRefOS = (byte)37,
+        AssemblyRefProcessor = (byte)36,
+        ClassLayout = (byte)15,
+        Constant = (byte)11,
+        CustomAttribute = (byte)12,
+        CustomDebugInformation = (byte)55,
+        DeclSecurity = (byte)14,
+        Document = (byte)48,
+        EncLog = (byte)30,
+        EncMap = (byte)31,
+        Event = (byte)20,
+        EventMap = (byte)18,
+        EventPtr = (byte)19,
+        ExportedType = (byte)39,
+        Field = (byte)4,
+        FieldLayout = (byte)16,
+        FieldMarshal = (byte)13,
+        FieldPtr = (byte)3,
+        FieldRva = (byte)29,
+        File = (byte)38,
+        GenericParam = (byte)42,
+        GenericParamConstraint = (byte)44,
+        ImplMap = (byte)28,
+        ImportScope = (byte)53,
+        InterfaceImpl = (byte)9,
+        LocalConstant = (byte)52,
+        LocalScope = (byte)50,
+        LocalVariable = (byte)51,
+        ManifestResource = (byte)40,
+        MemberRef = (byte)10,
+        MethodDebugInformation = (byte)49,
+        MethodDef = (byte)6,
+        MethodImpl = (byte)25,
+        MethodPtr = (byte)5,
+        MethodSemantics = (byte)24,
+        MethodSpec = (byte)43,
+        Module = (byte)0,
+        ModuleRef = (byte)26,
+        NestedClass = (byte)41,
+        Param = (byte)8,
+        ParamPtr = (byte)7,
+        Property = (byte)23,
+        PropertyMap = (byte)21,
+        PropertyPtr = (byte)22,
+        StandAloneSig = (byte)17,
+        StateMachineMethod = (byte)54,
+        TypeDef = (byte)2,
+        TypeRef = (byte)1,
+        TypeSpec = (byte)27,
+    }
+}
```

