# System.Security.Cryptography

``` diff
+namespace System.Security.Cryptography {
+    public abstract class Aes : SymmetricAlgorithm {
+        protected Aes();
+        public override KeySizes[] LegalBlockSizes { get; }
+        public override KeySizes[] LegalKeySizes { get; }
+        public static Aes Create();
+    }
+    public sealed class AesCng : Aes {
+        public AesCng();
+        public AesCng(string keyName);
+        public AesCng(string keyName, CngProvider provider);
+        public AesCng(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        public override byte[] Key { get; set; }
+        public override int KeySize { get; set; }
+        public override ICryptoTransform CreateDecryptor();
+        public override ICryptoTransform CreateDecryptor(byte[] rgbKey, byte[] rgbIV);
+        public override ICryptoTransform CreateEncryptor();
+        public override ICryptoTransform CreateEncryptor(byte[] rgbKey, byte[] rgbIV);
+        protected override void Dispose(bool disposing);
+        public override void GenerateIV();
+        public override void GenerateKey();
+    }
+    public class AsnEncodedData {
+        protected AsnEncodedData();
+        public AsnEncodedData(byte[] rawData);
+        public AsnEncodedData(AsnEncodedData asnEncodedData);
+        public AsnEncodedData(Oid oid, byte[] rawData);
+        public AsnEncodedData(string oid, byte[] rawData);
+        public Oid Oid { get; set; }
+        public byte[] RawData { get; set; }
+        public virtual void CopyFrom(AsnEncodedData asnEncodedData);
+        public virtual string Format(bool multiLine);
+    }
+    public sealed class AsnEncodedDataCollection : ICollection, IEnumerable {
+        public AsnEncodedDataCollection();
+        public AsnEncodedDataCollection(AsnEncodedData asnEncodedData);
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public AsnEncodedData this[int index] { get; }
+        public int Add(AsnEncodedData asnEncodedData);
+        public void CopyTo(AsnEncodedData[] array, int index);
+        public AsnEncodedDataEnumerator GetEnumerator();
+        public void Remove(AsnEncodedData asnEncodedData);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public sealed class AsnEncodedDataEnumerator : IEnumerator {
+        public AsnEncodedData Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public abstract class AsymmetricAlgorithm : IDisposable {
+        protected int KeySizeValue;
+        protected KeySizes[] LegalKeySizesValue;
+        protected AsymmetricAlgorithm();
+        public virtual int KeySize { get; set; }
+        public virtual KeySizes[] LegalKeySizes { get; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+    }
+    public enum CipherMode {
+        CBC = 1,
+        CTS = 5,
+        ECB = 2,
+    }
+    public sealed class CngAlgorithm : IEquatable<CngAlgorithm> {
+        public CngAlgorithm(string algorithm);
+        public string Algorithm { get; }
+        public static CngAlgorithm ECDiffieHellman { get; }
+        public static CngAlgorithm ECDiffieHellmanP256 { get; }
+        public static CngAlgorithm ECDiffieHellmanP384 { get; }
+        public static CngAlgorithm ECDiffieHellmanP521 { get; }
+        public static CngAlgorithm ECDsa { get; }
+        public static CngAlgorithm ECDsaP256 { get; }
+        public static CngAlgorithm ECDsaP384 { get; }
+        public static CngAlgorithm ECDsaP521 { get; }
+        public static CngAlgorithm MD5 { get; }
+        public static CngAlgorithm Rsa { get; }
+        public static CngAlgorithm Sha1 { get; }
+        public static CngAlgorithm Sha256 { get; }
+        public static CngAlgorithm Sha384 { get; }
+        public static CngAlgorithm Sha512 { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CngAlgorithm other);
+        public override int GetHashCode();
+        public static bool operator ==(CngAlgorithm left, CngAlgorithm right);
+        public static bool operator !=(CngAlgorithm left, CngAlgorithm right);
+        public override string ToString();
+    }
+    public sealed class CngAlgorithmGroup : IEquatable<CngAlgorithmGroup> {
+        public CngAlgorithmGroup(string algorithmGroup);
+        public string AlgorithmGroup { get; }
+        public static CngAlgorithmGroup DiffieHellman { get; }
+        public static CngAlgorithmGroup Dsa { get; }
+        public static CngAlgorithmGroup ECDiffieHellman { get; }
+        public static CngAlgorithmGroup ECDsa { get; }
+        public static CngAlgorithmGroup Rsa { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CngAlgorithmGroup other);
+        public override int GetHashCode();
+        public static bool operator ==(CngAlgorithmGroup left, CngAlgorithmGroup right);
+        public static bool operator !=(CngAlgorithmGroup left, CngAlgorithmGroup right);
+        public override string ToString();
+    }
+    public enum CngExportPolicies {
+        AllowArchiving = 4,
+        AllowExport = 1,
+        AllowPlaintextArchiving = 8,
+        AllowPlaintextExport = 2,
+        None = 0,
+    }
+    public sealed class CngKey : IDisposable {
+        public CngAlgorithm Algorithm { get; }
+        public CngAlgorithmGroup AlgorithmGroup { get; }
+        public CngExportPolicies ExportPolicy { get; }
+        public SafeNCryptKeyHandle Handle { get; }
+        public bool IsEphemeral { get; }
+        public bool IsMachineKey { get; }
+        public string KeyName { get; }
+        public int KeySize { get; }
+        public CngKeyUsages KeyUsage { get; }
+        public IntPtr ParentWindowHandle { get; set; }
+        public CngProvider Provider { get; }
+        public SafeNCryptProviderHandle ProviderHandle { get; }
+        public CngUIPolicy UIPolicy { get; }
+        public string UniqueName { get; }
+        public static CngKey Create(CngAlgorithm algorithm);
+        public static CngKey Create(CngAlgorithm algorithm, string keyName);
+        public static CngKey Create(CngAlgorithm algorithm, string keyName, CngKeyCreationParameters creationParameters);
+        public void Delete();
+        public void Dispose();
+        public static bool Exists(string keyName);
+        public static bool Exists(string keyName, CngProvider provider);
+        public static bool Exists(string keyName, CngProvider provider, CngKeyOpenOptions options);
+        public byte[] Export(CngKeyBlobFormat format);
+        public CngProperty GetProperty(string name, CngPropertyOptions options);
+        public bool HasProperty(string name, CngPropertyOptions options);
+        public static CngKey Import(byte[] keyBlob, CngKeyBlobFormat format);
+        public static CngKey Import(byte[] keyBlob, CngKeyBlobFormat format, CngProvider provider);
+        public static CngKey Open(SafeNCryptKeyHandle keyHandle, CngKeyHandleOpenOptions keyHandleOpenOptions);
+        public static CngKey Open(string keyName);
+        public static CngKey Open(string keyName, CngProvider provider);
+        public static CngKey Open(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        public void SetProperty(CngProperty property);
+    }
+    public sealed class CngKeyBlobFormat : IEquatable<CngKeyBlobFormat> {
+        public CngKeyBlobFormat(string format);
+        public static CngKeyBlobFormat EccFullPrivateBlob { get; }
+        public static CngKeyBlobFormat EccFullPublicBlob { get; }
+        public static CngKeyBlobFormat EccPrivateBlob { get; }
+        public static CngKeyBlobFormat EccPublicBlob { get; }
+        public string Format { get; }
+        public static CngKeyBlobFormat GenericPrivateBlob { get; }
+        public static CngKeyBlobFormat GenericPublicBlob { get; }
+        public static CngKeyBlobFormat OpaqueTransportBlob { get; }
+        public static CngKeyBlobFormat Pkcs8PrivateBlob { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CngKeyBlobFormat other);
+        public override int GetHashCode();
+        public static bool operator ==(CngKeyBlobFormat left, CngKeyBlobFormat right);
+        public static bool operator !=(CngKeyBlobFormat left, CngKeyBlobFormat right);
+        public override string ToString();
+    }
+    public enum CngKeyCreationOptions {
+        MachineKey = 32,
+        None = 0,
+        OverwriteExistingKey = 128,
+    }
+    public sealed class CngKeyCreationParameters {
+        public CngKeyCreationParameters();
+        public Nullable<CngExportPolicies> ExportPolicy { get; set; }
+        public CngKeyCreationOptions KeyCreationOptions { get; set; }
+        public Nullable<CngKeyUsages> KeyUsage { get; set; }
+        public CngPropertyCollection Parameters { get; }
+        public IntPtr ParentWindowHandle { get; set; }
+        public CngProvider Provider { get; set; }
+        public CngUIPolicy UIPolicy { get; set; }
+    }
+    public enum CngKeyHandleOpenOptions {
+        EphemeralKey = 1,
+        None = 0,
+    }
+    public enum CngKeyOpenOptions {
+        MachineKey = 32,
+        None = 0,
+        Silent = 64,
+        UserKey = 0,
+    }
+    public enum CngKeyUsages {
+        AllUsages = 16777215,
+        Decryption = 1,
+        KeyAgreement = 4,
+        None = 0,
+        Signing = 2,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CngProperty : IEquatable<CngProperty> {
+        public CngProperty(string name, byte[] value, CngPropertyOptions options);
+        public string Name { get; }
+        public CngPropertyOptions Options { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CngProperty other);
+        public override int GetHashCode();
+        public byte[] GetValue();
+        public static bool operator ==(CngProperty left, CngProperty right);
+        public static bool operator !=(CngProperty left, CngProperty right);
+    }
+    public sealed class CngPropertyCollection : Collection<CngProperty> {
+        public CngPropertyCollection();
+    }
+    public enum CngPropertyOptions {
+        CustomProperty = 1073741824,
+        None = 0,
+        Persist = -2147483648,
+    }
+    public sealed class CngProvider : IEquatable<CngProvider> {
+        public CngProvider(string provider);
+        public static CngProvider MicrosoftSmartCardKeyStorageProvider { get; }
+        public static CngProvider MicrosoftSoftwareKeyStorageProvider { get; }
+        public string Provider { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CngProvider other);
+        public override int GetHashCode();
+        public static bool operator ==(CngProvider left, CngProvider right);
+        public static bool operator !=(CngProvider left, CngProvider right);
+        public override string ToString();
+    }
+    public sealed class CngUIPolicy {
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel);
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel, string friendlyName);
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel, string friendlyName, string description);
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel, string friendlyName, string description, string useContext);
+        public CngUIPolicy(CngUIProtectionLevels protectionLevel, string friendlyName, string description, string useContext, string creationTitle);
+        public string CreationTitle { get; }
+        public string Description { get; }
+        public string FriendlyName { get; }
+        public CngUIProtectionLevels ProtectionLevel { get; }
+        public string UseContext { get; }
+    }
+    public enum CngUIProtectionLevels {
+        ForceHighProtection = 2,
+        None = 0,
+        ProtectKey = 1,
+    }
+    public sealed class CryptographicAttributeObject {
+        public CryptographicAttributeObject(Oid oid);
+        public CryptographicAttributeObject(Oid oid, AsnEncodedDataCollection values);
+        public Oid Oid { get; }
+        public AsnEncodedDataCollection Values { get; }
+    }
+    public sealed class CryptographicAttributeObjectCollection : ICollection, IEnumerable {
+        public CryptographicAttributeObjectCollection();
+        public CryptographicAttributeObjectCollection(CryptographicAttributeObject attribute);
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public CryptographicAttributeObject this[int index] { get; }
+        public int Add(AsnEncodedData asnEncodedData);
+        public int Add(CryptographicAttributeObject attribute);
+        public void CopyTo(CryptographicAttributeObject[] array, int index);
+        public CryptographicAttributeObjectEnumerator GetEnumerator();
+        public void Remove(CryptographicAttributeObject attribute);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public sealed class CryptographicAttributeObjectEnumerator : IEnumerator {
+        public CryptographicAttributeObject Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public class CryptographicException : Exception {
+        public CryptographicException();
+        public CryptographicException(int hr);
+        public CryptographicException(string message);
+        public CryptographicException(string message, Exception inner);
+        public CryptographicException(string format, string insert);
+    }
+    public class CryptoStream : Stream, IDisposable {
+        public CryptoStream(Stream stream, ICryptoTransform transform, CryptoStreamMode mode);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public bool HasFlushedFinalBlock { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        protected override void Dispose(bool disposing);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        public void FlushFinalBlock();
+        public override int Read(byte[] buffer, int offset, int count);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+    }
+    public enum CryptoStreamMode {
+        Read = 0,
+        Write = 1,
+    }
+    public sealed class CspKeyContainerInfo {
+        public CspKeyContainerInfo(CspParameters parameters);
+        public bool Accessible { get; }
+        public bool Exportable { get; }
+        public bool HardwareDevice { get; }
+        public string KeyContainerName { get; }
+        public KeyNumber KeyNumber { get; }
+        public bool MachineKeyStore { get; }
+        public bool Protected { get; }
+        public string ProviderName { get; }
+        public int ProviderType { get; }
+        public bool RandomlyGenerated { get; }
+        public bool Removable { get; }
+        public string UniqueKeyContainerName { get; }
+    }
+    public sealed class CspParameters {
+        public int KeyNumber;
+        public int ProviderType;
+        public string KeyContainerName;
+        public string ProviderName;
+        public CspParameters();
+        public CspParameters(int dwTypeIn);
+        public CspParameters(int dwTypeIn, string strProviderNameIn);
+        public CspParameters(int dwTypeIn, string strProviderNameIn, string strContainerNameIn);
+        public CspProviderFlags Flags { get; set; }
+        public IntPtr ParentWindowHandle { get; set; }
+    }
+    public enum CspProviderFlags {
+        CreateEphemeralKey = 128,
+        NoFlags = 0,
+        NoPrompt = 64,
+        UseArchivableKey = 16,
+        UseDefaultKeyContainer = 2,
+        UseExistingKey = 8,
+        UseMachineKeyStore = 1,
+        UseNonExportableKey = 4,
+        UseUserProtectedKey = 32,
+    }
+    public enum DataProtectionScope {
+        CurrentUser = 0,
+        LocalMachine = 1,
+    }
+    public abstract class DeriveBytes : IDisposable {
+        protected DeriveBytes();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract byte[] GetBytes(int cb);
+        public abstract void Reset();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ECCurve {
+        public ECCurve.ECCurveType CurveType;
+        public byte[] A;
+        public byte[] B;
+        public byte[] Cofactor;
+        public byte[] Order;
+        public byte[] Polynomial;
+        public byte[] Prime;
+        public byte[] Seed;
+        public Nullable<HashAlgorithmName> Hash;
+        public ECPoint G;
+        public bool IsCharacteristic2 { get; }
+        public bool IsExplicit { get; }
+        public bool IsNamed { get; }
+        public bool IsPrime { get; }
+        public Oid Oid { get; }
+        public static ECCurve CreateFromFriendlyName(string oidFriendlyName);
+        public static ECCurve CreateFromOid(Oid curveOid);
+        public static ECCurve CreateFromValue(string oidValue);
+        public void Validate();
+        public enum ECCurveType {
+            Characteristic2 = 4,
+            Implicit = 0,
+            Named = 5,
+            PrimeMontgomery = 3,
+            PrimeShortWeierstrass = 1,
+            PrimeTwistedEdwards = 2,
+        }
+        public static class NamedCurves {
+            public static ECCurve brainpoolP160r1 { get; }
+            public static ECCurve brainpoolP160t1 { get; }
+            public static ECCurve brainpoolP192r1 { get; }
+            public static ECCurve brainpoolP192t1 { get; }
+            public static ECCurve brainpoolP224r1 { get; }
+            public static ECCurve brainpoolP224t1 { get; }
+            public static ECCurve brainpoolP256r1 { get; }
+            public static ECCurve brainpoolP256t1 { get; }
+            public static ECCurve brainpoolP320r1 { get; }
+            public static ECCurve brainpoolP320t1 { get; }
+            public static ECCurve brainpoolP384r1 { get; }
+            public static ECCurve brainpoolP384t1 { get; }
+            public static ECCurve brainpoolP512r1 { get; }
+            public static ECCurve brainpoolP512t1 { get; }
+            public static ECCurve nistP256 { get; }
+            public static ECCurve nistP384 { get; }
+            public static ECCurve nistP521 { get; }
+        }
+    }
+    public abstract class ECDsa : AsymmetricAlgorithm {
+        protected ECDsa();
+        public static ECDsa Create();
+        public static ECDsa Create(ECCurve curve);
+        public static ECDsa Create(ECParameters parameters);
+        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);
+        public virtual ECParameters ExportParameters(bool includePrivateParameters);
+        public virtual void GenerateKey(ECCurve curve);
+        protected abstract byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected abstract byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public virtual void ImportParameters(ECParameters parameters);
+        public virtual byte[] SignData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        public virtual byte[] SignData(byte[] data, HashAlgorithmName hashAlgorithm);
+        public virtual byte[] SignData(Stream data, HashAlgorithmName hashAlgorithm);
+        public abstract byte[] SignHash(byte[] hash);
+        public bool VerifyData(byte[] data, byte[] signature, HashAlgorithmName hashAlgorithm);
+        public virtual bool VerifyData(byte[] data, int offset, int count, byte[] signature, HashAlgorithmName hashAlgorithm);
+        public bool VerifyData(Stream data, byte[] signature, HashAlgorithmName hashAlgorithm);
+        public abstract bool VerifyHash(byte[] hash, byte[] signature);
+    }
+    public sealed class ECDsaCng : ECDsa {
+        public ECDsaCng();
+        public ECDsaCng(int keySize);
+        public ECDsaCng(CngKey key);
+        public ECDsaCng(ECCurve curve);
+        public CngKey Key { get; }
+        public override int KeySize { get; set; }
+        public override KeySizes[] LegalKeySizes { get; }
+        protected override void Dispose(bool disposing);
+        public override ECParameters ExportExplicitParameters(bool includePrivateParameters);
+        public override ECParameters ExportParameters(bool includePrivateParameters);
+        public override void GenerateKey(ECCurve curve);
+        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public override void ImportParameters(ECParameters parameters);
+        public override byte[] SignHash(byte[] hash);
+        public override bool VerifyHash(byte[] hash, byte[] signature);
+    }
+    public sealed class ECDsaOpenSsl : ECDsa {
+        public ECDsaOpenSsl();
+        public ECDsaOpenSsl(int keySize);
+        public ECDsaOpenSsl(IntPtr handle);
+        public ECDsaOpenSsl(ECCurve curve);
+        public ECDsaOpenSsl(SafeEvpPKeyHandle pkeyHandle);
+        public override int KeySize { get; set; }
+        public override KeySizes[] LegalKeySizes { get; }
+        protected override void Dispose(bool disposing);
+        public SafeEvpPKeyHandle DuplicateKeyHandle();
+        public override ECParameters ExportExplicitParameters(bool includePrivateParameters);
+        public override ECParameters ExportParameters(bool includePrivateParameters);
+        public override void GenerateKey(ECCurve curve);
+        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public override void ImportParameters(ECParameters parameters);
+        public override byte[] SignHash(byte[] hash);
+        public override bool VerifyHash(byte[] hash, byte[] signature);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ECParameters {
+        public byte[] D;
+        public ECCurve Curve;
+        public ECPoint Q;
+        public void Validate();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ECPoint {
+        public byte[] X;
+        public byte[] Y;
+    }
+    public abstract class HashAlgorithm : IDisposable {
+        protected HashAlgorithm();
+        public virtual int HashSize { get; }
+        public byte[] ComputeHash(byte[] buffer);
+        public byte[] ComputeHash(byte[] buffer, int offset, int count);
+        public byte[] ComputeHash(Stream inputStream);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected abstract void HashCore(byte[] array, int ibStart, int cbSize);
+        protected abstract byte[] HashFinal();
+        public abstract void Initialize();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct HashAlgorithmName : IEquatable<HashAlgorithmName> {
+        public HashAlgorithmName(string name);
+        public static HashAlgorithmName MD5 { get; }
+        public string Name { get; }
+        public static HashAlgorithmName SHA1 { get; }
+        public static HashAlgorithmName SHA256 { get; }
+        public static HashAlgorithmName SHA384 { get; }
+        public static HashAlgorithmName SHA512 { get; }
+        public override bool Equals(object obj);
+        public bool Equals(HashAlgorithmName other);
+        public override int GetHashCode();
+        public static bool operator ==(HashAlgorithmName left, HashAlgorithmName right);
+        public static bool operator !=(HashAlgorithmName left, HashAlgorithmName right);
+        public override string ToString();
+    }
+    public abstract class HMAC : KeyedHashAlgorithm {
+        protected HMAC();
+        public string HashName { get; set; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override byte[] HashFinal();
+        public override void Initialize();
+    }
+    public class HMACMD5 : HMAC {
+        public HMACMD5();
+        public HMACMD5(byte[] key);
+        public override int HashSize { get; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override byte[] HashFinal();
+        public override void Initialize();
+    }
+    public class HMACSHA1 : HMAC {
+        public HMACSHA1();
+        public HMACSHA1(byte[] key);
+        public override int HashSize { get; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override byte[] HashFinal();
+        public override void Initialize();
+    }
+    public class HMACSHA256 : HMAC {
+        public HMACSHA256();
+        public HMACSHA256(byte[] key);
+        public override int HashSize { get; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override byte[] HashFinal();
+        public override void Initialize();
+    }
+    public class HMACSHA384 : HMAC {
+        public HMACSHA384();
+        public HMACSHA384(byte[] key);
+        public override int HashSize { get; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override byte[] HashFinal();
+        public override void Initialize();
+    }
+    public class HMACSHA512 : HMAC {
+        public HMACSHA512();
+        public HMACSHA512(byte[] key);
+        public override int HashSize { get; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override byte[] HashFinal();
+        public override void Initialize();
+    }
+    public interface ICryptoTransform : IDisposable {
+        bool CanReuseTransform { get; }
+        bool CanTransformMultipleBlocks { get; }
+        int InputBlockSize { get; }
+        int OutputBlockSize { get; }
+        int TransformBlock(byte[] inputBuffer, int inputOffset, int inputCount, byte[] outputBuffer, int outputOffset);
+        byte[] TransformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount);
+    }
+    public interface ICspAsymmetricAlgorithm {
+        CspKeyContainerInfo CspKeyContainerInfo { get; }
+        byte[] ExportCspBlob(bool includePrivateParameters);
+        void ImportCspBlob(byte[] rawData);
+    }
+    public sealed class IncrementalHash : IDisposable {
+        public HashAlgorithmName AlgorithmName { get; }
+        public void AppendData(byte[] data);
+        public void AppendData(byte[] data, int offset, int count);
+        public static IncrementalHash CreateHash(HashAlgorithmName hashAlgorithm);
+        public static IncrementalHash CreateHMAC(HashAlgorithmName hashAlgorithm, byte[] key);
+        public void Dispose();
+        public byte[] GetHashAndReset();
+    }
+    public abstract class KeyedHashAlgorithm : HashAlgorithm {
+        protected KeyedHashAlgorithm();
+        public virtual byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+    }
+    public enum KeyNumber {
+        Exchange = 1,
+        Signature = 2,
+    }
+    public sealed class KeySizes {
+        public KeySizes(int minSize, int maxSize, int skipSize);
+        public int MaxSize { get; }
+        public int MinSize { get; }
+        public int SkipSize { get; }
+    }
+    public abstract class MD5 : HashAlgorithm {
+        protected MD5();
+        public static MD5 Create();
+    }
+    public sealed class Oid {
+        public Oid(Oid oid);
+        public Oid(string oid);
+        public Oid(string value, string friendlyName);
+        public string FriendlyName { get; set; }
+        public string Value { get; set; }
+        public static Oid FromFriendlyName(string friendlyName, OidGroup group);
+        public static Oid FromOidValue(string oidValue, OidGroup group);
+    }
+    public sealed class OidCollection : ICollection, IEnumerable {
+        public OidCollection();
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public Oid this[int index] { get; }
+        public Oid this[string oid] { get; }
+        public int Add(Oid oid);
+        public void CopyTo(Oid[] array, int index);
+        public OidEnumerator GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
+    public sealed class OidEnumerator : IEnumerator {
+        public Oid Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public enum OidGroup {
+        All = 0,
+        Attribute = 5,
+        EncryptionAlgorithm = 2,
+        EnhancedKeyUsage = 7,
+        ExtensionOrAttribute = 6,
+        HashAlgorithm = 1,
+        KeyDerivationFunction = 10,
+        Policy = 8,
+        PublicKeyAlgorithm = 3,
+        SignatureAlgorithm = 4,
+        Template = 9,
+    }
+    public enum PaddingMode {
+        None = 1,
+        PKCS7 = 2,
+        Zeros = 3,
+    }
+    public static class ProtectedData {
+        public static byte[] Protect(byte[] userData, byte[] optionalEntropy, DataProtectionScope scope);
+        public static byte[] Unprotect(byte[] encryptedData, byte[] optionalEntropy, DataProtectionScope scope);
+    }
+    public abstract class RandomNumberGenerator : IDisposable {
+        protected RandomNumberGenerator();
+        public static RandomNumberGenerator Create();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract void GetBytes(byte[] data);
+    }
+    public class Rfc2898DeriveBytes : DeriveBytes {
+        public Rfc2898DeriveBytes(byte[] password, byte[] salt, int iterations);
+        public Rfc2898DeriveBytes(string password, byte[] salt);
+        public Rfc2898DeriveBytes(string password, byte[] salt, int iterations);
+        public Rfc2898DeriveBytes(string password, int saltSize);
+        public Rfc2898DeriveBytes(string password, int saltSize, int iterations);
+        public int IterationCount { get; set; }
+        public byte[] Salt { get; set; }
+        protected override void Dispose(bool disposing);
+        public override byte[] GetBytes(int cb);
+        public override void Reset();
+    }
+    public abstract class RSA : AsymmetricAlgorithm {
+        protected RSA();
+        public static RSA Create();
+        public abstract byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
+        public abstract byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
+        public abstract RSAParameters ExportParameters(bool includePrivateParameters);
+        protected abstract byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected abstract byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public abstract void ImportParameters(RSAParameters parameters);
+        public virtual byte[] SignData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public byte[] SignData(byte[] data, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public virtual byte[] SignData(Stream data, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public abstract byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public bool VerifyData(byte[] data, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public virtual bool VerifyData(byte[] data, int offset, int count, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public bool VerifyData(Stream data, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public abstract bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+    }
+    public sealed class RSACng : RSA {
+        public RSACng();
+        public RSACng(int keySize);
+        public RSACng(CngKey key);
+        public CngKey Key { get; }
+        public override KeySizes[] LegalKeySizes { get; }
+        public override byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
+        protected override void Dispose(bool disposing);
+        public override byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
+        public override RSAParameters ExportParameters(bool includePrivateParameters);
+        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public override void ImportParameters(RSAParameters parameters);
+        public override byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public override bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+    }
+    public sealed class RSACryptoServiceProvider : RSA, ICspAsymmetricAlgorithm {
+        public RSACryptoServiceProvider();
+        public RSACryptoServiceProvider(int dwKeySize);
+        public RSACryptoServiceProvider(int dwKeySize, CspParameters parameters);
+        public RSACryptoServiceProvider(CspParameters parameters);
+        public CspKeyContainerInfo CspKeyContainerInfo { get; }
+        public override int KeySize { get; }
+        public override KeySizes[] LegalKeySizes { get; }
+        public bool PersistKeyInCsp { get; set; }
+        public bool PublicOnly { get; }
+        public static bool UseMachineKeyStore { get; set; }
+        public byte[] Decrypt(byte[] rgb, bool fOAEP);
+        public override byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
+        protected override void Dispose(bool disposing);
+        public byte[] Encrypt(byte[] rgb, bool fOAEP);
+        public override byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
+        public byte[] ExportCspBlob(bool includePrivateParameters);
+        public override RSAParameters ExportParameters(bool includePrivateParameters);
+        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public void ImportCspBlob(byte[] keyBlob);
+        public override void ImportParameters(RSAParameters parameters);
+        public byte[] SignData(byte[] buffer, int offset, int count, object halg);
+        public byte[] SignData(byte[] buffer, object halg);
+        public byte[] SignData(Stream inputStream, object halg);
+        public override byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public byte[] SignHash(byte[] rgbHash, string str);
+        public bool VerifyData(byte[] buffer, object halg, byte[] signature);
+        public override bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public bool VerifyHash(byte[] rgbHash, string str, byte[] rgbSignature);
+    }
+    public sealed class RSAEncryptionPadding : IEquatable<RSAEncryptionPadding> {
+        public RSAEncryptionPaddingMode Mode { get; }
+        public HashAlgorithmName OaepHashAlgorithm { get; }
+        public static RSAEncryptionPadding OaepSHA1 { get; }
+        public static RSAEncryptionPadding OaepSHA256 { get; }
+        public static RSAEncryptionPadding OaepSHA384 { get; }
+        public static RSAEncryptionPadding OaepSHA512 { get; }
+        public static RSAEncryptionPadding Pkcs1 { get; }
+        public static RSAEncryptionPadding CreateOaep(HashAlgorithmName hashAlgorithm);
+        public override bool Equals(object obj);
+        public bool Equals(RSAEncryptionPadding other);
+        public override int GetHashCode();
+        public static bool operator ==(RSAEncryptionPadding left, RSAEncryptionPadding right);
+        public static bool operator !=(RSAEncryptionPadding left, RSAEncryptionPadding right);
+        public override string ToString();
+    }
+    public enum RSAEncryptionPaddingMode {
+        Oaep = 1,
+        Pkcs1 = 0,
+    }
+    public sealed class RSAOpenSsl : RSA {
+        public RSAOpenSsl();
+        public RSAOpenSsl(int keySize);
+        public RSAOpenSsl(IntPtr handle);
+        public RSAOpenSsl(RSAParameters parameters);
+        public RSAOpenSsl(SafeEvpPKeyHandle pkeyHandle);
+        public override int KeySize { set; }
+        public override KeySizes[] LegalKeySizes { get; }
+        public override byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);
+        protected override void Dispose(bool disposing);
+        public SafeEvpPKeyHandle DuplicateKeyHandle();
+        public override byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);
+        public override RSAParameters ExportParameters(bool includePrivateParameters);
+        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);
+        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);
+        public override void ImportParameters(RSAParameters parameters);
+        public override byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public override bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct RSAParameters {
+        public byte[] D;
+        public byte[] DP;
+        public byte[] DQ;
+        public byte[] Exponent;
+        public byte[] InverseQ;
+        public byte[] Modulus;
+        public byte[] P;
+        public byte[] Q;
+    }
+    public sealed class RSASignaturePadding : IEquatable<RSASignaturePadding> {
+        public RSASignaturePaddingMode Mode { get; }
+        public static RSASignaturePadding Pkcs1 { get; }
+        public static RSASignaturePadding Pss { get; }
+        public override bool Equals(object obj);
+        public bool Equals(RSASignaturePadding other);
+        public override int GetHashCode();
+        public static bool operator ==(RSASignaturePadding left, RSASignaturePadding right);
+        public static bool operator !=(RSASignaturePadding left, RSASignaturePadding right);
+        public override string ToString();
+    }
+    public enum RSASignaturePaddingMode {
+        Pkcs1 = 0,
+        Pss = 1,
+    }
+    public sealed class SafeEvpPKeyHandle : SafeHandle {
+        public SafeEvpPKeyHandle(IntPtr handle, bool ownsHandle);
+        public override bool IsInvalid { get; }
+        public SafeEvpPKeyHandle DuplicateHandle();
+        protected override bool ReleaseHandle();
+    }
+    public abstract class SHA1 : HashAlgorithm {
+        protected SHA1();
+        public static SHA1 Create();
+    }
+    public abstract class SHA256 : HashAlgorithm {
+        protected SHA256();
+        public static SHA256 Create();
+    }
+    public abstract class SHA384 : HashAlgorithm {
+        protected SHA384();
+        public static SHA384 Create();
+    }
+    public abstract class SHA512 : HashAlgorithm {
+        protected SHA512();
+        public static SHA512 Create();
+    }
+    public abstract class SymmetricAlgorithm : IDisposable {
+        protected byte[] IVValue;
+        protected byte[] KeyValue;
+        protected int BlockSizeValue;
+        protected int KeySizeValue;
+        protected CipherMode ModeValue;
+        protected KeySizes[] LegalBlockSizesValue;
+        protected KeySizes[] LegalKeySizesValue;
+        protected PaddingMode PaddingValue;
+        protected SymmetricAlgorithm();
+        public virtual int BlockSize { get; set; }
+        public virtual byte[] IV { get; set; }
+        public virtual byte[] Key { get; set; }
+        public virtual int KeySize { get; set; }
+        public virtual KeySizes[] LegalBlockSizes { get; }
+        public virtual KeySizes[] LegalKeySizes { get; }
+        public virtual CipherMode Mode { get; set; }
+        public virtual PaddingMode Padding { get; set; }
+        public virtual ICryptoTransform CreateDecryptor();
+        public abstract ICryptoTransform CreateDecryptor(byte[] rgbKey, byte[] rgbIV);
+        public virtual ICryptoTransform CreateEncryptor();
+        public abstract ICryptoTransform CreateEncryptor(byte[] rgbKey, byte[] rgbIV);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract void GenerateIV();
+        public abstract void GenerateKey();
+    }
+    public abstract class TripleDES : SymmetricAlgorithm {
+        protected TripleDES();
+        public override byte[] Key { get; set; }
+        public override KeySizes[] LegalBlockSizes { get; }
+        public override KeySizes[] LegalKeySizes { get; }
+        public static TripleDES Create();
+        public static bool IsWeakKey(byte[] rgbKey);
+    }
+    public sealed class TripleDESCng : TripleDES {
+        public TripleDESCng();
+        public TripleDESCng(string keyName);
+        public TripleDESCng(string keyName, CngProvider provider);
+        public TripleDESCng(string keyName, CngProvider provider, CngKeyOpenOptions openOptions);
+        public override byte[] Key { get; set; }
+        public override int KeySize { get; set; }
+        public override KeySizes[] LegalKeySizes { get; }
+        public override ICryptoTransform CreateDecryptor();
+        public override ICryptoTransform CreateDecryptor(byte[] rgbKey, byte[] rgbIV);
+        public override ICryptoTransform CreateEncryptor();
+        public override ICryptoTransform CreateEncryptor(byte[] rgbKey, byte[] rgbIV);
+        protected override void Dispose(bool disposing);
+        public override void GenerateIV();
+        public override void GenerateKey();
+    }
+}
```

