# System.Text

``` diff
+namespace System.Text {
+    public class ASCIIEncoding : Encoding {
+        public ASCIIEncoding();
+        public override bool IsSingleByte { get; }
+        public unsafe override int GetByteCount(char* chars, int count);
+        public override int GetByteCount(char[] chars, int index, int count);
+        public override int GetByteCount(string chars);
+        public unsafe override int GetBytes(char* chars, int charCount, byte* bytes, int byteCount);
+        public override int GetBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public override int GetBytes(string chars, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public unsafe override int GetCharCount(byte* bytes, int count);
+        public override int GetCharCount(byte[] bytes, int index, int count);
+        public unsafe override int GetChars(byte* bytes, int byteCount, char* chars, int charCount);
+        public override int GetChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex);
+        public override Decoder GetDecoder();
+        public override Encoder GetEncoder();
+        public override int GetMaxByteCount(int charCount);
+        public override int GetMaxCharCount(int byteCount);
+        public override string GetString(byte[] bytes, int byteIndex, int byteCount);
+    }
+    public sealed class CodePagesEncodingProvider {
+        public static EncodingProvider Instance { get; }
+    }
+    public abstract class Decoder {
+        protected Decoder();
+        public DecoderFallback Fallback { get; set; }
+        public DecoderFallbackBuffer FallbackBuffer { get; }
+        public unsafe virtual void Convert(byte* bytes, int byteCount, char* chars, int charCount, bool flush, out int bytesUsed, out int charsUsed, out bool completed);
+        public virtual void Convert(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex, int charCount, bool flush, out int bytesUsed, out int charsUsed, out bool completed);
+        public unsafe virtual int GetCharCount(byte* bytes, int count, bool flush);
+        public abstract int GetCharCount(byte[] bytes, int index, int count);
+        public virtual int GetCharCount(byte[] bytes, int index, int count, bool flush);
+        public unsafe virtual int GetChars(byte* bytes, int byteCount, char* chars, int charCount, bool flush);
+        public abstract int GetChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex);
+        public virtual int GetChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex, bool flush);
+        public virtual void Reset();
+    }
+    public sealed class DecoderExceptionFallback : DecoderFallback {
+        public DecoderExceptionFallback();
+        public override int MaxCharCount { get; }
+        public override DecoderFallbackBuffer CreateFallbackBuffer();
+        public override bool Equals(object value);
+        public override int GetHashCode();
+    }
+    public abstract class DecoderFallback {
+        protected DecoderFallback();
+        public static DecoderFallback ExceptionFallback { get; }
+        public abstract int MaxCharCount { get; }
+        public static DecoderFallback ReplacementFallback { get; }
+        public abstract DecoderFallbackBuffer CreateFallbackBuffer();
+    }
+    public abstract class DecoderFallbackBuffer {
+        protected DecoderFallbackBuffer();
+        public abstract int Remaining { get; }
+        public abstract bool Fallback(byte[] bytesUnknown, int index);
+        public abstract char GetNextChar();
+        public abstract bool MovePrevious();
+        public virtual void Reset();
+    }
+    public sealed class DecoderFallbackException : ArgumentException {
+        public DecoderFallbackException();
+        public DecoderFallbackException(string message);
+        public DecoderFallbackException(string message, byte[] bytesUnknown, int index);
+        public DecoderFallbackException(string message, Exception innerException);
+        public byte[] BytesUnknown { get; }
+        public int Index { get; }
+    }
+    public sealed class DecoderReplacementFallback : DecoderFallback {
+        public DecoderReplacementFallback();
+        public DecoderReplacementFallback(string replacement);
+        public string DefaultString { get; }
+        public override int MaxCharCount { get; }
+        public override DecoderFallbackBuffer CreateFallbackBuffer();
+        public override bool Equals(object value);
+        public override int GetHashCode();
+    }
+    public abstract class Encoder {
+        protected Encoder();
+        public EncoderFallback Fallback { get; set; }
+        public EncoderFallbackBuffer FallbackBuffer { get; }
+        public unsafe virtual void Convert(char* chars, int charCount, byte* bytes, int byteCount, bool flush, out int charsUsed, out int bytesUsed, out bool completed);
+        public virtual void Convert(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex, int byteCount, bool flush, out int charsUsed, out int bytesUsed, out bool completed);
+        public unsafe virtual int GetByteCount(char* chars, int count, bool flush);
+        public abstract int GetByteCount(char[] chars, int index, int count, bool flush);
+        public unsafe virtual int GetBytes(char* chars, int charCount, byte* bytes, int byteCount, bool flush);
+        public abstract int GetBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex, bool flush);
+        public virtual void Reset();
+    }
+    public sealed class EncoderExceptionFallback : EncoderFallback {
+        public EncoderExceptionFallback();
+        public override int MaxCharCount { get; }
+        public override EncoderFallbackBuffer CreateFallbackBuffer();
+        public override bool Equals(object value);
+        public override int GetHashCode();
+    }
+    public abstract class EncoderFallback {
+        protected EncoderFallback();
+        public static EncoderFallback ExceptionFallback { get; }
+        public abstract int MaxCharCount { get; }
+        public static EncoderFallback ReplacementFallback { get; }
+        public abstract EncoderFallbackBuffer CreateFallbackBuffer();
+    }
+    public abstract class EncoderFallbackBuffer {
+        protected EncoderFallbackBuffer();
+        public abstract int Remaining { get; }
+        public abstract bool Fallback(char charUnknownHigh, char charUnknownLow, int index);
+        public abstract bool Fallback(char charUnknown, int index);
+        public abstract char GetNextChar();
+        public abstract bool MovePrevious();
+        public virtual void Reset();
+    }
+    public sealed class EncoderFallbackException : ArgumentException {
+        public EncoderFallbackException();
+        public EncoderFallbackException(string message);
+        public EncoderFallbackException(string message, Exception innerException);
+        public char CharUnknown { get; }
+        public char CharUnknownHigh { get; }
+        public char CharUnknownLow { get; }
+        public int Index { get; }
+        public bool IsUnknownSurrogate();
+    }
+    public sealed class EncoderReplacementFallback : EncoderFallback {
+        public EncoderReplacementFallback();
+        public EncoderReplacementFallback(string replacement);
+        public string DefaultString { get; }
+        public override int MaxCharCount { get; }
+        public override EncoderFallbackBuffer CreateFallbackBuffer();
+        public override bool Equals(object value);
+        public override int GetHashCode();
+    }
+    public abstract class Encoding {
+        protected Encoding();
+        protected Encoding(int codePage);
+        protected Encoding(int codePage, EncoderFallback encoderFallback, DecoderFallback decoderFallback);
+        public static Encoding ASCII { get; }
+        public static Encoding BigEndianUnicode { get; }
+        public virtual int CodePage { get; }
+        public DecoderFallback DecoderFallback { get; }
+        public EncoderFallback EncoderFallback { get; }
+        public virtual string EncodingName { get; }
+        public virtual bool IsSingleByte { get; }
+        public static Encoding Unicode { get; }
+        public static Encoding UTF32 { get; }
+        public static Encoding UTF7 { get; }
+        public static Encoding UTF8 { get; }
+        public virtual string WebName { get; }
+        public virtual object Clone();
+        public static byte[] Convert(Encoding srcEncoding, Encoding dstEncoding, byte[] bytes);
+        public static byte[] Convert(Encoding srcEncoding, Encoding dstEncoding, byte[] bytes, int index, int count);
+        public override bool Equals(object value);
+        public unsafe virtual int GetByteCount(char* chars, int count);
+        public virtual int GetByteCount(char[] chars);
+        public abstract int GetByteCount(char[] chars, int index, int count);
+        public virtual int GetByteCount(string s);
+        public unsafe virtual int GetBytes(char* chars, int charCount, byte* bytes, int byteCount);
+        public virtual byte[] GetBytes(char[] chars);
+        public virtual byte[] GetBytes(char[] chars, int index, int count);
+        public abstract int GetBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public virtual byte[] GetBytes(string s);
+        public virtual int GetBytes(string s, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public unsafe virtual int GetCharCount(byte* bytes, int count);
+        public virtual int GetCharCount(byte[] bytes);
+        public abstract int GetCharCount(byte[] bytes, int index, int count);
+        public unsafe virtual int GetChars(byte* bytes, int byteCount, char* chars, int charCount);
+        public virtual char[] GetChars(byte[] bytes);
+        public virtual char[] GetChars(byte[] bytes, int index, int count);
+        public abstract int GetChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex);
+        public virtual Decoder GetDecoder();
+        public virtual Encoder GetEncoder();
+        public static Encoding GetEncoding(int codepage);
+        public static Encoding GetEncoding(int codepage, EncoderFallback encoderFallback, DecoderFallback decoderFallback);
+        public static Encoding GetEncoding(string name);
+        public static Encoding GetEncoding(string name, EncoderFallback encoderFallback, DecoderFallback decoderFallback);
+        public override int GetHashCode();
+        public abstract int GetMaxByteCount(int charCount);
+        public abstract int GetMaxCharCount(int byteCount);
+        public virtual byte[] GetPreamble();
+        public unsafe string GetString(byte* bytes, int byteCount);
+        public virtual string GetString(byte[] bytes);
+        public virtual string GetString(byte[] bytes, int index, int count);
+        public static void RegisterProvider(EncodingProvider provider);
+    }
+    public abstract class EncodingProvider {
+        public EncodingProvider();
+        public abstract Encoding GetEncoding(int codepage);
+        public virtual Encoding GetEncoding(int codepage, EncoderFallback encoderFallback, DecoderFallback decoderFallback);
+        public abstract Encoding GetEncoding(string name);
+        public virtual Encoding GetEncoding(string name, EncoderFallback encoderFallback, DecoderFallback decoderFallback);
+    }
+    public enum NormalizationForm {
+        FormC = 1,
+        FormD = 2,
+        FormKC = 5,
+        FormKD = 6,
+    }
+    public sealed class StringBuilder {
+        public StringBuilder();
+        public StringBuilder(int capacity);
+        public StringBuilder(int capacity, int maxCapacity);
+        public StringBuilder(string value);
+        public StringBuilder(string value, int capacity);
+        public StringBuilder(string value, int startIndex, int length, int capacity);
+        public int Capacity { get; set; }
+        public int Length { get; set; }
+        public int MaxCapacity { get; }
+        [System.Runtime.CompilerServices.IndexerName("Chars")]
+        public char this[int index] { get; set; }
+        public StringBuilder Append(bool value);
+        public StringBuilder Append(byte value);
+        public StringBuilder Append(char value);
+        public unsafe StringBuilder Append(char* value, int valueCount);
+        public StringBuilder Append(char value, int repeatCount);
+        public StringBuilder Append(char[] value);
+        public StringBuilder Append(char[] value, int startIndex, int charCount);
+        public StringBuilder Append(Decimal value);
+        public StringBuilder Append(double value);
+        public StringBuilder Append(short value);
+        public StringBuilder Append(int value);
+        public StringBuilder Append(long value);
+        public StringBuilder Append(object value);
+        public StringBuilder Append(sbyte value);
+        public StringBuilder Append(float value);
+        public StringBuilder Append(string value);
+        public StringBuilder Append(string value, int startIndex, int count);
+        public StringBuilder Append(ushort value);
+        public StringBuilder Append(uint value);
+        public StringBuilder Append(ulong value);
+        public StringBuilder AppendFormat(IFormatProvider provider, string format, object arg0);
+        public StringBuilder AppendFormat(IFormatProvider provider, string format, object arg0, object arg1);
+        public StringBuilder AppendFormat(IFormatProvider provider, string format, object arg0, object arg1, object arg2);
+        public StringBuilder AppendFormat(IFormatProvider provider, string format, params object[] args);
+        public StringBuilder AppendFormat(string format, object arg0);
+        public StringBuilder AppendFormat(string format, object arg0, object arg1);
+        public StringBuilder AppendFormat(string format, object arg0, object arg1, object arg2);
+        public StringBuilder AppendFormat(string format, params object[] args);
+        public StringBuilder AppendLine();
+        public StringBuilder AppendLine(string value);
+        public StringBuilder Clear();
+        public void CopyTo(int sourceIndex, char[] destination, int destinationIndex, int count);
+        public int EnsureCapacity(int capacity);
+        public bool Equals(StringBuilder sb);
+        public StringBuilder Insert(int index, bool value);
+        public StringBuilder Insert(int index, byte value);
+        public StringBuilder Insert(int index, char value);
+        public StringBuilder Insert(int index, char[] value);
+        public StringBuilder Insert(int index, char[] value, int startIndex, int charCount);
+        public StringBuilder Insert(int index, Decimal value);
+        public StringBuilder Insert(int index, double value);
+        public StringBuilder Insert(int index, short value);
+        public StringBuilder Insert(int index, int value);
+        public StringBuilder Insert(int index, long value);
+        public StringBuilder Insert(int index, object value);
+        public StringBuilder Insert(int index, sbyte value);
+        public StringBuilder Insert(int index, float value);
+        public StringBuilder Insert(int index, string value);
+        public StringBuilder Insert(int index, string value, int count);
+        public StringBuilder Insert(int index, ushort value);
+        public StringBuilder Insert(int index, uint value);
+        public StringBuilder Insert(int index, ulong value);
+        public StringBuilder Remove(int startIndex, int length);
+        public StringBuilder Replace(char oldChar, char newChar);
+        public StringBuilder Replace(char oldChar, char newChar, int startIndex, int count);
+        public StringBuilder Replace(string oldValue, string newValue);
+        public StringBuilder Replace(string oldValue, string newValue, int startIndex, int count);
+        public override string ToString();
+        public string ToString(int startIndex, int length);
+    }
+    public class UnicodeEncoding : Encoding {
+        public UnicodeEncoding();
+        public UnicodeEncoding(bool bigEndian, bool byteOrderMark);
+        public UnicodeEncoding(bool bigEndian, bool byteOrderMark, bool throwOnInvalidBytes);
+        public override bool Equals(object value);
+        public unsafe override int GetByteCount(char* chars, int count);
+        public override int GetByteCount(char[] chars, int index, int count);
+        public override int GetByteCount(string s);
+        public unsafe override int GetBytes(char* chars, int charCount, byte* bytes, int byteCount);
+        public override int GetBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public override int GetBytes(string s, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public unsafe override int GetCharCount(byte* bytes, int count);
+        public override int GetCharCount(byte[] bytes, int index, int count);
+        public unsafe override int GetChars(byte* bytes, int byteCount, char* chars, int charCount);
+        public override int GetChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex);
+        public override Decoder GetDecoder();
+        public override Encoder GetEncoder();
+        public override int GetHashCode();
+        public override int GetMaxByteCount(int charCount);
+        public override int GetMaxCharCount(int byteCount);
+        public override byte[] GetPreamble();
+        public override string GetString(byte[] bytes, int index, int count);
+    }
+    public sealed class UTF32Encoding : Encoding {
+        public UTF32Encoding();
+        public UTF32Encoding(bool bigEndian, bool byteOrderMark);
+        public UTF32Encoding(bool bigEndian, bool byteOrderMark, bool throwOnInvalidCharacters);
+        public override bool Equals(object value);
+        public unsafe override int GetByteCount(char* chars, int count);
+        public override int GetByteCount(char[] chars, int index, int count);
+        public override int GetByteCount(string s);
+        public unsafe override int GetBytes(char* chars, int charCount, byte* bytes, int byteCount);
+        public override int GetBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public override int GetBytes(string s, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public unsafe override int GetCharCount(byte* bytes, int count);
+        public override int GetCharCount(byte[] bytes, int index, int count);
+        public unsafe override int GetChars(byte* bytes, int byteCount, char* chars, int charCount);
+        public override int GetChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex);
+        public override Decoder GetDecoder();
+        public override Encoder GetEncoder();
+        public override int GetHashCode();
+        public override int GetMaxByteCount(int charCount);
+        public override int GetMaxCharCount(int byteCount);
+        public override byte[] GetPreamble();
+        public override string GetString(byte[] bytes, int index, int count);
+    }
+    public class UTF7Encoding : Encoding {
+        public UTF7Encoding();
+        public UTF7Encoding(bool allowOptionals);
+        public override bool Equals(object value);
+        public unsafe override int GetByteCount(char* chars, int count);
+        public override int GetByteCount(char[] chars, int index, int count);
+        public override int GetByteCount(string s);
+        public unsafe override int GetBytes(char* chars, int charCount, byte* bytes, int byteCount);
+        public override int GetBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public override int GetBytes(string s, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public unsafe override int GetCharCount(byte* bytes, int count);
+        public override int GetCharCount(byte[] bytes, int index, int count);
+        public unsafe override int GetChars(byte* bytes, int byteCount, char* chars, int charCount);
+        public override int GetChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex);
+        public override Decoder GetDecoder();
+        public override Encoder GetEncoder();
+        public override int GetHashCode();
+        public override int GetMaxByteCount(int charCount);
+        public override int GetMaxCharCount(int byteCount);
+        public override string GetString(byte[] bytes, int index, int count);
+    }
+    public class UTF8Encoding : Encoding {
+        public UTF8Encoding();
+        public UTF8Encoding(bool encoderShouldEmitUTF8Identifier);
+        public UTF8Encoding(bool encoderShouldEmitUTF8Identifier, bool throwOnInvalidBytes);
+        public override bool Equals(object value);
+        public unsafe override int GetByteCount(char* chars, int count);
+        public override int GetByteCount(char[] chars, int index, int count);
+        public override int GetByteCount(string chars);
+        public unsafe override int GetBytes(char* chars, int charCount, byte* bytes, int byteCount);
+        public override int GetBytes(char[] chars, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public override int GetBytes(string s, int charIndex, int charCount, byte[] bytes, int byteIndex);
+        public unsafe override int GetCharCount(byte* bytes, int count);
+        public override int GetCharCount(byte[] bytes, int index, int count);
+        public unsafe override int GetChars(byte* bytes, int byteCount, char* chars, int charCount);
+        public override int GetChars(byte[] bytes, int byteIndex, int byteCount, char[] chars, int charIndex);
+        public override Decoder GetDecoder();
+        public override Encoder GetEncoder();
+        public override int GetHashCode();
+        public override int GetMaxByteCount(int charCount);
+        public override int GetMaxCharCount(int byteCount);
+        public override byte[] GetPreamble();
+        public override string GetString(byte[] bytes, int index, int count);
+    }
+}
```

