# System.Reflection.Metadata.Ecma335

``` diff
 namespace System.Reflection.Metadata.Ecma335 {
+    public struct ArrayShapeEncoder {
+        public ArrayShapeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Shape(int rank, ImmutableArray<int> sizes, ImmutableArray<int> lowerBounds);
+    }
+    public struct BlobEncoder {
+        public BlobEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void CustomAttributeSignature(Action<FixedArgumentsEncoder> fixedArguments, Action<CustomAttributeNamedArgumentsEncoder> namedArguments);
+        public void CustomAttributeSignature(out FixedArgumentsEncoder fixedArguments, out CustomAttributeNamedArgumentsEncoder namedArguments);
+        public SignatureTypeEncoder FieldSignature();
+        public LocalVariablesEncoder LocalVariableSignature(int variableCount);
+        public MethodSignatureEncoder MethodSignature(SignatureCallingConvention convention=(SignatureCallingConvention)(0), int genericParameterCount=0, bool isInstanceMethod=false);
+        public GenericTypeArgumentsEncoder MethodSpecificationSignature(int genericArgumentCount);
+        public NamedArgumentsEncoder PermissionSetArguments(int argumentCount);
+        public PermissionSetEncoder PermissionSetBlob(int attributeCount);
+        public MethodSignatureEncoder PropertySignature(bool isInstanceProperty=false);
+        public SignatureTypeEncoder TypeSpecificationSignature();
+    }
+    public static class CodedIndex {
+        public static int CustomAttributeType(EntityHandle handle);
+        public static int HasConstant(EntityHandle handle);
+        public static int HasCustomAttribute(EntityHandle handle);
+        public static int HasCustomDebugInformation(EntityHandle handle);
+        public static int HasDeclSecurity(EntityHandle handle);
+        public static int HasFieldMarshal(EntityHandle handle);
+        public static int HasSemantics(EntityHandle handle);
+        public static int Implementation(EntityHandle handle);
+        public static int MemberForwarded(EntityHandle handle);
+        public static int MemberRefParent(EntityHandle handle);
+        public static int MethodDefOrRef(EntityHandle handle);
+        public static int ResolutionScope(EntityHandle handle);
+        public static int TypeDefOrRef(EntityHandle handle);
+        public static int TypeDefOrRefOrSpec(EntityHandle handle);
+        public static int TypeOrMethodDef(EntityHandle handle);
+    }
+    public sealed class ControlFlowBuilder {
+        public ControlFlowBuilder();
+        public void AddCatchRegion(LabelHandle tryStart, LabelHandle tryEnd, LabelHandle handlerStart, LabelHandle handlerEnd, EntityHandle catchType);
+        public void AddFaultRegion(LabelHandle tryStart, LabelHandle tryEnd, LabelHandle handlerStart, LabelHandle handlerEnd);
+        public void AddFilterRegion(LabelHandle tryStart, LabelHandle tryEnd, LabelHandle handlerStart, LabelHandle handlerEnd, LabelHandle filterStart);
+        public void AddFinallyRegion(LabelHandle tryStart, LabelHandle tryEnd, LabelHandle handlerStart, LabelHandle handlerEnd);
+    }
+    public struct CustomAttributeArrayTypeEncoder {
+        public CustomAttributeArrayTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomAttributeElementTypeEncoder ElementType();
+        public void ObjectArray();
+    }
+    public struct CustomAttributeElementTypeEncoder {
+        public CustomAttributeElementTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Boolean();
+        public void Byte();
+        public void Char();
+        public void Double();
+        public void Enum(string enumTypeName);
+        public void Int16();
+        public void Int32();
+        public void Int64();
+        public void PrimitiveType(PrimitiveSerializationTypeCode type);
+        public void SByte();
+        public void Single();
+        public void String();
+        public void SystemType();
+        public void UInt16();
+        public void UInt32();
+        public void UInt64();
+    }
+    public struct CustomAttributeNamedArgumentsEncoder {
+        public CustomAttributeNamedArgumentsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public NamedArgumentsEncoder Count(int count);
+    }
+    public struct CustomModifiersEncoder {
+        public CustomModifiersEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomModifiersEncoder AddModifier(EntityHandle type, bool isOptional);
+    }
+    public struct ExceptionRegionEncoder {
+        public BlobBuilder Builder { get; }
+        public bool HasSmallFormat { get; }
+        public ExceptionRegionEncoder Add(ExceptionRegionKind kind, int tryOffset, int tryLength, int handlerOffset, int handlerLength, EntityHandle catchType=null, int filterOffset=0);
+        public ExceptionRegionEncoder AddCatch(int tryOffset, int tryLength, int handlerOffset, int handlerLength, EntityHandle catchType);
+        public ExceptionRegionEncoder AddFault(int tryOffset, int tryLength, int handlerOffset, int handlerLength);
+        public ExceptionRegionEncoder AddFilter(int tryOffset, int tryLength, int handlerOffset, int handlerLength, int filterOffset);
+        public ExceptionRegionEncoder AddFinally(int tryOffset, int tryLength, int handlerOffset, int handlerLength);
+        public static bool IsSmallExceptionRegion(int startOffset, int length);
+        public static bool IsSmallRegionCount(int exceptionRegionCount);
+    }
+    public struct FixedArgumentsEncoder {
+        public FixedArgumentsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public LiteralEncoder AddArgument();
+    }
+    public enum FunctionPointerAttributes {
+        HasExplicitThis = 96,
+        HasThis = 32,
+        None = 0,
+    }
+    public struct GenericTypeArgumentsEncoder {
+        public GenericTypeArgumentsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public SignatureTypeEncoder AddArgument();
+    }
+    public struct InstructionEncoder {
+        public InstructionEncoder(BlobBuilder codeBuilder, ControlFlowBuilder controlFlowBuilder=null);
+        public BlobBuilder CodeBuilder { get; }
+        public ControlFlowBuilder ControlFlowBuilder { get; }
+        public int Offset { get; }
+        public void Branch(ILOpCode code, LabelHandle label);
+        public void Call(EntityHandle methodHandle);
+        public void Call(MemberReferenceHandle methodHandle);
+        public void Call(MethodDefinitionHandle methodHandle);
+        public void Call(MethodSpecificationHandle methodHandle);
+        public void CallIndirect(StandaloneSignatureHandle signature);
+        public LabelHandle DefineLabel();
+        public void LoadArgument(int argumentIndex);
+        public void LoadArgumentAddress(int argumentIndex);
+        public void LoadConstantI4(int value);
+        public void LoadConstantI8(long value);
+        public void LoadConstantR4(float value);
+        public void LoadConstantR8(double value);
+        public void LoadLocal(int slotIndex);
+        public void LoadLocalAddress(int slotIndex);
+        public void LoadString(UserStringHandle handle);
+        public void MarkLabel(LabelHandle label);
+        public void OpCode(ILOpCode code);
+        public void StoreArgument(int argumentIndex);
+        public void StoreLocal(int slotIndex);
+        public void Token(int token);
+        public void Token(EntityHandle handle);
+    }
+    public struct LabelHandle : IEquatable<LabelHandle> {
+        public int Id { get; }
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(LabelHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(LabelHandle left, LabelHandle right);
+        public static bool operator !=(LabelHandle left, LabelHandle right);
+    }
+    public struct LiteralEncoder {
+        public LiteralEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public ScalarEncoder Scalar();
+        public void TaggedScalar(Action<CustomAttributeElementTypeEncoder> type, Action<ScalarEncoder> scalar);
+        public void TaggedScalar(out CustomAttributeElementTypeEncoder type, out ScalarEncoder scalar);
+        public void TaggedVector(Action<CustomAttributeArrayTypeEncoder> arrayType, Action<VectorEncoder> vector);
+        public void TaggedVector(out CustomAttributeArrayTypeEncoder arrayType, out VectorEncoder vector);
+        public VectorEncoder Vector();
+    }
+    public struct LiteralsEncoder {
+        public LiteralsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public LiteralEncoder AddLiteral();
+    }
+    public struct LocalVariablesEncoder {
+        public LocalVariablesEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public LocalVariableTypeEncoder AddVariable();
+    }
+    public struct LocalVariableTypeEncoder {
+        public LocalVariableTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomModifiersEncoder CustomModifiers();
+        public SignatureTypeEncoder Type(bool isByRef=false, bool isPinned=false);
+        public void TypedReference();
+    }
+    public sealed class MetadataBuilder {
+        public MetadataBuilder(int userStringHeapStartOffset=0, int stringHeapStartOffset=0, int blobHeapStartOffset=0, int guidHeapStartOffset=0);
+        public AssemblyDefinitionHandle AddAssembly(StringHandle name, Version version, StringHandle culture, BlobHandle publicKey, AssemblyFlags flags, AssemblyHashAlgorithm hashAlgorithm);
+        public AssemblyFileHandle AddAssemblyFile(StringHandle name, BlobHandle hashValue, bool containsMetadata);
+        public AssemblyReferenceHandle AddAssemblyReference(StringHandle name, Version version, StringHandle culture, BlobHandle publicKeyOrToken, AssemblyFlags flags, BlobHandle hashValue);
+        public ConstantHandle AddConstant(EntityHandle parent, object value);
+        public CustomAttributeHandle AddCustomAttribute(EntityHandle parent, EntityHandle constructor, BlobHandle value);
+        public CustomDebugInformationHandle AddCustomDebugInformation(EntityHandle parent, GuidHandle kind, BlobHandle value);
+        public DeclarativeSecurityAttributeHandle AddDeclarativeSecurityAttribute(EntityHandle parent, DeclarativeSecurityAction action, BlobHandle permissionSet);
+        public DocumentHandle AddDocument(BlobHandle name, GuidHandle hashAlgorithm, BlobHandle hash, GuidHandle language);
+        public void AddEncLogEntry(EntityHandle entity, EditAndContinueOperation code);
+        public void AddEncMapEntry(EntityHandle entity);
+        public EventDefinitionHandle AddEvent(EventAttributes attributes, StringHandle name, EntityHandle type);
+        public void AddEventMap(TypeDefinitionHandle declaringType, EventDefinitionHandle eventList);
+        public ExportedTypeHandle AddExportedType(TypeAttributes attributes, StringHandle @namespace, StringHandle name, EntityHandle implementation, int typeDefinitionId);
+        public FieldDefinitionHandle AddFieldDefinition(FieldAttributes attributes, StringHandle name, BlobHandle signature);
+        public void AddFieldLayout(FieldDefinitionHandle field, int offset);
+        public void AddFieldRelativeVirtualAddress(FieldDefinitionHandle field, int offset);
+        public GenericParameterHandle AddGenericParameter(EntityHandle parent, GenericParameterAttributes attributes, StringHandle name, int index);
+        public GenericParameterConstraintHandle AddGenericParameterConstraint(GenericParameterHandle genericParameter, EntityHandle constraint);
+        public ImportScopeHandle AddImportScope(ImportScopeHandle parentScope, BlobHandle imports);
+        public InterfaceImplementationHandle AddInterfaceImplementation(TypeDefinitionHandle type, EntityHandle implementedInterface);
+        public LocalConstantHandle AddLocalConstant(StringHandle name, BlobHandle signature);
+        public LocalScopeHandle AddLocalScope(MethodDefinitionHandle method, ImportScopeHandle importScope, LocalVariableHandle variableList, LocalConstantHandle constantList, int startOffset, int length);
+        public LocalVariableHandle AddLocalVariable(LocalVariableAttributes attributes, int index, StringHandle name);
+        public ManifestResourceHandle AddManifestResource(ManifestResourceAttributes attributes, StringHandle name, EntityHandle implementation, uint offset);
+        public void AddMarshallingDescriptor(EntityHandle parent, BlobHandle descriptor);
+        public MemberReferenceHandle AddMemberReference(EntityHandle parent, StringHandle name, BlobHandle signature);
+        public MethodDebugInformationHandle AddMethodDebugInformation(DocumentHandle document, BlobHandle sequencePoints);
+        public MethodDefinitionHandle AddMethodDefinition(MethodAttributes attributes, MethodImplAttributes implAttributes, StringHandle name, BlobHandle signature, int bodyOffset, ParameterHandle parameterList);
+        public MethodImplementationHandle AddMethodImplementation(TypeDefinitionHandle type, EntityHandle methodBody, EntityHandle methodDeclaration);
+        public void AddMethodImport(MethodDefinitionHandle method, MethodImportAttributes attributes, StringHandle name, ModuleReferenceHandle module);
+        public void AddMethodSemantics(EntityHandle association, MethodSemanticsAttributes semantics, MethodDefinitionHandle methodDefinition);
+        public MethodSpecificationHandle AddMethodSpecification(EntityHandle method, BlobHandle instantiation);
+        public ModuleDefinitionHandle AddModule(int generation, StringHandle moduleName, GuidHandle mvid, GuidHandle encId, GuidHandle encBaseId);
+        public ModuleReferenceHandle AddModuleReference(StringHandle moduleName);
+        public void AddNestedType(TypeDefinitionHandle type, TypeDefinitionHandle enclosingType);
+        public ParameterHandle AddParameter(ParameterAttributes attributes, StringHandle name, int sequenceNumber);
+        public PropertyDefinitionHandle AddProperty(PropertyAttributes attributes, StringHandle name, BlobHandle signature);
+        public void AddPropertyMap(TypeDefinitionHandle declaringType, PropertyDefinitionHandle propertyList);
+        public StandaloneSignatureHandle AddStandaloneSignature(BlobHandle signature);
+        public void AddStateMachineMethod(MethodDefinitionHandle moveNextMethod, MethodDefinitionHandle kickoffMethod);
+        public TypeDefinitionHandle AddTypeDefinition(TypeAttributes attributes, StringHandle @namespace, StringHandle name, EntityHandle baseType, FieldDefinitionHandle fieldList, MethodDefinitionHandle methodList);
+        public void AddTypeLayout(TypeDefinitionHandle type, ushort packingSize, uint size);
+        public TypeReferenceHandle AddTypeReference(EntityHandle resolutionScope, StringHandle @namespace, StringHandle name);
+        public TypeSpecificationHandle AddTypeSpecification(BlobHandle signature);
+        public BlobHandle GetOrAddBlob(byte[] value);
+        public BlobHandle GetOrAddBlob(ImmutableArray<byte> value);
+        public BlobHandle GetOrAddBlob(BlobBuilder value);
+        public BlobHandle GetOrAddBlobUTF16(string value);
+        public BlobHandle GetOrAddBlobUTF8(string value, bool allowUnpairedSurrogates=true);
+        public BlobHandle GetOrAddConstantBlob(object value);
+        public BlobHandle GetOrAddDocumentName(string value);
+        public GuidHandle GetOrAddGuid(Guid guid);
+        public StringHandle GetOrAddString(string value);
+        public UserStringHandle GetOrAddUserString(string value);
+        public int GetRowCount(TableIndex table);
+        public ImmutableArray<int> GetRowCounts();
+        public ReservedBlob<GuidHandle> ReserveGuid();
+        public ReservedBlob<UserStringHandle> ReserveUserString(int length);
+        public void SetCapacity(HeapIndex heap, int byteCount);
+        public void SetCapacity(TableIndex table, int rowCount);
+    }
     public static class MetadataReaderExtensions {
+        public static SignatureTypeKind ResolveSignatureTypeKind(this MetadataReader reader, EntityHandle typeHandle, byte rawTypeKind);
     }
+    public sealed class MetadataRootBuilder {
+        public MetadataRootBuilder(MetadataBuilder tablesAndHeaps, string metadataVersion=null, bool suppressValidation=false);
+        public string MetadataVersion { get; }
+        public MetadataSizes Sizes { get; }
+        public bool SuppressValidation { get; }
+        public void Serialize(BlobBuilder builder, int methodBodyStreamRva, int mappedFieldDataStreamRva);
+    }
+    public sealed class MetadataSizes {
+        public ImmutableArray<int> ExternalRowCounts { get; }
+        public ImmutableArray<int> HeapSizes { get; }
+        public ImmutableArray<int> RowCounts { get; }
+        public int GetAlignedHeapSize(HeapIndex index);
+    }
     public static class MetadataTokens {
+        public static int GetHeapOffset(BlobHandle handle);
+        public static int GetHeapOffset(GuidHandle handle);
+        public static int GetHeapOffset(StringHandle handle);
+        public static int GetHeapOffset(UserStringHandle handle);
     }
+    public enum MethodBodyAttributes {
+        InitLocals = 1,
+        None = 0,
+    }
+    public struct MethodBodyStreamEncoder {
+        public MethodBodyStreamEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public MethodBodyStreamEncoder.MethodBody AddMethodBody(int codeSize, int maxStack=8, int exceptionRegionCount=0, bool hasSmallExceptionRegions=true, StandaloneSignatureHandle localVariablesSignature=null, MethodBodyAttributes attributes=(MethodBodyAttributes)(1));
+        public int AddMethodBody(InstructionEncoder instructionEncoder, int maxStack=8, StandaloneSignatureHandle localVariablesSignature=null, MethodBodyAttributes attributes=(MethodBodyAttributes)(1));
+        public struct MethodBody {
+            public ExceptionRegionEncoder ExceptionRegions { get; }
+            public Blob Instructions { get; }
+            public int Offset { get; }
+        }
+    }
+    public struct MethodSignatureEncoder {
+        public MethodSignatureEncoder(BlobBuilder builder, bool hasVarArgs);
+        public BlobBuilder Builder { get; }
+        public bool HasVarArgs { get; }
+        public void Parameters(int parameterCount, Action<ReturnTypeEncoder> returnType, Action<ParametersEncoder> parameters);
+        public void Parameters(int parameterCount, out ReturnTypeEncoder returnType, out ParametersEncoder parameters);
+    }
+    public struct NamedArgumentsEncoder {
+        public NamedArgumentsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void AddArgument(bool isField, Action<NamedArgumentTypeEncoder> type, Action<NameEncoder> name, Action<LiteralEncoder> literal);
+        public void AddArgument(bool isField, out NamedArgumentTypeEncoder type, out NameEncoder name, out LiteralEncoder literal);
+    }
+    public struct NamedArgumentTypeEncoder {
+        public NamedArgumentTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Object();
+        public CustomAttributeElementTypeEncoder ScalarType();
+        public CustomAttributeArrayTypeEncoder SZArray();
+    }
+    public struct NameEncoder {
+        public NameEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Name(string name);
+    }
+    public struct ParametersEncoder {
+        public ParametersEncoder(BlobBuilder builder, bool hasVarArgs=false);
+        public BlobBuilder Builder { get; }
+        public bool HasVarArgs { get; }
+        public ParameterTypeEncoder AddParameter();
+        public ParametersEncoder StartVarArgs();
+    }
+    public struct ParameterTypeEncoder {
+        public ParameterTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomModifiersEncoder CustomModifiers();
+        public SignatureTypeEncoder Type(bool isByRef=false);
+        public void TypedReference();
+    }
+    public struct PermissionSetEncoder {
+        public PermissionSetEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public PermissionSetEncoder AddPermission(string typeName, ImmutableArray<byte> encodedArguments);
+        public PermissionSetEncoder AddPermission(string typeName, BlobBuilder encodedArguments);
+    }
+    public sealed class PortablePdbBuilder {
+        public PortablePdbBuilder(MetadataBuilder tablesAndHeaps, ImmutableArray<int> typeSystemRowCounts, MethodDefinitionHandle entryPoint, Func<IEnumerable<Blob>, BlobContentId> idProvider=null);
+        public ushort FormatVersion { get; }
+        public Func<IEnumerable<Blob>, BlobContentId> IdProvider { get; }
+        public string MetadataVersion { get; }
+        public BlobContentId Serialize(BlobBuilder builder);
+    }
+    public struct ReturnTypeEncoder {
+        public ReturnTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomModifiersEncoder CustomModifiers();
+        public SignatureTypeEncoder Type(bool isByRef=false);
+        public void TypedReference();
+        public void Void();
+    }
+    public struct ScalarEncoder {
+        public ScalarEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Constant(object value);
+        public void NullArray();
+        public void SystemType(string serializedTypeName);
+    }
+    public struct SignatureDecoder<TType> {
+        public SignatureDecoder(ISignatureTypeProvider<TType> provider, MetadataReader metadataReader=null);
+        public TType DecodeFieldSignature(ref BlobReader blobReader);
+        public ImmutableArray<TType> DecodeLocalSignature(ref BlobReader blobReader);
+        public MethodSignature<TType> DecodeMethodSignature(ref BlobReader blobReader);
+        public ImmutableArray<TType> DecodeMethodSpecificationSignature(ref BlobReader blobReader);
+        public TType DecodeType(ref BlobReader blobReader, bool allowTypeSpecifications=false);
+    }
+    public struct SignatureTypeEncoder {
+        public SignatureTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Array(Action<SignatureTypeEncoder> elementType, Action<ArrayShapeEncoder> arrayShape);
+        public void Array(out SignatureTypeEncoder elementType, out ArrayShapeEncoder arrayShape);
+        public void Boolean();
+        public void Byte();
+        public void Char();
+        public CustomModifiersEncoder CustomModifiers();
+        public void Double();
+        public MethodSignatureEncoder FunctionPointer(SignatureCallingConvention convention=(SignatureCallingConvention)(0), FunctionPointerAttributes attributes=(FunctionPointerAttributes)(0), int genericParameterCount=0);
+        public GenericTypeArgumentsEncoder GenericInstantiation(EntityHandle genericType, int genericArgumentCount, bool isValueType);
+        public void GenericMethodTypeParameter(int parameterIndex);
+        public void GenericTypeParameter(int parameterIndex);
+        public void Int16();
+        public void Int32();
+        public void Int64();
+        public void IntPtr();
+        public void Object();
+        public SignatureTypeEncoder Pointer();
+        public void PrimitiveType(PrimitiveTypeCode type);
+        public void SByte();
+        public void Single();
+        public void String();
+        public SignatureTypeEncoder SZArray();
+        public void Type(EntityHandle type, bool isValueType);
+        public void UInt16();
+        public void UInt32();
+        public void UInt64();
+        public void UIntPtr();
+        public void VoidPointer();
+    }
+    public struct VectorEncoder {
+        public VectorEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public LiteralsEncoder Count(int count);
+    }
 }
```

