# 1.1.0 Preview 1 Known Issues

This document lists known issues for *.NET Core 1.1.0 Preview 1* and *.NET Core SDK 1.0.0 Preview 2.1* which may be encountered during usage.

## Previous versions of the Host Resolver are removed

Everything about .NET Core is designed to be side-by-side but there is an issue with the Preview 1 installers which removes previous versions of the Host Resolver (dotnet/host/fxr). The Preview 1 version is compatible with previous releases and you should see no changes in behavior with Preview 1 installed. However, if 1.1 is uninstalled the Host Resolver will be removed and dotnet commands will fail. Re-installing the latest released [.NET Core SDK](https://www.microsoft.com/net/download) will resolve the issue.

## Visual Studio unable to find the SDK

Installing the SDK will create new side-by-side directories for each version under \Program Files\dotnet\sdk. Generally it should be safe to remove older versions but there is an issue in Visual Studio which prevents it from finding this Preview if previous versions are uninstalled. The work around is to either not remove the previous versions or rename the directory.

- Directory name as installed is 1.0.0-preview2.1-003155
- Rename from ***preview2.1*** to ***preview2-1***

This will be resolved in the final 1.1.0 release and is tracked by [CLI Issue 4466](https://github.com/dotnet/cli/issues/4466).


## C++ Math libraries can behave differently across platforms

This is expected behavior. See discussion in [coreclr issue 4318](https://github.com/dotnet/coreclr/issues/4318)