# .NET Core 1.1.12

.NET Core 1.1.12 comprises:

* .NET Core Runtime 1.1.12
* .NET Core SDK 1.1.13

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/1.1/1.1.12.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                                   | SDK Binaries<sup>1</sup>                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-dev-win-x86.exe] \| [x64][dotnet-dev-win-x64.exe] | [x86][dotnet-dev-win-x86.zip] \| [x64][dotnet-dev-win-x64.zip] | [x86][dotnet-win-x86.exe] \| [x64][dotnet-win-x64.exe] | [x86][dotnet-win-x86.zip] \| [x64][dotnet-win-x64.zip] | [Hosting Bundle][DotNetCore-WindowsHosting.exe]<sup>1</sup> |
| macOS     | [x64][dotnet-dev-osx-x64.pkg]  | [x64][dotnet-dev-osx-x64.tar.gz]     | [x64][dotnet-osx-x64.pkg] | [x64][dotnet-osx-x64.tar.gz] | - |
| CentOS 7  | - | [x64][dotnet-dev-centos-x64.tar.gz] | - | [x64][dotnet-centos-x64.tar.gz]  | - |
| Debian 9  | - | [x64][dotnet-dev-debian.9-x64.tar.gz] | - | [x64][dotnet-debian.9-x64.tar.gz]  | - |
| Fedora 27   | -                                                | [x64][dotnet-dev-fedora.27-x64.tar.gz] | -                                                        | [x64][dotnet-fedora.27-x64.tar.gz] | - |
| Fedora 28   | -                                                | [x64][dotnet-dev-fedora.28-x64.tar.gz] | -                                                        | [x64][dotnet-fedora.28-x64.tar.gz] | - |
| RHEL 7    | -                                                | [x64][dotnet-dev-rhel-x64.tar.gz]                    | -                                                        | [x64][dotnet-rhel-x64.tar.gz] | - |
| Ubuntu 14.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu-x64.tar.gz]       | - | [x64][dotnet-ubuntu-x64.tar.gz] | - |
| Ubuntu 16.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.16.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.16.04-x64.tar.gz] | - |
| Ubuntu 18.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.18.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.18.04-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][coreclr-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | - |

1. Includes the .NET Core and ASP.NET Core runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

In your command prompt, run the following commands:

```bash
# Ubuntu 14.04, 16,04 and 18.04
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.13
```

### Run applications

If you only need to run existing applications, run the following command.

```bash
# Ubuntu 14.04, 16,04 and 18.04
sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.1.12
```

## Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$HOME/dotnet
```
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/1.1/1.1.12.md

[dotnet-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60439f54-4dd4-4128-8c3e-aaa346e54f63/9eed8f5fae4265f32ab4c859bfcbe720/dotnet-centos-x64.1.1.12.tar.gz
[dotnet-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e85cb6b-7a05-4766-b230-372df3ab80b0/6fa4bed7440dda5a10ee961d14c0def3/dotnet-debian.9-x64.1.1.12.tar.gz
[dotnet-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58c83eae-9a1a-4257-8b08-e72c6ddf8ed7/8298ff6440d2109e1e5991582e9a1331/dotnet-fedora.27-x64.1.1.12.tar.gz
[dotnet-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06012b3a-9c4d-41b0-b61b-6b2fedcddec2/9d0f39dcd9198f951fa735495d00112c/dotnet-fedora.28-x64.1.1.12.tar.gz
[dotnet-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f965480-976e-4e85-b80e-c7c39fbb8080/fffabde4aff2a525359b645dea57a6c6/dotnet-opensuse.42.3-x64.1.1.12.tar.gz
[dotnet-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c6b8bdeb-27e4-4149-9f5b-164ac344d48e/8e3e3c41f97317ea9d4b15250a092419/dotnet-osx-x64.1.1.12.pkg
[dotnet-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2dc4619f-cec3-4159-a061-ea288cb69f96/e7558401471ddc4cb8168a4bff711114/dotnet-osx-x64.1.1.12.tar.gz
[dotnet-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4992fb8-592e-474f-8834-e3a64e015b6e/955fe39bdb8603a06bb70d7a2cc0743d/dotnet-rhel-x64.1.1.12.tar.gz
[dotnet-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d75ff7e-dbcb-4602-b788-e5d51e193b26/19bc8f49ee59468e22fa800462ab17e3/dotnet-ubuntu-x64.1.1.12.tar.gz
[dotnet-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca6f8aeb-711c-4cb6-ab40-7bf687bf234f/402d838eb8a4c5a97c196e596883e267/dotnet-ubuntu.16.04-x64.1.1.12.tar.gz
[dotnet-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a84b8d06-915a-4409-8c64-320424d1d822/3e9af619592ab59f0831cdd67b4c1f19/dotnet-ubuntu.18.04-x64.1.1.12.tar.gz
[dotnet-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6f175fa3-5578-47e8-a03e-eb07a7bc619e/d727018b0a1f428377a2de6d6d30480f/dotnet-win-x64.1.1.12.exe
[dotnet-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/96c27dff-44b8-4ecd-bcd4-c56527b80572/be6d454ffa6346b70631159d1170352b/dotnet-win-x64.1.1.12.zip
[dotnet-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d776cddb-c401-4b85-b941-5ef02d4b4169/cdcf84cdc77ba08f66fdb3ff93e4675a/dotnet-win-x86.1.1.12.exe
[dotnet-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/02f966a0-edaa-4930-ad98-ea742670270d/dcc2b2e1cd7032625e2485930ca495bf/dotnet-win-x86.1.1.12.zip
[DotNetCore-WindowsHosting.exe]: https://download.visualstudio.microsoft.com/download/pr/1110274e-cd5c-4b82-8a3f-c71937d603b9/f507bbb5a47ca15cadf0d55efcdb5176/dotnetcore.1.0.15_1.1.12-windowshosting.exe
[dotnet-dev-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9032949d-db66-46bc-9548-7e118801e1e2/e505beee873cfa56413c055451cccdf6/dotnet-dev-centos-x64.1.1.13.tar.gz
[dotnet-dev-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93df87b2-f685-4966-a35b-bc26daac4d51/16417d162121cf54c2bed343ca8b79f6/dotnet-dev-debian.9-x64.1.1.13.tar.gz
[dotnet-dev-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0e8c5253-9a17-4181-af70-a8db26024196/20d14303a038aaf353ad4205d9473377/dotnet-dev-fedora.27-x64.1.1.13.tar.gz
[dotnet-dev-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/390e5457-7bd9-4669-99a1-dd61e47829d5/f4c1886ce93eea9b433a538c9e2a23d8/dotnet-dev-fedora.28-x64.1.1.13.tar.gz
[dotnet-dev-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ff0fc37-7937-4879-b09e-c4c986a1fbfd/0196f65e2a761fea9d50049f8588e704/dotnet-dev-opensuse.42.3-x64.1.1.13.tar.gz
[dotnet-dev-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/294628ef-c677-4f2b-9b32-965d262bd9b0/75b3465b93889ec468521866eb1eb2a2/dotnet-dev-osx-x64.1.1.13.pkg
[dotnet-dev-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7fdeaba7-cf01-4ecf-905c-5192424a9357/2b866b907f3b9a33f47fde137b5b7381/dotnet-dev-osx-x64.1.1.13.tar.gz
[dotnet-dev-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad8dba5f-665f-4602-873f-2f315d0f4b07/f653f760ad97620a8561822ba6fcc937/dotnet-dev-rhel-x64.1.1.13.tar.gz
[dotnet-dev-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/904d3146-d148-4f5b-8f96-5c48643e3f37/5769dbfc8cb5341e1a89822354ac4eeb/dotnet-dev-ubuntu-x64.1.1.13.tar.gz
[dotnet-dev-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c37da1a-3307-435c-973f-89b1bad1f31c/d4c2484339d2c888eda9419df8923998/dotnet-dev-ubuntu.16.04-x64.1.1.13.tar.gz
[dotnet-dev-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76a25d74-d4b5-43f7-b9f7-0d0f5ce9e90c/df2bf041d954c283fb08a27fd8a9524e/dotnet-dev-ubuntu.18.04-x64.1.1.13.tar.gz
[dotnet-dev-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1d145015-eb70-4e17-b808-e9fda0910ab3/80b480c8507742d2369c852bfe36eec6/dotnet-dev-win-x64.1.1.13.exe
[dotnet-dev-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/707f0887-b149-4ea1-9f97-7a841526c17e/423ece599bd8c0e2c80558b208b0e6b4/dotnet-dev-win-x64.1.1.13.zip
[dotnet-dev-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/42e527c7-bd17-4c5f-b418-e6bc0ac386c2/87c1a57275d1031139ddd1c48783adb0/dotnet-dev-win-x86.1.1.13.exe
[dotnet-dev-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5e35d95e-a547-4b1f-bdcd-668e5bff05f4/fd3556eddf1063f47ae236d26246df23/dotnet-dev-win-x86.1.1.13.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/83729897-e15b-4b9e-bfff-80d57675b3e9/55aa62a4467a1857f95d1b5b51fdab47/core-setup-1.1.12-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/314025be-f4b7-42bd-a7fe-7021d5d5949d/621672cdc23f62ec92849aec18887b2d/coreclr-1.1.12-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.12-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.13-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/dotnet-core/1.1
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/2019/03/12/net-core-march-2019/