# .NET Core September 2017 Update - Released 9/21/2017

.NET Core 1.0.7, 1.1.4 and SDK 1.1.4 are available for download and usage in your environment.

## Downloads

* [.NET Core 1.0.7](https://github.com/dotnet/core/blob/master/release-notes/download-archives/1.0.7-download.md)
* [.NET Core 1.1.4](https://github.com/dotnet/core/blob/master/release-notes/download-archives/1.1.4-download.md)

After installing the .NET Core SDK 1.1.4, the following command will show that you're running version `1.1.4` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created [dotnet/core #980](https://github.com/dotnet/core/issues/980) for your questions and comments.

## Azure AppServices

Deployment of the September 2017 Update on Azure AppServices is in process. Because AppServices is a high availability service, the deployment is carefully staged across regions over a period of time. Availability will begin in the West US 2 region today and gradually expand to all regions over the next few days.

## September Update Highlights

### High Sierra (macOS 10.13)

The September 2017 Update has been tested on macOS High Sierra to ensure compatibility. Please start an conversation in [dotnet/core #980](https://github.com/dotnet/core/issues/980) if issues are encountered.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 1.1.4 images.

## Fixes in the September 2017 Update

### 1.0.7

#### Core-Setup

* [`[d17d2ac36]`](https://github.com/dotnet/core-setup/pull/2642/commits/d17d2ac36d5682a8f2cb558541e8daaf2dacde65) Specify the CFG flag for Linker for native Binaries built on Windows so that they have the complete CFG configuration details in the binary

#### CoreFX

* [`[63b6bd467]`](https://github.com/dotnet/corefx/pull/21069/commits/63b6bd4676ec3ccb841233c6d808ce99216123e6) Check for openssl version before setting cert callback.
* [`[8d4300f3d]`](https://github.com/dotnet/corefx/pull/21989/commits/8d4300f3ddb25b79b055d42379c48f28a13cb80e) Unable to make https request when Oid lookup takes too long (#21320)
* [`[a077f83c3]`](https://github.com/dotnet/corefx/pull/23060/commits/a077f83c33ac9db70e98cc4c0798bce0b9e57c30) DriveInfo description for macOS High Sierra - System.IO.FileSystem.DriveInfoTests.DriveInfoUnixTests/PropertiesOfValidDrive failed with "Xunit.Sdk.EqualException"
* [`[9052f585f]`](https://github.com/dotnet/corefx/pull/23067/commits/9052f585fd0582d8187a7e0a0cf2f84f172322be) Fix segfaults in release branches for OSX 10.13
* [`[3af071c60]`](https://github.com/dotnet/corefx/pull/23219/commits/3af071c6033b4c9fd62fd088bb086c11fc5946cd) Prevent crash when Openssl's PKCS12_parse function fails
* [`[47d95a608]`](https://github.com/dotnet/corefx/pull/23232/commits/47d95a608513cefd1d91f417857f63101e5a5330) Simplify X509Chain building with OpenSSL

### 1.1.4

#### Core-Setup

* [`[ac50277ce]`](https://github.com/dotnet/core-setup/pull/2643/commits/ac50277ce60b94b08a59bf6495a80cbb4848c537) Specify the CFG flag for Linker for native Binaries built on Windows so that they have the complete CFG configuration details in the binary

#### CoreFX

* [`[63bc3dbff]`](https://github.com/dotnet/corefx/pull/21071/commits/63bc3dbff7754dc225efdb1c392ec0af8c405a5a) Check for openssl version before setting cert callback.
* [`[8e1d50748]`](https://github.com/dotnet/corefx/pull/21737/commits/8e1d507481334132d17aad913b3f8aebdefb5c9e) Backport crypto fixes for High Sierra - System.Security.Cryptography.Encryption.Aes.Tests.AesCipherTests failed with "Interop+AppleCrypto+AppleCommonCryptoCryptographicException"
* [`[454bdeb2e]`](https://github.com/dotnet/corefx/pull/21987/commits/454bdeb2ef477344b8626307892f442bff2a3106) Unable to make https request when Oid lookup takes too long (#21320)
* [`[3d2debcf3]`](https://github.com/dotnet/corefx/pull/23083/commits/3d2debcf3f4fb7ce06f58c0b617348835e9036c8) DriveInfo description for macOS High Sierra - System.IO.FileSystem.DriveInfoTests.DriveInfoUnixTests/PropertiesOfValidDrive failed with "Xunit.Sdk.EqualException"
* [`[3b44fcf84]`](https://github.com/dotnet/corefx/pull/23064/commits/3b44fcf8469dd78267387bc774880a6c6e3b563e) Fix segfaults in release branches for OSX 10.13
* [`[3a3dda967]`](https://github.com/dotnet/corefx/pull/23218/commits/3a3dda967fbebd3d1b58bd7917be277152388fff) Simplify X509Chain building with OpenSSL
* [`[715be49ac]`](https://github.com/dotnet/corefx/pull/23235/commits/715be49ac9595c911508f831469a96bc5d2a8591) IOException during "File.WriteAllText" to the file under NFS on Linux
