# 2.0.0 Preview 1 Known Issues

This document lists known issues for *.NET Core 2.0.0 Preview 1* and *.NET Core SDK 2.0.0 Preview 1* which may be encountered during usage.

## Running 1.0 first run experience after installing 2.0 CLI

[https://github.com/dotnet/cli/issues/6550](https://github.com/dotnet/cli/issues/6550)

This fails because the 1.0 first run shells out two dotnet commands to do dotnet new and dotnet restore. Because this is a simple shell out, the 2.0 CLI ends up being picked up to execute the commands. However, in the 1.0 CLI, we invoke dotnet new passing –f netcoreapp1.0 and netcoreapp1.1 and the 2.0 CLI no longer carries these templates, which causes the command and the whole first run to fail.

### Workarounds

* Run dotnet 1.0 first run experience before installing the 2.0 CLI by simply invoking 'dotnet new' in the command line after installing VS.
* Uninstalling the 2.0 CLI and then running 'dotnet new'.
* Putting a global.json pointing t 1.0 CLI in the root of the drive where you are executing the 1.0 command to trigger first run. Remember to remove it after the first run has been executed.
* Do nothing, in which case the first run will continue to run for 1.0 CLI and restore will hit the web.

## VB and .NET Core

There are a few issues with using VB and .NET Core to be aware of.

### System.Data namespace contains no types warning

[https://github.com/dotnet/sdk/pull/1188](https://github.com/dotnet/sdk/pull/1188)

Creating a console\class library will build successfully but with a warning that System.Data namespace contains no types.

#### Workaround

Adding `<NoWarn>$(NoWarn),40057</NoWarn>` to the project will suppress the warning.

### Packing a VB Library does not work

[https://github.com/NuGet/Home/issues/4886](https://github.com/NuGet/Home/issues/4886)

#### Workaround

Adding `<PackProjectInputFile>$(MSBuildProjectFile)</PackProjectInputFile>` to your `.vbproj` file and then invoking the Pack command will produce a package.

### Unit Test Templates Do Not Exist

Unit test templates don’t exist in Preview 1 because test discovery fails for VB projects. This issue is under investigation and there is no workaround at this time.

### Visual Studio for Mac

There are a [few items to be aware of](https://gist.github.com/mrward/70b8132003ef77d893111ecbea3e2225) if you are using .NET Core 2.0 with Visual Studio for Mac.

### Visual Studio Code

If you want to try .NET Core 2.0 with Visual Studio Code, you will need to use an updated C# Extension.

1. If you haven't already, install [Visual Studio Code](https://code.visualstudio.com).
1. Download the VSIX for the [latest C# Extension](https://github.com/OmniSharp/omnisharp-vscode/releases/download/v1.10.0-beta2/csharp-1.10.0-beta2.vsix).
1. Follow the instructions from [Installing Beta Releases](https://github.com/OmniSharp/omnisharp-vscode/wiki/Installing-Beta-Releases). **Note:** If you already have C# for VS Code installed, you’ll want to uninstall it and relaunch VS Code before installing the beta.

If you try out the C# for VS Code bits and find any issues, please file them at [OmniSharp/omnisharp-vscode](https://github.com/OmniSharp/omnisharp-vscode/issues).
