# .NET Core July 2018 Update - July 10, 2018

.NET Core 2.0.9 is available for download and usage in your environment.

* [Download .NET Core](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.0.9-download.md)

## Blog Round up

* [.NET Core](https://blogs.msdn.microsoft.com/dotnet/)

The .NET Core SDK 2.1 includes .NET Core 2.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1, running `dotnet --version` will show that you're running version `2.1.202` of the .NET Core tools.

`dotnet --info` has been greatly enhanced in .NET Core 2.1 and now provides detailed information on installed .NET Core components.

Your feedback is important and appreciated. We've created an issue at [dotnet/core #/1766](https://github.com/dotnet/core/issues//1766) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the updated images for .NET Core 2.0.9 and .NET Core SDK 2.1.202 and read ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/) for details and insights into using the .NET Core images.

## Azure AppServices

* Deployment of .NET Core 2.0.9 to Azure App Services has begun. It will be available in limited regions today and expected worldwide by the end of the week.

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

.NET Core 2.1 is expected to be declared LTS in the next few months. It is recommended that 2.1 be the default target for projects. .NET Core 2.0 will go out of support October 2018.

### Supported Linux version changes

Fedora 26 and Ubuntu 17.10 will reach end of life in July. This is the last update of .NET Core which will support these versions.

## Notable Changes in 2.0.9

### Microsoft Security Advisory CVE-2018-8356: .NET Core Security Feature Bypass Vulnerability

[CVE-2018-8356: .NET Core Security Feature Bypass Vulnerability](https://github.com/dotnet/announcements/issues/73)

Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a security feature bypass vulnerability that exists when .NET Core does not correctly validate certificates. An attacker who successfully exploited this vulnerability could present an expired certificate when challenged.

The update addresses the vulnerability by correcting how .NET Core applications handle certificate validation.

### Package and Binary updates

| Package name | Vulnerable versions | Secure versions |
| :--- | :--- | :--- |
System.Private.ServiceModel | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.Duplex | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.Http | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.NetTcp | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.Primitives | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
System.ServiceModel.Security | 4.0.0, 4.1.0, 4.1.1 <br> 4.3.0, 4.3.1 <br>4.4.0, 4.4.1, 4.4.2 <br> 4.5.0, 4.5.1 | 4.1.2 or later <br> 4.3.2 or later <br> 4.4.3 or later <br> 4.5.2 or later |
