# .NET Core May 2018 Update - May 8, 2018

Microsoft is releasing updates for .NET Core SDK and ASP.NET Core. This release includes fixes to address CVE-2018-0765 and is summarized in the [fixes](#notable-fixes-and-commits) section below.

.NET Core 2.0.7 (previously released) and SDK 2.1.200 are available for download and usage in your environment.

* [Getting Started](https://www.microsoft.com/net/core/)
* [Downloads](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.1.200-sdk-download.md)

The .NET Core SDK 2.1.200 includes .NET Core 2.0.7 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1.200, the following command will show that you're running version `2.1.200` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1452](https://github.com/dotnet/core/issues/1452) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.0.7-sdk-2.1.200 images.

### Using Linux package managers to update `dotnet-host.x86_64` breaks .NET Core

**Issue:** Running the package manager `update` command on Linux systems where .NET Core has been previously installed may offer an update for `dotnet-host.x86_64`. If the update is allowed to proceed, .NET Core could be in a broken state as only the dotnet host is updated.

**Resolution:** To install the update, either the Runtime or SDK must be explicitly installed. e.g. `sudo [apt-get, yum, dnf, zypper] install dotnet-runtime-2.0.7`, if you only need the runtime or `sudo [apt-get, yum, dnf, zypper] dotnet-sdk-2.1.200`, to install both the SDK and Runtime.

We are working to improve our Linux packages to enable correct package manager update behavior. This work is being tracked in the following issues:

* [dotnet/core-setup/issues/3556](https://github.com/dotnet/core-setup/issues/3556)
* [dotnet/cli/issues/8209](https://github.com/dotnet/cli/issues/8209)

## Package and Binary updates

The following is updated by the May 2018 update. Note that this package is not part of NETCore.App. Applications which reference the package will need to be updated and redeployed.

* System.Security.Cryptography.Xml

## Notable Fixes and Commits

### CVE-2018-0765: .NET Core Denial Of Service Vulnerability

Microsoft is aware of a denial of service vulnerability that exists when .NET Framework and .NET Core improperly process XML documents. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Framework, .NET Core, or .NET native application. See the following announcement for details.

[CVE-2018-0875](https://github.com/dotnet/announcements/issues/67)
