# .NET Core 2.1 - Supported OS versions

The tables below provide OS version information supported by .NET Core 2.1.

## Keys used in the tables

* **Bold numbers** indicate additions to this release.
* A '+' indicates the minimum supported version.
* Where possible, links to Distribution-owned lifecycle documentation is provided.

## Windows

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Windows Client                | 7 SP1+, 8.1                   | x64, x86       |
Windows 10 Client             | Version 1607+                 | x64, x86       |
Windows Server                | 2008 R2 SP1+                  | x64, x86       |

See the [Windows Lifecycle Fact Sheet](https://support.microsoft.com/en-us/help/13853/windows-lifecycle-fact-sheet) for details regarding each Windows release lifecycle.

## macOS

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Mac OS X (macOS)              | 10.12+                        | x64            | [Apple Support Sitemap](https://support.apple.com/sitemap) <br> [Apple Security Updates](https://support.apple.com/en-us/HT201222)

## Linux

OS                            | Version                       | Architectures  | Notes
------------------------------|-------------------------------|----------------|-----
Red Hat Enterprise Linux      | 6                             | x64            | [Microsoft support policy](https://www.microsoft.com/net/support/policy)
Red Hat Enterprise Linux <br> CentOS <br> Oracle Linux | 7    | x64            | [Red Hat support policy](https://access.redhat.com/support/policy/updates/errata/) <br> [CentOS lifecycle](https://wiki.centos.org/FAQ/General#head-fe8a0be91ee3e7dea812e8694491e1dde5b75e6d) <br> [Oracle Linux lifecycle](http://www.oracle.com/us/support/library/elsp-lifetime-069338.pdf)
Fedora                        | 28                            | x64            | [Fedora lifecycle](https://fedoraproject.org/wiki/End_of_life)
Debian                        | 9                             | x64, ARM32     | [Debian lifecycle](https://wiki.debian.org/DebianReleases)
Ubuntu                        | 19.04, 18.04, 16.04           | x64, ARM32\*   | [Ubuntu lifecycle](https://wiki.ubuntu.com/Releases)
Linux Mint                    | 18, 17                        | x64            | [Linux Mint end of life announcements](https://forums.linuxmint.com/search.php?keywords=%22end+of+life%22&terms=all&author=&sc=1&sf=titleonly&sr=posts&sk=t&sd=d&st=0&ch=300&t=0&submit=Search)
openSUSE                      | 42.3+                         | x64            | [OpenSUSE lifecycle](https://en.opensuse.org/Lifetime)
SUSE Enterprise Linux (SLES)  | 12 SP2+                       | x64            | [SUSE lifecycle](https://www.suse.com/lifecycle/)
Alpine Linux                  | 3.7+                          | x64            | [Alpine lifecycle](https://wiki.alpinelinux.org/wiki/Alpine_Linux:Releases)

* **Bold numbers** indicate additions in this release.
* '+' indicates the minimum supported version.

\* ARM32 support starts with Debian 9 and Ubuntu 16.04. Earlier versions of those distros are not supported on ARM32.

## Out of support OS versions

Support for the following versions was ended by the distribution owners and are [no longer supported by .NET Core 2.1](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md).

|OS         | Version  | End of Life |
|-----------|----------|-------------|
| Fedora    | 27       | [11/30/2018](https://fedoraproject.org/wiki/End_of_life)   |
| Fedora    | 26       | [5/29/2018](https://fedoramagazine.org/fedora-26-end-life/)   |
| Debian    | 8        | [6/17/2018](https://lists.debian.org/debian-security-announce/2018/msg00132.html)
| Ubuntu    | 17.10    | [7/19/2018](https://lists.ubuntu.com/archives/ubuntu-announce/2018-July/000232.html) |
| Ubuntu    | 14.04    | [06/2019](https://wiki.ubuntu.com/Releases)   |
