# .NET Core June 2018 Update - June 21, 2018

.NET Core 2.1.1 is available for download and usage in your environment. Have a look at the [Known Issues](2.1.1-known-issues.md) document as there are a few things to be aware of before installing. A [changelist](https://github.com/dotnet/core/blob/master/release-notes/2.1/2.1.1-commit.md) for the entire 2.1 development cycle is also available. This does not include ASP.NET Core or Entity Framework Core.

* [Download .NET Core](https://github.com/dotnet/core/blob/master/release-notes/download-archives/2.1.1-download.md)

## Blog Round up

* [.NET Core](https://blogs.msdn.microsoft.com/dotnet/)

The .NET Core SDK 2.1 includes .NET Core 2.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1, running `dotnet --version` will show that you're running version `2.1.301` of the .NET Core tools.

`dotnet --info` has been greatly enhanced in .NET Core 2.1 and now provides detailed information on installed .NET Core components.

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1719](https://github.com/dotnet/core/issues/1719) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the updated images for .NET Core 2.1.1 and .NET Core SDK 2.1.301 and read ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/) for details and insights into using the .NET Core images.

## Azure AppServices

* Deployment of .NET Core 2.1.1 to Azure App Services has begun. It will be available in limited regions today and expected worldwide by the end of the week.

## .NET Core Lifecycle News

It was announced in the [2.1 blog post](https://blogs.msdn.microsoft.com/dotnet/2018/05/30/announcing-net-core-2-1/) that we are working toward making 2.1 a long-term support (LTS) release. This update is a step along that path.

[.NET Core 2.0](https://blogs.msdn.microsoft.com/dotnet/2017/08/14/announcing-net-core-2-0/) was released on August 14, 2017. As a non-LTS release, it is supported for 3 months after the next release.
[.NET Core 2.1](https://blogs.msdn.microsoft.com/dotnet/2018/05/30/announcing-net-core-2-1/) was released on May 30th, 2018. As a result, .NET Core 2.0 will be supported until September 1, 2018.

Microsoft has a published [support policy](https://github.com/dotnet/core/blob/master/microsoft-support.md) for .NET Core. It includes policies for two release types: LTS and Current. .NET Core 2.0 is a Current release.

* LTS releases include features and components that have been stabilized, requiring few updates over a longer support release lifetime. These releases are a good choice for hosting applications that you do not intend to update often.
* Current releases include features and components that are new and that may undergo future change based on feedback. These releases are a good choice for applications in active development, giving you access to the latest features and improvements. You need to upgrade to later .NET Core releases more often to stay in support.

Both types of releases receive critical fixes throughout their lifecycle, for security, reliability, or to add support for new operating system versions. You must stay up-to-date with the latest patches to qualify for support.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

After that time, .NET Core patch updates will no longer include updated packages for .NET Core 2.0.

### Supported Linux version changes

No changes in supported versions this month. Ubuntu 17.10 will reach end-of-life in July and will be removed from the supported list at that time.

## Notable Changes in 2.1

### Linux installers

#### Installer changes

The .NET Core 2.1 release included Linux installer updates to support package manager update (eg `apt-get update`) functionality. With the release of 2.1.1, we can now see how it works. Each package manager has its own dialect and idiosyncracies so take the time to look into the particulars of your system. Here's an example using `dnf` on a Fedora 28 system.

First, you need to update the package database to determine if there are any updates. `dnf check-update` is useful in that it will provide a list of available updates without trying to install anything. To trim the list, we can do something like this ...

```bash
$sudo dnf check-update | grep dotnet
dotnet-sdk-2.1.x86_64                  2.1.301-1                        packages-microsoft-com-prod
```

Now that we know there is an update available, our system can be upgraded with the following. If this is the first install, you would usd `install` rather than `upgrade`.

```bash
$sudo dnf upgrade dotnet-sdk-2.1
Last metadata expiration check: 0:08:41 ago on Tue 19 Jun 2018 09:24:49 AM PDT.
Dependencies resolved.
=======================================================================================================================
 Package                           Arch             Version                Repository                             Size
=======================================================================================================================
Upgrading:
 aspnetcore-runtime-2.1            x86_64           2.1.1-1                packages-microsoft-com-prod            29 M
 dotnet-host                       x86_64           2.1.1-1                packages-microsoft-com-prod            45 k
 dotnet-hostfxr-2.1                x86_64           2.1.1-1                packages-microsoft-com-prod           195 k
 dotnet-runtime-2.1                x86_64           2.1.1-1                packages-microsoft-com-prod            27 M
 dotnet-runtime-deps-2.1           x86_64           2.1.1-1                packages-microsoft-com-prod           2.8 k
 dotnet-sdk-2.1                    x86_64           2.1.301-1              packages-microsoft-com-prod           109 M

Transaction Summary
=======================================================================================================================
Upgrade  6 Packages

Total download size: 165 M
Is this ok [y/N]:
```

The package manager will install the updated version and remove the previous from your system. This is a change from previous installations which would leave the old versions behind. If a previous release of 2.1 is needed, it can be installed by explicitly referencing the version. Sticking with the Fedora example, you would use `dnf --showduplicates.`

```bash
$dnf --showduplicates list dotnet-sdk-2.1
Last metadata expiration check: 0:15:00 ago on Tue 19 Jun 2018 09:25:25 AM PDT.

Installed Packages
dotnet-sdk-2.1.x86_64                              2.1.301-1                               @packages-microsoft-com-prod

Available Packages
dotnet-sdk-2.1.x86_64                              2.1.300-1                               packages-microsoft-com-prod
dotnet-sdk-2.1.x86_64                              2.1.301-1                               @packages-microsoft-com-prod
```

You can see that 2.1.300 and 2.1.301 are available and 2.1.301 is currently installed. `dnf install dotnet-sdk-2.1-2.1.300-1` will downgrade the system from 2.1.301 to 2.1.300.
