# .NET Core 2.1.11 Update - May 14, 2019

.NET Core 2.1.11 is available for [download](2.1.11-download.md) and usage in your environment. This release includes .NET Core 2.1.11, ASP.NET Core 2.1.11 and the .NET Core SDK.

**NOTE:** If you are a Visual Studio user, there are MSBuild version requirements so use only the .NET Core SDK supported for each Visual Studio version. If you use other development environments, we recommend using the latest SDK release.

| VS Version | .NET Core SDK |
| :-- | :--: |
| Visual Studio 2017 and Visual Studio for Mac | [2.1.507](#downloads) |
| Visual Studio 2019 (Windows) | [2.1.604](../2.1.604-SDK/2.1.604-SDK-download.md) |

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2111)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.1-known-issues.md)

We've created an issue at [dotnet/core #2727](https://github.com/dotnet/core/issues/2727) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

### Azure AppServices

* .NET Core 2.1.11 is being deployed to Azure App Services and the deployment is expected to complete in a couple of days.

## .NET Core Lifecycle News

Ubuntu 14.04 reached the [end of standard support April 2019](https://wiki.ubuntu.com/Releases). We will no longer produce and release packages for this OS version.

.NET Core 1.0 and 1.1, which entered "Maintenance" support status when 2.1 was declared LTS, will be end-of-life June 27, 2019. Updates for the 1.0 and 1.1 channels will no longer be offered after that date. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 2.1.11

.NET Core 2.1.11 release carries both security and non-security fixes.

* [CVE-2019-0820: .NET Core Tampering Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-0820)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core improperly process RegEx strings. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET application.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core applications handle RegEx string processing.

    **Affected Package and Binary updates**
    
    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Text.RegularExpressions.dll | 4.3.0 | 4.3.1 
    
* [CVE-2019-0980: ASP.NET Core Denial of Service Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-0980)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core and ASP.NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core and ASP.NET Core improperly handle web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core and ASP.NET Core application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core and ASP.NET Core web applications handle web requests.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Private.Uri | 4.3.0, 4.3.1 | 4.3.2 
    
* [CVE-2019-0981: ASP.NET Core Denial of Service Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-0981)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core and ASP.NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core and ASP.NET Core improperly handle web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core and ASP.NET Core application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core and ASP.NET Core web applications handle web requests.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Private.Uri | 4.3.0, 4.3.1 | 4.3.2
    
* [CVE-2019-0982: ASP.NET Core Denial of Service Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-0982)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core and ASP.NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core and ASP.NET Core improperly handle web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core and ASP.NET Core application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core and ASP.NET Core web applications handle web requests.

    **Affected Package and Binary updates**
  
    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Private.Uri | 4.3.0, 4.3.1 | 4.3.2  

### Additional fixes in this release

* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.11+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=user:aspnet+is:pr+label:Servicing-approved+milestone:2.1.11)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
dotnet-ef|2.1.11
Microsoft.AspNetCore.All|2.1.11
Microsoft.AspNetCore.App|2.1.11
Microsoft.AspNetCore.Identity.UI|2.1.11
Microsoft.AspNetCore.Mvc.Core|2.1.11
Microsoft.AspNetCore.Mvc.RazorPages|2.1.11
Microsoft.AspNetCore.SignalR.Protocols.MessagePack|1.0.11
Microsoft.AspNetCore.SignalR.Redis|1.0.11
Microsoft.Data.Sqlite|2.1.11
Microsoft.Data.Sqlite.Core|2.1.11
Microsoft.EntityFrameworkCore|2.1.11
Microsoft.EntityFrameworkCore.Abstractions|2.1.11
Microsoft.EntityFrameworkCore.Analyzers|2.1.11
Microsoft.EntityFrameworkCore.Design|2.1.11
Microsoft.EntityFrameworkCore.InMemory|2.1.11
Microsoft.EntityFrameworkCore.Proxies|2.1.11
Microsoft.EntityFrameworkCore.Relational|2.1.11
Microsoft.EntityFrameworkCore.Relational.Specification.Tests|2.1.11
Microsoft.EntityFrameworkCore.Specification.Tests|2.1.11
Microsoft.EntityFrameworkCore.Sqlite|2.1.11
Microsoft.EntityFrameworkCore.Sqlite.Core|2.1.11
Microsoft.EntityFrameworkCore.SqlServer|2.1.11
Microsoft.EntityFrameworkCore.Tools|2.1.11
Microsoft.NETCore.App|2.1.11
Microsoft.NETCore.DotNetAppHost|2.1.11
Microsoft.NETCore.DotNetHost|2.1.11
Microsoft.NETCore.DotNetHostPolicy|2.1.11
Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.linux-arm.Microsoft.NETCore.App|2.1.11
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.linux-arm.Microsoft.NETCore.DotNetHost|2.1.11
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.linux-arm64.Microsoft.NETCore.App|2.1.11
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHost|2.1.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.linux-musl-x64.Microsoft.NETCore.App|2.1.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost|2.1.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.linux-x64.Microsoft.NETCore.App|2.1.11
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.linux-x64.Microsoft.NETCore.DotNetHost|2.1.11
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.osx-x64.Microsoft.NETCore.App|2.1.11
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.osx-x64.Microsoft.NETCore.DotNetHost|2.1.11
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.rhel.6-x64.Microsoft.NETCore.App|2.1.11
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost|2.1.11
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.win-arm.Microsoft.NETCore.App|2.1.11
runtime.win-arm.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.win-arm.Microsoft.NETCore.DotNetHost|2.1.11
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.win-arm64.Microsoft.NETCore.App|2.1.11
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.win-arm64.Microsoft.NETCore.DotNetHost|2.1.11
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.win-x64.Microsoft.NETCore.App|2.1.11
runtime.win-x64.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.win-x64.Microsoft.NETCore.DotNetHost|2.1.11
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver|2.1.11
runtime.win-x86.Microsoft.NETCore.App|2.1.11
runtime.win-x86.Microsoft.NETCore.DotNetAppHost|2.1.11
runtime.win-x86.Microsoft.NETCore.DotNetHost|2.1.11
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy|2.1.11
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver|2.1.11
System.Memory|4.5.3

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.1/2.1.11/2.1.11.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e34e5f5-e817-4ba4-9bfe-03f341e2a807/5779a613184dd09596f71681064cdaa8/dotnet-runtime-2.1.11-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f3238746-7a47-407f-9d30-20de4bfd93e2/0c26aad99851325fd5240909f120614d/dotnet-runtime-2.1.11-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec41f227-48b2-4a15-a10b-020003e5630b/57d30d09d6cda24b2c9baabdc999f254/dotnet-runtime-2.1.11-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd164132-d4c4-4c1a-8233-a4fc7e157935/bffa5312d613cab1a14f0858f947a6fc/dotnet-runtime-2.1.11-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2e53964c-4433-4668-96c4-9365c9b8a82c/9c4b64e4ed0ef36be09b8a6f7e1f677c/dotnet-runtime-2.1.11-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37fc6578-1d55-45a6-9abb-7c50c70d9640/f5c243f9a198185909e78018aa650dcf/dotnet-runtime-2.1.11-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4753698b-f678-4470-a0cf-bcc896d78d45/8bdeb1fd072988ceb7bcf982c7f70c66/dotnet-runtime-2.1.11-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/cb38e0f6-8dc7-4594-9cd6-046964d3c894/b2aa5430c110c0dc6486096b4c834aaf/dotnet-runtime-2.1.11-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0a2dd531-45b5-4d59-9b8f-be5ac2d2e1de/5549783adc792b37ffd1d39c59ee44e2/dotnet-runtime-2.1.11-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e2abeb77-02c9-44e8-ac97-007610b73a18/da40662a3333b8aea5a5cd7bcdd2cc97/dotnet-runtime-2.1.11-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/100156ff-737e-4e31-840b-019a13df9519/d34c5667c69603c63d4a9f509f933655/dotnet-runtime-2.1.11-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0621a50e-d816-48f4-9d87-34ed5a5cac83/7bd42f7c0028c64a638716efc9f16bc2/dotnet-runtime-2.1.11-win-x86.zip
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2a18acf-4d99-4182-b663-e375bce7d11f/602d241f15d05e954fb54e4180e3fab9/aspnetcore-runtime-2.1.11-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/103a417e-384c-4c59-ac6a-ffe32f9a6d3c/f68e5e76f269a8b75c52bb965adc5b71/aspnetcore-runtime-2.1.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f0a5410-f311-47d6-a0d7-f8afe245bfc2/d4b0370ee8fdac3e8d8b0da7ec6b649a/aspnetcore-runtime-2.1.11-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/51a5d770-1657-4a5f-a91a-7ffd6cc807d9/7e3f05213ae80a1d5c69e3ac57f79935/aspnetcore-runtime-2.1.11-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d5fcdd67-2037-4b72-99cc-af2c8149dd50/0efc18d67e67ef7d9866af97c04b7ff1/aspnetcore-runtime-2.1.11-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/02857adc-b4dc-45dd-8d94-91259e32d8b0/bc59bdd5cc47a52024c215e71e2976c7/aspnetcore-runtime-2.1.11-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2f25a7cb-aeb0-4be8-a836-942603234572/bf992c77c51dff5f73f39475b7e7d140/aspnetcore-runtime-2.1.11-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9f4aafc6-5dd7-4cf7-bec8-a01e8b4fb89a/a6e483792905bbd3b2df3db4f48de13a/aspnetcore-runtime-2.1.11-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/0ad9d7d3-3cca-48e8-a5cc-07a5a6b8a020/820fd44b4eca9f31b11875d75068bb74/dotnet-hosting-2.1.11-win.exe
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fdbe8dd2-48c8-4ebf-9f99-fb7ff754f4b3/10b0884bcbb04d74155e2474b476cb1e/dotnet-sdk-2.1.507-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d084958-4fc5-48cb-bbf5-c94d98f796a7/501cba38b87badfaa39d262c23919cab/dotnet-sdk-2.1.507-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a82af378-d707-4c64-8e56-da2d0a62f0f7/8c3efbc60cdf66fcfa2db1ea3e4f7fcc/dotnet-sdk-2.1.507-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c82b55d4-f2b4-4d54-8848-66d53fe113ec/defe61b7a4bc81ae28e976afdd4ae183/dotnet-sdk-2.1.507-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/cfab2310-202d-4a46-8a80-13a0fe0a5917/4fef66f60a0ae12d6e93bdd308c642a4/dotnet-sdk-2.1.507-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8698ce7a-0d86-40af-a955-9407bd4e9969/f2d9af9d7d7d0e959b875a7347abdc6e/dotnet-sdk-2.1.507-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e1c269a-1e72-4109-ae57-dcb0da621f22/9c00e2d10d44ed645e632784c0f68eea/dotnet-sdk-2.1.507-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6674c926-b8f3-416b-abc2-1db57fa50dc9/6f53e3c39b2dae4e78a1325f3427ee11/dotnet-sdk-2.1.507-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8169bcb9-02bf-4380-8876-f63bfb0533d0/ac681a87b5fa21953cb9a0c0fffc4fe7/dotnet-sdk-2.1.507-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bc958862-8a27-470d-a22d-8075964271e5/df19cf19705249cfd37fd64df97157eb/dotnet-sdk-2.1.507-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5de9f59c-f953-4f93-9fa8-5d7015103255/342598bf94a7cb0c5e2222c09017f890/dotnet-sdk-2.1.507-win-x86.zip
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/10122067-a94f-4053-94e8-f03deda2135f/064bb8dde0397d188f6e88ed7eeac62c/aspnet-2.1.11-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/fa32c182-4029-4d71-a5d8-3aad70e00f92/f2137db910cd2ea8adff8ff195b12556/cli-2.1.11-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b63f344a-5a87-41ae-82d2-81990ca1e867/ec5a0af3e688522dda8b7b51adbb0083/core-setup-2.1.11-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/c6b1326f-8c0e-474a-b6c6-b372660403e3/9b2a0cb31e64bb1ad8736692284c0fec/coreclr-2.1.11-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/210587a4-fb59-49a4-8fbb-f15e95751f49/ecf9abdb30a2428236b499d2144826bc/corefx-2.1.11-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/a782c245-3b40-4cbd-8c6e-a88758d591be/980df24ada29dd20ea452e1cb9c31d36/dotnet-sdk-2.1.11-symbols.zip
[sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/563ddb49-52c6-44e5-bf1f-4c3d69d96380/7a18b8197e797933da76469b5e916127/sdk-2.1.507-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.11-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.507-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-may-2019/
