# .NET Core September 2018 Update - Sep 11, 2018

.NET Core 2.1.4 is available for [download](2.1.4-download.md) and usage in your environment. This release includes .NET Core 2.1.4, ASP.NET Core 2.1.4 and .NET Core SDK 2.1.402. All fixes of note can be seen in the [2.1.4 commits](2.1.4-commits.md) list.

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-214)
* [Known Issues](../2.1-known-issues.md)
* [Lifecycle](#net-core-lifecycle-news)

Visit the [.NET Core blog][dotnet-blog] to read more about this release. Your feedback is important and appreciated. We've created an issue at [dotnet/core #1932](https://github.com/dotnet/core/issues/1932) for your questions and comments.

## Downloads

|           | SDK Installer*                                   | SDK Binaries*                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][sdk-win-x86.exe] \| [x64][sdk-win-x64.exe] | [x86][sdk-win-x86] \| [x64][sdk-win-x64] | [x86][runtime-win-x86.exe] \| [x64][runtime-win-x64.exe] | [x86][runtime-win-x86] \| [x64][runtime-win-x64] | [x86][asp-runtime-win-x86.exe] \| [x64][asp-runtime-win-x64.exe] <br> [Hosting Bundle][hosting-win-x64.exe] |
| macOS     | [x64][sdk-mac-x64.pkg]  | [x64][sdk-mac-x64]     | [x64][runtime-mac-x64.pkg] | [x64][runtime-mac-x64] | [x64][asp-runtime-mac-x64]
| Linux     | [See installations steps below][linux-install]   | [x64][sdk-linux-x64] \| [ARM][sdk-linux-arm-x32] \| [ARM64][sdk-linux-arm-x64] \| [x64 Alpine][sdk-linux-musl-x64] | - | [x64][runtime-linux-x64] \| [ARM][runtime-linux-arm-x32] \| [ARM64][runtime-linux-arm-x64] \| [x64 Alpine][runtime-linux-musl-x64] | [x64][asp-runtime-linux-x64]  \| [ARM32][asp-runtime-linux-arm-x86] \| [x64 Alpine][asp-runtime-linux-musl-x64] |
| RHEL6     | -                                                | [x64][sdk-rhel.6-x64]                    | -                                                        | [x64][runtime-rhel.6-x64] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][symbols-coreclr] \| [Shared Framework][symbols-corefx] \| [Setup][symbols-core-setup] | - | [ASP.NET Core][symbols-aspnetcore] |

\* Includes the .NET Core and ASP.NET Core runtimes

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

### Azure AppServices

* Deployment of .NET Core 2.1.4 to Azure App Services will begin on today, September 11, 2018. Deployment will proceed to additional regions and is expected to be complete by the end of the week.

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

### Supported Linux version changes

No changes in support for September.

## Notable Changes in 2.1.4

### [CVE-2018-8409: .NET Core Denial Of Service Vulnerability](https://github.com/dotnet/Announcements/issues/83)

**Executive summary**

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability in .NET Core when System.IO.Pipelines improperly handles requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an application that is leveraging System.IO.Pipelines. The vulnerability can be exploited remotely, without authentication. A remote unauthenticated attacker could exploit this vulnerability by providing specially crafted requests to the application.

The update addresses the vulnerability by correcting how System.IO.Pipelines handles requests.

#### Package and Binary updates

| Package name | Vulnerable versions | Secure versions |
| :--- | :--- | :--- |
System.IO.Pipelines | 4.5.0 | 4.5.1 |


### [CVE-2018-8409: ASP.NET Core Denial Of Service Vulnerability](https://github.com/aspnet/Announcements/issues/316)

**Executive summary**

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability when ASP.NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication. A remote unauthenticated attacker could exploit this vulnerability by providing a specially crafted web requests to the ASP.NET Core application.

The update addresses the vulnerability by correcting how ASP.NET Core handles parsing web requests.

#### Package and Binary updates

| Package name | Vulnerable versions | Secure versions |
| :--- | :--- | :--- |
Microsoft.AspNetCore.All | 2.1.0, 2.1.1, 2.1.2, 2.1.3 | 2.1.4
Microsoft.AspNetCore.App | 2.1.0, 2.1.1, 2.1.2, 2.1.3 | 2.1.4
System.IO.Pipelines | 4.5.0 | 4.5.1

[dlc-runtime]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E
[dlc-sdk]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.1/2.1.4/2.1.4.md

[runtime-linux-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-linux-x64.tar.gz
[runtime-linux-arm-x32]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-linux-arm.tar.gz
[runtime-linux-musl-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-linux-musl-x64.tar.gz
[runtime-linux-arm-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-linux-arm64.tar.gz
[runtime-rhel.6-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-rhel.6-x64.tar.gz
[runtime-mac-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-osx-x64.tar.gz
[runtime-mac-x64.pkg]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-osx-x64.pkg
[runtime-win-x86]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-win-x86.zip
[runtime-win-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-win-x64.zip
[runtime-win-x86.exe]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-win-x86.exe
[runtime-win-x64.exe]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-runtime-2.1.4-win-x64.exe

[sdk-linux-x64]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-linux-x64.tar.gz
[sdk-linux-arm-x32]:  https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-linux-arm.tar.gz
[sdk-linux-arm-x64]:  https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-linux-arm64.tar.gz
[sdk-linux-musl-x64]:  https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-linux-musl-x64.tar.gz
[sdk-mac-x64]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-osx-x64.tar.gz
[sdk-mac-x64.pkg]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-osx-x64.pkg
[sdk-mac-x64.pkg-gs]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-osx-gs-x64.pkg
[sdk-win-x86]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-win-x86.zip
[sdk-win-x64]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-win-x64.zip
[sdk-win-x86.exe]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-win-x86.exe
[sdk-win-x86.exe-gs]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-win-gs-x86.exe
[sdk-win-x64.exe]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-win-x64.exe
[sdk-win-x64.exe-gs]: https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-win-gs-x64.exe
[sdk-rhel.6-x64]:  https://download.microsoft.com/download/8/A/7/8A765126-50CA-4C6F-890B-19AE47961E4B/dotnet-sdk-2.1.402-rhel.6-x64.tar.gz

[hosting-win-x64.exe]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/dotnet-hosting-2.1.4-win.exe
[asp-runtime-linux-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-runtime-2.1.4-linux-x64.tar.gz
[asp-runtime-linux-arm-x86]:  https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-runtime-2.1.4-linux-arm.tar.gz
[asp-runtime-linux-musl-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-runtime-2.1.4-linux-musl-x64.tar.gz
[asp-runtime-mac-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-runtime-2.1.4-osx-x64.tar.gz
[asp-runtime-win-x64.exe]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-runtime-2.1.4-win-x64.exe
[asp-runtime-win-x86.exe]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-runtime-2.1.4-win-x86.exe
[asp-runtime-win-x86]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-runtime-2.1.4-win-x86.zip
[asp-runtime-win-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-runtime-2.1.4-win-x64.zip
[asp-store-linux-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-store-2.1.4-linux-x64.tar.gz
[asp-store-mac-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnetcore-store-2.1.4-osx-x64.tar.gz
[asp-store-win-x64]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/AspNetCore.2.1.4.RuntimePackageStore_x64.exe
[asp-store-win-x86]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/AspNetCore.2.1.4.RuntimePackageStore_x86.exe

[symbols-aspnetcore]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/aspnet-2.1.4-symbols.zip
[symbols-coreclr]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/coreclr-2.1.4-symbols.zip
[symbols-corefx]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/corefx-2.1.4-symbols.zip
[symbols-core-setup]: https://download.microsoft.com/download/A/7/8/A78F1D25-8D5C-4411-B544-C7D527296D5E/core-setup-2.1.4-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.4-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.402-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/2018/09/11/net-core-september-2018-update/
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md
