# .NET Core 2.1.8 Known Issues and Resolutions

## ASP.NET Core 2.1.8

### Microsoft.AspNetCore dependency downgraded in this release

Existing applications may throw a `FileLoadException` after the 2.1.8 release is installed. The stack trace below is
common.
```
Unhandled Exception: System.IO.FileLoadException: Could not load file or assembly 'Microsoft.AspNetCore, Version=2.1.7.0, Culture=neutral, PublicKeyToken=adb9793829ddae60'. The located assembly's manifest definition does not match the assembly reference. (Exception from HRESULT: 0x80131040)
   at Program.CreateWebHostBuilder(String[] args)
```

#### Workarounds

If this issue affects your application, update the project in one of the following ways:
1. Remove version from AspNetCore.App `<PackageReference Include="Microsoft.AspNetCore.App" />`
2. Add `<PackageReference Include="Microsoft.AspNetCore" Version="2.1.7" />` (NB: this is **not** the .App package)
3. Update AspNetCore.App: `<PackageReference Include="Microsoft.AspNetCore.App" Version="2.1.8" />`

#### More information

* See [aspnet/AspNetCore #7546](https://github.com/aspnet/AspNetCore/issues/7546) for more information about this specific issue.
* See [2.1 Known Issues](../2.1-known-issues.md) for information about all the earlier known issues. 
