# .NET Core 2.1 Preview 2 Known Issues

This document lists known issues for *.NET Core 2.1 Preview 2* which may be encountered during usage.

## SDK

[sdk/issues/2128](https://github.com/dotnet/sdk/issues/2128)

There is a regression in DotNetCliToolReference support which results in the SDK failing to launch with the following error:

> Unable to generate deps.json, it may have been already generated. You can specify the "-d" option before the tool name for diagnostic output (for example, "dotnet -d ": /usr/local/share/dotnet/sdk/2.1.300-preview2-008530/Sdks/Microsoft.NET.Sdk/targets/GenerateDeps/GenerateDeps.proj

There error does not point to the actual issue which is:

> error MSB4018: System.UnauthorizedAccessException: Access to the path '/usr/local/share/dotnet/sdk/2.1.300-preview2-008530/Sdks/Microsoft.NET.Sdk/targets/GenerateDeps/obj/Debug/netcoreapp2.1/GenerateDeps.assets.cache' is denied.

**Workaround** - Give write permissions to the /usr/share/dotnet/sdk/version

## Installing on Linux using the installers installs the latest available dotnet-host package

There is an issue with dotnet-host 2.1.0-preview2-26406-04-1 which introduces a dependency incompatibility. [core-setup/issues/2128](https://github.com/dotnet/core-setup/issues/4007). This is only a problem when installing a previous version of .NET Core on a clean machine. For example, if you installed dotnet-runtime-2.0.6, the Preview 2 host will be installed but not the rest of Preview 2.

We have temporarily removed the Preview 2 installers from the Linux package feeds until this is fully resolved.

**Workaround** - If you have gotten into this state, downgrade the dotnet-host pacakge to an older version.

```bash
sudo apt install dotnet-host=2.0.6-1
```

## SocketsHttpHandler hangs on single core machines

There is an issue with the new default HttpClientHandler that will cause hangs on single core machines when multiple connections are opened simultaneously. [corefx/issues/28979](https://github.com/dotnet/corefx/issues/28979). This issue has since been fixed, but is present in the Preview 2 build.

**Workaround** - Use a machine with 2+ cores, or enable the older platform specific HttpClientHandler ([as described in the Preview 2 blog post](https://blogs.msdn.microsoft.com/dotnet/2018/04/11/announcing-net-core-2-1-preview-2/))

## Global Tools

### Global Tools targeting Preview or RC will not "roll-forward" to RTM

_This issue affects tool authors_

Global Tools are framework-dependent applications and subject to the same .NET Core runtime selection behavior as other applications. A key behavior is that preview releases do not roll-forward to a final (AKA "RTM") release in the absence of a preview release being installed on a given machine. Tool writers that publish tools for a preview need to publish releases for later previews and the final release in order for those tools to work for their users.

**Action -** When .NET Core SDK is released (RTM), authors need to rebuild and re-publish their tools with the released RTM SDK.

### Global Tools must target .NET Core Runtime 2.1

_This issue affects tool authors and tool users_

Starting with Preview 2, Global Tools must target .NET Core Runtime 2.1 or above. This change was made to support a new executable model that is only available in .NET Core Runtime 2.1 Preview 2 or above. Global Tools built with Preview 1 that targeted .NET Core 2.0 must be rebuilt. Users of Global Tools need to have .NET Core Runtime 2.1.0 Preview 2 or above installed (the usual case).

You can find more info at the dotnet/cli issue on GitHub [Global tools targeting netcoreapp2.0 do not work with preview2 SDK #9073](https://github.com/dotnet/cli/issues/9073).

**Action -** Authors need to upgrade Global Tools to use .NET Core 2.1.

1. Install .NET Core 2.1 Preview 2 (or above).
2. Check that you're targeting `netcoreapp2.1`.
3. Build, deploy and push the new version.
4. Your users will need to uninstall the Preview 1 version of your tools (see issue _.NET Core SDK 2.1.300 Preview 1 Global Tools_).

### Global Tools pinned to .NET Core Runtime 2.1.0 Preview 1 may fail

_This issue affects primarily tool users_

Global Tools no longer support .NET Core Runtime 2.1.0 Preview 1 and will fail with the message: 

```bash
Failed to locate managed application [/Users/kathleen/.dotnet/tools/dotnetsay.dll]
```

Because of roll-forward behavior, this will only occur if the user's machine has .NET Core Runtime 2.1.0 Preview 1 installed. This can result in different behavior on different machines.

**Workarounds:**

Do one of the following:

1. Upgrade to a version of the tool that targets .NET Core Runtime 2.1.0 Preview 2 or above.
2. Uninstall .NET Core 2.1.0 Preview 1 from the user's computer.

### Test projects for Global Tools require explicit references

_This issue affects only tool authors_

Global Tool projects that include the property `PackAsTool=true` (the normal case) do not flow dependencies to test projects. If a project with `PackAsTool=true` has Project or Package Reference, tests will fail with errors such as:

```bash
Could not load file or assembly '<project dll>'. The system cannot find the file specified.
```

You can find more information at the dotnet/cli issue on GitHub [dotnet 2.1-preview 2 test unable to load dependent project libraries #9109](https://github.com/dotnet/cli/issues/9109).

**Workarounds:**

Do one of the following:

1. Add the Project and Package Reference to the test project. For example: if the Global Tool project you are testing has a reference to Newtonsoft.Json, the test project needs a reference to Newtonsoft.Json as well.

2. Instead of adding `<PackAsTool>true</PackAsTool>` property in project file, pass it to `pack` via command line. Remove the property from the .csproj file and use `dotnet pack /p:PackAsTool=true`.

3. Create a separate project just to pack. Move all of the logic you intend to test into a project that this pack project references. Include the `PackAsTool=true` property only in the pack project, allowing you to test other projects.

### Breaking changes from .NET Core SDK 2.1.300 Preview 1 Global Tools

.NET Core SDK 2.1.300 Preview 1 provided feedback that led to changes in Global Tools. There are several breaking changes between Preview 1 and Preview 2, and the recommendation is:

**Action**
* Tool authors should rebuild and republish Global Tools using SDK 2.1.300 Preview 2 or higher, targeting .NET Core Runtime 2.1.0 with Preview 2 of the runtime also installed on the machine (the normal case).
* Tool users should 
  * Upgrade to .NET Core 2.1.0 Preview 2 or higher.
  * Remove the tools packages folder.
  * Remove the tools folder, empty it, or remove individual Preview 1 tools.
  * Reinstall upgraded tools.

Tool users can remove all tools

**Windows**

1. Delete the tool packages directory: `%USERPROFILE%\.dotnet\toolspkgs`.
2. Delete the tools, empty it or remove individual Preview 1 tools from the directory: `%USERPROFILE%\.dotnet\tools` (`C:\Users\NAME\.dotnet\tools`).

**MacOS and Linux**

1. Delete the tools directory: `$HOME/.dotnet/tools`.
2. Delete the tools, empty it or remove individual Preview 1 tools from the directory: `$HOME/.dotnet/toolspkgs`.

If you would like to continue to use Preview 1 Global Tools, you may encounter these problems:

#### Preview 1 Global Tools give warning when install in later SDKs

If a Global Tool created in Preview 1 is installed in the Preview 2 or later SDK, you will receive the following warning: 

`Format version is missing. This tool may not be supported in this SDK version.`

To help with future forward compatibility, Global Tools now include a format version for the internal structure they were created with. If this format version is not present or changes, this warning will be displayed. The format version is not present in Preview 1 Global Tools.

**Action -** You may ignore this warning moving from Preview 1 to later versions of 2.1.300.

#### Preview 1 Global Tools cannot be uninstalled with later previews

The `dotnet tool uninstall` command in Preview 2 cannot uninstall Global Tools that were installed using Preview 1 due to a change in the installation layout. The location of package content (the implementation) moved from `$HOME/.dotnet/toolspkgs` to `$HOME/.dotnet/tools/.store`. The Preview2 SDK will try to delete package content from `$HOME/.dotnet/tools/.store` where it did not exist. 

Preview 1 did not include an `uninstall` command.

**Action -** Manually remove the shim and the implementation directory to uninstall any Preview 1 tools. The shim is in the `.dotnet\tools` directory and the implementation is in `.dotnet\toolspkgs`.
