# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
     public class Socket : IDisposable {
+        public int Receive(Span<byte> buffer);
+        public int Receive(Span<byte> buffer, SocketFlags socketFlags);
+        public int Receive(Span<byte> buffer, SocketFlags socketFlags, out SocketError errorCode);
+        public int Send(ReadOnlySpan<byte> buffer);
+        public int Send(ReadOnlySpan<byte> buffer, SocketFlags socketFlags);
+        public int Send(ReadOnlySpan<byte> buffer, SocketFlags socketFlags, out SocketError errorCode);
     }
     public class SocketAsyncEventArgs : EventArgs, IDisposable {
+        public Memory<byte> MemoryBuffer { get; }
+        public void SetBuffer(Memory<byte> buffer);
     }
     public static class SocketTaskExtensions {
+        public static ValueTask<int> ReceiveAsync(this Socket socket, Memory<byte> buffer, SocketFlags socketFlags, CancellationToken cancellationToken=default(CancellationToken));
+        public static ValueTask<int> SendAsync(this Socket socket, ReadOnlyMemory<byte> buffer, SocketFlags socketFlags, CancellationToken cancellationToken=default(CancellationToken));
     }
+    public sealed class UnixDomainSocketEndPoint : EndPoint {
+        public UnixDomainSocketEndPoint(string path);
+    }
 }
```

