# System.Runtime.Intrinsics.X86

``` diff
+namespace System.Runtime.Intrinsics.X86 {
+    public static class Aes {
+        public static bool IsSupported { get; }
+        public static Vector128<byte> Decrypt(Vector128<byte> value, Vector128<byte> roundKey);
+        public static Vector128<sbyte> Decrypt(Vector128<sbyte> value, Vector128<sbyte> roundKey);
+        public static Vector128<byte> DecryptLast(Vector128<byte> value, Vector128<byte> roundKey);
+        public static Vector128<sbyte> DecryptLast(Vector128<sbyte> value, Vector128<sbyte> roundKey);
+        public static Vector128<byte> Encrypt(Vector128<byte> value, Vector128<byte> roundKey);
+        public static Vector128<sbyte> Encrypt(Vector128<sbyte> value, Vector128<sbyte> roundKey);
+        public static Vector128<byte> EncryptLast(Vector128<byte> value, Vector128<byte> roundKey);
+        public static Vector128<sbyte> EncryptLast(Vector128<sbyte> value, Vector128<sbyte> roundKey);
+        public static Vector128<byte> InvisibleMixColumn(Vector128<byte> value);
+        public static Vector128<sbyte> InvisibleMixColumn(Vector128<sbyte> value);
+        public static Vector128<byte> KeygenAssist(Vector128<byte> value, byte control);
+        public static Vector128<sbyte> KeygenAssist(Vector128<sbyte> value, byte control);
+    }
+    public static class Avx {
+        public static bool IsSupported { get; }
+        public static Vector256<double> Add(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Add(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> AddSubtract(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> AddSubtract(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> And(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> And(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> AndNot(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> AndNot(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> Blend(Vector256<double> left, Vector256<double> right, byte control);
+        public static Vector256<float> Blend(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<double> BlendVariable(Vector256<double> left, Vector256<double> right, Vector256<double> mask);
+        public static Vector256<float> BlendVariable(Vector256<float> left, Vector256<float> right, Vector256<float> mask);
+        public static Vector128<float> BroadcastElementToVector128(ref float source);
+        public static Vector256<double> BroadcastElementToVector256(ref double source);
+        public static Vector256<float> BroadcastElementToVector256(ref float source);
+        public unsafe static Vector256<double> BroadcastVector128ToVector256(double* address);
+        public unsafe static Vector256<float> BroadcastVector128ToVector256(float* address);
+        public static Vector256<double> Ceiling(Vector256<double> value);
+        public static Vector256<float> Ceiling(Vector256<float> value);
+        public static Vector128<double> Compare(Vector128<double> left, Vector128<double> right, FloatComparisonMode mode);
+        public static Vector128<float> Compare(Vector128<float> left, Vector128<float> right, FloatComparisonMode mode);
+        public static Vector256<double> Compare(Vector256<double> left, Vector256<double> right, FloatComparisonMode mode);
+        public static Vector256<float> Compare(Vector256<float> left, Vector256<float> right, FloatComparisonMode mode);
+        public static Vector128<double> CompareScalar(Vector128<double> left, Vector128<double> right, FloatComparisonMode mode);
+        public static Vector128<float> CompareScalar(Vector128<float> left, Vector128<float> right, FloatComparisonMode mode);
+        public static float ConvertToSingle(Vector256<float> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector256<double> value);
+        public static Vector128<int> ConvertToVector128Int32WithTruncation(Vector256<double> value);
+        public static Vector128<float> ConvertToVector128Single(Vector256<double> value);
+        public static Vector256<double> ConvertToVector256Double(Vector256<int> value);
+        public static Vector256<double> ConvertToVector256Double(Vector256<float> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector256<float> value);
+        public static Vector256<int> ConvertToVector256Int32WithTruncation(Vector256<float> value);
+        public static Vector256<float> ConvertToVector256Single(Vector256<int> value);
+        public static Vector256<double> Divide(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Divide(Vector256<float> left, Vector256<float> right);
+        public static Vector256<float> DotProduct(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<double> DuplicateEvenIndexed(Vector256<double> value);
+        public static Vector256<float> DuplicateEvenIndexed(Vector256<float> value);
+        public static Vector256<float> DuplicateOddIndexed(Vector256<float> value);
+        public static Vector256<T> ExtendToVector256<T>(Vector128<T> value) where T : struct;
+        public static byte Extract(Vector256<byte> value, byte index);
+        public static short Extract(Vector256<short> value, byte index);
+        public static int Extract(Vector256<int> value, byte index);
+        public static long Extract(Vector256<long> value, byte index);
+        public static sbyte Extract(Vector256<sbyte> value, byte index);
+        public static ushort Extract(Vector256<ushort> value, byte index);
+        public static uint Extract(Vector256<uint> value, byte index);
+        public static ulong Extract(Vector256<ulong> value, byte index);
+        public unsafe static void ExtractVector128(byte* address, Vector256<byte> value, byte index);
+        public unsafe static void ExtractVector128(double* address, Vector256<double> value, byte index);
+        public unsafe static void ExtractVector128(short* address, Vector256<short> value, byte index);
+        public unsafe static void ExtractVector128(int* address, Vector256<int> value, byte index);
+        public unsafe static void ExtractVector128(long* address, Vector256<long> value, byte index);
+        public unsafe static void ExtractVector128(sbyte* address, Vector256<sbyte> value, byte index);
+        public unsafe static void ExtractVector128(float* address, Vector256<float> value, byte index);
+        public unsafe static void ExtractVector128(ushort* address, Vector256<ushort> value, byte index);
+        public unsafe static void ExtractVector128(uint* address, Vector256<uint> value, byte index);
+        public unsafe static void ExtractVector128(ulong* address, Vector256<ulong> value, byte index);
+        public static Vector128<T> ExtractVector128<T>(Vector256<T> value, byte index) where T : struct;
+        public static Vector256<double> Floor(Vector256<double> value);
+        public static Vector256<float> Floor(Vector256<float> value);
+        public static Vector128<T> GetLowerHalf<T>(Vector256<T> value) where T : struct;
+        public static Vector256<double> HorizontalAdd(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> HorizontalAdd(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> HorizontalSubtract(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> HorizontalSubtract(Vector256<float> left, Vector256<float> right);
+        public unsafe static Vector256<byte> Insert(Vector256<byte> value, byte* address, byte index);
+        public static Vector256<byte> Insert(Vector256<byte> value, byte data, byte index);
+        public unsafe static Vector256<double> Insert(Vector256<double> value, double* address, byte index);
+        public unsafe static Vector256<short> Insert(Vector256<short> value, short* address, byte index);
+        public static Vector256<short> Insert(Vector256<short> value, short data, byte index);
+        public unsafe static Vector256<int> Insert(Vector256<int> value, int* address, byte index);
+        public static Vector256<int> Insert(Vector256<int> value, int data, byte index);
+        public unsafe static Vector256<long> Insert(Vector256<long> value, long* address, byte index);
+        public static Vector256<long> Insert(Vector256<long> value, long data, byte index);
+        public unsafe static Vector256<sbyte> Insert(Vector256<sbyte> value, sbyte* address, byte index);
+        public static Vector256<sbyte> Insert(Vector256<sbyte> value, sbyte data, byte index);
+        public unsafe static Vector256<float> Insert(Vector256<float> value, float* address, byte index);
+        public unsafe static Vector256<ushort> Insert(Vector256<ushort> value, ushort* address, byte index);
+        public static Vector256<ushort> Insert(Vector256<ushort> value, ushort data, byte index);
+        public unsafe static Vector256<uint> Insert(Vector256<uint> value, uint* address, byte index);
+        public static Vector256<uint> Insert(Vector256<uint> value, uint data, byte index);
+        public unsafe static Vector256<ulong> Insert(Vector256<ulong> value, ulong* address, byte index);
+        public static Vector256<ulong> Insert(Vector256<ulong> value, ulong data, byte index);
+        public static Vector256<T> Insert<T>(Vector256<T> value, Vector128<T> data, byte index) where T : struct;
+        public unsafe static Vector256<byte> LoadAlignedVector256(byte* address);
+        public unsafe static Vector256<double> LoadAlignedVector256(double* address);
+        public unsafe static Vector256<short> LoadAlignedVector256(short* address);
+        public unsafe static Vector256<int> LoadAlignedVector256(int* address);
+        public unsafe static Vector256<long> LoadAlignedVector256(long* address);
+        public unsafe static Vector256<sbyte> LoadAlignedVector256(sbyte* address);
+        public unsafe static Vector256<float> LoadAlignedVector256(float* address);
+        public unsafe static Vector256<ushort> LoadAlignedVector256(ushort* address);
+        public unsafe static Vector256<uint> LoadAlignedVector256(uint* address);
+        public unsafe static Vector256<ulong> LoadAlignedVector256(ulong* address);
+        public unsafe static Vector256<byte> LoadDquVector256(byte* address);
+        public unsafe static Vector256<short> LoadDquVector256(short* address);
+        public unsafe static Vector256<int> LoadDquVector256(int* address);
+        public unsafe static Vector256<long> LoadDquVector256(long* address);
+        public unsafe static Vector256<sbyte> LoadDquVector256(sbyte* address);
+        public unsafe static Vector256<ushort> LoadDquVector256(ushort* address);
+        public unsafe static Vector256<uint> LoadDquVector256(uint* address);
+        public unsafe static Vector256<ulong> LoadDquVector256(ulong* address);
+        public unsafe static Vector256<byte> LoadVector256(byte* address);
+        public unsafe static Vector256<double> LoadVector256(double* address);
+        public unsafe static Vector256<short> LoadVector256(short* address);
+        public unsafe static Vector256<int> LoadVector256(int* address);
+        public unsafe static Vector256<long> LoadVector256(long* address);
+        public unsafe static Vector256<sbyte> LoadVector256(sbyte* address);
+        public unsafe static Vector256<float> LoadVector256(float* address);
+        public unsafe static Vector256<ushort> LoadVector256(ushort* address);
+        public unsafe static Vector256<uint> LoadVector256(uint* address);
+        public unsafe static Vector256<ulong> LoadVector256(ulong* address);
+        public unsafe static Vector128<double> MaskLoad(double* address, Vector128<ulong> mask);
+        public unsafe static Vector256<double> MaskLoad(double* address, Vector256<ulong> mask);
+        public unsafe static Vector128<float> MaskLoad(float* address, Vector128<uint> mask);
+        public unsafe static Vector256<float> MaskLoad(float* address, Vector256<uint> mask);
+        public unsafe static void MaskStore(double* address, Vector128<double> mask, Vector128<ulong> source);
+        public unsafe static void MaskStore(double* address, Vector256<double> mask, Vector256<ulong> source);
+        public unsafe static void MaskStore(float* address, Vector128<float> mask, Vector128<uint> source);
+        public unsafe static void MaskStore(float* address, Vector256<float> mask, Vector256<uint> source);
+        public static Vector256<double> Max(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Max(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> Min(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Min(Vector256<float> left, Vector256<float> right);
+        public static int MoveMask(Vector256<double> value);
+        public static int MoveMask(Vector256<float> value);
+        public static Vector256<double> Multiply(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Multiply(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> Or(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Or(Vector256<float> left, Vector256<float> right);
+        public static Vector128<double> Permute(Vector128<double> value, byte control);
+        public static Vector128<float> Permute(Vector128<float> value, byte control);
+        public static Vector256<double> Permute(Vector256<double> value, byte control);
+        public static Vector256<float> Permute(Vector256<float> value, byte control);
+        public static Vector256<T> Permute2x128<T>(Vector256<T> left, Vector256<T> right, byte control) where T : struct;
+        public static Vector128<double> PermuteVar(Vector128<double> left, Vector128<double> mask);
+        public static Vector128<float> PermuteVar(Vector128<float> left, Vector128<float> mask);
+        public static Vector256<double> PermuteVar(Vector256<double> left, Vector256<double> mask);
+        public static Vector256<float> PermuteVar(Vector256<float> left, Vector256<float> mask);
+        public static Vector256<float> Reciprocal(Vector256<float> value);
+        public static Vector256<float> ReciprocalSqrt(Vector256<float> value);
+        public static Vector256<double> RoundCurrentDirection(Vector256<double> value);
+        public static Vector256<float> RoundCurrentDirection(Vector256<float> value);
+        public static Vector256<double> RoundToNearestInteger(Vector256<double> value);
+        public static Vector256<float> RoundToNearestInteger(Vector256<float> value);
+        public static Vector256<double> RoundToNegativeInfinity(Vector256<double> value);
+        public static Vector256<float> RoundToNegativeInfinity(Vector256<float> value);
+        public static Vector256<double> RoundToPositiveInfinity(Vector256<double> value);
+        public static Vector256<float> RoundToPositiveInfinity(Vector256<float> value);
+        public static Vector256<double> RoundToZero(Vector256<double> value);
+        public static Vector256<float> RoundToZero(Vector256<float> value);
+        public static Vector256<T> SetAllVector256<T>(T value) where T : struct;
+        public static Vector256<T> SetHighLow<T>(Vector128<T> hi, Vector128<T> lo) where T : struct;
+        public static Vector256<byte> SetVector256(byte e31, byte e30, byte e29, byte e28, byte e27, byte e26, byte e25, byte e24, byte e23, byte e22, byte e21, byte e20, byte e19, byte e18, byte e17, byte e16, byte e15, byte e14, byte e13, byte e12, byte e11, byte e10, byte e9, byte e8, byte e7, byte e6, byte e5, byte e4, byte e3, byte e2, byte e1, byte e0);
+        public static Vector256<double> SetVector256(double e3, double e2, double e1, double e0);
+        public static Vector256<short> SetVector256(short e15, short e14, short e13, short e12, short e11, short e10, short e9, short e8, short e7, short e6, short e5, short e4, short e3, short e2, short e1, short e0);
+        public static Vector256<int> SetVector256(int e7, int e6, int e5, int e4, int e3, int e2, int e1, int e0);
+        public static Vector256<long> SetVector256(long e3, long e2, long e1, long e0);
+        public static Vector256<sbyte> SetVector256(sbyte e31, sbyte e30, sbyte e29, sbyte e28, sbyte e27, sbyte e26, sbyte e25, sbyte e24, sbyte e23, sbyte e22, sbyte e21, sbyte e20, sbyte e19, sbyte e18, sbyte e17, sbyte e16, sbyte e15, sbyte e14, sbyte e13, sbyte e12, sbyte e11, sbyte e10, sbyte e9, sbyte e8, sbyte e7, sbyte e6, sbyte e5, sbyte e4, sbyte e3, sbyte e2, sbyte e1, sbyte e0);
+        public static Vector256<float> SetVector256(float e7, float e6, float e5, float e4, float e3, float e2, float e1, float e0);
+        public static Vector256<ushort> SetVector256(ushort e15, ushort e14, ushort e13, ushort e12, ushort e11, ushort e10, ushort e9, ushort e8, ushort e7, ushort e6, ushort e5, ushort e4, ushort e3, ushort e2, ushort e1, ushort e0);
+        public static Vector256<uint> SetVector256(uint e7, uint e6, uint e5, uint e4, uint e3, uint e2, uint e1, uint e0);
+        public static Vector256<ulong> SetVector256(ulong e3, ulong e2, ulong e1, ulong e0);
+        public static Vector256<T> SetZeroVector256<T>() where T : struct;
+        public static Vector256<double> Shuffle(Vector256<double> value, Vector256<double> right, byte control);
+        public static Vector256<float> Shuffle(Vector256<float> value, Vector256<float> right, byte control);
+        public static Vector256<double> Sqrt(Vector256<double> value);
+        public static Vector256<float> Sqrt(Vector256<float> value);
+        public static Vector256<U> StaticCast<T, U>(Vector256<T> value) where T : struct where U : struct;
+        public unsafe static void Store(byte* address, Vector256<byte> source);
+        public unsafe static void Store(double* address, Vector256<double> source);
+        public unsafe static void Store(short* address, Vector256<short> source);
+        public unsafe static void Store(int* address, Vector256<int> source);
+        public unsafe static void Store(long* address, Vector256<long> source);
+        public unsafe static void Store(sbyte* address, Vector256<sbyte> source);
+        public unsafe static void Store(float* address, Vector256<float> source);
+        public unsafe static void Store(ushort* address, Vector256<ushort> source);
+        public unsafe static void Store(uint* address, Vector256<uint> source);
+        public unsafe static void Store(ulong* address, Vector256<ulong> source);
+        public unsafe static void StoreAligned(byte* address, Vector256<byte> source);
+        public unsafe static void StoreAligned(double* address, Vector256<double> source);
+        public unsafe static void StoreAligned(short* address, Vector256<short> source);
+        public unsafe static void StoreAligned(int* address, Vector256<int> source);
+        public unsafe static void StoreAligned(long* address, Vector256<long> source);
+        public unsafe static void StoreAligned(sbyte* address, Vector256<sbyte> source);
+        public unsafe static void StoreAligned(float* address, Vector256<float> source);
+        public unsafe static void StoreAligned(ushort* address, Vector256<ushort> source);
+        public unsafe static void StoreAligned(uint* address, Vector256<uint> source);
+        public unsafe static void StoreAligned(ulong* address, Vector256<ulong> source);
+        public unsafe static void StoreAlignedNonTemporal(byte* address, Vector256<byte> source);
+        public unsafe static void StoreAlignedNonTemporal(double* address, Vector256<double> source);
+        public unsafe static void StoreAlignedNonTemporal(short* address, Vector256<short> source);
+        public unsafe static void StoreAlignedNonTemporal(int* address, Vector256<int> source);
+        public unsafe static void StoreAlignedNonTemporal(long* address, Vector256<long> source);
+        public unsafe static void StoreAlignedNonTemporal(sbyte* address, Vector256<sbyte> source);
+        public unsafe static void StoreAlignedNonTemporal(float* address, Vector256<float> source);
+        public unsafe static void StoreAlignedNonTemporal(ushort* address, Vector256<ushort> source);
+        public unsafe static void StoreAlignedNonTemporal(uint* address, Vector256<uint> source);
+        public unsafe static void StoreAlignedNonTemporal(ulong* address, Vector256<ulong> source);
+        public static Vector256<double> Subtract(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Subtract(Vector256<float> left, Vector256<float> right);
+        public static bool TestC(Vector128<double> left, Vector128<double> right);
+        public static bool TestC(Vector128<float> left, Vector128<float> right);
+        public static bool TestC<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool TestNotZAndNotC(Vector128<double> left, Vector128<double> right);
+        public static bool TestNotZAndNotC(Vector128<float> left, Vector128<float> right);
+        public static bool TestNotZAndNotC<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool TestZ(Vector128<double> left, Vector128<double> right);
+        public static bool TestZ(Vector128<float> left, Vector128<float> right);
+        public static bool TestZ<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<double> UnpackHigh(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> UnpackHigh(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> UnpackLow(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> UnpackLow(Vector256<float> left, Vector256<float> right);
+        public static Vector256<double> Xor(Vector256<double> left, Vector256<double> right);
+        public static Vector256<float> Xor(Vector256<float> left, Vector256<float> right);
+        public static void ZeroAll();
+        public static Vector256<T> ZeroExtendToVector256<T>(Vector128<T> value) where T : struct;
+        public static void ZeroUpper();
+    }
+    public static class Avx2 {
+        public static bool IsSupported { get; }
+        public static Vector256<ushort> Abs(Vector256<short> value);
+        public static Vector256<uint> Abs(Vector256<int> value);
+        public static Vector256<byte> Abs(Vector256<sbyte> value);
+        public static Vector256<byte> Add(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Add(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Add(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> Add(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> Add(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Add(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Add(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> Add(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> AddSaturate(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> AddSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<sbyte> AddSaturate(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> AddSaturate(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<sbyte> AlignRight(Vector256<sbyte> left, Vector256<sbyte> right, byte mask);
+        public static Vector256<byte> And(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> And(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> And(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> And(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> And(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> And(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> And(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> And(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> AndNot(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> AndNot(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> AndNot(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> AndNot(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> AndNot(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> AndNot(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> AndNot(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> AndNot(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> Average(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<ushort> Average(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector128<int> Blend(Vector128<int> left, Vector128<int> right, byte control);
+        public static Vector128<uint> Blend(Vector128<uint> left, Vector128<uint> right, byte control);
+        public static Vector256<short> Blend(Vector256<short> left, Vector256<short> right, byte control);
+        public static Vector256<int> Blend(Vector256<int> left, Vector256<int> right, byte control);
+        public static Vector256<ushort> Blend(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static Vector256<uint> Blend(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static Vector256<byte> BlendVariable(Vector256<byte> left, Vector256<byte> right, Vector256<byte> mask);
+        public static Vector256<sbyte> BlendVariable(Vector256<sbyte> left, Vector256<sbyte> right, Vector256<sbyte> mask);
+        public static Vector128<T> BroadcastElementToVector128<T>(Vector128<T> value) where T : struct;
+        public static Vector256<T> BroadcastElementToVector256<T>(Vector128<T> value) where T : struct;
+        public unsafe static Vector256<byte> BroadcastVector128ToVector256(byte* address);
+        public unsafe static Vector256<short> BroadcastVector128ToVector256(short* address);
+        public unsafe static Vector256<int> BroadcastVector128ToVector256(int* address);
+        public unsafe static Vector256<long> BroadcastVector128ToVector256(long* address);
+        public unsafe static Vector256<sbyte> BroadcastVector128ToVector256(sbyte* address);
+        public unsafe static Vector256<ushort> BroadcastVector128ToVector256(ushort* address);
+        public unsafe static Vector256<uint> BroadcastVector128ToVector256(uint* address);
+        public unsafe static Vector256<ulong> BroadcastVector128ToVector256(ulong* address);
+        public static Vector256<byte> CompareEqual(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> CompareEqual(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> CompareEqual(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> CompareEqual(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> CompareEqual(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> CompareEqual(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> CompareEqual(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> CompareEqual(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<short> CompareGreaterThan(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> CompareGreaterThan(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> CompareGreaterThan(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> CompareGreaterThan(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static double ConvertToDouble(Vector256<double> value);
+        public static int ConvertToInt32(Vector256<int> value);
+        public static uint ConvertToUInt32(Vector256<uint> value);
+        public static Vector256<short> ConvertToVector256Int16(Vector128<sbyte> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector128<short> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector128<sbyte> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<short> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<int> value);
+        public static Vector256<long> ConvertToVector256Int64(Vector128<sbyte> value);
+        public static Vector256<ushort> ConvertToVector256UInt16(Vector128<byte> value);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector128<byte> value);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector128<ushort> value);
+        public static Vector256<ulong> ConvertToVector256UInt64(Vector128<byte> value);
+        public static Vector256<ulong> ConvertToVector256UInt64(Vector128<ushort> value);
+        public static Vector256<ulong> ConvertToVector256UInt64(Vector128<uint> value);
+        public unsafe static void ExtractVector128(byte* address, Vector256<byte> value, byte index);
+        public unsafe static void ExtractVector128(short* address, Vector256<short> value, byte index);
+        public unsafe static void ExtractVector128(int* address, Vector256<int> value, byte index);
+        public unsafe static void ExtractVector128(long* address, Vector256<long> value, byte index);
+        public static Vector128<byte> ExtractVector128(Vector256<byte> value, byte index);
+        public static Vector128<short> ExtractVector128(Vector256<short> value, byte index);
+        public static Vector128<int> ExtractVector128(Vector256<int> value, byte index);
+        public static Vector128<long> ExtractVector128(Vector256<long> value, byte index);
+        public static Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, byte index);
+        public static Vector128<ushort> ExtractVector128(Vector256<ushort> value, byte index);
+        public static Vector128<uint> ExtractVector128(Vector256<uint> value, byte index);
+        public static Vector128<ulong> ExtractVector128(Vector256<ulong> value, byte index);
+        public unsafe static void ExtractVector128(sbyte* address, Vector256<sbyte> value, byte index);
+        public unsafe static void ExtractVector128(ushort* address, Vector256<ushort> value, byte index);
+        public unsafe static void ExtractVector128(uint* address, Vector256<uint> value, byte index);
+        public unsafe static void ExtractVector128(ulong* address, Vector256<ulong> value, byte index);
+        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<int> index, Vector128<double> mask, byte scale);
+        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<long> index, Vector128<double> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<int> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<long> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector256<long> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<int> index, Vector128<long> mask, byte scale);
+        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<long> index, Vector128<long> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<int> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<long> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector256<long> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<int> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<long> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector256<long> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<int> index, Vector128<ulong> mask, byte scale);
+        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<long> index, Vector128<ulong> mask, byte scale);
+        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector128<int> index, Vector256<double> mask, byte scale);
+        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector256<long> index, Vector256<double> mask, byte scale);
+        public unsafe static Vector256<int> GatherMaskVector256(Vector256<int> source, int* baseAddress, Vector256<int> index, Vector256<int> mask, byte scale);
+        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector128<int> index, Vector256<long> mask, byte scale);
+        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector256<long> index, Vector256<long> mask, byte scale);
+        public unsafe static Vector256<float> GatherMaskVector256(Vector256<float> source, float* baseAddress, Vector256<int> index, Vector256<float> mask, byte scale);
+        public unsafe static Vector256<uint> GatherMaskVector256(Vector256<uint> source, uint* baseAddress, Vector256<int> index, Vector256<uint> mask, byte scale);
+        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector128<int> index, Vector256<ulong> mask, byte scale);
+        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector256<long> index, Vector256<ulong> mask, byte scale);
+        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<int> GatherVector256(int* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<float> GatherVector256(float* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<uint> GatherVector256(uint* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector256<long> index, byte scale);
+        public static Vector256<short> HorizontalAdd(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> HorizontalAdd(Vector256<int> left, Vector256<int> right);
+        public static Vector256<short> HorizontalAddSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<short> HorizontalSubtract(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> HorizontalSubtract(Vector256<int> left, Vector256<int> right);
+        public static Vector256<short> HorizontalSubtractSaturate(Vector256<short> left, Vector256<short> right);
+        public unsafe static Vector256<byte> Insert(Vector256<byte> value, byte* address, byte index);
+        public static Vector256<byte> Insert(Vector256<byte> value, Vector128<byte> data, byte index);
+        public unsafe static Vector256<short> Insert(Vector256<short> value, short* address, byte index);
+        public static Vector256<short> Insert(Vector256<short> value, Vector128<short> data, byte index);
+        public unsafe static Vector256<int> Insert(Vector256<int> value, int* address, byte index);
+        public static Vector256<int> Insert(Vector256<int> value, Vector128<int> data, byte index);
+        public unsafe static Vector256<long> Insert(Vector256<long> value, long* address, byte index);
+        public static Vector256<long> Insert(Vector256<long> value, Vector128<long> data, byte index);
+        public static Vector256<sbyte> Insert(Vector256<sbyte> value, Vector128<sbyte> data, byte index);
+        public unsafe static Vector256<sbyte> Insert(Vector256<sbyte> value, sbyte* address, byte index);
+        public static Vector256<ushort> Insert(Vector256<ushort> value, Vector128<ushort> data, byte index);
+        public unsafe static Vector256<ushort> Insert(Vector256<ushort> value, ushort* address, byte index);
+        public static Vector256<uint> Insert(Vector256<uint> value, Vector128<uint> data, byte index);
+        public unsafe static Vector256<uint> Insert(Vector256<uint> value, uint* address, byte index);
+        public static Vector256<ulong> Insert(Vector256<ulong> value, Vector128<ulong> data, byte index);
+        public unsafe static Vector256<ulong> Insert(Vector256<ulong> value, ulong* address, byte index);
+        public unsafe static Vector256<byte> LoadAlignedVector256NonTemporal(byte* address);
+        public unsafe static Vector256<short> LoadAlignedVector256NonTemporal(short* address);
+        public unsafe static Vector256<int> LoadAlignedVector256NonTemporal(int* address);
+        public unsafe static Vector256<long> LoadAlignedVector256NonTemporal(long* address);
+        public unsafe static Vector256<sbyte> LoadAlignedVector256NonTemporal(sbyte* address);
+        public unsafe static Vector256<ushort> LoadAlignedVector256NonTemporal(ushort* address);
+        public unsafe static Vector256<uint> LoadAlignedVector256NonTemporal(uint* address);
+        public unsafe static Vector256<ulong> LoadAlignedVector256NonTemporal(ulong* address);
+        public unsafe static Vector128<int> MaskLoad(int* address, Vector128<int> mask);
+        public unsafe static Vector256<int> MaskLoad(int* address, Vector256<int> mask);
+        public unsafe static Vector128<long> MaskLoad(long* address, Vector128<long> mask);
+        public unsafe static Vector256<long> MaskLoad(long* address, Vector256<long> mask);
+        public unsafe static Vector128<uint> MaskLoad(uint* address, Vector128<uint> mask);
+        public unsafe static Vector256<uint> MaskLoad(uint* address, Vector256<uint> mask);
+        public unsafe static Vector128<ulong> MaskLoad(ulong* address, Vector128<ulong> mask);
+        public unsafe static Vector256<ulong> MaskLoad(ulong* address, Vector256<ulong> mask);
+        public unsafe static void MaskStore(int* address, Vector128<int> mask, Vector128<int> source);
+        public unsafe static void MaskStore(int* address, Vector256<int> mask, Vector256<int> source);
+        public unsafe static void MaskStore(long* address, Vector128<long> mask, Vector128<long> source);
+        public unsafe static void MaskStore(long* address, Vector256<long> mask, Vector256<long> source);
+        public unsafe static void MaskStore(uint* address, Vector128<uint> mask, Vector128<uint> source);
+        public unsafe static void MaskStore(uint* address, Vector256<uint> mask, Vector256<uint> source);
+        public unsafe static void MaskStore(ulong* address, Vector128<ulong> mask, Vector128<ulong> source);
+        public unsafe static void MaskStore(ulong* address, Vector256<ulong> mask, Vector256<ulong> source);
+        public static Vector256<byte> Max(Vector256<byte> left, Vector256<short> right);
+        public static Vector256<short> Max(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Max(Vector256<int> left, Vector256<int> right);
+        public static Vector256<sbyte> Max(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Max(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Max(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<byte> Min(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Min(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Min(Vector256<int> left, Vector256<int> right);
+        public static Vector256<sbyte> Min(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Min(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Min(Vector256<uint> left, Vector256<uint> right);
+        public static int MoveMask(Vector256<byte> value);
+        public static int MoveMask(Vector256<sbyte> value);
+        public static Vector256<ushort> MultipleSumAbsoluteDifferences(Vector256<byte> left, Vector256<byte> right, byte mask);
+        public static Vector256<long> Multiply(Vector256<int> left, Vector256<int> right);
+        public static Vector256<ulong> Multiply(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<short> MultiplyAddAdjacent(Vector256<byte> left, Vector256<sbyte> right);
+        public static Vector256<int> MultiplyAddAdjacent(Vector256<short> left, Vector256<short> right);
+        public static Vector256<short> MultiplyHigh(Vector256<short> left, Vector256<short> right);
+        public static Vector256<ushort> MultiplyHigh(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<short> MultiplyHighRoundScale(Vector256<short> left, Vector256<short> right);
+        public static Vector256<short> MultiplyLow(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> MultiplyLow(Vector256<int> left, Vector256<int> right);
+        public static Vector256<byte> Or(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Or(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Or(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> Or(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> Or(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Or(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Or(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> Or(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<sbyte> PackSignedSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<short> PackSignedSaturate(Vector256<int> left, Vector256<int> right);
+        public static Vector256<byte> PackUnsignedSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<ushort> PackUnsignedSaturate(Vector256<int> left, Vector256<int> right);
+        public static Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, byte control);
+        public static Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, byte control);
+        public static Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, byte control);
+        public static Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, byte control);
+        public static Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, byte control);
+        public static Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, byte control);
+        public static Vector256<double> Permute4x64(Vector256<double> value, byte control);
+        public static Vector256<long> Permute4x64(Vector256<long> value, byte control);
+        public static Vector256<ulong> Permute4x64(Vector256<ulong> value, byte control);
+        public static Vector256<int> PermuteVar8x32(Vector256<int> left, Vector256<int> mask);
+        public static Vector256<float> PermuteVar8x32(Vector256<float> left, Vector256<float> mask);
+        public static Vector256<uint> PermuteVar8x32(Vector256<uint> left, Vector256<uint> mask);
+        public static Vector256<short> ShiftLeftLogical(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftLeftLogical(Vector256<short> value, Vector128<short> count);
+        public static Vector256<int> ShiftLeftLogical(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftLeftLogical(Vector256<int> value, Vector128<int> count);
+        public static Vector256<long> ShiftLeftLogical(Vector256<long> value, byte count);
+        public static Vector256<long> ShiftLeftLogical(Vector256<long> value, Vector128<long> count);
+        public static Vector256<ushort> ShiftLeftLogical(Vector256<ushort> value, byte count);
+        public static Vector256<ushort> ShiftLeftLogical(Vector256<ushort> value, Vector128<ushort> count);
+        public static Vector256<uint> ShiftLeftLogical(Vector256<uint> value, byte count);
+        public static Vector256<uint> ShiftLeftLogical(Vector256<uint> value, Vector128<uint> count);
+        public static Vector256<ulong> ShiftLeftLogical(Vector256<ulong> value, byte count);
+        public static Vector256<ulong> ShiftLeftLogical(Vector256<ulong> value, Vector128<ulong> count);
+        public static Vector256<byte> ShiftLeftLogical128BitLane(Vector256<byte> value, byte numBytes);
+        public static Vector256<short> ShiftLeftLogical128BitLane(Vector256<short> value, byte numBytes);
+        public static Vector256<int> ShiftLeftLogical128BitLane(Vector256<int> value, byte numBytes);
+        public static Vector256<long> ShiftLeftLogical128BitLane(Vector256<long> value, byte numBytes);
+        public static Vector256<sbyte> ShiftLeftLogical128BitLane(Vector256<sbyte> value, byte numBytes);
+        public static Vector256<ushort> ShiftLeftLogical128BitLane(Vector256<ushort> value, byte numBytes);
+        public static Vector256<uint> ShiftLeftLogical128BitLane(Vector256<uint> value, byte numBytes);
+        public static Vector256<ulong> ShiftLeftLogical128BitLane(Vector256<ulong> value, byte numBytes);
+        public static Vector128<int> ShiftLeftLogicalVariable(Vector128<int> value, Vector128<uint> count);
+        public static Vector128<long> ShiftLeftLogicalVariable(Vector128<long> value, Vector128<ulong> count);
+        public static Vector128<uint> ShiftLeftLogicalVariable(Vector128<uint> value, Vector128<uint> count);
+        public static Vector128<ulong> ShiftLeftLogicalVariable(Vector128<ulong> value, Vector128<ulong> count);
+        public static Vector256<int> ShiftLeftLogicalVariable(Vector256<int> value, Vector256<uint> count);
+        public static Vector256<long> ShiftLeftLogicalVariable(Vector256<long> value, Vector256<ulong> count);
+        public static Vector256<uint> ShiftLeftLogicalVariable(Vector256<uint> value, Vector256<uint> count);
+        public static Vector256<ulong> ShiftLeftLogicalVariable(Vector256<ulong> value, Vector256<ulong> count);
+        public static Vector256<short> ShiftRightArithmetic(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftRightArithmetic(Vector256<short> value, Vector128<short> count);
+        public static Vector256<int> ShiftRightArithmetic(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftRightArithmetic(Vector256<int> value, Vector128<int> count);
+        public static Vector128<int> ShiftRightArithmeticVariable(Vector128<int> value, Vector128<uint> count);
+        public static Vector256<int> ShiftRightArithmeticVariable(Vector256<int> value, Vector256<uint> count);
+        public static Vector256<short> ShiftRightLogical(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftRightLogical(Vector256<short> value, Vector128<short> count);
+        public static Vector256<int> ShiftRightLogical(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftRightLogical(Vector256<int> value, Vector128<int> count);
+        public static Vector256<long> ShiftRightLogical(Vector256<long> value, byte count);
+        public static Vector256<long> ShiftRightLogical(Vector256<long> value, Vector128<long> count);
+        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> value, byte count);
+        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> value, Vector128<ushort> count);
+        public static Vector256<uint> ShiftRightLogical(Vector256<uint> value, byte count);
+        public static Vector256<uint> ShiftRightLogical(Vector256<uint> value, Vector128<uint> count);
+        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> value, byte count);
+        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> value, Vector128<ulong> count);
+        public static Vector256<byte> ShiftRightLogical128BitLane(Vector256<byte> value, byte numBytes);
+        public static Vector256<short> ShiftRightLogical128BitLane(Vector256<short> value, byte numBytes);
+        public static Vector256<int> ShiftRightLogical128BitLane(Vector256<int> value, byte numBytes);
+        public static Vector256<long> ShiftRightLogical128BitLane(Vector256<long> value, byte numBytes);
+        public static Vector256<sbyte> ShiftRightLogical128BitLane(Vector256<sbyte> value, byte numBytes);
+        public static Vector256<ushort> ShiftRightLogical128BitLane(Vector256<ushort> value, byte numBytes);
+        public static Vector256<uint> ShiftRightLogical128BitLane(Vector256<uint> value, byte numBytes);
+        public static Vector256<ulong> ShiftRightLogical128BitLane(Vector256<ulong> value, byte numBytes);
+        public static Vector128<int> ShiftRightLogicalVariable(Vector128<int> value, Vector128<uint> count);
+        public static Vector128<long> ShiftRightLogicalVariable(Vector128<long> value, Vector128<ulong> count);
+        public static Vector128<uint> ShiftRightLogicalVariable(Vector128<uint> value, Vector128<uint> count);
+        public static Vector128<ulong> ShiftRightLogicalVariable(Vector128<ulong> value, Vector128<ulong> count);
+        public static Vector256<int> ShiftRightLogicalVariable(Vector256<int> value, Vector256<uint> count);
+        public static Vector256<long> ShiftRightLogicalVariable(Vector256<long> value, Vector256<ulong> count);
+        public static Vector256<uint> ShiftRightLogicalVariable(Vector256<uint> value, Vector256<uint> count);
+        public static Vector256<ulong> ShiftRightLogicalVariable(Vector256<ulong> value, Vector256<ulong> count);
+        public static Vector256<byte> Shuffle(Vector256<byte> value, Vector256<byte> mask);
+        public static Vector256<int> Shuffle(Vector256<int> value, byte control);
+        public static Vector256<sbyte> Shuffle(Vector256<sbyte> value, Vector256<sbyte> mask);
+        public static Vector256<uint> Shuffle(Vector256<uint> value, byte control);
+        public static Vector256<short> ShuffleHigh(Vector256<short> value, byte control);
+        public static Vector256<ushort> ShuffleHigh(Vector256<ushort> value, byte control);
+        public static Vector256<short> ShuffleLow(Vector256<short> value, byte control);
+        public static Vector256<ushort> ShuffleLow(Vector256<ushort> value, byte control);
+        public static Vector256<short> Sign(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Sign(Vector256<int> left, Vector256<int> right);
+        public static Vector256<sbyte> Sign(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<byte> Subtract(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Subtract(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Subtract(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> Subtract(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> Subtract(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Subtract(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Subtract(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> Subtract(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> SubtractSaturate(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> SubtractSaturate(Vector256<short> left, Vector256<short> right);
+        public static Vector256<sbyte> SubtractSaturate(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> SubtractSaturate(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<ulong> SumAbsoluteDifferences(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<byte> UnpackHigh(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> UnpackHigh(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> UnpackHigh(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> UnpackHigh(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> UnpackHigh(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> UnpackHigh(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> UnpackHigh(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> UnpackHigh(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> UnpackLow(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> UnpackLow(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> UnpackLow(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> UnpackLow(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> UnpackLow(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> UnpackLow(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> UnpackLow(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> UnpackLow(Vector256<ulong> left, Vector256<ulong> right);
+        public static Vector256<byte> Xor(Vector256<byte> left, Vector256<byte> right);
+        public static Vector256<short> Xor(Vector256<short> left, Vector256<short> right);
+        public static Vector256<int> Xor(Vector256<int> left, Vector256<int> right);
+        public static Vector256<long> Xor(Vector256<long> left, Vector256<long> right);
+        public static Vector256<sbyte> Xor(Vector256<sbyte> left, Vector256<sbyte> right);
+        public static Vector256<ushort> Xor(Vector256<ushort> left, Vector256<ushort> right);
+        public static Vector256<uint> Xor(Vector256<uint> left, Vector256<uint> right);
+        public static Vector256<ulong> Xor(Vector256<ulong> left, Vector256<ulong> right);
+    }
+    public static class Bmi1 {
+        public static bool IsSupported { get; }
+        public static uint AndNot(uint left, uint right);
+        public static ulong AndNot(ulong left, ulong right);
+        public static uint BitFieldExtract(uint value, uint control);
+        public static uint BitFieldExtract(uint value, uint start, uint length);
+        public static ulong BitFieldExtract(ulong value, ulong control);
+        public static ulong BitFieldExtract(ulong value, ulong start, ulong length);
+        public static uint ExtractLowestSetBit(uint value);
+        public static ulong ExtractLowestSetBit(ulong value);
+        public static uint GetMaskUptoLowestSetBit(uint value);
+        public static ulong GetMaskUptoLowestSetBit(ulong value);
+        public static uint ResetLowestSetBit(uint value);
+        public static ulong ResetLowestSetBit(ulong value);
+        public static uint TrailingZeroCount(uint value);
+        public static ulong TrailingZeroCount(ulong value);
+    }
+    public static class Bmi2 {
+        public static bool IsSupported { get; }
+        public unsafe static uint MultiplyNoFlags(uint left, uint right, uint* high);
+        public unsafe static ulong MultiplyNoFlags(ulong left, ulong right, ulong* high);
+        public static uint ParallelBitDeposit(uint value, uint mask);
+        public static ulong ParallelBitDeposit(ulong value, ulong mask);
+        public static uint ParallelBitExtract(uint value, uint mask);
+        public static ulong ParallelBitExtract(ulong value, ulong mask);
+        public static uint ZeroHighBits(uint value, uint index);
+        public static ulong ZeroHighBits(ulong value, ulong index);
+    }
+    public enum FloatComparisonMode : byte {
+        EqualOrderedNonSignaling = (byte)0,
+        EqualOrderedSignaling = (byte)16,
+        EqualUnorderedNonSignaling = (byte)8,
+        EqualUnorderedSignaling = (byte)24,
+        FalseOrderedNonSignaling = (byte)11,
+        FalseOrderedSignaling = (byte)27,
+        GreaterThanOrderedNonSignaling = (byte)30,
+        GreaterThanOrderedSignaling = (byte)14,
+        GreaterThanOrEqualOrderedNonSignaling = (byte)29,
+        GreaterThanOrEqualOrderedSignaling = (byte)13,
+        LessThanOrderedNonSignaling = (byte)17,
+        LessThanOrderedSignaling = (byte)1,
+        LessThanOrEqualOrderedNonSignaling = (byte)18,
+        LessThanOrEqualOrderedSignaling = (byte)2,
+        NotEqualOrderedNonSignaling = (byte)12,
+        NotEqualOrderedSignaling = (byte)28,
+        NotEqualUnorderedNonSignaling = (byte)4,
+        NotEqualUnorderedSignaling = (byte)20,
+        NotGreaterThanOrEqualUnorderedNonSignaling = (byte)25,
+        NotGreaterThanOrEqualUnorderedSignaling = (byte)9,
+        NotGreaterThanUnorderedNonSignaling = (byte)26,
+        NotGreaterThanUnorderedSignaling = (byte)10,
+        NotLessThanOrEqualUnorderedNonSignaling = (byte)22,
+        NotLessThanOrEqualUnorderedSignaling = (byte)6,
+        NotLessThanUnorderedNonSignaling = (byte)21,
+        NotLessThanUnorderedSignaling = (byte)5,
+        OrderedNonSignaling = (byte)7,
+        OrderedSignaling = (byte)23,
+        TrueUnorderedNonSignaling = (byte)15,
+        TrueUnorderedSignaling = (byte)31,
+        UnorderedNonSignaling = (byte)3,
+        UnorderedSignaling = (byte)19,
+    }
+    public static class Fma {
+        public static bool IsSupported { get; }
+        public static Vector128<double> MultiplyAdd(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAdd(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplyAdd(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplyAdd(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplyAddNegated(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAddNegated(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplyAddNegated(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplyAddNegated(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplyAddNegatedScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAddNegatedScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector128<double> MultiplyAddScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAddScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector128<double> MultiplyAddSubtract(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplyAddSubtract(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplyAddSubtract(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplyAddSubtract(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplySubtract(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtract(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplySubtract(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplySubtract(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplySubtractAdd(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtractAdd(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplySubtractAdd(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplySubtractAdd(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplySubtractNegated(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtractNegated(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector256<double> MultiplySubtractNegated(Vector256<double> a, Vector256<double> b, Vector256<double> c);
+        public static Vector256<float> MultiplySubtractNegated(Vector256<float> a, Vector256<float> b, Vector256<float> c);
+        public static Vector128<double> MultiplySubtractNegatedScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtractNegatedScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+        public static Vector128<double> MultiplySubtractScalar(Vector128<double> a, Vector128<double> b, Vector128<double> c);
+        public static Vector128<float> MultiplySubtractScalar(Vector128<float> a, Vector128<float> b, Vector128<float> c);
+    }
+    public static class Lzcnt {
+        public static bool IsSupported { get; }
+        public static uint LeadingZeroCount(uint value);
+        public static ulong LeadingZeroCount(ulong value);
+    }
+    public static class Pclmulqdq {
+        public static bool IsSupported { get; }
+        public static Vector128<long> CarryLessMultiply(Vector128<long> left, Vector128<long> right, byte control);
+        public static Vector128<ulong> CarryLessMultiply(Vector128<ulong> left, Vector128<ulong> right, byte control);
+    }
+    public static class Popcnt {
+        public static bool IsSupported { get; }
+        public static int PopCount(uint value);
+        public static long PopCount(ulong value);
+    }
+    public enum ResultsFlag : byte {
+        CFlag = (byte)0,
+        NotCFlagAndNotZFlag = (byte)1,
+        OFlag = (byte)2,
+        SFlag = (byte)3,
+        ZFlag = (byte)4,
+    }
+    public static class Sse {
+        public static bool IsSupported { get; }
+        public static Vector128<float> Add(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> AddScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> And(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> AndNot(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareEqualOrderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareEqualScalar(Vector128<float> left, Vector128<float> right);
+        public static bool CompareEqualUnorderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareGreaterThanOrderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareGreaterThanOrEqualOrderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareGreaterThanOrEqualScalar(Vector128<float> left, Vector128<float> right);
+        public static bool CompareGreaterThanOrEqualUnorderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareGreaterThanScalar(Vector128<float> left, Vector128<float> right);
+        public static bool CompareGreaterThanUnorderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareLessThan(Vector128<float> left, Vector128<float> right);
+        public static bool CompareLessThanOrderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareLessThanOrEqualOrderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareLessThanOrEqualScalar(Vector128<float> left, Vector128<float> right);
+        public static bool CompareLessThanOrEqualUnorderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareLessThanScalar(Vector128<float> left, Vector128<float> right);
+        public static bool CompareLessThanUnorderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotEqual(Vector128<float> left, Vector128<float> right);
+        public static bool CompareNotEqualOrderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotEqualScalar(Vector128<float> left, Vector128<float> right);
+        public static bool CompareNotEqualUnorderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotGreaterThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotGreaterThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotGreaterThanOrEqualScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotGreaterThanScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotLessThan(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotLessThanOrEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotLessThanOrEqualScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareNotLessThanScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareOrdered(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareOrderedScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareUnordered(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> CompareUnorderedScalar(Vector128<float> left, Vector128<float> right);
+        public static int ConvertToInt32(Vector128<float> value);
+        public static int ConvertToInt32WithTruncation(Vector128<float> value);
+        public static long ConvertToInt64(Vector128<float> value);
+        public static long ConvertToInt64WithTruncation(Vector128<float> value);
+        public static float ConvertToSingle(Vector128<float> value);
+        public static Vector128<float> ConvertToVector128SingleScalar(Vector128<float> upper, int value);
+        public static Vector128<float> ConvertToVector128SingleScalar(Vector128<float> upper, long value);
+        public static Vector128<float> Divide(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> DivideScalar(Vector128<float> left, Vector128<float> right);
+        public unsafe static Vector128<float> LoadAlignedVector128(float* address);
+        public unsafe static Vector128<float> LoadHigh(Vector128<float> value, float* address);
+        public unsafe static Vector128<float> LoadLow(Vector128<float> value, float* address);
+        public unsafe static Vector128<float> LoadScalar(float* address);
+        public unsafe static Vector128<float> LoadVector128(float* address);
+        public static Vector128<float> Max(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MaxScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> Min(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MinScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MoveHighToLow(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MoveLowToHigh(Vector128<float> left, Vector128<float> right);
+        public static int MoveMask(Vector128<float> value);
+        public static Vector128<float> MoveScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector128<float> Multiply(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> MultiplyScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> Or(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> Reciprocal(Vector128<float> value);
+        public static Vector128<float> ReciprocalScalar(Vector128<float> value);
+        public static Vector128<float> ReciprocalSqrt(Vector128<float> value);
+        public static Vector128<float> ReciprocalSqrtScalar(Vector128<float> value);
+        public static Vector128<float> SetAllVector128(float value);
+        public static Vector128<float> SetScalar(float value);
+        public static Vector128<float> SetVector128(float e3, float e2, float e1, float e0);
+        public static Vector128<float> SetZeroVector128();
+        public static Vector128<float> Shuffle(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<float> Sqrt(Vector128<float> value);
+        public static Vector128<float> SqrtScalar(Vector128<float> value);
+        public static Vector128<U> StaticCast<T, U>(Vector128<T> value) where T : struct where U : struct;
+        public unsafe static void Store(float* address, Vector128<float> source);
+        public unsafe static void StoreAligned(float* address, Vector128<float> source);
+        public unsafe static void StoreAlignedNonTemporal(float* address, Vector128<float> source);
+        public unsafe static void StoreHigh(float* address, Vector128<float> source);
+        public unsafe static void StoreLow(float* address, Vector128<float> source);
+        public unsafe static void StoreScalar(float* address, Vector128<float> source);
+        public static Vector128<float> Subtract(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> SubtractScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> UnpackHigh(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> UnpackLow(Vector128<float> left, Vector128<float> right);
+        public static Vector128<float> Xor(Vector128<float> left, Vector128<float> right);
+    }
+    public static class Sse2 {
+        public static bool IsSupported { get; }
+        public static Vector128<byte> Add(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Add(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Add(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Add(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Add(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> Add(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Add(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Add(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Add(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> AddSaturate(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> AddSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<sbyte> AddSaturate(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> AddSaturate(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<double> AddScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<byte> And(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> And(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> And(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> And(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> And(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> And(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> And(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> And(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> And(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> AndNot(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> AndNot(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> AndNot(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> AndNot(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> AndNot(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> AndNot(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> AndNot(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> AndNot(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> AndNot(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> Average(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<ushort> Average(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<byte> CompareEqual(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> CompareEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> CompareEqual(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> CompareEqual(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> CompareEqual(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> CompareEqual(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> CompareEqual(Vector128<uint> left, Vector128<uint> right);
+        public static bool CompareEqualOrderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareEqualScalar(Vector128<double> left, Vector128<double> right);
+        public static bool CompareEqualUnorderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> CompareGreaterThan(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> CompareGreaterThan(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> CompareGreaterThan(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool CompareGreaterThanOrderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareGreaterThanOrEqualOrderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareGreaterThanOrEqualScalar(Vector128<double> left, Vector128<double> right);
+        public static bool CompareGreaterThanOrEqualUnorderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareGreaterThanScalar(Vector128<double> left, Vector128<double> right);
+        public static bool CompareGreaterThanUnorderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareLessThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> CompareLessThan(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> CompareLessThan(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> CompareLessThan(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool CompareLessThanOrderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareLessThanOrEqualOrderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareLessThanOrEqualScalar(Vector128<double> left, Vector128<double> right);
+        public static bool CompareLessThanOrEqualUnorderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareLessThanScalar(Vector128<double> left, Vector128<double> right);
+        public static bool CompareLessThanUnorderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotEqual(Vector128<double> left, Vector128<double> right);
+        public static bool CompareNotEqualOrderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotEqualScalar(Vector128<double> left, Vector128<double> right);
+        public static bool CompareNotEqualUnorderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotGreaterThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotGreaterThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotGreaterThanOrEqualScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotGreaterThanScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotLessThan(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotLessThanOrEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotLessThanOrEqualScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareNotLessThanScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareOrdered(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareOrderedScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareUnordered(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> CompareUnorderedScalar(Vector128<double> left, Vector128<double> right);
+        public static double ConvertToDouble(Vector128<double> value);
+        public static int ConvertToInt32(Vector128<double> value);
+        public static int ConvertToInt32(Vector128<int> value);
+        public static int ConvertToInt32WithTruncation(Vector128<double> value);
+        public static long ConvertToInt64(Vector128<double> value);
+        public static long ConvertToInt64(Vector128<long> value);
+        public static long ConvertToInt64WithTruncation(Vector128<double> value);
+        public static uint ConvertToUInt32(Vector128<uint> value);
+        public static ulong ConvertToUInt64(Vector128<ulong> value);
+        public static Vector128<double> ConvertToVector128Double(Vector128<int> value);
+        public static Vector128<double> ConvertToVector128Double(Vector128<float> value);
+        public static Vector128<double> ConvertToVector128DoubleScalar(Vector128<double> upper, int value);
+        public static Vector128<double> ConvertToVector128DoubleScalar(Vector128<double> upper, long value);
+        public static Vector128<double> ConvertToVector128DoubleScalar(Vector128<double> upper, Vector128<float> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<double> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<float> value);
+        public static Vector128<int> ConvertToVector128Int32Scalar(int value);
+        public static Vector128<int> ConvertToVector128Int32WithTruncation(Vector128<double> value);
+        public static Vector128<int> ConvertToVector128Int32WithTruncation(Vector128<float> value);
+        public static Vector128<long> ConvertToVector128Int64Scalar(long value);
+        public static Vector128<float> ConvertToVector128Single(Vector128<double> value);
+        public static Vector128<float> ConvertToVector128Single(Vector128<int> value);
+        public static Vector128<float> ConvertToVector128SingleScalar(Vector128<float> upper, Vector128<double> value);
+        public static Vector128<uint> ConvertToVector128UInt32Scalar(uint value);
+        public static Vector128<ulong> ConvertToVector128UInt64Scalar(ulong value);
+        public static Vector128<double> Divide(Vector128<double> left, Vector128<double> right);
+        public static Vector128<double> DivideScalar(Vector128<double> left, Vector128<double> right);
+        public static short Extract(Vector128<short> value, byte index);
+        public static ushort Extract(Vector128<ushort> value, byte index);
+        public static Vector128<short> Insert(Vector128<short> value, short data, byte index);
+        public static Vector128<ushort> Insert(Vector128<ushort> value, ushort data, byte index);
+        public unsafe static Vector128<byte> LoadAlignedVector128(byte* address);
+        public unsafe static Vector128<double> LoadAlignedVector128(double* address);
+        public unsafe static Vector128<short> LoadAlignedVector128(short* address);
+        public unsafe static Vector128<int> LoadAlignedVector128(int* address);
+        public unsafe static Vector128<long> LoadAlignedVector128(long* address);
+        public unsafe static Vector128<sbyte> LoadAlignedVector128(sbyte* address);
+        public unsafe static Vector128<ushort> LoadAlignedVector128(ushort* address);
+        public unsafe static Vector128<uint> LoadAlignedVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadAlignedVector128(ulong* address);
+        public unsafe static Vector128<double> LoadHigh(Vector128<double> value, double* address);
+        public unsafe static Vector128<double> LoadLow(Vector128<double> value, double* address);
+        public unsafe static Vector128<byte> LoadScalar(byte* address);
+        public unsafe static Vector128<double> LoadScalar(double* address);
+        public unsafe static Vector128<short> LoadScalar(short* address);
+        public unsafe static Vector128<int> LoadScalar(int* address);
+        public unsafe static Vector128<long> LoadScalar(long* address);
+        public unsafe static Vector128<sbyte> LoadScalar(sbyte* address);
+        public unsafe static Vector128<ushort> LoadScalar(ushort* address);
+        public unsafe static Vector128<uint> LoadScalar(uint* address);
+        public unsafe static Vector128<ulong> LoadScalar(ulong* address);
+        public unsafe static Vector128<byte> LoadVector128(byte* address);
+        public unsafe static Vector128<double> LoadVector128(double* address);
+        public unsafe static Vector128<short> LoadVector128(short* address);
+        public unsafe static Vector128<int> LoadVector128(int* address);
+        public unsafe static Vector128<long> LoadVector128(long* address);
+        public unsafe static Vector128<sbyte> LoadVector128(sbyte* address);
+        public unsafe static Vector128<ushort> LoadVector128(ushort* address);
+        public unsafe static Vector128<uint> LoadVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadVector128(ulong* address);
+        public unsafe static void MaskMove(Vector128<byte> source, Vector128<byte> mask, byte* address);
+        public unsafe static void MaskMove(Vector128<sbyte> source, Vector128<sbyte> mask, sbyte* address);
+        public static Vector128<byte> Max(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Max(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Max(Vector128<short> left, Vector128<short> right);
+        public static Vector128<double> MaxScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<byte> Min(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Min(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Min(Vector128<short> left, Vector128<short> right);
+        public static Vector128<double> MinScalar(Vector128<double> left, Vector128<double> right);
+        public static int MoveMask(Vector128<double> value);
+        public static int MoveMask(Vector128<sbyte> value);
+        public static Vector128<double> MoveScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<double> Multiply(Vector128<double> left, Vector128<double> right);
+        public static Vector128<ulong> Multiply(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<short> MultiplyHigh(Vector128<short> left, Vector128<short> right);
+        public static Vector128<ushort> MultiplyHigh(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<int> MultiplyHorizontalAdd(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> MultiplyLow(Vector128<short> left, Vector128<short> right);
+        public static Vector128<double> MultiplyScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<byte> Or(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Or(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Or(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Or(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Or(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> Or(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Or(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Or(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Or(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<sbyte> PackSignedSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> PackSignedSaturate(Vector128<int> left, Vector128<int> right);
+        public static Vector128<byte> PackUnsignedSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<byte> SetAllVector128(byte value);
+        public static Vector128<double> SetAllVector128(double value);
+        public static Vector128<short> SetAllVector128(short value);
+        public static Vector128<int> SetAllVector128(int value);
+        public static Vector128<long> SetAllVector128(long value);
+        public static Vector128<sbyte> SetAllVector128(sbyte value);
+        public static Vector128<ushort> SetAllVector128(ushort value);
+        public static Vector128<uint> SetAllVector128(uint value);
+        public static Vector128<ulong> SetAllVector128(ulong value);
+        public static Vector128<double> SetScalar(double value);
+        public static Vector128<byte> SetVector128(byte e15, byte e14, byte e13, byte e12, byte e11, byte e10, byte e9, byte e8, byte e7, byte e6, byte e5, byte e4, byte e3, byte e2, byte e1, byte e0);
+        public static Vector128<double> SetVector128(double e1, double e0);
+        public static Vector128<short> SetVector128(short e7, short e6, short e5, short e4, short e3, short e2, short e1, short e0);
+        public static Vector128<int> SetVector128(int e3, int e2, int e1, int e0);
+        public static Vector128<long> SetVector128(long e1, long e0);
+        public static Vector128<sbyte> SetVector128(sbyte e15, sbyte e14, sbyte e13, sbyte e12, sbyte e11, sbyte e10, sbyte e9, sbyte e8, sbyte e7, sbyte e6, sbyte e5, sbyte e4, sbyte e3, sbyte e2, sbyte e1, sbyte e0);
+        public static Vector128<ushort> SetVector128(ushort e7, ushort e6, ushort e5, ushort e4, ushort e3, ushort e2, ushort e1, ushort e0);
+        public static Vector128<uint> SetVector128(uint e3, uint e2, uint e1, uint e0);
+        public static Vector128<ulong> SetVector128(ulong e1, ulong e0);
+        public static Vector128<T> SetZeroVector128<T>() where T : struct;
+        public static Vector128<short> ShiftLeftLogical(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftLeftLogical(Vector128<short> value, Vector128<short> count);
+        public static Vector128<int> ShiftLeftLogical(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftLeftLogical(Vector128<int> value, Vector128<int> count);
+        public static Vector128<long> ShiftLeftLogical(Vector128<long> value, byte count);
+        public static Vector128<long> ShiftLeftLogical(Vector128<long> value, Vector128<long> count);
+        public static Vector128<ushort> ShiftLeftLogical(Vector128<ushort> value, byte count);
+        public static Vector128<ushort> ShiftLeftLogical(Vector128<ushort> value, Vector128<ushort> count);
+        public static Vector128<uint> ShiftLeftLogical(Vector128<uint> value, byte count);
+        public static Vector128<uint> ShiftLeftLogical(Vector128<uint> value, Vector128<uint> count);
+        public static Vector128<ulong> ShiftLeftLogical(Vector128<ulong> value, byte count);
+        public static Vector128<ulong> ShiftLeftLogical(Vector128<ulong> value, Vector128<ulong> count);
+        public static Vector128<byte> ShiftLeftLogical128BitLane(Vector128<byte> value, byte numBytes);
+        public static Vector128<short> ShiftLeftLogical128BitLane(Vector128<short> value, byte numBytes);
+        public static Vector128<int> ShiftLeftLogical128BitLane(Vector128<int> value, byte numBytes);
+        public static Vector128<long> ShiftLeftLogical128BitLane(Vector128<long> value, byte numBytes);
+        public static Vector128<sbyte> ShiftLeftLogical128BitLane(Vector128<sbyte> value, byte numBytes);
+        public static Vector128<ushort> ShiftLeftLogical128BitLane(Vector128<ushort> value, byte numBytes);
+        public static Vector128<uint> ShiftLeftLogical128BitLane(Vector128<uint> value, byte numBytes);
+        public static Vector128<ulong> ShiftLeftLogical128BitLane(Vector128<ulong> value, byte numBytes);
+        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, Vector128<short> count);
+        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, Vector128<int> count);
+        public static Vector128<short> ShiftRightLogical(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftRightLogical(Vector128<short> value, Vector128<short> count);
+        public static Vector128<int> ShiftRightLogical(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftRightLogical(Vector128<int> value, Vector128<int> count);
+        public static Vector128<long> ShiftRightLogical(Vector128<long> value, byte count);
+        public static Vector128<long> ShiftRightLogical(Vector128<long> value, Vector128<long> count);
+        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, byte count);
+        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, Vector128<ushort> count);
+        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, byte count);
+        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, Vector128<uint> count);
+        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, byte count);
+        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, Vector128<ulong> count);
+        public static Vector128<byte> ShiftRightLogical128BitLane(Vector128<byte> value, byte numBytes);
+        public static Vector128<short> ShiftRightLogical128BitLane(Vector128<short> value, byte numBytes);
+        public static Vector128<int> ShiftRightLogical128BitLane(Vector128<int> value, byte numBytes);
+        public static Vector128<long> ShiftRightLogical128BitLane(Vector128<long> value, byte numBytes);
+        public static Vector128<sbyte> ShiftRightLogical128BitLane(Vector128<sbyte> value, byte numBytes);
+        public static Vector128<ushort> ShiftRightLogical128BitLane(Vector128<ushort> value, byte numBytes);
+        public static Vector128<uint> ShiftRightLogical128BitLane(Vector128<uint> value, byte numBytes);
+        public static Vector128<ulong> ShiftRightLogical128BitLane(Vector128<ulong> value, byte numBytes);
+        public static Vector128<double> Shuffle(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<int> Shuffle(Vector128<int> value, byte control);
+        public static Vector128<uint> Shuffle(Vector128<uint> value, byte control);
+        public static Vector128<short> ShuffleHigh(Vector128<short> value, byte control);
+        public static Vector128<ushort> ShuffleHigh(Vector128<ushort> value, byte control);
+        public static Vector128<short> ShuffleLow(Vector128<short> value, byte control);
+        public static Vector128<ushort> ShuffleLow(Vector128<ushort> value, byte control);
+        public static Vector128<double> Sqrt(Vector128<double> value);
+        public static Vector128<double> SqrtScalar(Vector128<double> value);
+        public unsafe static void Store(byte* address, Vector128<byte> source);
+        public unsafe static void Store(double* address, Vector128<double> source);
+        public unsafe static void Store(short* address, Vector128<short> source);
+        public unsafe static void Store(int* address, Vector128<int> source);
+        public unsafe static void Store(long* address, Vector128<long> source);
+        public unsafe static void Store(sbyte* address, Vector128<sbyte> source);
+        public unsafe static void Store(ushort* address, Vector128<ushort> source);
+        public unsafe static void Store(uint* address, Vector128<uint> source);
+        public unsafe static void Store(ulong* address, Vector128<ulong> source);
+        public unsafe static void StoreAligned(byte* address, Vector128<byte> source);
+        public unsafe static void StoreAligned(double* address, Vector128<double> source);
+        public unsafe static void StoreAligned(short* address, Vector128<short> source);
+        public unsafe static void StoreAligned(int* address, Vector128<int> source);
+        public unsafe static void StoreAligned(long* address, Vector128<long> source);
+        public unsafe static void StoreAligned(sbyte* address, Vector128<sbyte> source);
+        public unsafe static void StoreAligned(ushort* address, Vector128<ushort> source);
+        public unsafe static void StoreAligned(uint* address, Vector128<uint> source);
+        public unsafe static void StoreAligned(ulong* address, Vector128<ulong> source);
+        public unsafe static void StoreAlignedNonTemporal(byte* address, Vector128<byte> source);
+        public unsafe static void StoreAlignedNonTemporal(double* address, Vector128<double> source);
+        public unsafe static void StoreAlignedNonTemporal(short* address, Vector128<short> source);
+        public unsafe static void StoreAlignedNonTemporal(int* address, Vector128<int> source);
+        public unsafe static void StoreAlignedNonTemporal(long* address, Vector128<long> source);
+        public unsafe static void StoreAlignedNonTemporal(sbyte* address, Vector128<sbyte> source);
+        public unsafe static void StoreAlignedNonTemporal(ushort* address, Vector128<ushort> source);
+        public unsafe static void StoreAlignedNonTemporal(uint* address, Vector128<uint> source);
+        public unsafe static void StoreAlignedNonTemporal(ulong* address, Vector128<ulong> source);
+        public unsafe static void StoreHigh(double* address, Vector128<double> source);
+        public unsafe static void StoreLow(double* address, Vector128<double> source);
+        public unsafe static void StoreLow(long* address, Vector128<long> source);
+        public unsafe static void StoreLow(ulong* address, Vector128<ulong> source);
+        public unsafe static void StoreScalar(double* address, Vector128<double> source);
+        public static Vector128<byte> Subtract(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Subtract(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Subtract(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Subtract(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Subtract(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> Subtract(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Subtract(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Subtract(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Subtract(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> SubtractSaturate(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> SubtractSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<sbyte> SubtractSaturate(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> SubtractSaturate(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<double> SubtractScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<long> SumAbsoluteDifferences(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<byte> UnpackHigh(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> UnpackHigh(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> UnpackHigh(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> UnpackHigh(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> UnpackHigh(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> UnpackHigh(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> UnpackHigh(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> UnpackHigh(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> UnpackHigh(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> UnpackLow(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> UnpackLow(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> UnpackLow(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> UnpackLow(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> UnpackLow(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> UnpackLow(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> UnpackLow(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> UnpackLow(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> UnpackLow(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<byte> Xor(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Xor(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Xor(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Xor(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Xor(Vector128<long> left, Vector128<long> right);
+        public static Vector128<sbyte> Xor(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Xor(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Xor(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Xor(Vector128<ulong> left, Vector128<ulong> right);
+    }
+    public static class Sse3 {
+        public static bool IsSupported { get; }
+        public static Vector128<double> AddSubtract(Vector128<double> left, Vector128<double> right);
+        public static Vector128<float> AddSubtract(Vector128<float> left, Vector128<float> right);
+        public static Vector128<double> HorizontalAdd(Vector128<double> left, Vector128<double> right);
+        public static Vector128<float> HorizontalAdd(Vector128<float> left, Vector128<float> right);
+        public static Vector128<double> HorizontalSubtract(Vector128<double> left, Vector128<double> right);
+        public static Vector128<float> HorizontalSubtract(Vector128<float> left, Vector128<float> right);
+        public unsafe static Vector128<double> LoadAndDuplicateToVector128(double* address);
+        public unsafe static Vector128<byte> LoadDquVector128(byte* address);
+        public unsafe static Vector128<short> LoadDquVector128(short* address);
+        public unsafe static Vector128<int> LoadDquVector128(int* address);
+        public unsafe static Vector128<long> LoadDquVector128(long* address);
+        public unsafe static Vector128<sbyte> LoadDquVector128(sbyte* address);
+        public unsafe static Vector128<ushort> LoadDquVector128(ushort* address);
+        public unsafe static Vector128<uint> LoadDquVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadDquVector128(ulong* address);
+        public static Vector128<double> MoveAndDuplicate(Vector128<double> source);
+        public static Vector128<float> MoveHighAndDuplicate(Vector128<float> source);
+        public static Vector128<float> MoveLowAndDuplicate(Vector128<float> source);
+    }
+    public static class Sse41 {
+        public static bool IsSupported { get; }
+        public static Vector128<double> Blend(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<short> Blend(Vector128<short> left, Vector128<short> right, byte control);
+        public static Vector128<float> Blend(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<ushort> Blend(Vector128<ushort> left, Vector128<ushort> right, byte control);
+        public static Vector128<byte> BlendVariable(Vector128<byte> left, Vector128<byte> right, Vector128<byte> mask);
+        public static Vector128<double> BlendVariable(Vector128<double> left, Vector128<double> right, Vector128<double> mask);
+        public static Vector128<sbyte> BlendVariable(Vector128<sbyte> left, Vector128<sbyte> right, Vector128<sbyte> mask);
+        public static Vector128<float> BlendVariable(Vector128<float> left, Vector128<float> right, Vector128<float> mask);
+        public static Vector128<double> Ceiling(Vector128<double> value);
+        public static Vector128<float> Ceiling(Vector128<float> value);
+        public static Vector128<double> CeilingScalar(Vector128<double> value);
+        public static Vector128<float> CeilingScalar(Vector128<float> value);
+        public static Vector128<long> CompareEqual(Vector128<long> left, Vector128<long> right);
+        public static Vector128<ulong> CompareEqual(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<short> ConvertToVector128Int16(Vector128<byte> value);
+        public static Vector128<short> ConvertToVector128Int16(Vector128<sbyte> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<byte> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<short> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<sbyte> value);
+        public static Vector128<int> ConvertToVector128Int32(Vector128<ushort> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<byte> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<short> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<int> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<sbyte> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<ushort> value);
+        public static Vector128<long> ConvertToVector128Int64(Vector128<uint> value);
+        public static Vector128<double> DotProduct(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<float> DotProduct(Vector128<float> left, Vector128<float> right, byte control);
+        public static byte Extract(Vector128<byte> value, byte index);
+        public static int Extract(Vector128<int> value, byte index);
+        public static long Extract(Vector128<long> value, byte index);
+        public static sbyte Extract(Vector128<sbyte> value, byte index);
+        public static float Extract(Vector128<float> value, byte index);
+        public static uint Extract(Vector128<uint> value, byte index);
+        public static ulong Extract(Vector128<ulong> value, byte index);
+        public static Vector128<double> Floor(Vector128<double> value);
+        public static Vector128<float> Floor(Vector128<float> value);
+        public static Vector128<double> FloorScalar(Vector128<double> value);
+        public static Vector128<float> FloorScalar(Vector128<float> value);
+        public static Vector128<byte> Insert(Vector128<byte> value, byte data, byte index);
+        public static Vector128<int> Insert(Vector128<int> value, int data, byte index);
+        public static Vector128<long> Insert(Vector128<long> value, long data, byte index);
+        public static Vector128<sbyte> Insert(Vector128<sbyte> value, sbyte data, byte index);
+        public static Vector128<float> Insert(Vector128<float> value, float data, byte index);
+        public static Vector128<uint> Insert(Vector128<uint> value, uint data, byte index);
+        public static Vector128<ulong> Insert(Vector128<ulong> value, ulong data, byte index);
+        public unsafe static Vector128<byte> LoadAlignedNonTemporal(byte* address);
+        public unsafe static Vector128<short> LoadAlignedNonTemporal(short* address);
+        public unsafe static Vector128<int> LoadAlignedNonTemporal(int* address);
+        public unsafe static Vector128<long> LoadAlignedNonTemporal(long* address);
+        public unsafe static Vector128<sbyte> LoadAlignedNonTemporal(sbyte* address);
+        public unsafe static Vector128<ushort> LoadAlignedNonTemporal(ushort* address);
+        public unsafe static Vector128<uint> LoadAlignedNonTemporal(uint* address);
+        public unsafe static Vector128<ulong> LoadAlignedNonTemporal(ulong* address);
+        public static Vector128<int> Max(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> Max(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Max(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Max(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<int> Min(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> Min(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Min(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Min(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ushort> MinHorizontal(Vector128<ushort> value);
+        public static Vector128<ushort> MultipleSumAbsoluteDifferences(Vector128<byte> left, Vector128<byte> right, byte mask);
+        public static Vector128<long> Multiply(Vector128<int> left, Vector128<int> right);
+        public static Vector128<int> MultiplyLow(Vector128<int> left, Vector128<int> right);
+        public static Vector128<ushort> PackUnsignedSaturate(Vector128<int> left, Vector128<int> right);
+        public static Vector128<double> RoundCurrentDirection(Vector128<double> value);
+        public static Vector128<float> RoundCurrentDirection(Vector128<float> value);
+        public static Vector128<double> RoundCurrentDirectionScalar(Vector128<double> value);
+        public static Vector128<float> RoundCurrentDirectionScalar(Vector128<float> value);
+        public static Vector128<double> RoundToNearestInteger(Vector128<double> value);
+        public static Vector128<float> RoundToNearestInteger(Vector128<float> value);
+        public static Vector128<double> RoundToNearestIntegerScalar(Vector128<double> value);
+        public static Vector128<float> RoundToNearestIntegerScalar(Vector128<float> value);
+        public static Vector128<double> RoundToNegativeInfinity(Vector128<double> value);
+        public static Vector128<float> RoundToNegativeInfinity(Vector128<float> value);
+        public static Vector128<double> RoundToNegativeInfinityScalar(Vector128<double> value);
+        public static Vector128<float> RoundToNegativeInfinityScalar(Vector128<float> value);
+        public static Vector128<double> RoundToPositiveInfinity(Vector128<double> value);
+        public static Vector128<float> RoundToPositiveInfinity(Vector128<float> value);
+        public static Vector128<double> RoundToPositiveInfinityScalar(Vector128<double> value);
+        public static Vector128<float> RoundToPositiveInfinityScalar(Vector128<float> value);
+        public static Vector128<double> RoundToZero(Vector128<double> value);
+        public static Vector128<float> RoundToZero(Vector128<float> value);
+        public static Vector128<double> RoundToZeroScalar(Vector128<double> value);
+        public static Vector128<float> RoundToZeroScalar(Vector128<float> value);
+        public static bool TestAllOnes(Vector128<byte> value);
+        public static bool TestAllOnes(Vector128<short> value);
+        public static bool TestAllOnes(Vector128<int> value);
+        public static bool TestAllOnes(Vector128<long> value);
+        public static bool TestAllOnes(Vector128<sbyte> value);
+        public static bool TestAllOnes(Vector128<ushort> value);
+        public static bool TestAllOnes(Vector128<uint> value);
+        public static bool TestAllOnes(Vector128<ulong> value);
+        public static bool TestAllZeros(Vector128<byte> left, Vector128<byte> right);
+        public static bool TestAllZeros(Vector128<short> left, Vector128<short> right);
+        public static bool TestAllZeros(Vector128<int> left, Vector128<int> right);
+        public static bool TestAllZeros(Vector128<long> left, Vector128<long> right);
+        public static bool TestAllZeros(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool TestAllZeros(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool TestAllZeros(Vector128<uint> left, Vector128<uint> right);
+        public static bool TestAllZeros(Vector128<ulong> left, Vector128<ulong> right);
+        public static bool TestC(Vector128<byte> left, Vector128<byte> right);
+        public static bool TestC(Vector128<short> left, Vector128<short> right);
+        public static bool TestC(Vector128<int> left, Vector128<int> right);
+        public static bool TestC(Vector128<long> left, Vector128<long> right);
+        public static bool TestC(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool TestC(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool TestC(Vector128<uint> left, Vector128<uint> right);
+        public static bool TestC(Vector128<ulong> left, Vector128<ulong> right);
+        public static bool TestMixOnesZeros(Vector128<byte> left, Vector128<byte> right);
+        public static bool TestMixOnesZeros(Vector128<short> left, Vector128<short> right);
+        public static bool TestMixOnesZeros(Vector128<int> left, Vector128<int> right);
+        public static bool TestMixOnesZeros(Vector128<long> left, Vector128<long> right);
+        public static bool TestMixOnesZeros(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool TestMixOnesZeros(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool TestMixOnesZeros(Vector128<uint> left, Vector128<uint> right);
+        public static bool TestMixOnesZeros(Vector128<ulong> left, Vector128<ulong> right);
+        public static bool TestNotZAndNotC(Vector128<byte> left, Vector128<byte> right);
+        public static bool TestNotZAndNotC(Vector128<short> left, Vector128<short> right);
+        public static bool TestNotZAndNotC(Vector128<int> left, Vector128<int> right);
+        public static bool TestNotZAndNotC(Vector128<long> left, Vector128<long> right);
+        public static bool TestNotZAndNotC(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool TestNotZAndNotC(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool TestNotZAndNotC(Vector128<uint> left, Vector128<uint> right);
+        public static bool TestNotZAndNotC(Vector128<ulong> left, Vector128<ulong> right);
+        public static bool TestZ(Vector128<byte> left, Vector128<byte> right);
+        public static bool TestZ(Vector128<short> left, Vector128<short> right);
+        public static bool TestZ(Vector128<int> left, Vector128<int> right);
+        public static bool TestZ(Vector128<long> left, Vector128<long> right);
+        public static bool TestZ(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static bool TestZ(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool TestZ(Vector128<uint> left, Vector128<uint> right);
+        public static bool TestZ(Vector128<ulong> left, Vector128<ulong> right);
+    }
+    public static class Sse42 {
+        public static bool IsSupported { get; }
+        public static bool CompareExplicitLength(Vector128<byte> left, byte leftLength, Vector128<byte> right, byte rightLength, ResultsFlag flag, StringComparisonMode mode);
+        public static bool CompareExplicitLength(Vector128<short> left, byte leftLength, Vector128<short> right, byte rightLength, ResultsFlag flag, StringComparisonMode mode);
+        public static bool CompareExplicitLength(Vector128<sbyte> left, byte leftLength, Vector128<sbyte> right, byte rightLength, ResultsFlag flag, StringComparisonMode mode);
+        public static bool CompareExplicitLength(Vector128<ushort> left, byte leftLength, Vector128<ushort> right, byte rightLength, ResultsFlag flag, StringComparisonMode mode);
+        public static Vector128<ushort> CompareExplicitLengthBitMask(Vector128<byte> left, byte leftLength, Vector128<byte> right, byte rightLength, StringComparisonMode mode);
+        public static Vector128<byte> CompareExplicitLengthBitMask(Vector128<short> left, byte leftLength, Vector128<short> right, byte rightLength, StringComparisonMode mode);
+        public static Vector128<ushort> CompareExplicitLengthBitMask(Vector128<sbyte> left, byte leftLength, Vector128<sbyte> right, byte rightLength, StringComparisonMode mode);
+        public static Vector128<byte> CompareExplicitLengthBitMask(Vector128<ushort> left, byte leftLength, Vector128<ushort> right, byte rightLength, StringComparisonMode mode);
+        public static int CompareExplicitLengthIndex(Vector128<byte> left, byte leftLength, Vector128<byte> right, byte rightLength, StringComparisonMode mode);
+        public static int CompareExplicitLengthIndex(Vector128<short> left, byte leftLength, Vector128<short> right, byte rightLength, StringComparisonMode mode);
+        public static int CompareExplicitLengthIndex(Vector128<sbyte> left, byte leftLength, Vector128<sbyte> right, byte rightLength, StringComparisonMode mode);
+        public static int CompareExplicitLengthIndex(Vector128<ushort> left, byte leftLength, Vector128<ushort> right, byte rightLength, StringComparisonMode mode);
+        public static Vector128<byte> CompareExplicitLengthUnitMask(Vector128<byte> left, byte leftLength, Vector128<byte> right, byte rightLength, StringComparisonMode mode);
+        public static Vector128<ushort> CompareExplicitLengthUnitMask(Vector128<short> left, byte leftLength, Vector128<short> right, byte rightLength, StringComparisonMode mode);
+        public static Vector128<byte> CompareExplicitLengthUnitMask(Vector128<sbyte> left, byte leftLength, Vector128<sbyte> right, byte rightLength, StringComparisonMode mode);
+        public static Vector128<ushort> CompareExplicitLengthUnitMask(Vector128<ushort> left, byte leftLength, Vector128<ushort> right, byte rightLength, StringComparisonMode mode);
+        public static Vector128<long> CompareGreaterThan(Vector128<long> left, Vector128<long> right);
+        public static bool CompareImplicitLength(Vector128<byte> left, Vector128<byte> right, ResultsFlag flag, StringComparisonMode mode);
+        public static bool CompareImplicitLength(Vector128<short> left, Vector128<short> right, ResultsFlag flag, StringComparisonMode mode);
+        public static bool CompareImplicitLength(Vector128<sbyte> left, Vector128<sbyte> right, ResultsFlag flag, StringComparisonMode mode);
+        public static bool CompareImplicitLength(Vector128<ushort> left, Vector128<ushort> right, ResultsFlag flag, StringComparisonMode mode);
+        public static Vector128<ushort> CompareImplicitLengthBitMask(Vector128<byte> left, Vector128<byte> right, StringComparisonMode mode);
+        public static Vector128<byte> CompareImplicitLengthBitMask(Vector128<short> left, Vector128<short> right, StringComparisonMode mode);
+        public static Vector128<ushort> CompareImplicitLengthBitMask(Vector128<sbyte> left, Vector128<sbyte> right, StringComparisonMode mode);
+        public static Vector128<byte> CompareImplicitLengthBitMask(Vector128<ushort> left, Vector128<ushort> right, StringComparisonMode mode);
+        public static int CompareImplicitLengthIndex(Vector128<byte> left, Vector128<byte> right, StringComparisonMode mode);
+        public static int CompareImplicitLengthIndex(Vector128<short> left, Vector128<short> right, StringComparisonMode mode);
+        public static int CompareImplicitLengthIndex(Vector128<sbyte> left, Vector128<sbyte> right, StringComparisonMode mode);
+        public static int CompareImplicitLengthIndex(Vector128<ushort> left, Vector128<ushort> right, StringComparisonMode mode);
+        public static Vector128<byte> CompareImplicitLengthUnitMask(Vector128<byte> left, Vector128<byte> right, StringComparisonMode mode);
+        public static Vector128<ushort> CompareImplicitLengthUnitMask(Vector128<short> left, Vector128<short> right, StringComparisonMode mode);
+        public static Vector128<byte> CompareImplicitLengthUnitMask(Vector128<sbyte> left, Vector128<sbyte> right, StringComparisonMode mode);
+        public static Vector128<ushort> CompareImplicitLengthUnitMask(Vector128<ushort> left, Vector128<ushort> right, StringComparisonMode mode);
+        public static uint Crc32(uint crc, byte data);
+        public static uint Crc32(uint crc, ushort data);
+        public static uint Crc32(uint crc, uint data);
+        public static ulong Crc32(ulong crc, ulong data);
+    }
+    public static class Ssse3 {
+        public static bool IsSupported { get; }
+        public static Vector128<ushort> Abs(Vector128<short> value);
+        public static Vector128<uint> Abs(Vector128<int> value);
+        public static Vector128<byte> Abs(Vector128<sbyte> value);
+        public static Vector128<sbyte> AlignRight(Vector128<sbyte> left, Vector128<sbyte> right, byte mask);
+        public static Vector128<short> HorizontalAdd(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> HorizontalAdd(Vector128<int> left, Vector128<int> right);
+        public static Vector128<short> HorizontalAddSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> HorizontalSubtract(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> HorizontalSubtract(Vector128<int> left, Vector128<int> right);
+        public static Vector128<short> HorizontalSubtractSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<short> MultiplyAddAdjacent(Vector128<byte> left, Vector128<sbyte> right);
+        public static Vector128<short> MultiplyHighRoundScale(Vector128<short> left, Vector128<short> right);
+        public static Vector128<sbyte> Shuffle(Vector128<sbyte> value, Vector128<sbyte> mask);
+        public static Vector128<short> Sign(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Sign(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> Sign(Vector128<sbyte> left, Vector128<sbyte> right);
+    }
+    public enum StringComparisonMode : byte {
+        EqualAny = (byte)0,
+        EqualEach = (byte)8,
+        EqualOrdered = (byte)12,
+        LeastSignificant = (byte)0,
+        MaskedNegativePolarity = (byte)48,
+        MostSignificant = (byte)64,
+        NegativePolarity = (byte)16,
+        Ranges = (byte)4,
+    }
+}
```

