# System.IO.Enumeration

``` diff
+namespace System.IO.Enumeration {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, Size=1)]
+    public struct FileSystemEntry {
+        public FileAttributes Attributes { get; }
+        public DateTimeOffset CreationTimeUtc { get; }
+        public ReadOnlySpan<char> Directory { get; }
+        public ReadOnlySpan<char> FileName { get; }
+        public bool IsDirectory { get; }
+        public bool IsHidden { get; }
+        public DateTimeOffset LastAccessTimeUtc { get; }
+        public DateTimeOffset LastWriteTimeUtc { get; }
+        public long Length { get; }
+        public ReadOnlySpan<char> OriginalRootDirectory { get; }
+        public ReadOnlySpan<char> RootDirectory { get; }
+        public FileSystemInfo ToFileSystemInfo();
+        public string ToFullPath();
+        public string ToSpecifiedFullPath();
+    }
+    public class FileSystemEnumerable<TResult> : IEnumerable, IEnumerable<TResult> {
+        public FileSystemEnumerable(string directory, FileSystemEnumerable<TResult>.FindTransform transform, EnumerationOptions options=null);
+        public FileSystemEnumerable<TResult>.FindPredicate ShouldIncludePredicate { get; set; }
+        public FileSystemEnumerable<TResult>.FindPredicate ShouldRecursePredicate { get; set; }
+        public IEnumerator<TResult> GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public delegate bool FindPredicate(ref FileSystemEntry entry);
+        public delegate TResult FindTransform(ref FileSystemEntry entry);
+    }
+    public abstract class FileSystemEnumerator<TResult> : CriticalFinalizerObject, IDisposable, IEnumerator, IEnumerator<TResult> {
+        public FileSystemEnumerator(string directory, EnumerationOptions options=null);
+        public TResult Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        protected virtual bool ContinueOnError(int error);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public bool MoveNext();
+        protected virtual void OnDirectoryFinished(ReadOnlySpan<char> directory);
+        public void Reset();
+        protected virtual bool ShouldIncludeEntry(ref FileSystemEntry entry);
+        protected virtual bool ShouldRecurseIntoEntry(ref FileSystemEntry entry);
+        protected abstract TResult TransformEntry(ref FileSystemEntry entry);
+    }
+    public static class FileSystemName {
+        public static bool MatchesSimpleExpression(ReadOnlySpan<char> expression, ReadOnlySpan<char> name, bool ignoreCase=true);
+        public static bool MatchesWin32Expression(ReadOnlySpan<char> expression, ReadOnlySpan<char> name, bool ignoreCase=true);
+        public static string TranslateWin32Expression(string expression);
+    }
+}
```

