# System.IO

``` diff
 namespace System.IO {
     public static class Directory {
+        public static IEnumerable<string> EnumerateDirectories(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static IEnumerable<string> EnumerateFiles(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static IEnumerable<string> EnumerateFileSystemEntries(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static string[] GetDirectories(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static string[] GetFiles(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static string[] GetFileSystemEntries(string path, string searchPattern, EnumerationOptions enumerationOptions);
     }
     public sealed class DirectoryInfo : FileSystemInfo {
+        public IEnumerable<DirectoryInfo> EnumerateDirectories(string searchPattern, EnumerationOptions enumerationOptions);
+        public IEnumerable<FileInfo> EnumerateFiles(string searchPattern, EnumerationOptions enumerationOptions);
+        public IEnumerable<FileSystemInfo> EnumerateFileSystemInfos(string searchPattern, EnumerationOptions enumerationOptions);
+        public DirectoryInfo[] GetDirectories(string searchPattern, EnumerationOptions enumerationOptions);
+        public FileInfo[] GetFiles(string searchPattern, EnumerationOptions enumerationOptions);
+        public FileSystemInfo[] GetFileSystemInfos(string searchPattern, EnumerationOptions enumerationOptions);
     }
+    public class EnumerationOptions {
+        public EnumerationOptions();
+        public FileAttributes AttributesToSkip { get; set; }
+        public int BufferSize { get; set; }
+        public bool IgnoreInaccessible { get; set; }
+        public MatchCasing MatchCasing { get; set; }
+        public MatchType MatchType { get; set; }
+        public bool RecurseSubdirectories { get; set; }
+        public bool ReturnSpecialDirectories { get; set; }
+    }
+    public enum MatchCasing {
+        CaseInsensitive = 2,
+        CaseSensitive = 1,
+        PlatformDefault = 0,
+    }
+    public enum MatchType {
+        Simple = 0,
+        Win32 = 1,
+    }
     public class MemoryStream : Stream {
-        public override Task WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken=default(CancellationToken));

+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken=default(CancellationToken));
     }
     public static class Path {
+        public static ReadOnlySpan<char> GetDirectoryName(ReadOnlySpan<char> path);
+        public static ReadOnlySpan<char> GetExtension(ReadOnlySpan<char> path);
+        public static ReadOnlySpan<char> GetFileName(ReadOnlySpan<char> path);
+        public static ReadOnlySpan<char> GetFileNameWithoutExtension(ReadOnlySpan<char> path);
+        public static string GetFullPath(string path, string basePath);
+        public static ReadOnlySpan<char> GetPathRoot(ReadOnlySpan<char> path);
+        public static bool HasExtension(ReadOnlySpan<char> path);
+        public static bool IsPathFullyQualified(ReadOnlySpan<char> path);
+        public static bool IsPathRooted(ReadOnlySpan<char> path);
+        public static string Join(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2);
+        public static string Join(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2, ReadOnlySpan<char> path3);
+        public static bool TryJoin(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2, ReadOnlySpan<char> path3, Span<char> destination, out int charsWritten);
+        public static bool TryJoin(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2, Span<char> destination, out int charsWritten);
     }
     public abstract class Stream : MarshalByRefObject, IDisposable {
-        public virtual int Read(Span<byte> destination);
+        public virtual int Read(Span<byte> buffer);
-        public virtual ValueTask<int> ReadAsync(Memory<byte> destination, CancellationToken cancellationToken=default(CancellationToken));
+        public virtual ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken=default(CancellationToken));
-        public virtual void Write(ReadOnlySpan<byte> source);
+        public virtual void Write(ReadOnlySpan<byte> buffer);
-        public virtual Task WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken=default(CancellationToken));

+        public virtual ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken=default(CancellationToken));
     }
 }
```

