# System.IO

``` diff
 namespace System.IO {
     public class BinaryReader : IDisposable {
+        public virtual int Read(Span<byte> buffer);
+        public virtual int Read(Span<char> buffer);
     }
     public class BinaryWriter : IDisposable {
+        public virtual void Write(ReadOnlySpan<byte> buffer);
+        public virtual void Write(ReadOnlySpan<char> chars);
     }
     public static class Directory {
+        public static IEnumerable<string> EnumerateDirectories(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static IEnumerable<string> EnumerateFiles(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static IEnumerable<string> EnumerateFileSystemEntries(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static string[] GetDirectories(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static string[] GetFiles(string path, string searchPattern, EnumerationOptions enumerationOptions);
+        public static string[] GetFileSystemEntries(string path, string searchPattern, EnumerationOptions enumerationOptions);
     }
     public sealed class DirectoryInfo : FileSystemInfo {
+        public IEnumerable<DirectoryInfo> EnumerateDirectories(string searchPattern, EnumerationOptions enumerationOptions);
+        public IEnumerable<FileInfo> EnumerateFiles(string searchPattern, EnumerationOptions enumerationOptions);
+        public IEnumerable<FileSystemInfo> EnumerateFileSystemInfos(string searchPattern, EnumerationOptions enumerationOptions);
+        public DirectoryInfo[] GetDirectories(string searchPattern, EnumerationOptions enumerationOptions);
+        public FileInfo[] GetFiles(string searchPattern, EnumerationOptions enumerationOptions);
+        public FileSystemInfo[] GetFileSystemInfos(string searchPattern, EnumerationOptions enumerationOptions);
     }
+    public class EnumerationOptions {
+        public EnumerationOptions();
+        public FileAttributes AttributesToSkip { get; set; }
+        public int BufferSize { get; set; }
+        public bool IgnoreInaccessible { get; set; }
+        public MatchCasing MatchCasing { get; set; }
+        public MatchType MatchType { get; set; }
+        public bool RecurseSubdirectories { get; set; }
+        public bool ReturnSpecialDirectories { get; set; }
+    }
     public class FileStream : Stream {
-        public string Name { get; }
+        public virtual string Name { get; }
-        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginRead(byte[] array, int offset, int numBytes, AsyncCallback callback, object state);
-        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] array, int offset, int numBytes, AsyncCallback callback, object state);
     }
+    public enum MatchCasing {
+        CaseInsensitive = 2,
+        CaseSensitive = 1,
+        PlatformDefault = 0,
+    }
+    public enum MatchType {
+        Simple = 0,
+        Win32 = 1,
+    }
     public class MemoryStream : Stream {
+        public override int Read(Span<byte> destination);
+        public override ValueTask<int> ReadAsync(Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public override void Write(ReadOnlySpan<byte> source);
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public static class Path {
+        public static ReadOnlySpan<char> GetDirectoryName(ReadOnlySpan<char> path);
+        public static ReadOnlySpan<char> GetExtension(ReadOnlySpan<char> path);
+        public static ReadOnlySpan<char> GetFileName(ReadOnlySpan<char> path);
+        public static ReadOnlySpan<char> GetFileNameWithoutExtension(ReadOnlySpan<char> path);
+        public static string GetFullPath(string path, string basePath);
+        public static ReadOnlySpan<char> GetPathRoot(ReadOnlySpan<char> path);
+        public static bool HasExtension(ReadOnlySpan<char> path);
+        public static bool IsPathFullyQualified(ReadOnlySpan<char> path);
+        public static bool IsPathFullyQualified(string path);
+        public static bool IsPathRooted(ReadOnlySpan<char> path);
+        public static string Join(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2);
+        public static string Join(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2, ReadOnlySpan<char> path3);
+        public static bool TryJoin(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2, ReadOnlySpan<char> path3, Span<char> destination, out int charsWritten);
+        public static bool TryJoin(ReadOnlySpan<char> path1, ReadOnlySpan<char> path2, Span<char> destination, out int charsWritten);
     }
     public abstract class Stream : MarshalByRefObject, IDisposable {
+        public Task CopyToAsync(Stream destination, CancellationToken cancellationToken);
+        public virtual int Read(Span<byte> buffer);
+        public virtual ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual void Write(ReadOnlySpan<byte> buffer);
+        public virtual ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class StreamReader : TextReader {
+        public override int Read(Span<char> buffer);
+        public override ValueTask<int> ReadAsync(Memory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override int ReadBlock(Span<char> buffer);
+        public override ValueTask<int> ReadBlockAsync(Memory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class StreamWriter : TextWriter {
+        public override void Write(ReadOnlySpan<char> buffer);
+        public override Task WriteAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override void WriteLine(ReadOnlySpan<char> buffer);
+        public override void WriteLine(string value);
+        public override Task WriteLineAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class StringReader : TextReader {
+        public override int Read(Span<char> buffer);
+        public override ValueTask<int> ReadAsync(Memory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override int ReadBlock(Span<char> buffer);
+        public override ValueTask<int> ReadBlockAsync(Memory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class StringWriter : TextWriter {
+        public override void Write(ReadOnlySpan<char> buffer);
+        public override Task WriteAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override void WriteLine(ReadOnlySpan<char> buffer);
+        public override Task WriteLineAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class TextReader : MarshalByRefObject, IDisposable {
+        public virtual int Read(Span<char> buffer);
+        public virtual ValueTask<int> ReadAsync(Memory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual int ReadBlock(Span<char> buffer);
+        public virtual ValueTask<int> ReadBlockAsync(Memory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class TextWriter : MarshalByRefObject, IDisposable {
+        public virtual void Write(ReadOnlySpan<char> buffer);
+        public virtual Task WriteAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual void WriteLine(ReadOnlySpan<char> buffer);
+        public virtual Task WriteLineAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class UnmanagedMemoryStream : Stream {
+        public override int Read(Span<byte> destination);
+        public override void Write(ReadOnlySpan<byte> source);
     }
 }
```

