# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
+    public static class CryptographicOperations {
+        public static bool FixedTimeEquals(ReadOnlySpan<byte> left, ReadOnlySpan<byte> right);
+        public static void ZeroMemory(Span<byte> buffer);
+    }
     public class CryptoStream : Stream, IDisposable {
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
     }
     public abstract class DSA : AsymmetricAlgorithm {
+        public virtual bool TryCreateSignature(ReadOnlySpan<byte> hash, Span<byte> destination, out int bytesWritten);
+        protected virtual bool TryHashData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool TrySignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool VerifyData(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm);
+        public virtual bool VerifySignature(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature);
     }
+    public abstract class ECDiffieHellman : AsymmetricAlgorithm {
+        protected ECDiffieHellman();
+        public override string KeyExchangeAlgorithm { get; }
+        public abstract ECDiffieHellmanPublicKey PublicKey { get; }
+        public override string SignatureAlgorithm { get; }
+        public static new ECDiffieHellman Create();
+        public static ECDiffieHellman Create(ECCurve curve);
+        public static ECDiffieHellman Create(ECParameters parameters);
+        public static new ECDiffieHellman Create(string algorithm);
+        public byte[] DeriveKeyFromHash(ECDiffieHellmanPublicKey otherPartyPublicKey, HashAlgorithmName hashAlgorithm);
+        public virtual byte[] DeriveKeyFromHash(ECDiffieHellmanPublicKey otherPartyPublicKey, HashAlgorithmName hashAlgorithm, byte[] secretPrepend, byte[] secretAppend);
+        public byte[] DeriveKeyFromHmac(ECDiffieHellmanPublicKey otherPartyPublicKey, HashAlgorithmName hashAlgorithm, byte[] hmacKey);
+        public virtual byte[] DeriveKeyFromHmac(ECDiffieHellmanPublicKey otherPartyPublicKey, HashAlgorithmName hashAlgorithm, byte[] hmacKey, byte[] secretPrepend, byte[] secretAppend);
+        public virtual byte[] DeriveKeyMaterial(ECDiffieHellmanPublicKey otherPartyPublicKey);
+        public virtual byte[] DeriveKeyTls(ECDiffieHellmanPublicKey otherPartyPublicKey, byte[] prfLabel, byte[] prfSeed);
+        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);
+        public virtual ECParameters ExportParameters(bool includePrivateParameters);
+        public override void FromXmlString(string xmlString);
+        public virtual void GenerateKey(ECCurve curve);
+        public virtual void ImportParameters(ECParameters parameters);
+        public override string ToXmlString(bool includePrivateParameters);
+    }
     public abstract class ECDiffieHellmanPublicKey : IDisposable {
+        protected ECDiffieHellmanPublicKey();
+        public virtual ECParameters ExportExplicitParameters();
+        public virtual ECParameters ExportParameters();
     }
     public abstract class ECDsa : AsymmetricAlgorithm {
+        protected virtual bool TryHashData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool TrySignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool TrySignHash(ReadOnlySpan<byte> hash, Span<byte> destination, out int bytesWritten);
+        public virtual bool VerifyData(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm);
+        public virtual bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature);
     }
     public abstract class HashAlgorithm : ICryptoTransform, IDisposable {
+        protected virtual void HashCore(ReadOnlySpan<byte> source);
+        public bool TryComputeHash(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        protected virtual bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
-    public struct HashAlgorithmName : IEquatable<HashAlgorithmName>
+    public readonly struct HashAlgorithmName : IEquatable<HashAlgorithmName>
     public abstract class HMAC : KeyedHashAlgorithm {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACMD5 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACSHA1 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACSHA256 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACSHA384 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACSHA512 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class IncrementalHash : IDisposable {
+        public void AppendData(ReadOnlySpan<byte> data);
+        public bool TryGetHashAndReset(Span<byte> destination, out int bytesWritten);
     }
     public abstract class RandomNumberGenerator : IDisposable {
+        public static void Fill(Span<byte> data);
+        public virtual void GetBytes(Span<byte> data);
+        public virtual void GetNonZeroBytes(Span<byte> data);
     }
     public abstract class RSA : AsymmetricAlgorithm {
+        public virtual bool TryDecrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding, out int bytesWritten);
+        public virtual bool TryEncrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding, out int bytesWritten);
+        protected virtual bool TryHashData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool TrySignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding, out int bytesWritten);
+        public virtual bool TrySignHash(ReadOnlySpan<byte> hash, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding, out int bytesWritten);
+        public virtual bool VerifyData(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public virtual bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
     }
     public sealed class SHA1Managed : SHA1 {
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA256Managed : SHA256 {
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA384Managed : SHA384 {
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA512Managed : SHA512 {
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
 }
```

