# .NET Core 2.2.5 Update - May 14, 2019

.NET Core 2.2.5 is available for [download](2.2.5-download.md) and usage in your environment. This release includes .NET Core 2.2.5, ASP.NET Core 2.2.5 and updates to the .NET Core SDK.

**Note:** If you are a Visual Studio user, there are MSBuild version requirements so use only the .NET Core SDK supported for each Visual Studio version. If you use other development environments, we recommend using the latest SDK release.

| VS Version | .NET Core SDK |
| :-- | :--: |
| Visual Studio 2017 and Visual Studio for Mac | [2.2.107](#downloads) |
| Visual Studio 2019 (Windows) | [2.2.204](../2.2.204-SDK/2.2.204-SDK-download.md) |

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-225)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.2-known-issues.md)

We've created an issue at [dotnet/core #2727](https://github.com/dotnet/core/issues/2727) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

### Azure AppServices

* .NET Core 2.2.5 is being deployed to Azure App Services and the deployment is expected to complete in a couple of days.

## .NET Core Lifecycle News

Ubuntu 14.04 reached the [end of standard support April 2019](https://wiki.ubuntu.com/Releases). We will no longer produce and release packages for this OS version.

.NET Core 1.0 and 1.1, which entered "Maintenance" support status when 2.1 was declared LTS, will be end-of-life June 27, 2019. Updates for the 1.0 and 1.1 channels will no longer be offered after that date. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 2.2.5

.NET Core 2.2.5 release carries both security and non-security fixes.

* [CVE-2019-0820: .NET Core Tampering Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-0820)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core improperly process RegEx strings. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET application.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core applications handle RegEx string processing.

    **Affected Package and Binary updates**
    
    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Text.RegularExpressions.dll | 4.3.0 | 4.3.1  
    
* [CVE-2019-0980: ASP.NET Core Denial of Service Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-0980)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core and ASP.NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core and ASP.NET Core improperly handle web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core and ASP.NET Core application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core and ASP.NET Core web applications handle web requests.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Private.Uri | 4.3.0, 4.3.1 | 4.3.2  
    
* [CVE-2019-0981: ASP.NET Core Denial of Service Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-0981)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core and ASP.NET Core 1.0, 1.1, 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists when .NET Core and ASP.NET Core improperly handle web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core and ASP.NET Core application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to a .NET Core application.

The update addresses the vulnerability by correcting how .NET Core and ASP.NET Core web applications handle web requests.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    System.Private.Uri | 4.3.0, 4.3.1 | 4.3.2  

* [CVE-2019-0982: ASP.NET Core Denial of Service Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-0982)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability exists when ASP.NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the ASP.NET Core application.

The update addresses the vulnerability by correcting how the ASP.NET Core web application handles web requests.

    **Affected Package and Binary updates**
  
    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 1.0.0, 1.0.1, 1.0.2, 1.0.3, 1.0.4<br/>1.1.0 | 1.0.11<br/>1.1.5  

### Additional fixes in this release
* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.2.5+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.2.5+label%3Aservicing-approved)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=%E2%9C%93&q=milestone%3A2.1.11+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=user:aspnet+is:pr+label:Servicing-approved+milestone:2.2.5)


## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.AspNetCore.All|2.2.5
Microsoft.AspNetCore.App|2.2.5
Microsoft.AspNetCore.AzureAppServices.HostingStartup|2.2.5
Microsoft.AspNetCore.AzureAppServicesIntegration|2.2.5
Microsoft.AspNetCore.DataProtection.StackExchangeRedis|2.2.5
Microsoft.AspNetCore.Identity.UI|2.2.5
Microsoft.AspNetCore.Mvc.Core|2.2.5
Microsoft.AspNetCore.Mvc.RazorPages|2.2.5
Microsoft.AspNetCore.SignalR.Protocols.MessagePack|1.1.5
Microsoft.AspNetCore.SignalR.Redis|1.1.5
Microsoft.AspNetCore.SignalR.StackExchangeRedis|1.1.5
Microsoft.DotNet.Web.Client.ItemTemplates|2.2.5
Microsoft.DotNet.Web.ItemTemplates|2.2.5
Microsoft.DotNet.Web.ProjectTemplates.2.2|2.2.5
Microsoft.DotNet.Web.Spa.ProjectTemplates|2.2.5
Microsoft.Extensions.Caching.StackExchangeRedis|2.2.5
Microsoft.Extensions.Diagnostics.HealthChecks|2.2.5
Microsoft.Extensions.Logging.AzureAppServices|2.2.5
Microsoft.NETCore.App|2.2.5
Microsoft.NETCore.DotNetAppHost|2.2.5
Microsoft.NETCore.DotNetHost|2.2.5
Microsoft.NETCore.DotNetHostPolicy|2.2.5
Microsoft.NETCore.DotNetHostResolver|2.2.5
Microsoft.NETCore.Platforms|2.2.1
Microsoft.Windows.Compatibility|2.1.1
runtime.linux-arm.Microsoft.NETCore.App|2.2.5
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.linux-arm.Microsoft.NETCore.DotNetHost|2.2.5
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.linux-arm64.Microsoft.NETCore.App|2.2.5
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHost|2.2.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.linux-musl-x64.Microsoft.NETCore.App|2.2.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost|2.2.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.linux-x64.Microsoft.NETCore.App|2.2.5
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.linux-x64.Microsoft.NETCore.DotNetHost|2.2.5
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.osx-x64.Microsoft.NETCore.App|2.2.5
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.osx-x64.Microsoft.NETCore.DotNetHost|2.2.5
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.rhel.6-x64.Microsoft.NETCore.App|2.2.5
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost|2.2.5
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.win-arm.Microsoft.NETCore.App|2.2.5
runtime.win-arm.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.win-arm.Microsoft.NETCore.DotNetHost|2.2.5
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.win-arm64.Microsoft.NETCore.App|2.2.5
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.win-arm64.Microsoft.NETCore.DotNetHost|2.2.5
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.win-x64.Microsoft.NETCore.App|2.2.5
runtime.win-x64.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.win-x64.Microsoft.NETCore.DotNetHost|2.2.5
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver|2.2.5
runtime.win-x86.Microsoft.NETCore.App|2.2.5
runtime.win-x86.Microsoft.NETCore.DotNetAppHost|2.2.5
runtime.win-x86.Microsoft.NETCore.DotNetHost|2.2.5
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy|2.2.5
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver|2.2.5
System.Data.SqlClient|4.6.1

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.2/2.2.5/2.2.5.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/87521bd8-1522-4141-9532-91d580292c42/59116d9f6ebced4fdc8b76b9e3bbabbf/dotnet-runtime-2.2.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7aca89ca-5196-4b89-93bc-1ee1eeb251d7/ca4ff94c8692a6846a756fc07174974d/dotnet-runtime-2.2.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e6c7d880-e951-49ba-9ad1-1b7ab92647c0/82fd0a220c311dae0096aa1fc857b003/dotnet-runtime-2.2.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/21968111-f65e-48c7-9c35-8b40de4af06c/66b7a2c7b92b54bd3311f4509cc9b9ed/dotnet-runtime-2.2.5-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5a373bc6-6284-4bce-aff5-791900a05241/f6761a726ca304512f05258d416f2a6b/dotnet-runtime-2.2.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3451957c-1d40-4ec4-a439-d018f92c5c12/77a0101ccfb7f5edc768f258450b295c/dotnet-runtime-2.2.5-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7969882-ed80-4f57-8f7e-10576a3a43ad/afa91359198122a385e9527187c7313c/dotnet-runtime-2.2.5-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/526d7d4f-cacf-452f-af9c-a13d55949490/32a864dadc46f8cea3924aee2023d347/dotnet-runtime-2.2.5-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/57b58505-b244-485f-b2fb-181c442f314e/07aad4d611362c0e6ddf8ea77799ebdd/dotnet-runtime-2.2.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/84ea4970-ac74-4a0c-a93d-b2438c507dac/9babcf7e3f459a1ddb1fe0df02fdc619/dotnet-runtime-2.2.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3810a636-75a9-497a-98f0-48ad497e339e/093ab61953f8a1d05fa27e54ffa7868b/dotnet-runtime-2.2.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ae0efd9e-e55d-4148-9d95-dd3e5fd8e6d2/5297cf422f6b4818077a6f459acde520/dotnet-runtime-2.2.5-win-x86.zip
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd6635b9-f6f8-4c2d-beda-2e381fe39586/740973b83c199bf863a51c83a2432151/aspnetcore-runtime-2.2.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f49a9f48-15ca-430e-b618-2e133c266d2e/e79e338cbbd15e0835b27c25d9463976/aspnetcore-runtime-2.2.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/411768dc-83c3-4b15-acd3-d4490aad6dde/90e0b4848a18585ab4fc170c8d7a2fbe/aspnetcore-runtime-2.2.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d655e91b-d5b3-4925-9520-1f7b7dcb73ac/b860dd24c035e206d3edc181129cc47d/aspnetcore-runtime-2.2.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/c239e990-da4e-4c6f-9f47-c39b8679d159/4b4795085f593d3479b222fef5721d54/aspnetcore-runtime-2.2.5-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/28989ee4-5f2a-4a2e-bc48-4fdb8e3e78af/81cf0048a65e782111ecb76116f1439d/aspnetcore-runtime-2.2.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1e67f249-a5d7-48a3-81c6-99b5ce398295/bc840f7a713e39e2e7ef30034adbeedf/aspnetcore-runtime-2.2.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bd58c47e-0538-4c15-aaaa-edef158ccaa0/008cf89ab5a656e3305bb99ce3ed8d82/aspnetcore-runtime-2.2.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b969a905-45f3-47cb-9496-4d502df0d904/5b2467d0289ab68863fa2ef7f13c2f7d/aspnetcore-runtime-2.2.5-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/34f4b2a6-c3b8-495c-a11f-6db955f27757/8c340c1a8c25966e39e0c0a4b308dff4/dotnet-hosting-2.2.5-win.exe
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e010bdaf-8d32-465c-932e-699693b65e8d/68f80c81fad71f132f3781aa0d1fd0ba/dotnet-sdk-2.2.107-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d079fa72-efbb-4efb-a987-bf71f82b6628/dc7559cc5e4dfa9ee36d8accb93bebaf/dotnet-sdk-2.2.107-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76c888e7-cb8e-45c6-be3e-d11ab25a1c7f/b730a4bb06d941b6a5b4bfbbbe4614db/dotnet-sdk-2.2.107-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d4aedbf-4539-468a-90e1-18159bbc306e/a9f61399d21e2bab1b187d86cc9299f5/dotnet-sdk-2.2.107-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d3392a3f-8437-4357-8ed1-58061a421ab7/4e354d4a659d1ac4b20ebacb2dedf656/dotnet-sdk-2.2.107-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f89d26ff-c9f0-459c-97e0-0d56e0ee43ef/fc1dcdc4fe2eb39cfd04e4c6cf60d8e1/dotnet-sdk-2.2.107-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c25443a9-b476-4f8e-9a6b-2f40c3aac41f/c0c6a29966e356499116cc34099d196a/dotnet-sdk-2.2.107-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/501f5099-2370-4518-9d9b-1f7a80f86e9e/65b89add29994a6d995d41dfed135710/dotnet-sdk-2.2.107-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fb931b49-7f40-44ba-a347-f0b9fe655864/c99d8ab0402d4b8e6831e1ee74aa945b/dotnet-sdk-2.2.107-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/36894bf1-79a9-4f12-a719-a69f82998b2a/36f6a6e2c6d7cab21722a3ebb5db47be/dotnet-sdk-2.2.107-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9c48244e-b292-4d16-9c19-5d10f734ab73/e288faa1ec2facfeda91f0614995ff9c/dotnet-sdk-2.2.107-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d766f851-6010-436d-a220-d328f01acc88/9c64558435869468dcf922e84fbfd6d6/dotnet-sdk-2.2.107-win-x86.zip
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0c8969d6-a150-4fd0-b5ee-f85cf47b29fd/8628d29e58df3e675327e89a3cc02eb6/aspnet-2.2.5-symbols.zip
[aspnet-extensions-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/1d8cdfb8-e3b4-470a-838b-629a4df38034/a3b613b6c5bd68514e6ffdc68e43402d/aspnet-extensions-2.2.5-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b7a489d4-5833-486e-af48-47aeba1deead/6e23995d55fdb4241e9135a5f60a975d/cli-2.2.5-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0cb24dfa-e1c8-4c7d-b6e8-ada512a895b4/4431f0316bd4af2c8d93df78bddd3931/core-setup-2.2.5-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/173d6b83-0ee0-4a76-88d4-1b2cb9defc35/5603ecf3d3b2b346f1c41d1ea9d1a6dc/coreclr-2.2.5-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/8ca8518d-3e3e-438b-bb1d-130e96896abf/fb6ce1b1bb8215f0d41c9004d45819ec/corefx-2.2.5-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/bc10e87f-b8c9-475f-b128-c79f1b10a479/89bb00ae7d070290942a48261504a73a/dotnet-sdk-2.2.5-symbols.zip
[sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/9b63dd6e-9ad5-4fd7-a269-2a1ff6795665/ec2b12679604ba6a073d58e2ab78a656/sdk-2.2.107-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.5-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.107-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-may-2019/

