# .NET Core 3.0 Preview Known Issues

This document lists known issues for **.NET Core 3.0 Preview releases** which may be encountered during usage.

## .NET Core

### Preview 5

- **Visual style in WinForms app not showing correctly when publishing with PublishReadyToRun=true**

    The ReadyToRun compiler in this preview does not copy Win32 resources from the managed assembly to the compiled output binary, which causes an issue with visual styles in WinForms apps. The workaround is to skip compilation of System.Windows.Forms.dll by adding the following to the project file:
    ```xml
    <ItemGroup>
      <PublishReadyToRunExclude Include="System.Windows.Forms.dll" />            
    </ItemGroup>
    ```    

- **Scaffolding hangs indefinitely**

    With a 3.0.100-preview5 SDK installed, and Visual Studio 16.0-preview2 or earlier, attempting to scaffold a .NET Core 3.0 project in Visual Studio will cause Visual Studio to hang indefinitely, with no indication of the problem. With a 3.0.100-preview5 SDK installed, and Visual Studio 16.0-preview3, Scaffolding will fail for all 3.0 projects.

    Workaround: Uninstall 3.0.100-preview5 and install a lower version.

## ASP.NET Core

### Preview 4

- **[RESOLVED] Server-side Blazor app fails to run on non-Windows platforms**

    Running a server-side Blazor app on a non-Windows platform fails with the following error:

    ```
    System.InvalidOperationException: Could not load the embedded file manifest 'Microsoft.Extensions.FileProviders.Embedded.Manifest.xml' for assembly 'Microsoft.AspNetCore.Components.Server'.
    ```

    This will be addressed in the next preview update.

- **[RESOLVED] A request made to a CORS-enabled endpoint without an origin header fails with an HTTP 500 error.**

    Possible workarounds include:

    1. Having a middleware that sets the value in `HttpContext.Items` after `UseCors()`

        ```C#
        app.UseCors();

        app.Use((context, next) =>
        {
            context.Items["__CorsMiddlewareInvoked"] = true;
            return next();
        });
        ```

    2. Disable the check in `EndpointRouting`:
    
        ```C#
        services.AddRouting(r => r.SuppressCheckForUnhandledSecurityMetadata = true);
        ```

    The first option would be preferred since it's not removing a check for a mis-configured application.

- **[RESOLVED] Design-time errors in Visual Studio when using a component with child content from a component that lives in a different namespace**

    This issue will be addressed in a future preview of Visual Studio. To workaround this issue, fully qualify the name of the child component

- **[RESOLVED] Design-time errors in Visual Studio for class libraries with Blazor components**

    This issue will be addressed in a future preview of Visual Studio. To workaround this issue add the `<AddRazorSupportForMvc>true</AddRazorSupportForMvc>` property to your project file.

- **Publishing an ASP.NET Core hosted client-side Blazor app to Azure as a self-contained app fails**

    Publishing an ASP.NET Core hosted client-side Blazor app to Azure as a self-contained app fails with the following error:

    ```
    Error CS0006: Metadata file 'C:\Users\user\Source\Repos\WebApplication3\WebApplication3.Client\bin\Release\netstandard2.0\win-x86\WebApplication1.Client.dll' could not be found
    ```

    To workaround this issue, add the `<AppendRuntimeIdentifierToOutputPath>false</AppendRuntimeIdentifierToOutputPath>` property to the client project file.

### Preview 3

- **[RESOLVED] The Windows Hosting bundle doesn't exist for Preview3**: The Windows Hosting bundle contained an issue which copied the 32 bit dlls into 64 bit locations. To work aroud this issue, please install the 3.0 Preview 2 [Hosting Bundle](https://github.com/dotnet/core/blob/master/release-notes/3.0/preview/3.0.0-preview2-download.md) and run the executable on a command line with the paramaters `OPT_NO_SHAREDFX=1 OPT_NO_RUNTIME=1`. Then install the appropriate .NET and ASP.NET runtimes for preview3.

- **[RESOLVED] Updates to .razor files fail to show up in subsequent builds**: Updates to Razor Component (.razor) in Visual Studio may fail to show up in subsequent builds. To work around this issue add the following item group to the project file:

    ```xml
    <ItemGroup>
        <UpToDateCheckInput Include="@(Content->WithMetadataValue('Extension', '.razor'))" />
    </ItemGroup>
    ```

- **[RESOLVED] Updates to Razor Components in .razor files fail to show up in IntelliSense**: Updates to Razor Components defined in .razor files may fail to show up in IntelliSense in Visual Studio. To workaround this issue rebuild the project.

- **[RESOLVED] Single Page Applications with authentication enabled throws method not found exception when visiting the register or login pages**: The exception message is the one below.
`Method not found: 'Microsoft.EntityFrameworkCore.Metadata.Builders.IndexBuilder Microsoft.EntityFrameworkCore.Metadata.Builders.EntityTypeBuilder``1.HasIndex(System.Linq.Expressions.Expression``1<System.Func``2<!0,System.Object>>)'.` To workaround this issue follow these steps:
  * Replace the following package references with the ones below in your csproj folder:
    ```xml
    <PackageReference Include="Microsoft.AspNetCore.Identity.EntityFrameworkCore" Version="3.0.0-preview3-19153-02" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Sqlite" Version="3.0.0-preview3.19153.1" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Tools" Version="3.0.0-preview3.19153.1" />
    ```

    ```xml
    <PackageReference Include="Microsoft.AspNetCore.Identity.EntityFrameworkCore" Version="3.0.0-preview-18579-0056" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Sqlite" Version="3.0.0-preview.19080.1" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Tools" Version="3.0.0-preview.19080.1" />
    <PackageReference Include="Microsoft.EntityFrameworkCore.Relational" Version="3.0.0-preview.19080.1" />
    <PackageReference Include="Microsoft.EntityFrameworkCore" Version="3.0.0-preview.19080.1" />
    ```

  * Add the following snippet to your csproj file:
    ```xml
    <PropertyGroup>
      <NoWarn>$(NoWarn);NU1605</NoWarn>
    </PropertyGroup>
    ```
    
- **Referencing 3.0.0 MVC libraries don't work as intended**: There are several issues with referencing a 3.0.0 MVC library.

    * Razor pages will 404, 
    * ApplicationParts and factories will not be discoverable
    * Controllers will not be discoverable

    To workaround this issue do the following:

    * Add the helper method:
    ```C#
    private void Add30AssemblyWorkaround(Assembly referencedAssembly, ApplicationPartManager applicationPartManager)
    {
        var partFactory = ApplicationPartFactory.GetApplicationPartFactory(referencedAssembly);

        foreach (var part in partFactory.GetApplicationParts(referencedAssembly))
        {
            applicationPartManager.ApplicationParts.Add(part);
        }

        var relatedAssemblies = RelatedAssemblyAttribute.GetRelatedAssemblies(referencedAssembly, throwOnError: true);
        foreach (var assembly in relatedAssemblies)
        {
            partFactory = ApplicationPartFactory.GetApplicationPartFactory(assembly);
            foreach (var part in partFactory.GetApplicationParts(assembly))
            {
                applicationPartManager.ApplicationParts.Add(part);
            }
        }
    }
    ```

    * Modify your `services.AddMvc()` call in `Startup.cs`:
    ```C#
    services.AddMvc()
        .ConfigureApplicationPartManager(manager =>
        {
            var referencedAssembly = Assembly.Load("RCL");
            Add30AssemblyWorkaround(referencedAssembly, manager);
        })
        ...
    ```

- **[RESOLVED] React template with authentication has a syntax error on build** in file /ClientApp/src/components/api-authorization/ApiAuthorizationConstants.js
When building or running the react template with authentication, after opening the browser, the app won't work and the following error message will be displayed.
  ```console
  ×
  Error: Module build failed: SyntaxError: ClientApp/src/components/  api-authorization/ApiAuthorizationConstants.js: Unexpected token (27:25)
  
    25 |   DefaultLoginRedirectPath: '/',
    26 |   ApiAuthorizationClientConfigurationUrl: `/_configuration/$ {ApplicationName}`,
  > 27 |   ApiAuthorizationPrefix = prefix,
       |                          ^
    28 |   Login: `${prefix}/${LoginActions.Login}`,
    29 |   LoginFailed: `${prefix}/${LoginActions.LoginFailed}`,
    30 |   LoginCallback: `${prefix}/${LoginActions.LoginCallback}`,
  ```
  * Workaround:
  Replace `ApiAuthorizationPrefix = prefix,` with `ApiAuthorizationPrefix: prefix,`

- **[RESOLVED] Import error "Cannot find module "./components/api-authorization/Login"**: When building or running the react template with authentication, after opening the browser, the app won't work and the following error message will be displayed.
  ```console
  ×
  Error: Cannot find module "./components/api-authorization/Login"
  ▼ 13 stack frames were expanded.
  ./src/components/api-authorization/ApiAuthorizationRoutes.js
  https://localhost:44315/static/js/bundle.js:53166:7
  __webpack_require__
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:678
  fn
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:88
  ./src/App.js
  https://localhost:44315/static/js/bundle.js:51925:111
  __webpack_require__
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:678
  fn
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:88
  ./src/index.js
  https://localhost:44315/static/js/bundle.js:54708:63
  __webpack_require__
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:678
  fn
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:88
  0
  https://localhost:44315/static/js/bundle.js:54860:18
  __webpack_require__
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:678
  (anonymous function)
  ClientApp/webpack/bootstrap 43633f0e2b726d97cc14:724
  (anonymous function)
  https://localhost:44315/static/js/bundle.js:728:10
  ```

  * Workaround:
    * Remove the file /ClientApp/src/components/api-authorizationApi/AuthorizationRoutes.js
    * Replace the contents of App.js with these
      ```javascript
      import React, { Component } from 'react';
      import { Route } from 'react-router';
      import { Layout } from './components/Layout';
      import { Home } from './components/Home';
      import { FetchData } from './components/FetchData';
      import { Counter } from './components/Counter';
      import { Login } from './components/api-authorization/Login'
      import { Logout } from './components/api-authorization/Logout'
      import AuthorizeRoute from './components/api-authorization/AuthorizeRoute';
      import { ApplicationPaths, LoginActions, LogoutActions } from './components/api-authorization/ApiAuthorizationConstants';

      export default class App extends Component {
        static displayName = App.name;

        render () {
          return (
            <Layout>
              <Route exact path='/' component={Home} />
              <Route path='/counter' component={Counter} />
              <AuthorizeRoute path='/fetch-data' component={FetchData} />
              <Route path={ApplicationPaths.Login} render={() => loginAction(LoginActions.Login)} />
              <Route path={ApplicationPaths.LoginFailed} render={() => loginAction(LoginActions.LoginFailed)} />
              <Route path={ApplicationPaths.LoginCallback} render={() => loginAction(LoginActions.LoginCallback)} />
              <Route path={ApplicationPaths.Profile} render={() => loginAction(LoginActions.Profile)} />
              <Route path={ApplicationPaths.Register} render={() => loginAction(LoginActions.Register)} />
              <Route path={ApplicationPaths.LogOut} render={() => logoutAction(LogoutActions.Logout)} />
              <Route path={ApplicationPaths.LogOutCallback} render={() => logoutAction(LogoutActions.LogoutCallback)} />
              <Route path={ApplicationPaths.LoggedOut} render={() => logoutAction(LogoutActions.LoggedOut)} />
            </Layout>
          );
        }
      }

      function loginAction(name){
          return (<Login action={name}></Login>);
      }

      function logoutAction(name) {
          return (<Logout action={name}></Logout>);
      }
      ```

- **[RESOLVED] Runtime compilation using Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation throws an error stating "Cannot find reference assembly"**: When performing runtime Razor compilation, the application throws an error stating reference assemblies cannot be found. To workaround this, edit the project file and add this following property:
  ```xml
  <PropertyGroup>
    <PreserveCompilationReferences>true</PreserveCompilationReferences>
  </PropertyGroup>
   ```
