# System.Buffers

``` diff
 namespace System.Buffers {
+    public ref struct SequenceReader<T> where T : struct, IEquatable<T> {
+        public SequenceReader(ReadOnlySequence<T> sequence);
+        public long Consumed { get; }
+        public ReadOnlySpan<T> CurrentSpan { get; }
+        public int CurrentSpanIndex { get; }
+        public bool End { get; }
+        public long Length { get; }
+        public SequencePosition Position { get; }
+        public long Remaining { get; }
+        public ReadOnlySequence<T> Sequence { get; }
+        public ReadOnlySpan<T> UnreadSpan { get; }
+        public void Advance(long count);
+        public long AdvancePast(T value);
+        public long AdvancePastAny(ReadOnlySpan<T> values);
+        public long AdvancePastAny(T value0, T value1);
+        public long AdvancePastAny(T value0, T value1, T value2);
+        public long AdvancePastAny(T value0, T value1, T value2, T value3);
+        public bool IsNext(ReadOnlySpan<T> next, bool advancePast = false);
+        public bool IsNext(T next, bool advancePast = false);
+        public void Rewind(long count);
+        public bool TryAdvanceTo(T delimiter, bool advancePastDelimiter = true);
+        public bool TryAdvanceToAny(ReadOnlySpan<T> delimiters, bool advancePastDelimiter = true);
+        public bool TryCopyTo(Span<T> destination);
+        public bool TryPeek(out T value);
+        public bool TryRead(out T value);
+        public bool TryReadTo(out ReadOnlySequence<T> sequence, ReadOnlySpan<T> delimiter, bool advancePastDelimiter = true);
+        public bool TryReadTo(out ReadOnlySequence<T> sequence, T delimiter, bool advancePastDelimiter = true);
+        public bool TryReadTo(out ReadOnlySequence<T> sequence, T delimiter, T delimiterEscape, bool advancePastDelimiter = true);
+        public bool TryReadTo(out ReadOnlySpan<T> span, T delimiter, bool advancePastDelimiter = true);
+        public bool TryReadTo(out ReadOnlySpan<T> span, T delimiter, T delimiterEscape, bool advancePastDelimiter = true);
+        public bool TryReadToAny(out ReadOnlySequence<T> sequence, ReadOnlySpan<T> delimiters, bool advancePastDelimiter = true);
+        public bool TryReadToAny(out ReadOnlySpan<T> span, ReadOnlySpan<T> delimiters, bool advancePastDelimiter = true);
+    }
+    public static class SequenceReaderExtensions {
+        public static bool TryReadBigEndian(this ref SequenceReader<byte> reader, out short value);
+        public static bool TryReadBigEndian(this ref SequenceReader<byte> reader, out int value);
+        public static bool TryReadBigEndian(this ref SequenceReader<byte> reader, out long value);
+        public static bool TryReadLittleEndian(this ref SequenceReader<byte> reader, out short value);
+        public static bool TryReadLittleEndian(this ref SequenceReader<byte> reader, out int value);
+        public static bool TryReadLittleEndian(this ref SequenceReader<byte> reader, out long value);
+    }
 }
```

